/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.search.SearchTerm;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConverters;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.SimpleSearchTerm;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.eclipse.angus.mail.imap.SortTerm;

@Component(value="imap,imaps,pop3,pop3s,smtp,smtps")
public class MailComponent
extends HealthCheckComponent
implements HeaderFilterStrategyAware,
SSLContextParametersAware {
    @Metadata(label="advanced")
    private MailConfiguration configuration;
    @Metadata(label="advanced")
    private ContentTypeResolver contentTypeResolver;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="filter", description="To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy;

    public MailComponent() {
    }

    public MailComponent(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public MailComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Map sstParams;
        Object sortTerm;
        URI url = new URI(uri);
        MailConfiguration config = this.getConfiguration().copy();
        config.configure(url);
        this.configureAdditionalJavaMailProperties(config, parameters);
        MailEndpoint endpoint = new MailEndpoint(uri, this, config);
        Object searchTerm = this.getAndRemoveOrResolveReferenceParameter(parameters, "searchTerm", Object.class);
        if (searchTerm != null) {
            SearchTerm st = searchTerm instanceof SimpleSearchTerm ? MailConverters.toSearchTerm((SimpleSearchTerm)searchTerm) : (SearchTerm)this.getCamelContext().getTypeConverter().mandatoryConvertTo(SearchTerm.class, searchTerm);
            endpoint.setSearchTerm(st);
        }
        if ((sortTerm = this.getAndRemoveOrResolveReferenceParameter(parameters, "sortTerm", Object.class)) != null) {
            SortTerm[] st;
            if (sortTerm instanceof String) {
                st = MailConverters.toSortTerm((String)sortTerm);
            } else if (sortTerm instanceof SortTerm[]) {
                st = (SortTerm[])sortTerm;
            } else {
                throw new IllegalArgumentException("SortTerm must either be SortTerm[] or a String value");
            }
            endpoint.setSortTerm(st);
        }
        if (!(sstParams = PropertiesHelper.extractProperties(parameters, (String)"searchTerm.")).isEmpty()) {
            SimpleSearchTerm sst = new SimpleSearchTerm();
            this.setProperties(sst, sstParams);
            SearchTerm st = MailConverters.toSearchTerm(sst);
            endpoint.setSearchTerm(st);
        }
        endpoint.setContentTypeResolver(this.contentTypeResolver);
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        this.setProperties((Endpoint)endpoint, parameters);
        StringHelper.notEmpty((String)config.getHost(), (String)"host");
        StringHelper.notEmpty((String)config.getProtocol(), (String)"protocol");
        if (endpoint.getConfiguration().getSslContextParameters() == null) {
            endpoint.getConfiguration().setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    private void configureAdditionalJavaMailProperties(MailConfiguration config, Map<String, Object> parameters) {
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (!entry.getKey().toString().startsWith("mail.")) continue;
            config.getAdditionalJavaMailProperties().put(entry.getKey(), entry.getValue());
            toRemove.add(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : toRemove) {
            parameters.remove(entry);
        }
    }

    public MailConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new MailConfiguration(this.getCamelContext());
        }
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public void setEndpointHeaderFilterStrategy(Endpoint endpoint) {
        if (this.headerFilterStrategy != null && endpoint instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)endpoint).setHeaderFilterStrategy(this.headerFilterStrategy);
        }
    }
}

