/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class LogEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":loggerName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "log".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "loggerName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(30);
        props.add("showProperties");
        props.add("showStreams");
        props.add("showHeaders");
        props.add("showException");
        props.add("sourceLocationLoggerName");
        props.add("showExchangeId");
        props.add("logMask");
        props.add("groupActiveOnly");
        props.add("showFiles");
        props.add("showAll");
        props.add("plain");
        props.add("exchangeFormatter");
        props.add("maxChars");
        props.add("loggerName");
        props.add("level");
        props.add("groupDelay");
        props.add("showAllProperties");
        props.add("showExchangePattern");
        props.add("showBodyType");
        props.add("showFuture");
        props.add("showCaughtException");
        props.add("showStackTrace");
        props.add("skipBodyLineSeparator");
        props.add("lazyStartProducer");
        props.add("marker");
        props.add("multiline");
        props.add("groupSize");
        props.add("showBody");
        props.add("style");
        props.add("groupInterval");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

