/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class JacksonTypeConverters {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonTypeConverters.class);
    private final Object lock = new Object();
    private volatile ObjectMapper defaultMapper;
    private boolean init;
    private boolean enabled;
    private boolean toPojo;
    private String moduleClassNames;

    @Converter(fallback=true)
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws Exception {
        if (!this.init && exchange != null) {
            Map globalOptions = exchange.getContext().getGlobalOptions();
            String text = (String)globalOptions.get("CamelJacksonEnableTypeConverter");
            if (text != null) {
                text = exchange.getContext().resolvePropertyPlaceholders(text);
                this.enabled = "true".equalsIgnoreCase(text);
            }
            if ((text = (String)globalOptions.get("CamelJacksonTypeConverterToPojo")) != null) {
                text = exchange.getContext().resolvePropertyPlaceholders(text);
                this.toPojo = "true".equalsIgnoreCase(text);
            }
            this.moduleClassNames = (String)globalOptions.get("CamelJacksonTypeConverterModuleClassNames");
            this.init = true;
        }
        if (!this.enabled) {
            return null;
        }
        if (!this.toPojo && JacksonTypeConverters.isNotPojoType(type)) {
            return null;
        }
        if (exchange != null) {
            Object out;
            ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
            if (String.class.isAssignableFrom(type)) {
                out = mapper.writeValueAsString(value);
                return type.cast(out);
            }
            if (byte[].class.isAssignableFrom(type)) {
                out = mapper.writeValueAsBytes(value);
                return type.cast(out);
            }
            if (ByteBuffer.class.isAssignableFrom(type)) {
                out = mapper.writeValueAsBytes(value);
                return type.cast(ByteBuffer.wrap((byte[])out));
            }
            if (mapper.canSerialize(type) && !Enum.class.isAssignableFrom(type)) {
                if (String.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((String)value, type);
                }
                if (byte[].class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((byte[])value, type);
                }
                if (File.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((File)value, type);
                }
                if (InputStream.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((InputStream)value, type);
                }
                if (Reader.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((Reader)value, type);
                }
                return (T)mapper.convertValue(value, type);
            }
        }
        return null;
    }

    private static boolean isNotPojoType(Class<?> type) {
        boolean isString = String.class.isAssignableFrom(type);
        boolean isNumber = Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
        return isString || isNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper resolveObjectMapper(CamelContext camelContext) throws Exception {
        Set mappers = camelContext.getRegistry().findByType(ObjectMapper.class);
        if (mappers.size() == 1) {
            return (ObjectMapper)mappers.iterator().next();
        }
        if (this.defaultMapper == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.defaultMapper == null) {
                    ObjectMapper mapper = new ObjectMapper();
                    if (this.moduleClassNames != null) {
                        for (Object o : ObjectHelper.createIterable((String)this.moduleClassNames)) {
                            Class type = camelContext.getClassResolver().resolveMandatoryClass(o.toString(), Module.class);
                            Module module = (Module)camelContext.getInjector().newInstance(type);
                            LOG.debug("Registering module: {} -> {}", o, (Object)module);
                            mapper.registerModule(module);
                        }
                    }
                    this.defaultMapper = mapper;
                }
            }
        }
        return this.defaultMapper;
    }
}

