/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class OAuth2ClientConfigurer
extends ServiceSupport
implements HttpClientConfigurer {
    private final String clientId;
    private final String clientSecret;
    private final String tokenEndpoint;
    private final String scope;
    private final boolean cacheTokens;
    private final Long cachedTokensDefaultExpirySeconds;
    private final Long cachedTokensExpirationMarginSeconds;
    private static final ConcurrentMap<OAuth2URIAndCredentials, TokenCache> tokenCache = new ConcurrentHashMap<OAuth2URIAndCredentials, TokenCache>();
    private final boolean useBodyAuthentication;
    private final String resourceIndicator;
    private HttpClient httpClient;

    public OAuth2ClientConfigurer(String clientId, String clientSecret, String tokenEndpoint, String resourceIndicator, String scope, boolean cacheTokens, long cachedTokensDefaultExpirySeconds, long cachedTokensExpirationMarginSeconds, boolean useBodyAuthentication) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenEndpoint = tokenEndpoint;
        this.resourceIndicator = resourceIndicator;
        this.scope = scope;
        this.cacheTokens = cacheTokens;
        this.cachedTokensDefaultExpirySeconds = cachedTokensDefaultExpirySeconds;
        this.cachedTokensExpirationMarginSeconds = cachedTokensExpirationMarginSeconds;
        this.useBodyAuthentication = useBodyAuthentication;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        this.httpClient = clientBuilder.build();
        clientBuilder.addRequestInterceptorFirst((request, entity, context) -> {
            URI requestUri = this.getUriFromRequest(request);
            OAuth2URIAndCredentials uriAndCredentials = new OAuth2URIAndCredentials(requestUri, this.clientId, this.clientSecret);
            if (this.cacheTokens) {
                if (tokenCache.containsKey(uriAndCredentials) && !((TokenCache)tokenCache.get(uriAndCredentials)).isExpiredWithMargin(this.cachedTokensExpirationMarginSeconds)) {
                    request.setHeader("Authorization", (Object)("Bearer " + ((TokenCache)tokenCache.get(uriAndCredentials)).getToken()));
                } else {
                    JsonObject accessTokenResponse = this.getAccessTokenResponse(this.httpClient);
                    String accessToken = accessTokenResponse.getString("access_token");
                    String expiresIn = accessTokenResponse.getString("expires_in");
                    if (expiresIn != null && !expiresIn.isEmpty()) {
                        tokenCache.put(uriAndCredentials, new TokenCache(accessToken, expiresIn));
                    } else if (this.cachedTokensDefaultExpirySeconds > 0L) {
                        tokenCache.put(uriAndCredentials, new TokenCache(accessToken, this.cachedTokensDefaultExpirySeconds));
                    }
                    request.setHeader("Authorization", (Object)("Bearer " + accessToken));
                }
            } else {
                JsonObject accessTokenResponse = this.getAccessTokenResponse(this.httpClient);
                String accessToken = accessTokenResponse.getString("access_token");
                request.setHeader("Authorization", (Object)("Bearer " + accessToken));
            }
        });
    }

    private JsonObject getAccessTokenResponse(HttpClient httpClient) throws IOException {
        Object bodyStr = "grant_type=client_credentials";
        if (this.scope != null) {
            bodyStr = (String)bodyStr + "&scope=" + this.scope;
        }
        HttpPost httpPost = new HttpPost(this.tokenEndpoint);
        if (this.useBodyAuthentication) {
            bodyStr = (String)bodyStr + "&client_id=" + this.clientId;
            bodyStr = (String)bodyStr + "&client_secret=" + this.clientSecret;
        } else {
            httpPost.addHeader("Authorization", (Object)HttpCredentialsHelper.generateBasicAuthHeader(this.clientId, this.clientSecret));
        }
        if (null != this.resourceIndicator) {
            bodyStr = String.join((CharSequence)bodyStr, "&resource=" + this.resourceIndicator);
        }
        httpPost.setEntity((HttpEntity)new StringEntity((String)bodyStr, ContentType.APPLICATION_FORM_URLENCODED));
        AtomicReference result = new AtomicReference();
        httpClient.execute((ClassicHttpRequest)httpPost, response -> {
            try {
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getCode() != 200) {
                    throw new HttpException("Received error response from token request with Status Code: " + response.getCode());
                }
                result.set((JsonObject)Jsoner.deserialize((String)responseString));
            }
            catch (DeserializationException e) {
                throw new HttpException("Something went wrong when reading token request response", (Throwable)e);
            }
            return null;
        });
        return (JsonObject)result.get();
    }

    private URI getUriFromRequest(HttpRequest request) {
        URI result;
        try {
            result = request.getUri();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected void doStop() throws Exception {
        super.doStop();
        HttpClient httpClient = this.httpClient;
        if (httpClient instanceof Closeable) {
            Closeable closeable = (Closeable)httpClient;
            IOHelper.close((Closeable)closeable);
            this.httpClient = null;
        }
    }

    private record OAuth2URIAndCredentials(URI uri, String clientId, String clientSecret) {
    }

    private static class TokenCache {
        private String token;
        private Instant expirationTime;

        public TokenCache() {
        }

        public TokenCache(String token, String expires_in) {
            this.token = token;
            this.setExpirationTimeSeconds(expires_in);
        }

        public TokenCache(String accessToken, Long seconds) {
            this.token = accessToken;
            this.expirationTime = Instant.now().plusSeconds(seconds);
        }

        public boolean isExpired() {
            return Instant.now().isAfter(this.expirationTime);
        }

        public boolean isExpiredWithMargin(Long marginSeconds) {
            return Instant.now().isAfter(this.expirationTime.minusSeconds(marginSeconds));
        }

        public void setExpirationTimeSeconds(String expires_in) {
            this.expirationTime = Instant.now().plusSeconds(Long.parseLong(expires_in));
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public Instant getExpirationTime() {
            return this.expirationTime;
        }

        public void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }
    }
}

