/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileProcessStrategySupport;
import org.apache.camel.component.file.strategy.GenericFileRenamer;
import org.apache.camel.support.ExchangeHelper;

public class GenericFileRenameProcessStrategy<T>
extends GenericFileProcessStrategySupport<T> {
    private GenericFileRenamer<T> beginRenamer;
    private GenericFileRenamer<T> failureRenamer;
    private GenericFileRenamer<T> commitRenamer;

    @Override
    public boolean begin(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        boolean result = super.begin(operations, endpoint, exchange, file);
        if (!result) {
            return false;
        }
        if (this.beginRenamer != null) {
            GenericFile<T> newName = this.beginRenamer.renameFile(operations, exchange, file);
            GenericFile<T> to = this.renameFile(operations, file, newName);
            if (endpoint instanceof FileEndpoint) {
                FileEndpoint fe = (FileEndpoint)endpoint;
                if (to != null) {
                    to.bindToExchange(exchange, fe.isProbeContentType());
                }
            } else if (to != null) {
                to.bindToExchange(exchange);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        try {
            operations.releaseRetrievedFileResources(exchange);
            if (this.failureRenamer != null) {
                Exchange copy = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
                if (endpoint instanceof FileEndpoint) {
                    FileEndpoint fe = (FileEndpoint)endpoint;
                    file.bindToExchange(copy, fe.isProbeContentType());
                } else {
                    file.bindToExchange(copy);
                }
                copy.getMessage().setMessageId(exchange.getMessage().getMessageId());
                copy.setExchangeId(exchange.getExchangeId());
                GenericFile<T> newName = this.failureRenamer.renameFile(operations, copy, file);
                this.renameFile(operations, file, newName);
            }
        }
        finally {
            if (this.exclusiveReadLockStrategy != null) {
                this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnRollback(operations, file, exchange);
            }
            this.deleteLocalWorkFile(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        try {
            operations.releaseRetrievedFileResources(exchange);
            if (this.commitRenamer != null) {
                Exchange copy = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
                if (endpoint instanceof FileEndpoint) {
                    FileEndpoint fe = (FileEndpoint)endpoint;
                    file.bindToExchange(copy, fe.isProbeContentType());
                } else {
                    file.bindToExchange(copy);
                }
                copy.getMessage().setMessageId(exchange.getMessage().getMessageId());
                copy.setExchangeId(exchange.getExchangeId());
                GenericFile<T> newName = this.commitRenamer.renameFile(operations, copy, file);
                this.renameFile(operations, file, newName);
            }
        }
        finally {
            this.deleteLocalWorkFile(exchange);
            if (this.exclusiveReadLockStrategy != null) {
                this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnCommit(operations, file, exchange);
            }
        }
    }

    public GenericFileRenamer<T> getBeginRenamer() {
        return this.beginRenamer;
    }

    public void setBeginRenamer(GenericFileRenamer<T> beginRenamer) {
        this.beginRenamer = beginRenamer;
    }

    public GenericFileRenamer<T> getCommitRenamer() {
        return this.commitRenamer;
    }

    public void setCommitRenamer(GenericFileRenamer<T> commitRenamer) {
        this.commitRenamer = commitRenamer;
    }

    public GenericFileRenamer<T> getFailureRenamer() {
        return this.failureRenamer;
    }

    public void setFailureRenamer(GenericFileRenamer<T> failureRenamer) {
        this.failureRenamer = failureRenamer;
    }
}

