/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileBinding;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.consumer.DirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.FileOffsetResumeAdapter;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.resume.Resumables;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConsumer
extends GenericFileConsumer<File>
implements ResumeAware<ResumeStrategy> {
    private static final Logger LOG = LoggerFactory.getLogger(FileConsumer.class);
    private ResumeStrategy resumeStrategy;
    private final String endpointPath;
    private Set<String> extendedAttributes;

    public FileConsumer(FileEndpoint endpoint, Processor processor, GenericFileOperations<File> operations, GenericFileProcessStrategy<File> processStrategy) {
        super(endpoint, processor, operations, processStrategy);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
        if (endpoint.getExtendedAttributes() != null) {
            List<String> attributes = Arrays.asList(endpoint.getExtendedAttributes().split(","));
            this.extendedAttributes = new HashSet<String>(attributes);
        }
    }

    @Override
    protected Exchange createExchange(GenericFile<File> file) {
        Exchange exchange = this.createExchange(true);
        if (file != null) {
            file.bindToExchange(exchange, this.getEndpoint().isProbeContentType());
        }
        return exchange;
    }

    private boolean pollDirectory(Exchange dynamic, File directory, List<GenericFile<File>> fileList, int depth) {
        File[] files;
        ++depth;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Polling directory: {}, absolute path: {}", (Object)directory.getPath(), (Object)directory.getAbsolutePath());
        }
        if ((files = this.listFiles(directory)) == null || files.length == 0) {
            return true;
        }
        if (this.getEndpoint().isPreSort()) {
            Arrays.sort(files, Comparator.comparing(File::getAbsoluteFile));
        }
        return !this.processPolledFiles(dynamic, fileList, depth, files);
    }

    private boolean processPolledFiles(Exchange dynamic, List<GenericFile<File>> fileList, int depth, File[] files) {
        for (File file : files) {
            ResumeAdapter adapter;
            if (!this.canPollMoreFiles(fileList)) {
                return true;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found file: {} [isAbsolute: {}, isDirectory: {}, isFile: {}, isHidden: {}]", new Object[]{file, file.isAbsolute(), file.isDirectory(), file.isFile(), file.isHidden()});
            }
            Supplier gf = Suppliers.memorize(() -> FileConsumer.asGenericFile(this.endpointPath, file, this.getEndpoint().getCharset(), this.getEndpoint().isProbeContentType()));
            if (this.resumeStrategy != null && (adapter = this.setupResumeStrategy((GenericFile)gf.get())) instanceof DirectoryEntriesResumeAdapter) {
                DirectoryEntriesResumeAdapter directoryEntriesResumeAdapter = (DirectoryEntriesResumeAdapter)adapter;
                LOG.trace("Running the resume process for file {}", (Object)file);
                if (directoryEntriesResumeAdapter.resume(file)) {
                    LOG.trace("Skipping file {} because it has been marked previously consumed", (Object)file);
                    continue;
                }
            }
            if (!this.processEntry(dynamic, fileList, depth, file, gf, files)) continue;
            return true;
        }
        return false;
    }

    private boolean processEntry(Exchange dynamic, List<GenericFile<File>> fileList, int depth, File file, Supplier<GenericFile<File>> gf, File[] files) {
        if (file.isDirectory()) {
            return this.processDirectoryEntry(dynamic, fileList, depth, file, gf, files);
        }
        this.processFileEntry(dynamic, fileList, depth, file, gf, files);
        return false;
    }

    private void processFileEntry(Exchange dynamic, List<GenericFile<File>> fileList, int depth, File file, Supplier<GenericFile<File>> gf, File[] files) {
        boolean valid;
        if (depth >= this.endpoint.minDepth && (valid = this.isValidFile(dynamic, gf, file.getName(), file.getAbsolutePath(), this.getRelativeFilePath(this.endpointPath, (String)null, (String)null, file), false, files))) {
            LOG.trace("Adding valid file: {}", (Object)file);
            if (this.extendedAttributes != null) {
                Path path = file.toPath();
                HashMap<String, Object> allAttributes = new HashMap<String, Object>();
                for (String attribute : this.extendedAttributes) {
                    this.readAttributes(file, path, allAttributes, attribute);
                }
                gf.get().setExtendedAttributes(allAttributes);
            }
            fileList.add(gf.get());
        }
    }

    private boolean processDirectoryEntry(Exchange dynamic, List<GenericFile<File>> fileList, int depth, File file, Supplier<GenericFile<File>> gf, File[] files) {
        boolean valid;
        if (this.endpoint.isRecursive() && depth < this.endpoint.getMaxDepth() && (valid = this.isValidFile(dynamic, gf, file.getName(), file.getAbsolutePath(), this.getRelativeFilePath(this.endpointPath, (String)null, (String)null, file), true, files))) {
            boolean canPollMore = this.pollDirectory(dynamic, file, fileList, depth);
            return !canPollMore;
        }
        return false;
    }

    private ResumeAdapter setupResumeStrategy(GenericFile<File> gf) {
        ResumeAdapter adapter = this.resumeStrategy.getAdapter();
        LOG.trace("Checking the resume adapter: {}", (Object)adapter);
        if (adapter instanceof FileOffsetResumeAdapter) {
            FileOffsetResumeAdapter fileOffsetResumeAdapter = (FileOffsetResumeAdapter)adapter;
            LOG.trace("The resume adapter is for offsets: {}", (Object)adapter);
            fileOffsetResumeAdapter.setResumePayload(gf);
            adapter.resume();
        }
        return adapter;
    }

    @Override
    protected boolean pollDirectory(Exchange dynamic, String fileName, List<GenericFile<File>> fileList, int depth) {
        LOG.trace("pollDirectory from fileName: {}", (Object)fileName);
        File directory = new File(fileName);
        if (!directory.exists() || !directory.isDirectory()) {
            LOG.debug("Cannot poll as directory does not exist or its not a directory: {}", (Object)directory);
            if (this.getEndpoint().isDirectoryMustExist()) {
                throw new GenericFileOperationFailedException("Directory does not exist: " + String.valueOf(directory));
            }
            return true;
        }
        return this.pollDirectory(dynamic, directory, fileList, depth);
    }

    private File[] listFiles(File directory) {
        if (!this.getEndpoint().isIncludeHiddenDirs() && directory.isHidden()) {
            return null;
        }
        File[] dirFiles = directory.listFiles();
        if (dirFiles == null || dirFiles.length == 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No files found in directory: {}", (Object)directory.getPath());
            }
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found {} in directory: {}", (Object)dirFiles.length, (Object)directory.getPath());
        }
        return dirFiles;
    }

    private void readAttributes(File file, Path path, Map<String, Object> allAttributes, String attribute) {
        block11: {
            try {
                String prefix = null;
                if (attribute.endsWith(":*")) {
                    prefix = attribute.substring(0, attribute.length() - 1);
                } else if (attribute.equals("*")) {
                    prefix = "basic:";
                }
                if (ObjectHelper.isNotEmpty((String)prefix)) {
                    Map<String, Object> attributes = Files.readAttributes(path, attribute, new LinkOption[0]);
                    if (attributes != null) {
                        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                            allAttributes.put(prefix + entry.getKey(), entry.getValue());
                        }
                    }
                } else if (!attribute.contains(":")) {
                    allAttributes.put("basic:" + attribute, Files.getAttribute(path, attribute, new LinkOption[0]));
                } else {
                    allAttributes.put(attribute, Files.getAttribute(path, attribute, new LinkOption[0]));
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block11;
                LOG.debug("Unable to read attribute {} on file {}", new Object[]{attribute, file, e});
            }
        }
    }

    protected boolean isMatched(Supplier<GenericFile<File>> file, String doneFileName, File[] files) {
        String onlyName = FileUtil.stripPath((String)doneFileName);
        for (File f : files) {
            if (!f.getName().equals(onlyName)) continue;
            return true;
        }
        LOG.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    public static GenericFile<File> asGenericFile(String endpointPath, File file, String charset, boolean probeContentType) {
        File path;
        GenericFile<File> answer = new GenericFile<File>(probeContentType);
        answer.setBinding(new FileBinding());
        answer.setCharset(charset);
        answer.setEndpointPath(endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getName());
        answer.setDirectory(file.isDirectory());
        answer.setAbsolute(FileUtil.isAbsolute((File)file));
        answer.setAbsoluteFilePath(file.getAbsolutePath());
        answer.setFileLengthSupplier(file::length);
        answer.setLastModifiedSupplier(file::lastModified);
        String endpointNormalizedSep = FileUtil.normalizePath((String)endpointPath) + File.separator;
        String p = file.getPath();
        if (p.startsWith(endpointNormalizedSep)) {
            p = p.substring(endpointNormalizedSep.length());
        }
        if ((path = new File(p)).getParent() != null) {
            answer.setRelativeFilePath(path.getParent() + File.separator + file.getName());
        } else {
            answer.setRelativeFilePath(path.getName());
        }
        answer.setFileName(answer.getRelativeFilePath());
        answer.setBody(file);
        return answer;
    }

    @Override
    protected Supplier<String> getRelativeFilePath(String endpointPath, String path, String absolutePath, File file) {
        return () -> {
            File f;
            String endpointNormalizedSep = FileUtil.normalizePath((String)endpointPath) + File.separator;
            String p = file.getPath();
            if (p.startsWith(endpointNormalizedSep)) {
                p = p.substring(endpointNormalizedSep.length());
            }
            Object answer = (f = new File(p)).getParent() != null ? f.getParent() + File.separator + file.getName() : f.getName();
            return answer;
        };
    }

    @Override
    protected void updateFileHeaders(GenericFile<File> file, Message message) {
        File upToDateFile = file.getFile();
        if (this.fileHasMoved(file)) {
            upToDateFile = new File(file.getAbsoluteFilePath());
        }
        long length = upToDateFile.length();
        long modified = upToDateFile.lastModified();
        file.setFileLength(length);
        file.setLastModified(modified);
        if (length >= 0L) {
            message.setHeader("CamelFileLength", (Object)length);
        }
        if (modified >= 0L) {
            message.setHeader("CamelFileLastModified", (Object)modified);
        }
        message.setHeader("CamelFileInitialOffset", (Object)Resumables.of((Object)upToDateFile, (Object)file.getLastOffsetValue()));
    }

    public FileEndpoint getEndpoint() {
        return (FileEndpoint)super.getEndpoint();
    }

    @Override
    protected boolean isMatchedHiddenFile(Supplier<GenericFile<File>> file, String name, boolean isDirectory) {
        if (isDirectory) {
            if (!name.startsWith(".")) {
                return true;
            }
            return this.getEndpoint().isIncludeHiddenDirs() && !".camel".equals(name);
        }
        if (this.getEndpoint().isIncludeHiddenFiles()) {
            return true;
        }
        return super.isMatchedHiddenFile(file, name, isDirectory);
    }

    private boolean fileHasMoved(GenericFile<File> file) {
        return !file.getFile().getAbsolutePath().equals(file.getAbsoluteFilePath());
    }

    @Override
    protected void doStart() throws Exception {
        if (this.resumeStrategy != null) {
            this.resumeStrategy.loadCache();
        }
        boolean startScheduler = this.isStartScheduler();
        this.setStartScheduler(false);
        try {
            super.doStart();
            File file = this.getEndpoint().getFile();
            if (!file.exists() && !file.isDirectory()) {
                this.tryCreateDirectory(file);
            }
            this.tryReadingStartDirectory(file);
        }
        finally {
            if (startScheduler) {
                this.setStartScheduler(true);
                this.startScheduler();
            }
        }
        super.doStart();
    }

    private void tryCreateDirectory(File file) throws FileNotFoundException {
        if (this.getEndpoint().isAutoCreate()) {
            this.doCreateStartDirectory(file);
        } else if (this.getEndpoint().isStartingDirectoryMustExist()) {
            throw new FileNotFoundException("Starting directory does not exist: " + String.valueOf(file));
        }
    }

    private void doCreateStartDirectory(File file) {
        LOG.debug("Creating non existing starting directory: {}", (Object)file);
        boolean absolute = FileUtil.isAbsolute((File)file);
        boolean created = this.operations.buildDirectory(file.getPath(), absolute);
        if (!created) {
            LOG.warn("Cannot auto create starting directory: {}", (Object)file);
        }
    }

    private void tryReadingStartDirectory(File file) throws IOException {
        if (!this.getEndpoint().isStartingDirectoryMustExist() && this.getEndpoint().isStartingDirectoryMustHaveAccess()) {
            throw new IllegalArgumentException("You cannot set startingDirectoryMustHaveAccess=true without setting startingDirectoryMustExist=true");
        }
        if (this.getEndpoint().isStartingDirectoryMustExist() && this.getEndpoint().isStartingDirectoryMustHaveAccess() && (!file.canRead() || !file.canWrite())) {
            throw new IOException("Starting directory permission denied: " + String.valueOf(file));
        }
    }

    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public String adapterFactoryService() {
        return "file-adapter-factory";
    }
}

