/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer.adapters;

import java.io.File;
import java.util.Optional;
import org.apache.camel.component.file.consumer.GenericFileResumable;
import org.apache.camel.component.file.consumer.GenericFileResumeAdapter;
import org.apache.camel.resume.cache.SingleEntryCache;

public class DefaultGenericFileResumeAdapter
implements GenericFileResumeAdapter {
    private final SingleEntryCache<File, Long> cache;

    public DefaultGenericFileResumeAdapter(SingleEntryCache<File, Long> cache) {
        this.cache = cache;
    }

    private Optional<Long> getLastOffset(GenericFileResumable<File> resumable) {
        File addressable = (File)resumable.getAddressable();
        return this.cache.get((Object)addressable);
    }

    @Override
    public Optional<Long> getLastOffset(File addressable) {
        return this.cache.get((Object)addressable);
    }

    @Override
    public void resume(GenericFileResumable<File> resumable) {
        Optional<Long> lastOffsetOpt = this.getLastOffset(resumable);
        if (!lastOffsetOpt.isPresent()) {
            return;
        }
        long lastOffset = lastOffsetOpt.get();
        resumable.updateLastOffset(lastOffset);
    }

    public void resume() {
    }
}

