/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.util.URISupport;

public abstract class GenericFileSendDynamicAware
implements SendDynamicAware {
    private String scheme;

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        RuntimeCamelCatalog catalog = (RuntimeCamelCatalog)exchange.getContext().getExtension(RuntimeCamelCatalog.class);
        Map properties = catalog.endpointProperties(uri);
        Map lenient = catalog.endpointLenientProperties(uri);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, lenient);
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        boolean fileName = entry.getProperties().containsKey("fileName");
        boolean tempFileName = entry.getProperties().containsKey("tempFileName");
        boolean idempotentKey = entry.getProperties().containsKey("idempotentKey");
        boolean move = entry.getProperties().containsKey("move");
        boolean moveFailed = entry.getProperties().containsKey("moveFailed");
        boolean preMove = entry.getProperties().containsKey("preMove");
        boolean moveExisting = entry.getProperties().containsKey("moveExisting");
        if (fileName || tempFileName || idempotentKey || move || moveFailed || preMove || moveExisting) {
            Object val;
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(entry.getProperties());
            Map originalParams = URISupport.parseQuery((String)entry.getOriginalUri());
            if (fileName && (val = originalParams.get("fileName")) != null) {
                params.put("fileName", val.toString());
            }
            if (tempFileName && (val = originalParams.get("tempFileName")) != null) {
                params.put("tempFileName", val.toString());
            }
            if (idempotentKey && (val = originalParams.get("idempotentKey")) != null) {
                params.put("idempotentKey", val.toString());
            }
            if (move && (val = originalParams.get("move")) != null) {
                params.put("move", val.toString());
            }
            if (moveFailed && (val = originalParams.get("moveFailed")) != null) {
                params.put("moveFailed", val.toString());
            }
            if (preMove && (val = originalParams.get("preMove")) != null) {
                params.put("preMove", val.toString());
            }
            if (moveExisting && (val = originalParams.get("moveExisting")) != null) {
                params.put("moveExisting", val.toString());
            }
            RuntimeCamelCatalog catalog = (RuntimeCamelCatalog)exchange.getContext().getExtension(RuntimeCamelCatalog.class);
            return catalog.asEndpointUri(this.scheme, params, false);
        }
        return entry.getUri();
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }
}

