/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.crypt;

import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.cms.common.DefaultCryptoCmsConfiguration;
import org.apache.camel.component.crypto.cms.crypt.TransRecipientInfo;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsNoKeyOrCertificateForAliasException;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class DefaultKeyTransRecipientInfo
extends DefaultCryptoCmsConfiguration
implements TransRecipientInfo {
    @UriParam(label="encrypt")
    private String certificateAlias;
    private String keyEncryptionAlgorithm = "RSA";

    protected String getCertificateAlias() throws CryptoCmsException {
        if (this.certificateAlias == null) {
            throw new CryptoCmsException("Certificate alias not configured in recipient " + this);
        }
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public String toString() {
        return "certificate alias=" + this.certificateAlias + ", key encryption algorithm=" + this.keyEncryptionAlgorithm;
    }

    @Override
    public String getKeyEncryptionAlgorithm(Exchange exchange) throws CryptoCmsException {
        return this.keyEncryptionAlgorithm;
    }

    @Override
    public X509Certificate getCertificate(Exchange exchange) throws CryptoCmsException {
        Certificate cert;
        String alias = this.getCertificateAlias();
        try {
            cert = this.getKeyStore().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoCmsException("Problem during reading the certificate with the alias '" + alias + "' from the keystore of the recipient " + this);
        }
        if (cert instanceof X509Certificate) {
            return (X509Certificate)cert;
        }
        throw new CryptoCmsNoKeyOrCertificateForAliasException("No X509 certificate found for the alias '" + alias + "' in the keystore of the recipient " + this);
    }
}

