/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.View;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewRow;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.couchbase.CouchbaseEndpoint;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultScheduledPollConsumer;

public class CouchbaseConsumer
extends DefaultScheduledPollConsumer {
    private final CouchbaseEndpoint endpoint;
    private final CouchbaseClient client;
    private final View view;
    private final Query query;

    public CouchbaseConsumer(CouchbaseEndpoint endpoint, CouchbaseClient client, Processor processor) {
        super((DefaultEndpoint)endpoint, processor);
        this.client = client;
        this.endpoint = endpoint;
        this.view = client.getView(endpoint.getDesignDocumentName(), endpoint.getViewName());
        this.query = new Query();
        this.init();
    }

    private void init() {
        int skip;
        this.query.setIncludeDocs(true);
        int limit = this.endpoint.getLimit();
        if (limit > 0) {
            this.query.setLimit(limit);
        }
        if ((skip = this.endpoint.getSkip()) > 0) {
            this.query.setSkip(skip);
        }
        this.query.setDescending(this.endpoint.isDescending());
        String rangeStartKey = this.endpoint.getRangeStartKey();
        String rangeEndKey = this.endpoint.getRangeEndKey();
        if ("".equals(rangeStartKey) || "".equals(rangeEndKey)) {
            return;
        }
        this.query.setRange(rangeStartKey, rangeEndKey);
    }

    protected void doStart() throws Exception {
        this.log.info("Starting Couchbase consumer");
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.info("Stopping Couchbase consumer");
        super.doStop();
    }

    protected synchronized int poll() throws Exception {
        ViewResponse result = this.client.query((AbstractView)this.view, this.query);
        this.log.info("Received result set from Couchbase");
        if (this.log.isTraceEnabled()) {
            this.log.trace("ViewResponse = {}", (Object)result);
        }
        String consumerProcessedStrategy = this.endpoint.getConsumerProcessedStrategy();
        for (ViewRow row : result) {
            String id = row.getId();
            Object doc = row.getDocument();
            String key = row.getKey();
            String designDocumentName = this.endpoint.getDesignDocumentName();
            String viewName = this.endpoint.getViewName();
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setBody(doc);
            exchange.getIn().setHeader("CCB_ID", (Object)id);
            exchange.getIn().setHeader("CCB_KEY", (Object)key);
            exchange.getIn().setHeader("CCB_DDN", (Object)designDocumentName);
            exchange.getIn().setHeader("CCB_VN", (Object)viewName);
            if ("delete".equalsIgnoreCase(consumerProcessedStrategy)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Deleting doc with ID {}", (Object)id);
                }
                this.client.delete(id);
            } else if ("filter".equalsIgnoreCase(consumerProcessedStrategy)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Filtering out ID {}", (Object)id);
                }
            } else {
                this.log.trace("No strategy set for already processed docs, beware of duplicates!");
            }
            this.logDetails(id, doc, key, designDocumentName, viewName, exchange);
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)e);
            }
        }
        return result.size();
    }

    private void logDetails(String id, Object doc, String key, String designDocumentName, String viewName, Exchange exchange) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created exchange = {}", (Object)exchange);
            this.log.trace("Added Document in body = {}", doc);
            this.log.trace("Adding to Header");
            this.log.trace("ID = {}", (Object)id);
            this.log.trace("Key = {}", (Object)key);
            this.log.trace("Design Document Name = {}", (Object)designDocumentName);
            this.log.trace("View Name = {}", (Object)viewName);
        }
    }
}

