/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component;

import javax.annotation.processing.Generated;
import org.apache.camel.builder.component.dsl.*;

/**
 * Component DSL builder.
 *
 * You can build a component as follows:
 * <pre>
 * KafkaComponent kafka =
 * ComponentBuilderFactory.kafka().setBrokers("{{host:port}}").build();
 * </pre>
 * This creates a new Kafka component, but often you want to register the
 * component to CamelContext, which can be done as follows:
 * <pre>
 * ComponentBuilderFactory.kafka().setBrokers("{{host:port}}").register(camelContext, "kafka");
 * </pre>
 * This configures and registers the component to CamelContext with the name
 * kafka. If you have separate Kafka brokers you can register more components
 * with their own name:
 * <pre>
 * ComponentBuilderFactory.kafka().setBrokers("{{host2:port}}").register(camelContext, "kafka2");
 * </pre>
 *
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface ComponentsBuilderFactory {

    /**
     * ActiveMQ (camel-activemq)
     * Send messages to (or consume from) Apache ActiveMQ. This component
     * extends the Camel JMS component.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-activemq
     * 
     * @return the dsl builder
     */
    static ActivemqComponentBuilderFactory.ActivemqComponentBuilder activemq() {
        return ActivemqComponentBuilderFactory.activemq();
    }
    /**
     * AMQP (camel-amqp)
     * Messaging with AMQP protocol using Apache QPid Client.
     * 
     * Category: messaging
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-amqp
     * 
     * @return the dsl builder
     */
    static AmqpComponentBuilderFactory.AmqpComponentBuilder amqp() {
        return AmqpComponentBuilderFactory.amqp();
    }
    /**
     * ArangoDb (camel-arangodb)
     * Perform operations on ArangoDb when used as a Document Database, or as a
     * Graph Database
     * 
     * Category: database
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-arangodb
     * 
     * @return the dsl builder
     */
    static ArangodbComponentBuilderFactory.ArangodbComponentBuilder arangodb() {
        return ArangodbComponentBuilderFactory.arangodb();
    }
    /**
     * AS2 (camel-as2)
     * Transfer data securely and reliably using the AS2 protocol (RFC4130).
     * 
     * Category: file
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-as2
     * 
     * @return the dsl builder
     */
    static As2ComponentBuilderFactory.As2ComponentBuilder as2() {
        return As2ComponentBuilderFactory.as2();
    }
    /**
     * Asterisk (camel-asterisk)
     * Interact with Asterisk PBX Server (VoIP).
     * 
     * Category: mobile
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-asterisk
     * 
     * @return the dsl builder
     */
    static AsteriskComponentBuilderFactory.AsteriskComponentBuilder asterisk() {
        return AsteriskComponentBuilderFactory.asterisk();
    }
    /**
     * Atmosphere Websocket (camel-atmosphere-websocket)
     * Expose WebSocket endpoints using the Atmosphere framework.
     * 
     * Category: http,networking
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-atmosphere-websocket
     * 
     * @return the dsl builder
     */
    static AtmosphereWebsocketComponentBuilderFactory.AtmosphereWebsocketComponentBuilder atmosphereWebsocket() {
        return AtmosphereWebsocketComponentBuilderFactory.atmosphereWebsocket();
    }
    /**
     * Atom (camel-atom)
     * Poll Atom RSS feeds.
     * 
     * Category: document
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-atom
     * 
     * @return the dsl builder
     */
    static AtomComponentBuilderFactory.AtomComponentBuilder atom() {
        return AtomComponentBuilderFactory.atom();
    }
    /**
     * Avro RPC (camel-avro-rpc)
     * Produce or consume Apache Avro RPC services.
     * 
     * Category: rpc
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-avro-rpc
     * 
     * @return the dsl builder
     */
    static AvroComponentBuilderFactory.AvroComponentBuilder avro() {
        return AvroComponentBuilderFactory.avro();
    }
    /**
     * AWS Bedrock (camel-aws-bedrock)
     * Invoke Model of AWS Bedrock service.
     * 
     * Category: ai,cloud
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-aws-bedrock
     * 
     * @return the dsl builder
     */
    static AwsBedrockComponentBuilderFactory.AwsBedrockComponentBuilder awsBedrock() {
        return AwsBedrockComponentBuilderFactory.awsBedrock();
    }
    /**
     * AWS Bedrock Agent (camel-aws-bedrock)
     * Operate on AWS Bedrock through its Agent.
     * 
     * Category: ai,cloud
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-aws-bedrock
     * 
     * @return the dsl builder
     */
    static AwsBedrockAgentComponentBuilderFactory.AwsBedrockAgentComponentBuilder awsBedrockAgent() {
        return AwsBedrockAgentComponentBuilderFactory.awsBedrockAgent();
    }
    /**
     * AWS Bedrock Agent Runtime (camel-aws-bedrock)
     * Invoke Model of AWS Bedrock Agent Runtime service.
     * 
     * Category: ai,cloud
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-aws-bedrock
     * 
     * @return the dsl builder
     */
    static AwsBedrockAgentRuntimeComponentBuilderFactory.AwsBedrockAgentRuntimeComponentBuilder awsBedrockAgentRuntime() {
        return AwsBedrockAgentRuntimeComponentBuilderFactory.awsBedrockAgentRuntime();
    }
    /**
     * AWS Cloudtrail (camel-aws-cloudtrail)
     * Consume events from Amazon Cloudtrail using AWS SDK version 2.x.
     * 
     * Category: cloud,management,monitoring
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-aws-cloudtrail
     * 
     * @return the dsl builder
     */
    static AwsCloudtrailComponentBuilderFactory.AwsCloudtrailComponentBuilder awsCloudtrail() {
        return AwsCloudtrailComponentBuilderFactory.awsCloudtrail();
    }
    /**
     * AWS Config Service (camel-aws-config)
     * Manage AWS Config service.
     * 
     * Category: cloud,management
     * Since: 4.3
     * Maven coordinates: org.apache.camel:camel-aws-config
     * 
     * @return the dsl builder
     */
    static AwsConfigComponentBuilderFactory.AwsConfigComponentBuilder awsConfig() {
        return AwsConfigComponentBuilderFactory.awsConfig();
    }
    /**
     * AWS Secrets Manager (camel-aws-secrets-manager)
     * Manage secrets using AWS Secrets Manager.
     * 
     * Category: cloud,management
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-aws-secrets-manager
     * 
     * @return the dsl builder
     */
    static AwsSecretsManagerComponentBuilderFactory.AwsSecretsManagerComponentBuilder awsSecretsManager() {
        return AwsSecretsManagerComponentBuilderFactory.awsSecretsManager();
    }
    /**
     * AWS Athena (camel-aws2-athena)
     * Access AWS Athena.
     * 
     * Category: cloud,database
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-aws2-athena
     * 
     * @return the dsl builder
     */
    static Aws2AthenaComponentBuilderFactory.Aws2AthenaComponentBuilder aws2Athena() {
        return Aws2AthenaComponentBuilderFactory.aws2Athena();
    }
    /**
     * AWS CloudWatch (camel-aws2-cw)
     * Sending metrics to AWS CloudWatch.
     * 
     * Category: cloud,monitoring
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-cw
     * 
     * @return the dsl builder
     */
    static Aws2CwComponentBuilderFactory.Aws2CwComponentBuilder aws2Cw() {
        return Aws2CwComponentBuilderFactory.aws2Cw();
    }
    /**
     * AWS DynamoDB (camel-aws2-ddb)
     * Store and retrieve data from AWS DynamoDB.
     * 
     * Category: cloud,database
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * @return the dsl builder
     */
    static Aws2DdbComponentBuilderFactory.Aws2DdbComponentBuilder aws2Ddb() {
        return Aws2DdbComponentBuilderFactory.aws2Ddb();
    }
    /**
     * AWS DynamoDB Streams (camel-aws2-ddb)
     * Receive messages from AWS DynamoDB Stream.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     * 
     * @return the dsl builder
     */
    static Aws2DdbstreamComponentBuilderFactory.Aws2DdbstreamComponentBuilder aws2Ddbstream() {
        return Aws2DdbstreamComponentBuilderFactory.aws2Ddbstream();
    }
    /**
     * AWS Elastic Compute Cloud (EC2) (camel-aws2-ec2)
     * Manage AWS EC2 instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ec2
     * 
     * @return the dsl builder
     */
    static Aws2Ec2ComponentBuilderFactory.Aws2Ec2ComponentBuilder aws2Ec2() {
        return Aws2Ec2ComponentBuilderFactory.aws2Ec2();
    }
    /**
     * AWS Elastic Container Service (ECS) (camel-aws2-ecs)
     * Manage AWS ECS cluster instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ecs
     * 
     * @return the dsl builder
     */
    static Aws2EcsComponentBuilderFactory.Aws2EcsComponentBuilder aws2Ecs() {
        return Aws2EcsComponentBuilderFactory.aws2Ecs();
    }
    /**
     * AWS Elastic Kubernetes Service (EKS) (camel-aws2-eks)
     * Manage AWS EKS cluster instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-eks
     * 
     * @return the dsl builder
     */
    static Aws2EksComponentBuilderFactory.Aws2EksComponentBuilder aws2Eks() {
        return Aws2EksComponentBuilderFactory.aws2Eks();
    }
    /**
     * AWS Eventbridge (camel-aws2-eventbridge)
     * Send events to AWS Eventbridge cluster instances.
     * 
     * Category: cloud,management
     * Since: 3.6
     * Maven coordinates: org.apache.camel:camel-aws2-eventbridge
     * 
     * @return the dsl builder
     */
    static Aws2EventbridgeComponentBuilderFactory.Aws2EventbridgeComponentBuilder aws2Eventbridge() {
        return Aws2EventbridgeComponentBuilderFactory.aws2Eventbridge();
    }
    /**
     * AWS Identity and Access Management (IAM) (camel-aws2-iam)
     * Manage AWS IAM instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-iam
     * 
     * @return the dsl builder
     */
    static Aws2IamComponentBuilderFactory.Aws2IamComponentBuilder aws2Iam() {
        return Aws2IamComponentBuilderFactory.aws2Iam();
    }
    /**
     * AWS Kinesis (camel-aws2-kinesis)
     * Consume and produce records from and to AWS Kinesis Streams.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * @return the dsl builder
     */
    static Aws2KinesisComponentBuilderFactory.Aws2KinesisComponentBuilder aws2Kinesis() {
        return Aws2KinesisComponentBuilderFactory.aws2Kinesis();
    }
    /**
     * AWS Kinesis Firehose (camel-aws2-kinesis)
     * Produce data to AWS Kinesis Firehose streams.
     * 
     * Category: cloud,messaging
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-kinesis
     * 
     * @return the dsl builder
     */
    static Aws2KinesisFirehoseComponentBuilderFactory.Aws2KinesisFirehoseComponentBuilder aws2KinesisFirehose() {
        return Aws2KinesisFirehoseComponentBuilderFactory.aws2KinesisFirehose();
    }
    /**
     * AWS Key Management Service (KMS) (camel-aws2-kms)
     * Manage keys stored in AWS KMS instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-kms
     * 
     * @return the dsl builder
     */
    static Aws2KmsComponentBuilderFactory.Aws2KmsComponentBuilder aws2Kms() {
        return Aws2KmsComponentBuilderFactory.aws2Kms();
    }
    /**
     * AWS Lambda (camel-aws2-lambda)
     * Manage and invoke AWS Lambda functions.
     * 
     * Category: cloud,serverless
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-lambda
     * 
     * @return the dsl builder
     */
    static Aws2LambdaComponentBuilderFactory.Aws2LambdaComponentBuilder aws2Lambda() {
        return Aws2LambdaComponentBuilderFactory.aws2Lambda();
    }
    /**
     * AWS MQ (camel-aws2-mq)
     * Send messages to AWS MQ.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-mq
     * 
     * @return the dsl builder
     */
    static Aws2MqComponentBuilderFactory.Aws2MqComponentBuilder aws2Mq() {
        return Aws2MqComponentBuilderFactory.aws2Mq();
    }
    /**
     * AWS Managed Streaming for Apache Kafka (MSK) (camel-aws2-msk)
     * Manage AWS MSK instances.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-msk
     * 
     * @return the dsl builder
     */
    static Aws2MskComponentBuilderFactory.Aws2MskComponentBuilder aws2Msk() {
        return Aws2MskComponentBuilderFactory.aws2Msk();
    }
    /**
     * AWS RedshiftData (camel-aws2-redshift)
     * Perform operations on AWS Redshift using Redshift Data API.
     * 
     * Category: cloud,serverless,database,bigdata
     * Since: 4.1
     * Maven coordinates: org.apache.camel:camel-aws2-redshift
     * 
     * @return the dsl builder
     */
    static Aws2RedshiftDataComponentBuilderFactory.Aws2RedshiftDataComponentBuilder aws2RedshiftData() {
        return Aws2RedshiftDataComponentBuilderFactory.aws2RedshiftData();
    }
    /**
     * AWS S3 Storage Service (camel-aws2-s3)
     * Store and retrieve objects from AWS S3 Storage Service.
     * 
     * Category: cloud,file
     * Since: 3.2
     * Maven coordinates: org.apache.camel:camel-aws2-s3
     * 
     * @return the dsl builder
     */
    static Aws2S3ComponentBuilderFactory.Aws2S3ComponentBuilder aws2S3() {
        return Aws2S3ComponentBuilderFactory.aws2S3();
    }
    /**
     * AWS Simple Email Service (SES) (camel-aws2-ses)
     * Send e-mails through AWS SES service.
     * 
     * Category: cloud,mail
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ses
     * 
     * @return the dsl builder
     */
    static Aws2SesComponentBuilderFactory.Aws2SesComponentBuilder aws2Ses() {
        return Aws2SesComponentBuilderFactory.aws2Ses();
    }
    /**
     * AWS Simple Notification System (SNS) (camel-aws2-sns)
     * Send messages to AWS Simple Notification Topic.
     * 
     * Category: cloud,messaging,mobile
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sns
     * 
     * @return the dsl builder
     */
    static Aws2SnsComponentBuilderFactory.Aws2SnsComponentBuilder aws2Sns() {
        return Aws2SnsComponentBuilderFactory.aws2Sns();
    }
    /**
     * AWS Simple Queue Service (SQS) (camel-aws2-sqs)
     * Send and receive messages to/from AWS SQS.
     * 
     * Category: cloud,messaging
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-sqs
     * 
     * @return the dsl builder
     */
    static Aws2SqsComponentBuilderFactory.Aws2SqsComponentBuilder aws2Sqs() {
        return Aws2SqsComponentBuilderFactory.aws2Sqs();
    }
    /**
     * AWS StepFunctions (camel-aws2-step-functions)
     * Manage and invoke AWS Step functions.
     * 
     * Category: cloud,serverless
     * Since: 4.0
     * Maven coordinates: org.apache.camel:camel-aws2-step-functions
     * 
     * @return the dsl builder
     */
    static Aws2StepFunctionsComponentBuilderFactory.Aws2StepFunctionsComponentBuilder aws2StepFunctions() {
        return Aws2StepFunctionsComponentBuilderFactory.aws2StepFunctions();
    }
    /**
     * AWS Security Token Service (STS) (camel-aws2-sts)
     * Manage AWS STS cluster instances.
     * 
     * Category: cloud,management
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-aws2-sts
     * 
     * @return the dsl builder
     */
    static Aws2StsComponentBuilderFactory.Aws2StsComponentBuilder aws2Sts() {
        return Aws2StsComponentBuilderFactory.aws2Sts();
    }
    /**
     * AWS Timestream (camel-aws2-timestream)
     * Write records and execute queries on AWS time-series database
     * 
     * Category: cloud,database
     * Since: 4.1
     * Maven coordinates: org.apache.camel:camel-aws2-timestream
     * 
     * @return the dsl builder
     */
    static Aws2TimestreamComponentBuilderFactory.Aws2TimestreamComponentBuilder aws2Timestream() {
        return Aws2TimestreamComponentBuilderFactory.aws2Timestream();
    }
    /**
     * AWS Translate (camel-aws2-translate)
     * Translate texts using AWS Translate and AWS SDK version 2.x.
     * 
     * Category: cloud,management
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-translate
     * 
     * @return the dsl builder
     */
    static Aws2TranslateComponentBuilderFactory.Aws2TranslateComponentBuilder aws2Translate() {
        return Aws2TranslateComponentBuilderFactory.aws2Translate();
    }
    /**
     * Azure CosmosDB (camel-azure-cosmosdb)
     * To read and write records to the CosmosDB database on Azure cloud
     * platform.
     * 
     * Category: cloud,database
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-azure-cosmosdb
     * 
     * @return the dsl builder
     */
    static AzureCosmosdbComponentBuilderFactory.AzureCosmosdbComponentBuilder azureCosmosdb() {
        return AzureCosmosdbComponentBuilderFactory.azureCosmosdb();
    }
    /**
     * Azure Event Hubs (camel-azure-eventhubs)
     * Send and receive events to/from Azure Event Hubs using AMQP protocol.
     * 
     * Category: cloud,messaging
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-azure-eventhubs
     * 
     * @return the dsl builder
     */
    static AzureEventhubsComponentBuilderFactory.AzureEventhubsComponentBuilder azureEventhubs() {
        return AzureEventhubsComponentBuilderFactory.azureEventhubs();
    }
    /**
     * Azure Files (camel-azure-files)
     * Send and receive files to Azure storage file share
     * 
     * Category: cloud,file
     * Since: 3.22
     * Maven coordinates: org.apache.camel:camel-azure-files
     * 
     * @return the dsl builder
     */
    static AzureFilesComponentBuilderFactory.AzureFilesComponentBuilder azureFiles() {
        return AzureFilesComponentBuilderFactory.azureFiles();
    }
    /**
     * Azure Key Vault (camel-azure-key-vault)
     * Manage secrets and keys in Azure Key Vault Service
     * 
     * Category: cloud,cloud
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-azure-key-vault
     * 
     * @return the dsl builder
     */
    static AzureKeyVaultComponentBuilderFactory.AzureKeyVaultComponentBuilder azureKeyVault() {
        return AzureKeyVaultComponentBuilderFactory.azureKeyVault();
    }
    /**
     * Azure ServiceBus (camel-azure-servicebus)
     * Send and receive messages to/from Azure Service Bus.
     * 
     * Category: cloud,messaging
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-azure-servicebus
     * 
     * @return the dsl builder
     */
    static AzureServicebusComponentBuilderFactory.AzureServicebusComponentBuilder azureServicebus() {
        return AzureServicebusComponentBuilderFactory.azureServicebus();
    }
    /**
     * Azure Storage Blob Service (camel-azure-storage-blob)
     * Store and retrieve blobs from Azure Storage Blob Service.
     * 
     * Category: cloud,file
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-blob
     * 
     * @return the dsl builder
     */
    static AzureStorageBlobComponentBuilderFactory.AzureStorageBlobComponentBuilder azureStorageBlob() {
        return AzureStorageBlobComponentBuilderFactory.azureStorageBlob();
    }
    /**
     * Azure Storage Data Lake Service (camel-azure-storage-datalake)
     * Sends and receives files to/from Azure Data Lake Storage.
     * 
     * Category: cloud,file,bigdata
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-azure-storage-datalake
     * 
     * @return the dsl builder
     */
    static AzureStorageDatalakeComponentBuilderFactory.AzureStorageDatalakeComponentBuilder azureStorageDatalake() {
        return AzureStorageDatalakeComponentBuilderFactory.azureStorageDatalake();
    }
    /**
     * Azure Storage Queue Service (camel-azure-storage-queue)
     * Stores and retrieves messages to/from Azure Storage Queue.
     * 
     * Category: cloud,messaging
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-azure-storage-queue
     * 
     * @return the dsl builder
     */
    static AzureStorageQueueComponentBuilderFactory.AzureStorageQueueComponentBuilder azureStorageQueue() {
        return AzureStorageQueueComponentBuilderFactory.azureStorageQueue();
    }
    /**
     * Bean (camel-bean)
     * Invoke methods of Java beans stored in Camel registry.
     * 
     * Category: core,script
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * @return the dsl builder
     */
    static BeanComponentBuilderFactory.BeanComponentBuilder bean() {
        return BeanComponentBuilderFactory.bean();
    }
    /**
     * Bean Validator (camel-bean-validator)
     * Validate the message body using the Java Bean Validation API.
     * 
     * Category: validation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-bean-validator
     * 
     * @return the dsl builder
     */
    static BeanValidatorComponentBuilderFactory.BeanValidatorComponentBuilder beanValidator() {
        return BeanValidatorComponentBuilderFactory.beanValidator();
    }
    /**
     * Bonita (camel-bonita)
     * Communicate with a remote Bonita BPM process engine.
     * 
     * Category: workflow
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-bonita
     * 
     * @return the dsl builder
     */
    static BonitaComponentBuilderFactory.BonitaComponentBuilder bonita() {
        return BonitaComponentBuilderFactory.bonita();
    }
    /**
     * Box (camel-box)
     * Upload, download and manage files, folders, groups, collaborations, etc.
     * on box.com.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-box
     * 
     * @return the dsl builder
     */
    static BoxComponentBuilderFactory.BoxComponentBuilder box() {
        return BoxComponentBuilderFactory.box();
    }
    /**
     * Braintree (camel-braintree)
     * Process payments using Braintree Payments.
     * 
     * Category: saas
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-braintree
     * 
     * @return the dsl builder
     */
    static BraintreeComponentBuilderFactory.BraintreeComponentBuilder braintree() {
        return BraintreeComponentBuilderFactory.braintree();
    }
    /**
     * Browse (camel-browse)
     * Inspect the messages received on endpoints supporting BrowsableEndpoint.
     * 
     * Category: core,monitoring
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-browse
     * 
     * @return the dsl builder
     */
    static BrowseComponentBuilderFactory.BrowseComponentBuilder browse() {
        return BrowseComponentBuilderFactory.browse();
    }
    /**
     * Caffeine Cache (camel-caffeine)
     * Perform caching operations using Caffeine Cache.
     * 
     * Category: cache,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * @return the dsl builder
     */
    static CaffeineCacheComponentBuilderFactory.CaffeineCacheComponentBuilder caffeineCache() {
        return CaffeineCacheComponentBuilderFactory.caffeineCache();
    }
    /**
     * Caffeine LoadCache (camel-caffeine)
     * Perform caching operations using Caffeine Cache with an attached
     * CacheLoader.
     * 
     * Category: cache,clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-caffeine
     * 
     * @return the dsl builder
     */
    static CaffeineLoadcacheComponentBuilderFactory.CaffeineLoadcacheComponentBuilder caffeineLoadcache() {
        return CaffeineLoadcacheComponentBuilderFactory.caffeineLoadcache();
    }
    /**
     * ChatScript (camel-chatscript)
     * Chat with a ChatScript Server.
     * 
     * Category: ai,chat
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-chatscript
     * 
     * @return the dsl builder
     */
    static ChatscriptComponentBuilderFactory.ChatscriptComponentBuilder chatscript() {
        return ChatscriptComponentBuilderFactory.chatscript();
    }
    /**
     * Chunk (camel-chunk)
     * Transform messages using Chunk templating engine.
     * 
     * Category: transformation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-chunk
     * 
     * @return the dsl builder
     */
    static ChunkComponentBuilderFactory.ChunkComponentBuilder chunk() {
        return ChunkComponentBuilderFactory.chunk();
    }
    /**
     * Class (camel-bean)
     * Invoke methods of Java beans specified by class name.
     * 
     * Category: core,script
     * Since: 2.4
     * Maven coordinates: org.apache.camel:camel-bean
     * 
     * @return the dsl builder
     */
    static ClasComponentBuilderFactory.ClasComponentBuilder clas() {
        return ClasComponentBuilderFactory.clas();
    }
    /**
     * CM SMS Gateway (camel-cm-sms)
     * Send SMS messages via CM SMS Gateway.
     * 
     * Category: mobile
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-cm-sms
     * 
     * @return the dsl builder
     */
    static CmSmsComponentBuilderFactory.CmSmsComponentBuilder cmSms() {
        return CmSmsComponentBuilderFactory.cmSms();
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static CoapComponentBuilderFactory.CoapComponentBuilder coap() {
        return CoapComponentBuilderFactory.coap();
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static CoapTcpComponentBuilderFactory.CoapTcpComponentBuilder coapTcp() {
        return CoapTcpComponentBuilderFactory.coapTcp();
    }
    /**
     * CoAP (Secure) (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static CoapsComponentBuilderFactory.CoapsComponentBuilder coaps() {
        return CoapsComponentBuilderFactory.coaps();
    }
    /**
     * CoAP (camel-coap)
     * Send and receive messages to/from COAP capable devices.
     * 
     * Category: iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-coap
     * 
     * @return the dsl builder
     */
    static CoapsTcpComponentBuilderFactory.CoapsTcpComponentBuilder coapsTcp() {
        return CoapsTcpComponentBuilderFactory.coapsTcp();
    }
    /**
     * CometD (camel-cometd)
     * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
     * messaging using the CometD/Bayeux protocol.
     * 
     * Category: networking,messaging
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     * 
     * @return the dsl builder
     */
    static CometdComponentBuilderFactory.CometdComponentBuilder cometd() {
        return CometdComponentBuilderFactory.cometd();
    }
    /**
     * CometD (Secure) (camel-cometd)
     * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
     * messaging using the CometD/Bayeux protocol.
     * 
     * Category: networking,messaging
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cometd
     * 
     * @return the dsl builder
     */
    static CometdsComponentBuilderFactory.CometdsComponentBuilder cometds() {
        return CometdsComponentBuilderFactory.cometds();
    }
    /**
     * Consul (camel-consul)
     * Integrate with Consul service discovery and configuration store.
     * 
     * Category: cloud,api
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-consul
     * 
     * @return the dsl builder
     */
    static ConsulComponentBuilderFactory.ConsulComponentBuilder consul() {
        return ConsulComponentBuilderFactory.consul();
    }
    /**
     * Control Bus (camel-controlbus)
     * Manage and monitor Camel routes.
     * 
     * Category: core,monitoring
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-controlbus
     * 
     * @return the dsl builder
     */
    static ControlbusComponentBuilderFactory.ControlbusComponentBuilder controlbus() {
        return ControlbusComponentBuilderFactory.controlbus();
    }
    /**
     * Couchbase (camel-couchbase)
     * Query Couchbase Views with a poll strategy and/or perform various
     * operations against Couchbase databases.
     * 
     * Category: database
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-couchbase
     * 
     * @return the dsl builder
     */
    static CouchbaseComponentBuilderFactory.CouchbaseComponentBuilder couchbase() {
        return CouchbaseComponentBuilderFactory.couchbase();
    }
    /**
     * CouchDB (camel-couchdb)
     * Consume changesets for inserts, updates and deletes in a CouchDB
     * database, as well as get, save, update and delete documents from a
     * CouchDB database.
     * 
     * Category: database
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-couchdb
     * 
     * @return the dsl builder
     */
    static CouchdbComponentBuilderFactory.CouchdbComponentBuilder couchdb() {
        return CouchdbComponentBuilderFactory.couchdb();
    }
    /**
     * Cassandra CQL (camel-cassandraql)
     * Integrate with Cassandra 2.0 using the CQL3 API (not the Thrift API).
     * Based on Cassandra Java Driver provided by DataStax.
     * 
     * Category: database,bigdata
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-cassandraql
     * 
     * @return the dsl builder
     */
    static CqlComponentBuilderFactory.CqlComponentBuilder cql() {
        return CqlComponentBuilderFactory.cql();
    }
    /**
     * Cron (camel-cron)
     * A generic interface for triggering events at times specified through the
     * Unix cron syntax.
     * 
     * Category: scheduling
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-cron
     * 
     * @return the dsl builder
     */
    static CronComponentBuilderFactory.CronComponentBuilder cron() {
        return CronComponentBuilderFactory.cron();
    }
    /**
     * Crypto (JCE) (camel-crypto)
     * Sign and verify exchanges using the Signature Service of the Java
     * Cryptographic Extension (JCE).
     * 
     * Category: security,transformation
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-crypto
     * 
     * @return the dsl builder
     */
    static CryptoComponentBuilderFactory.CryptoComponentBuilder crypto() {
        return CryptoComponentBuilderFactory.crypto();
    }
    /**
     * CXF (camel-cxf-soap)
     * Expose SOAP WebServices using Apache CXF or connect to external
     * WebServices using CXF WS client.
     * 
     * Category: http,webservice
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-cxf-soap
     * 
     * @return the dsl builder
     */
    static CxfComponentBuilderFactory.CxfComponentBuilder cxf() {
        return CxfComponentBuilderFactory.cxf();
    }
    /**
     * CXF-RS (camel-cxf-rest)
     * Expose JAX-RS REST services using Apache CXF or connect to external REST
     * services using CXF REST client.
     * 
     * Category: rest
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-cxf-rest
     * 
     * @return the dsl builder
     */
    static CxfrsComponentBuilderFactory.CxfrsComponentBuilder cxfrs() {
        return CxfrsComponentBuilderFactory.cxfrs();
    }
    /**
     * Data Format (camel-dataformat)
     * Use a Camel Data Format as a regular Camel Component.
     * 
     * Category: core,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-dataformat
     * 
     * @return the dsl builder
     */
    static DataformatComponentBuilderFactory.DataformatComponentBuilder dataformat() {
        return DataformatComponentBuilderFactory.dataformat();
    }
    /**
     * Dataset (camel-dataset)
     * Provide data for load and soak testing of your Camel application.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * @return the dsl builder
     */
    static DatasetComponentBuilderFactory.DatasetComponentBuilder dataset() {
        return DatasetComponentBuilderFactory.dataset();
    }
    /**
     * DataSet Test (camel-dataset)
     * Extends the mock component by pulling messages from another endpoint on
     * startup to set the expected message bodies.
     * 
     * Category: core,testing
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-dataset
     * 
     * @return the dsl builder
     */
    static DatasetTestComponentBuilderFactory.DatasetTestComponentBuilder datasetTest() {
        return DatasetTestComponentBuilderFactory.datasetTest();
    }
    /**
     * Debezium DB2 Connector (camel-debezium-db2)
     * Capture changes from a DB2 database.
     * 
     * Category: database
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-db2
     * 
     * @return the dsl builder
     */
    static DebeziumDb2ComponentBuilderFactory.DebeziumDb2ComponentBuilder debeziumDb2() {
        return DebeziumDb2ComponentBuilderFactory.debeziumDb2();
    }
    /**
     * Debezium MongoDB Connector (camel-debezium-mongodb)
     * Capture changes from a MongoDB database.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mongodb
     * 
     * @return the dsl builder
     */
    static DebeziumMongodbComponentBuilderFactory.DebeziumMongodbComponentBuilder debeziumMongodb() {
        return DebeziumMongodbComponentBuilderFactory.debeziumMongodb();
    }
    /**
     * Debezium MySQL Connector (camel-debezium-mysql)
     * Capture changes from a MySQL database.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mysql
     * 
     * @return the dsl builder
     */
    static DebeziumMysqlComponentBuilderFactory.DebeziumMysqlComponentBuilder debeziumMysql() {
        return DebeziumMysqlComponentBuilderFactory.debeziumMysql();
    }
    /**
     * Debezium Oracle Connector (camel-debezium-oracle)
     * Capture changes from a Oracle database.
     * 
     * Category: database
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-oracle
     * 
     * @return the dsl builder
     */
    static DebeziumOracleComponentBuilderFactory.DebeziumOracleComponentBuilder debeziumOracle() {
        return DebeziumOracleComponentBuilderFactory.debeziumOracle();
    }
    /**
     * Debezium PostgresSQL Connector (camel-debezium-postgres)
     * Capture changes from a PostgresSQL database.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-postgres
     * 
     * @return the dsl builder
     */
    static DebeziumPostgresComponentBuilderFactory.DebeziumPostgresComponentBuilder debeziumPostgres() {
        return DebeziumPostgresComponentBuilderFactory.debeziumPostgres();
    }
    /**
     * Debezium SQL Server Connector (camel-debezium-sqlserver)
     * Capture changes from an SQL Server database.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
     * 
     * @return the dsl builder
     */
    static DebeziumSqlserverComponentBuilderFactory.DebeziumSqlserverComponentBuilder debeziumSqlserver() {
        return DebeziumSqlserverComponentBuilderFactory.debeziumSqlserver();
    }
    /**
     * DHIS2 (camel-dhis2)
     * Leverages the DHIS2 Java SDK to integrate Apache Camel with the DHIS2 Web
     * API.
     * 
     * Category: api
     * Since: 4.0
     * Maven coordinates: org.apache.camel:camel-dhis2
     * 
     * @return the dsl builder
     */
    static Dhis2ComponentBuilderFactory.Dhis2ComponentBuilder dhis2() {
        return Dhis2ComponentBuilderFactory.dhis2();
    }
    /**
     * DigitalOcean (camel-digitalocean)
     * Manage Droplets and resources within the DigitalOcean cloud.
     * 
     * Category: cloud,management
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-digitalocean
     * 
     * @return the dsl builder
     */
    static DigitaloceanComponentBuilderFactory.DigitaloceanComponentBuilder digitalocean() {
        return DigitaloceanComponentBuilderFactory.digitalocean();
    }
    /**
     * Direct (camel-direct)
     * Call another endpoint from the same Camel Context synchronously.
     * 
     * Category: core,messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-direct
     * 
     * @return the dsl builder
     */
    static DirectComponentBuilderFactory.DirectComponentBuilder direct() {
        return DirectComponentBuilderFactory.direct();
    }
    /**
     * Disruptor (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * @return the dsl builder
     */
    static DisruptorComponentBuilderFactory.DisruptorComponentBuilder disruptor() {
        return DisruptorComponentBuilderFactory.disruptor();
    }
    /**
     * Disruptor VM (camel-disruptor)
     * Provides asynchronous SEDA behavior using LMAX Disruptor.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-disruptor
     * 
     * @return the dsl builder
     */
    static DisruptorVmComponentBuilderFactory.DisruptorVmComponentBuilder disruptorVm() {
        return DisruptorVmComponentBuilderFactory.disruptorVm();
    }
    /**
     * Deep Java Library (camel-djl)
     * Infer Deep Learning models from message exchanges data using Deep Java
     * Library (DJL).
     * 
     * Category: ai
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-djl
     * 
     * @return the dsl builder
     */
    static DjlComponentBuilderFactory.DjlComponentBuilder djl() {
        return DjlComponentBuilderFactory.djl();
    }
    /**
     * DNS (camel-dns)
     * Perform DNS queries using DNSJava.
     * 
     * Category: networking
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-dns
     * 
     * @return the dsl builder
     */
    static DnsComponentBuilderFactory.DnsComponentBuilder dns() {
        return DnsComponentBuilderFactory.dns();
    }
    /**
     * Docker (camel-docker)
     * Manage Docker containers.
     * 
     * Category: cloud,container
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-docker
     * 
     * @return the dsl builder
     */
    static DockerComponentBuilderFactory.DockerComponentBuilder docker() {
        return DockerComponentBuilderFactory.docker();
    }
    /**
     * Drill (camel-drill)
     * Perform queries against an Apache Drill cluster.
     * 
     * Category: database,bigdata
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-drill
     * 
     * @return the dsl builder
     */
    static DrillComponentBuilderFactory.DrillComponentBuilder drill() {
        return DrillComponentBuilderFactory.drill();
    }
    /**
     * Dropbox (camel-dropbox)
     * Upload, download and manage files, folders, groups, collaborations, etc
     * on Dropbox.
     * 
     * Category: cloud,file,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-dropbox
     * 
     * @return the dsl builder
     */
    static DropboxComponentBuilderFactory.DropboxComponentBuilder dropbox() {
        return DropboxComponentBuilderFactory.dropbox();
    }
    /**
     * Dynamic Router (camel-dynamic-router)
     * The Dynamic Router component routes exchanges to recipients, and the
     * recipients (and their rules) may change at runtime.
     * 
     * Category: messaging,core
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-dynamic-router
     * 
     * @return the dsl builder
     */
    static DynamicRouterComponentBuilderFactory.DynamicRouterComponentBuilder dynamicRouter() {
        return DynamicRouterComponentBuilderFactory.dynamicRouter();
    }
    /**
     * Dynamic Router Control (camel-dynamic-router)
     * The Dynamic Router control endpoint for operations that allow routing
     * participants to subscribe or unsubscribe to participate in dynamic
     * message routing.
     * 
     * Category: messaging
     * Since: 4.4
     * Maven coordinates: org.apache.camel:camel-dynamic-router
     * 
     * @return the dsl builder
     */
    static DynamicRouterControlComponentBuilderFactory.DynamicRouterControlComponentBuilder dynamicRouterControl() {
        return DynamicRouterControlComponentBuilderFactory.dynamicRouterControl();
    }
    /**
     * Ehcache (camel-ehcache)
     * Perform caching operations using Ehcache.
     * 
     * Category: cache,clustering
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-ehcache
     * 
     * @return the dsl builder
     */
    static EhcacheComponentBuilderFactory.EhcacheComponentBuilder ehcache() {
        return EhcacheComponentBuilderFactory.ehcache();
    }
    /**
     * Elasticsearch (camel-elasticsearch)
     * Send requests to ElasticSearch via Java Client API.
     * 
     * Category: search,monitoring
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-elasticsearch
     * 
     * @return the dsl builder
     */
    static ElasticsearchComponentBuilderFactory.ElasticsearchComponentBuilder elasticsearch() {
        return ElasticsearchComponentBuilderFactory.elasticsearch();
    }
    /**
     * Elasticsearch Low level Rest Client (camel-elasticsearch-rest-client)
     * Perform queries and other operations on Elasticsearch or OpenSearch (uses
     * low-level client).
     * 
     * Category: search
     * Since: 4.3
     * Maven coordinates: org.apache.camel:camel-elasticsearch-rest-client
     * 
     * @return the dsl builder
     */
    static ElasticsearchRestClientComponentBuilderFactory.ElasticsearchRestClientComponentBuilder elasticsearchRestClient() {
        return ElasticsearchRestClientComponentBuilderFactory.elasticsearchRestClient();
    }
    /**
     * Etcd v3 (camel-etcd3)
     * Get, set, delete or watch keys in etcd key-value store.
     * 
     * Category: clustering,database
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-etcd3
     * 
     * @return the dsl builder
     */
    static Etcd3ComponentBuilderFactory.Etcd3ComponentBuilder etcd3() {
        return Etcd3ComponentBuilderFactory.etcd3();
    }
    /**
     * Exec (camel-exec)
     * Execute commands on the underlying operating system.
     * 
     * Category: core
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-exec
     * 
     * @return the dsl builder
     */
    static ExecComponentBuilderFactory.ExecComponentBuilder exec() {
        return ExecComponentBuilderFactory.exec();
    }
    /**
     * FHIR (camel-fhir)
     * Exchange information in the healthcare domain using the FHIR (Fast
     * Healthcare Interoperability Resources) standard.
     * 
     * Category: api
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-fhir
     * 
     * @return the dsl builder
     */
    static FhirComponentBuilderFactory.FhirComponentBuilder fhir() {
        return FhirComponentBuilderFactory.fhir();
    }
    /**
     * File (camel-file)
     * Read and write files.
     * 
     * Category: file,core
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-file
     * 
     * @return the dsl builder
     */
    static FileComponentBuilderFactory.FileComponentBuilder file() {
        return FileComponentBuilderFactory.file();
    }
    /**
     * File Watch (camel-file-watch)
     * Get notified about file events in a directory using
     * java.nio.file.WatchService.
     * 
     * Category: file
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-file-watch
     * 
     * @return the dsl builder
     */
    static FileWatchComponentBuilderFactory.FileWatchComponentBuilder fileWatch() {
        return FileWatchComponentBuilderFactory.fileWatch();
    }
    /**
     * Flatpack (camel-flatpack)
     * Parse fixed width and delimited files using the FlatPack library.
     * 
     * Category: transformation
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-flatpack
     * 
     * @return the dsl builder
     */
    static FlatpackComponentBuilderFactory.FlatpackComponentBuilder flatpack() {
        return FlatpackComponentBuilderFactory.flatpack();
    }
    /**
     * Flink (camel-flink)
     * Send DataSet jobs to an Apache Flink cluster.
     * 
     * Category: transformation,bigdata
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-flink
     * 
     * @return the dsl builder
     */
    static FlinkComponentBuilderFactory.FlinkComponentBuilder flink() {
        return FlinkComponentBuilderFactory.flink();
    }
    /**
     * FOP (camel-fop)
     * Render messages into PDF and other output formats supported by Apache
     * FOP.
     * 
     * Category: file,transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-fop
     * 
     * @return the dsl builder
     */
    static FopComponentBuilderFactory.FopComponentBuilder fop() {
        return FopComponentBuilderFactory.fop();
    }
    /**
     * Freemarker (camel-freemarker)
     * Transform messages using FreeMarker templates.
     * 
     * Category: transformation
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-freemarker
     * 
     * @return the dsl builder
     */
    static FreemarkerComponentBuilderFactory.FreemarkerComponentBuilder freemarker() {
        return FreemarkerComponentBuilderFactory.freemarker();
    }
    /**
     * FTP (camel-ftp)
     * Upload and download files to/from FTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * @return the dsl builder
     */
    static FtpComponentBuilderFactory.FtpComponentBuilder ftp() {
        return FtpComponentBuilderFactory.ftp();
    }
    /**
     * FTPS (camel-ftp)
     * Upload and download files to/from FTP servers supporting the FTPS
     * protocol.
     * 
     * Category: file
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * @return the dsl builder
     */
    static FtpsComponentBuilderFactory.FtpsComponentBuilder ftps() {
        return FtpsComponentBuilderFactory.ftps();
    }
    /**
     * Geocoder (camel-geocoder)
     * Find geocodes (latitude and longitude) for a given address or the other
     * way round.
     * 
     * Category: api,search
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-geocoder
     * 
     * @return the dsl builder
     */
    static GeocoderComponentBuilderFactory.GeocoderComponentBuilder geocoder() {
        return GeocoderComponentBuilderFactory.geocoder();
    }
    /**
     * Git (camel-git)
     * Perform operations on git repositories.
     * 
     * Category: file
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-git
     * 
     * @return the dsl builder
     */
    static GitComponentBuilderFactory.GitComponentBuilder git() {
        return GitComponentBuilderFactory.git();
    }
    /**
     * GitHub (camel-github)
     * Interact with the GitHub API.
     * 
     * Category: file,cloud,api
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-github
     * 
     * @return the dsl builder
     */
    static GithubComponentBuilderFactory.GithubComponentBuilder github() {
        return GithubComponentBuilderFactory.github();
    }
    /**
     * Google BigQuery (camel-google-bigquery)
     * Google BigQuery data warehouse for analytics.
     * 
     * Category: cloud,bigdata
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * @return the dsl builder
     */
    static GoogleBigqueryComponentBuilderFactory.GoogleBigqueryComponentBuilder googleBigquery() {
        return GoogleBigqueryComponentBuilderFactory.googleBigquery();
    }
    /**
     * Google BigQuery Standard SQL (camel-google-bigquery)
     * Access Google Cloud BigQuery service using SQL queries.
     * 
     * Category: cloud,messaging
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-bigquery
     * 
     * @return the dsl builder
     */
    static GoogleBigquerySqlComponentBuilderFactory.GoogleBigquerySqlComponentBuilder googleBigquerySql() {
        return GoogleBigquerySqlComponentBuilderFactory.googleBigquerySql();
    }
    /**
     * Google Calendar (camel-google-calendar)
     * Perform various operations on a Google Calendar.
     * 
     * Category: api,cloud
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * @return the dsl builder
     */
    static GoogleCalendarComponentBuilderFactory.GoogleCalendarComponentBuilder googleCalendar() {
        return GoogleCalendarComponentBuilderFactory.googleCalendar();
    }
    /**
     * Google Calendar Stream (camel-google-calendar)
     * Poll for changes in a Google Calendar.
     * 
     * Category: cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     * 
     * @return the dsl builder
     */
    static GoogleCalendarStreamComponentBuilderFactory.GoogleCalendarStreamComponentBuilder googleCalendarStream() {
        return GoogleCalendarStreamComponentBuilderFactory.googleCalendarStream();
    }
    /**
     * Google Drive (camel-google-drive)
     * Manage files in Google Drive.
     * 
     * Category: file,cloud,api
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-google-drive
     * 
     * @return the dsl builder
     */
    static GoogleDriveComponentBuilderFactory.GoogleDriveComponentBuilder googleDrive() {
        return GoogleDriveComponentBuilderFactory.googleDrive();
    }
    /**
     * Google Cloud Functions (camel-google-functions)
     * Manage and invoke Google Cloud Functions
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-functions
     * 
     * @return the dsl builder
     */
    static GoogleFunctionsComponentBuilderFactory.GoogleFunctionsComponentBuilder googleFunctions() {
        return GoogleFunctionsComponentBuilderFactory.googleFunctions();
    }
    /**
     * Google Mail (camel-google-mail)
     * Manage messages in Google Mail.
     * 
     * Category: cloud,api,mail
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * @return the dsl builder
     */
    static GoogleMailComponentBuilderFactory.GoogleMailComponentBuilder googleMail() {
        return GoogleMailComponentBuilderFactory.googleMail();
    }
    /**
     * Google Mail Stream (camel-google-mail)
     * Poll for incoming messages in Google Mail.
     * 
     * Category: cloud,mail
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-google-mail
     * 
     * @return the dsl builder
     */
    static GoogleMailStreamComponentBuilderFactory.GoogleMailStreamComponentBuilder googleMailStream() {
        return GoogleMailStreamComponentBuilderFactory.googleMailStream();
    }
    /**
     * Google Pubsub (camel-google-pubsub)
     * Send and receive messages to/from Google Cloud Platform PubSub Service.
     * 
     * Category: cloud,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-google-pubsub
     * 
     * @return the dsl builder
     */
    static GooglePubsubComponentBuilderFactory.GooglePubsubComponentBuilder googlePubsub() {
        return GooglePubsubComponentBuilderFactory.googlePubsub();
    }
    /**
     * Google PubSub Lite (camel-google-pubsub-lite)
     * Send and receive messages to/from Google Cloud Platform PubSub Lite
     * Service.
     * 
     * Category: cloud,messaging
     * Since: 4.6
     * Maven coordinates: org.apache.camel:camel-google-pubsub-lite
     * 
     * @return the dsl builder
     */
    static GooglePubsubLiteComponentBuilderFactory.GooglePubsubLiteComponentBuilder googlePubsubLite() {
        return GooglePubsubLiteComponentBuilderFactory.googlePubsubLite();
    }
    /**
     * Google Secret Manager (camel-google-secret-manager)
     * Manage Google Secret Manager Secrets
     * 
     * Category: cloud
     * Since: 3.16
     * Maven coordinates: org.apache.camel:camel-google-secret-manager
     * 
     * @return the dsl builder
     */
    static GoogleSecretManagerComponentBuilderFactory.GoogleSecretManagerComponentBuilder googleSecretManager() {
        return GoogleSecretManagerComponentBuilderFactory.googleSecretManager();
    }
    /**
     * Google Sheets (camel-google-sheets)
     * Manage spreadsheets in Google Sheets.
     * 
     * Category: cloud,document
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * @return the dsl builder
     */
    static GoogleSheetsComponentBuilderFactory.GoogleSheetsComponentBuilder googleSheets() {
        return GoogleSheetsComponentBuilderFactory.googleSheets();
    }
    /**
     * Google Sheets Stream (camel-google-sheets)
     * Poll for changes in Google Sheets.
     * 
     * Category: cloud,document
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-sheets
     * 
     * @return the dsl builder
     */
    static GoogleSheetsStreamComponentBuilderFactory.GoogleSheetsStreamComponentBuilder googleSheetsStream() {
        return GoogleSheetsStreamComponentBuilderFactory.googleSheetsStream();
    }
    /**
     * Google Storage (camel-google-storage)
     * Store and retrieve objects from Google Cloud Storage Service using the
     * google-cloud-storage library.
     * 
     * Category: cloud
     * Since: 3.9
     * Maven coordinates: org.apache.camel:camel-google-storage
     * 
     * @return the dsl builder
     */
    static GoogleStorageComponentBuilderFactory.GoogleStorageComponentBuilder googleStorage() {
        return GoogleStorageComponentBuilderFactory.googleStorage();
    }
    /**
     * Grape (camel-grape)
     * Fetch, load and manage additional jars dynamically after Camel Context
     * was started.
     * 
     * Category: management
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-grape
     * 
     * @return the dsl builder
     */
    static GrapeComponentBuilderFactory.GrapeComponentBuilder grape() {
        return GrapeComponentBuilderFactory.grape();
    }
    /**
     * GraphQL (camel-graphql)
     * Send GraphQL queries and mutations to external systems.
     * 
     * Category: api
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-graphql
     * 
     * @return the dsl builder
     */
    static GraphqlComponentBuilderFactory.GraphqlComponentBuilder graphql() {
        return GraphqlComponentBuilderFactory.graphql();
    }
    /**
     * gRPC (camel-grpc)
     * Expose gRPC endpoints and access external gRPC endpoints.
     * 
     * Category: rpc
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-grpc
     * 
     * @return the dsl builder
     */
    static GrpcComponentBuilderFactory.GrpcComponentBuilder grpc() {
        return GrpcComponentBuilderFactory.grpc();
    }
    /**
     * Guava EventBus (camel-guava-eventbus)
     * Send and receive messages to/from Guava EventBus.
     * 
     * Category: messaging
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-guava-eventbus
     * 
     * @return the dsl builder
     */
    static GuavaEventbusComponentBuilderFactory.GuavaEventbusComponentBuilder guavaEventbus() {
        return GuavaEventbusComponentBuilderFactory.guavaEventbus();
    }
    /**
     * Hashicorp Vault (camel-hashicorp-vault)
     * Manage secrets in Hashicorp Vault Service
     * 
     * Category: cloud,cloud
     * Since: 3.18
     * Maven coordinates: org.apache.camel:camel-hashicorp-vault
     * 
     * @return the dsl builder
     */
    static HashicorpVaultComponentBuilderFactory.HashicorpVaultComponentBuilder hashicorpVault() {
        return HashicorpVaultComponentBuilderFactory.hashicorpVault();
    }
    /**
     * Hazelcast Atomic Number (camel-hazelcast)
     * Increment, decrement, set, etc. Hazelcast atomic number (a grid wide
     * number).
     * 
     * Category: cache,clustering
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastAtomicvalueComponentBuilderFactory.HazelcastAtomicvalueComponentBuilder hazelcastAtomicvalue() {
        return HazelcastAtomicvalueComponentBuilderFactory.hazelcastAtomicvalue();
    }
    /**
     * Hazelcast Instance (camel-hazelcast)
     * Consume join/leave events of a cache instance in a Hazelcast cluster.
     * 
     * Category: cache,clustering
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastInstanceComponentBuilderFactory.HazelcastInstanceComponentBuilder hazelcastInstance() {
        return HazelcastInstanceComponentBuilderFactory.hazelcastInstance();
    }
    /**
     * Hazelcast List (camel-hazelcast)
     * Perform operations on Hazelcast distributed list.
     * 
     * Category: cache,clustering
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastListComponentBuilderFactory.HazelcastListComponentBuilder hazelcastList() {
        return HazelcastListComponentBuilderFactory.hazelcastList();
    }
    /**
     * Hazelcast Map (camel-hazelcast)
     * Perform operations on Hazelcast distributed map.
     * 
     * Category: cache,clustering
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastMapComponentBuilderFactory.HazelcastMapComponentBuilder hazelcastMap() {
        return HazelcastMapComponentBuilderFactory.hazelcastMap();
    }
    /**
     * Hazelcast Multimap (camel-hazelcast)
     * Perform operations on Hazelcast distributed multimap.
     * 
     * Category: cache,clustering
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastMultimapComponentBuilderFactory.HazelcastMultimapComponentBuilder hazelcastMultimap() {
        return HazelcastMultimapComponentBuilderFactory.hazelcastMultimap();
    }
    /**
     * Hazelcast Queue (camel-hazelcast)
     * Perform operations on Hazelcast distributed queue.
     * 
     * Category: cache,clustering,messaging
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastQueueComponentBuilderFactory.HazelcastQueueComponentBuilder hazelcastQueue() {
        return HazelcastQueueComponentBuilderFactory.hazelcastQueue();
    }
    /**
     * Hazelcast Replicated Map (camel-hazelcast)
     * Perform operations on Hazelcast replicated map.
     * 
     * Category: cache,clustering
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastReplicatedmapComponentBuilderFactory.HazelcastReplicatedmapComponentBuilder hazelcastReplicatedmap() {
        return HazelcastReplicatedmapComponentBuilderFactory.hazelcastReplicatedmap();
    }
    /**
     * Hazelcast Ringbuffer (camel-hazelcast)
     * Perform operations on Hazelcast distributed ringbuffer.
     * 
     * Category: cache,clustering
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastRingbufferComponentBuilderFactory.HazelcastRingbufferComponentBuilder hazelcastRingbuffer() {
        return HazelcastRingbufferComponentBuilderFactory.hazelcastRingbuffer();
    }
    /**
     * Hazelcast SEDA (camel-hazelcast)
     * Asynchronously send/receive Exchanges between Camel routes running on
     * potentially distinct JVMs/hosts backed by Hazelcast BlockingQueue.
     * 
     * Category: cache,clustering
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastSedaComponentBuilderFactory.HazelcastSedaComponentBuilder hazelcastSeda() {
        return HazelcastSedaComponentBuilderFactory.hazelcastSeda();
    }
    /**
     * Hazelcast Set (camel-hazelcast)
     * Perform operations on Hazelcast distributed set.
     * 
     * Category: cache,clustering
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastSetComponentBuilderFactory.HazelcastSetComponentBuilder hazelcastSet() {
        return HazelcastSetComponentBuilderFactory.hazelcastSet();
    }
    /**
     * Hazelcast Topic (camel-hazelcast)
     * Send and receive messages to/from Hazelcast distributed topic.
     * 
     * Category: cache,clustering
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-hazelcast
     * 
     * @return the dsl builder
     */
    static HazelcastTopicComponentBuilderFactory.HazelcastTopicComponentBuilder hazelcastTopic() {
        return HazelcastTopicComponentBuilderFactory.hazelcastTopic();
    }
    /**
     * HTTP (camel-http)
     * Send requests to external HTTP servers using Apache HTTP Client 5.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     * 
     * @return the dsl builder
     */
    static HttpComponentBuilderFactory.HttpComponentBuilder http() {
        return HttpComponentBuilderFactory.http();
    }
    /**
     * HTTPS (Secure) (camel-http)
     * Send requests to external HTTP servers using Apache HTTP Client 5.x.
     * 
     * Category: http
     * Since: 2.3
     * Maven coordinates: org.apache.camel:camel-http
     * 
     * @return the dsl builder
     */
    static HttpsComponentBuilderFactory.HttpsComponentBuilder https() {
        return HttpsComponentBuilderFactory.https();
    }
    /**
     * Huawei Distributed Message Service (DMS) (camel-huaweicloud-dms)
     * To integrate with a fully managed, high-performance message queuing
     * service on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-dms
     * 
     * @return the dsl builder
     */
    static HwcloudDmsComponentBuilderFactory.HwcloudDmsComponentBuilder hwcloudDms() {
        return HwcloudDmsComponentBuilderFactory.hwcloudDms();
    }
    /**
     * Huawei Cloud Face Recognition Service (FRS) (camel-huaweicloud-frs)
     * Face Recognition Service (FRS) is an intelligent service that uses
     * computers to process, analyze, and understand facial images based on
     * human facial features.
     * 
     * Category: cloud,messaging
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-huaweicloud-frs
     * 
     * @return the dsl builder
     */
    static HwcloudFrsComponentBuilderFactory.HwcloudFrsComponentBuilder hwcloudFrs() {
        return HwcloudFrsComponentBuilderFactory.hwcloudFrs();
    }
    /**
     * Huawei FunctionGraph (camel-huaweicloud-functiongraph)
     * To call serverless functions on Huawei Cloud
     * 
     * Category: cloud,serverless
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-functiongraph
     * 
     * @return the dsl builder
     */
    static HwcloudFunctiongraphComponentBuilderFactory.HwcloudFunctiongraphComponentBuilder hwcloudFunctiongraph() {
        return HwcloudFunctiongraphComponentBuilderFactory.hwcloudFunctiongraph();
    }
    /**
     * Huawei Identity and Access Management (IAM) (camel-huaweicloud-iam)
     * To securely manage users on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.11
     * Maven coordinates: org.apache.camel:camel-huaweicloud-iam
     * 
     * @return the dsl builder
     */
    static HwcloudIamComponentBuilderFactory.HwcloudIamComponentBuilder hwcloudIam() {
        return HwcloudIamComponentBuilderFactory.hwcloudIam();
    }
    /**
     * Huawei Cloud Image Recognition (camel-huaweicloud-imagerecognition)
     * To identify objects, scenes, and concepts in images on Huawei Cloud
     * 
     * Category: cloud,messaging
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-imagerecognition
     * 
     * @return the dsl builder
     */
    static HwcloudImagerecognitionComponentBuilderFactory.HwcloudImagerecognitionComponentBuilder hwcloudImagerecognition() {
        return HwcloudImagerecognitionComponentBuilderFactory.hwcloudImagerecognition();
    }
    /**
     * Huawei Object Storage Service (OBS) (camel-huaweicloud-obs)
     * To provide stable, secure, efficient, and easy-to-use cloud storage
     * service on Huawei Cloud
     * 
     * Category: cloud
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-huaweicloud-obs
     * 
     * @return the dsl builder
     */
    static HwcloudObsComponentBuilderFactory.HwcloudObsComponentBuilder hwcloudObs() {
        return HwcloudObsComponentBuilderFactory.hwcloudObs();
    }
    /**
     * Huawei Simple Message Notification (SMN) (camel-huaweicloud-smn)
     * To broadcast messages and connect cloud services through notifications on
     * Huawei Cloud
     * 
     * Category: cloud,messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-huaweicloud-smn
     * 
     * @return the dsl builder
     */
    static HwcloudSmnComponentBuilderFactory.HwcloudSmnComponentBuilder hwcloudSmn() {
        return HwcloudSmnComponentBuilderFactory.hwcloudSmn();
    }
    /**
     * IEC 60870 Client (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) client using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * @return the dsl builder
     */
    static Iec60870ClientComponentBuilderFactory.Iec60870ClientComponentBuilder iec60870Client() {
        return Iec60870ClientComponentBuilderFactory.iec60870Client();
    }
    /**
     * IEC 60870 Server (camel-iec60870)
     * IEC 60870 supervisory control and data acquisition (SCADA) server using
     * NeoSCADA implementation.
     * 
     * Category: iot
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * @return the dsl builder
     */
    static Iec60870ServerComponentBuilderFactory.Iec60870ServerComponentBuilder iec60870Server() {
        return Iec60870ServerComponentBuilderFactory.iec60870Server();
    }
    /**
     * Ignite Cache (camel-ignite)
     * Perform cache operations on an Ignite cache or consume changes from a
     * continuous query.
     * 
     * Category: cache,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static IgniteCacheComponentBuilderFactory.IgniteCacheComponentBuilder igniteCache() {
        return IgniteCacheComponentBuilderFactory.igniteCache();
    }
    /**
     * Ignite Compute (camel-ignite)
     * Run compute operations on an Ignite cluster.
     * 
     * Category: cache,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static IgniteComputeComponentBuilderFactory.IgniteComputeComponentBuilder igniteCompute() {
        return IgniteComputeComponentBuilderFactory.igniteCompute();
    }
    /**
     * Ignite Events (camel-ignite)
     * Receive events from an Ignite cluster by creating a local event listener.
     * 
     * Category: messaging,cache,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static IgniteEventsComponentBuilderFactory.IgniteEventsComponentBuilder igniteEvents() {
        return IgniteEventsComponentBuilderFactory.igniteEvents();
    }
    /**
     * Ignite ID Generator (camel-ignite)
     * Interact with Ignite Atomic Sequences and ID Generators .
     * 
     * Category: cache,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static IgniteIdgenComponentBuilderFactory.IgniteIdgenComponentBuilder igniteIdgen() {
        return IgniteIdgenComponentBuilderFactory.igniteIdgen();
    }
    /**
     * Ignite Messaging (camel-ignite)
     * Send and receive messages from an Ignite topic.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static IgniteMessagingComponentBuilderFactory.IgniteMessagingComponentBuilder igniteMessaging() {
        return IgniteMessagingComponentBuilderFactory.igniteMessaging();
    }
    /**
     * Ignite Queues (camel-ignite)
     * Interact with Ignite Queue data structures.
     * 
     * Category: cache,clustering,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static IgniteQueueComponentBuilderFactory.IgniteQueueComponentBuilder igniteQueue() {
        return IgniteQueueComponentBuilderFactory.igniteQueue();
    }
    /**
     * Ignite Sets (camel-ignite)
     * Interact with Ignite Set data structures.
     * 
     * Category: cache,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ignite
     * 
     * @return the dsl builder
     */
    static IgniteSetComponentBuilderFactory.IgniteSetComponentBuilder igniteSet() {
        return IgniteSetComponentBuilderFactory.igniteSet();
    }
    /**
     * IMAP (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static ImapComponentBuilderFactory.ImapComponentBuilder imap() {
        return ImapComponentBuilderFactory.imap();
    }
    /**
     * IMAPS (Secure) (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static ImapsComponentBuilderFactory.ImapsComponentBuilder imaps() {
        return ImapsComponentBuilderFactory.imaps();
    }
    /**
     * Infinispan (camel-infinispan)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan
     * 
     * @return the dsl builder
     */
    static InfinispanComponentBuilderFactory.InfinispanComponentBuilder infinispan() {
        return InfinispanComponentBuilderFactory.infinispan();
    }
    /**
     * Infinispan Embedded (camel-infinispan-embedded)
     * Read and write from/to Infinispan distributed key/value store and data
     * grid.
     * 
     * Category: cache,clustering
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-infinispan-embedded
     * 
     * @return the dsl builder
     */
    static InfinispanEmbeddedComponentBuilderFactory.InfinispanEmbeddedComponentBuilder infinispanEmbedded() {
        return InfinispanEmbeddedComponentBuilderFactory.infinispanEmbedded();
    }
    /**
     * InfluxDB (camel-influxdb)
     * Interact with InfluxDB v1, a time series database.
     * 
     * Category: database
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-influxdb
     * 
     * @return the dsl builder
     */
    static InfluxdbComponentBuilderFactory.InfluxdbComponentBuilder influxdb() {
        return InfluxdbComponentBuilderFactory.influxdb();
    }
    /**
     * InfluxDB2 (camel-influxdb2)
     * Interact with InfluxDB v2, a time series database.
     * 
     * Category: database
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-influxdb2
     * 
     * @return the dsl builder
     */
    static Influxdb2ComponentBuilderFactory.Influxdb2ComponentBuilder influxdb2() {
        return Influxdb2ComponentBuilderFactory.influxdb2();
    }
    /**
     * IRC (camel-irc)
     * Send and receive messages to/from and IRC chat.
     * 
     * Category: chat
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-irc
     * 
     * @return the dsl builder
     */
    static IrcComponentBuilderFactory.IrcComponentBuilder irc() {
        return IrcComponentBuilderFactory.irc();
    }
    /**
     * IronMQ (camel-ironmq)
     * Send and receive messages to/from IronMQ an elastic and durable hosted
     * message queue as a service.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-ironmq
     * 
     * @return the dsl builder
     */
    static IronmqComponentBuilderFactory.IronmqComponentBuilder ironmq() {
        return IronmqComponentBuilderFactory.ironmq();
    }
    /**
     * JCache (camel-jcache)
     * Perform caching operations against JSR107/JCache.
     * 
     * Category: cache,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-jcache
     * 
     * @return the dsl builder
     */
    static JcacheComponentBuilderFactory.JcacheComponentBuilder jcache() {
        return JcacheComponentBuilderFactory.jcache();
    }
    /**
     * JCR (camel-jcr)
     * Read and write nodes to/from a JCR compliant content repository.
     * 
     * Category: database,cms
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-jcr
     * 
     * @return the dsl builder
     */
    static JcrComponentBuilderFactory.JcrComponentBuilder jcr() {
        return JcrComponentBuilderFactory.jcr();
    }
    /**
     * JDBC (camel-jdbc)
     * Access databases through SQL and JDBC.
     * 
     * Category: database
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jdbc
     * 
     * @return the dsl builder
     */
    static JdbcComponentBuilderFactory.JdbcComponentBuilder jdbc() {
        return JdbcComponentBuilderFactory.jdbc();
    }
    /**
     * Jetty (camel-jetty)
     * Expose HTTP endpoints using Jetty 12.
     * 
     * Category: http
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jetty
     * 
     * @return the dsl builder
     */
    static JettyComponentBuilderFactory.JettyComponentBuilder jetty() {
        return JettyComponentBuilderFactory.jetty();
    }
    /**
     * JGroups (camel-jgroups)
     * Exchange messages with JGroups clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-jgroups
     * 
     * @return the dsl builder
     */
    static JgroupsComponentBuilderFactory.JgroupsComponentBuilder jgroups() {
        return JgroupsComponentBuilderFactory.jgroups();
    }
    /**
     * JGroups raft (camel-jgroups-raft)
     * Exchange messages with JGroups-raft clusters.
     * 
     * Category: clustering,messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-jgroups-raft
     * 
     * @return the dsl builder
     */
    static JgroupsRaftComponentBuilderFactory.JgroupsRaftComponentBuilder jgroupsRaft() {
        return JgroupsRaftComponentBuilderFactory.jgroupsRaft();
    }
    /**
     * Jira (camel-jira)
     * Interact with JIRA issue tracker.
     * 
     * Category: document
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jira
     * 
     * @return the dsl builder
     */
    static JiraComponentBuilderFactory.JiraComponentBuilder jira() {
        return JiraComponentBuilderFactory.jira();
    }
    /**
     * JMS (camel-jms)
     * Sent and receive messages to/from a JMS Queue or Topic.
     * 
     * Category: messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jms
     * 
     * @return the dsl builder
     */
    static JmsComponentBuilderFactory.JmsComponentBuilder jms() {
        return JmsComponentBuilderFactory.jms();
    }
    /**
     * JMX (camel-jmx)
     * Receive JMX notifications.
     * 
     * Category: monitoring
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jmx
     * 
     * @return the dsl builder
     */
    static JmxComponentBuilderFactory.JmxComponentBuilder jmx() {
        return JmxComponentBuilderFactory.jmx();
    }
    /**
     * JOLT (camel-jolt)
     * JSON to JSON transformation using JOLT.
     * 
     * Category: transformation
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-jolt
     * 
     * @return the dsl builder
     */
    static JoltComponentBuilderFactory.JoltComponentBuilder jolt() {
        return JoltComponentBuilderFactory.jolt();
    }
    /**
     * JOOQ (camel-jooq)
     * Store and retrieve Java objects from an SQL database using JOOQ.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-jooq
     * 
     * @return the dsl builder
     */
    static JooqComponentBuilderFactory.JooqComponentBuilder jooq() {
        return JooqComponentBuilderFactory.jooq();
    }
    /**
     * JPA (camel-jpa)
     * Store and retrieve Java objects from databases using Java Persistence API
     * (JPA).
     * 
     * Category: database
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-jpa
     * 
     * @return the dsl builder
     */
    static JpaComponentBuilderFactory.JpaComponentBuilder jpa() {
        return JpaComponentBuilderFactory.jpa();
    }
    /**
     * JSLT (camel-jslt)
     * Query or transform JSON payloads using JSLT.
     * 
     * Category: transformation
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-jslt
     * 
     * @return the dsl builder
     */
    static JsltComponentBuilderFactory.JsltComponentBuilder jslt() {
        return JsltComponentBuilderFactory.jslt();
    }
    /**
     * JsonPatch (camel-json-patch)
     * Transforms JSON using JSON patch (RFC 6902).
     * 
     * Category: transformation
     * Since: 3.12
     * Maven coordinates: org.apache.camel:camel-json-patch
     * 
     * @return the dsl builder
     */
    static JsonPatchComponentBuilderFactory.JsonPatchComponentBuilder jsonPatch() {
        return JsonPatchComponentBuilderFactory.jsonPatch();
    }
    /**
     * JSON Schema Validator (camel-json-validator)
     * Validate JSON payloads using NetworkNT JSON Schema.
     * 
     * Category: validation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-json-validator
     * 
     * @return the dsl builder
     */
    static JsonValidatorComponentBuilderFactory.JsonValidatorComponentBuilder jsonValidator() {
        return JsonValidatorComponentBuilderFactory.jsonValidator();
    }
    /**
     * JSONata (camel-jsonata)
     * Transforms JSON payload using JSONata transformation.
     * 
     * Category: transformation
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-jsonata
     * 
     * @return the dsl builder
     */
    static JsonataComponentBuilderFactory.JsonataComponentBuilder jsonata() {
        return JsonataComponentBuilderFactory.jsonata();
    }
    /**
     * JT400 (camel-jt400)
     * Exchanges messages with an IBM i system using data queues, message
     * queues, or program call. IBM i is the replacement for AS/400 and iSeries
     * servers.
     * 
     * Category: messaging
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-jt400
     * 
     * @return the dsl builder
     */
    static Jt400ComponentBuilderFactory.Jt400ComponentBuilder jt400() {
        return Jt400ComponentBuilderFactory.jt400();
    }
    /**
     * JTE (camel-jte)
     * Transform messages using a Java based template engine (JTE).
     * 
     * Category: transformation
     * Since: 4.4
     * Maven coordinates: org.apache.camel:camel-jte
     * 
     * @return the dsl builder
     */
    static JteComponentBuilderFactory.JteComponentBuilder jte() {
        return JteComponentBuilderFactory.jte();
    }
    /**
     * Kafka (camel-kafka)
     * Sent and receive messages to/from an Apache Kafka broker.
     * 
     * Category: messaging
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-kafka
     * 
     * @return the dsl builder
     */
    static KafkaComponentBuilderFactory.KafkaComponentBuilder kafka() {
        return KafkaComponentBuilderFactory.kafka();
    }
    /**
     * Kamelet (camel-kamelet)
     * To call Kamelets
     * 
     * Category: core
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-kamelet
     * 
     * @return the dsl builder
     */
    static KameletComponentBuilderFactory.KameletComponentBuilder kamelet() {
        return KameletComponentBuilderFactory.kamelet();
    }
    /**
     * Knative (camel-knative)
     * Send and receive events from Knative.
     * 
     * Category: cloud
     * Since: 3.15
     * Maven coordinates: org.apache.camel:camel-knative
     * 
     * @return the dsl builder
     */
    static KnativeComponentBuilderFactory.KnativeComponentBuilder knative() {
        return KnativeComponentBuilderFactory.knative();
    }
    /**
     * Kubernetes ConfigMap (camel-kubernetes)
     * Perform operations on Kubernetes ConfigMaps and get notified on
     * ConfigMaps changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesConfigMapsComponentBuilderFactory.KubernetesConfigMapsComponentBuilder kubernetesConfigMaps() {
        return KubernetesConfigMapsComponentBuilderFactory.kubernetesConfigMaps();
    }
    /**
     * Kubernetes Cronjob (camel-kubernetes)
     * Perform operations on Kubernetes CronJob.
     * 
     * Category: container,cloud
     * Since: 4.3
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesCronjobComponentBuilderFactory.KubernetesCronjobComponentBuilder kubernetesCronjob() {
        return KubernetesCronjobComponentBuilderFactory.kubernetesCronjob();
    }
    /**
     * Kubernetes Custom Resources (camel-kubernetes)
     * Perform operations on Kubernetes Custom Resources and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud
     * Since: 3.7
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesCustomResourcesComponentBuilderFactory.KubernetesCustomResourcesComponentBuilder kubernetesCustomResources() {
        return KubernetesCustomResourcesComponentBuilderFactory.kubernetesCustomResources();
    }
    /**
     * Kubernetes Deployments (camel-kubernetes)
     * Perform operations on Kubernetes Deployments and get notified on
     * Deployment changes.
     * 
     * Category: container,cloud
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesDeploymentsComponentBuilderFactory.KubernetesDeploymentsComponentBuilder kubernetesDeployments() {
        return KubernetesDeploymentsComponentBuilderFactory.kubernetesDeployments();
    }
    /**
     * Kubernetes Event (camel-kubernetes)
     * Perform operations on Kubernetes Events and get notified on Events
     * changes.
     * 
     * Category: container,cloud
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesEventsComponentBuilderFactory.KubernetesEventsComponentBuilder kubernetesEvents() {
        return KubernetesEventsComponentBuilderFactory.kubernetesEvents();
    }
    /**
     * Kubernetes HPA (camel-kubernetes)
     * Perform operations on Kubernetes Horizontal Pod Autoscalers (HPA) and get
     * notified on HPA changes.
     * 
     * Category: container,cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesHpaComponentBuilderFactory.KubernetesHpaComponentBuilder kubernetesHpa() {
        return KubernetesHpaComponentBuilderFactory.kubernetesHpa();
    }
    /**
     * Kubernetes Job (camel-kubernetes)
     * Perform operations on Kubernetes Jobs.
     * 
     * Category: container,cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesJobComponentBuilderFactory.KubernetesJobComponentBuilder kubernetesJob() {
        return KubernetesJobComponentBuilderFactory.kubernetesJob();
    }
    /**
     * Kubernetes Namespaces (camel-kubernetes)
     * Perform operations on Kubernetes Namespaces and get notified on Namespace
     * changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesNamespacesComponentBuilderFactory.KubernetesNamespacesComponentBuilder kubernetesNamespaces() {
        return KubernetesNamespacesComponentBuilderFactory.kubernetesNamespaces();
    }
    /**
     * Kubernetes Nodes (camel-kubernetes)
     * Perform operations on Kubernetes Nodes and get notified on Node changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesNodesComponentBuilderFactory.KubernetesNodesComponentBuilder kubernetesNodes() {
        return KubernetesNodesComponentBuilderFactory.kubernetesNodes();
    }
    /**
     * Kubernetes Persistent Volume (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes and get notified on
     * Persistent Volume changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesPersistentVolumesComponentBuilderFactory.KubernetesPersistentVolumesComponentBuilder kubernetesPersistentVolumes() {
        return KubernetesPersistentVolumesComponentBuilderFactory.kubernetesPersistentVolumes();
    }
    /**
     * Kubernetes Persistent Volume Claim (camel-kubernetes)
     * Perform operations on Kubernetes Persistent Volumes Claims and get
     * notified on Persistent Volumes Claim changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesPersistentVolumesClaimsComponentBuilderFactory.KubernetesPersistentVolumesClaimsComponentBuilder kubernetesPersistentVolumesClaims() {
        return KubernetesPersistentVolumesClaimsComponentBuilderFactory.kubernetesPersistentVolumesClaims();
    }
    /**
     * Kubernetes Pods (camel-kubernetes)
     * Perform operations on Kubernetes Pods and get notified on Pod changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesPodsComponentBuilderFactory.KubernetesPodsComponentBuilder kubernetesPods() {
        return KubernetesPodsComponentBuilderFactory.kubernetesPods();
    }
    /**
     * Kubernetes Replication Controller (camel-kubernetes)
     * Perform operations on Kubernetes Replication Controllers and get notified
     * on Replication Controllers changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesReplicationControllersComponentBuilderFactory.KubernetesReplicationControllersComponentBuilder kubernetesReplicationControllers() {
        return KubernetesReplicationControllersComponentBuilderFactory.kubernetesReplicationControllers();
    }
    /**
     * Kubernetes Resources Quota (camel-kubernetes)
     * Perform operations on Kubernetes Resources Quotas.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesResourcesQuotaComponentBuilderFactory.KubernetesResourcesQuotaComponentBuilder kubernetesResourcesQuota() {
        return KubernetesResourcesQuotaComponentBuilderFactory.kubernetesResourcesQuota();
    }
    /**
     * Kubernetes Secrets (camel-kubernetes)
     * Perform operations on Kubernetes Secrets.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesSecretsComponentBuilderFactory.KubernetesSecretsComponentBuilder kubernetesSecrets() {
        return KubernetesSecretsComponentBuilderFactory.kubernetesSecrets();
    }
    /**
     * Kubernetes Service Account (camel-kubernetes)
     * Perform operations on Kubernetes Service Accounts.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesServiceAccountsComponentBuilderFactory.KubernetesServiceAccountsComponentBuilder kubernetesServiceAccounts() {
        return KubernetesServiceAccountsComponentBuilderFactory.kubernetesServiceAccounts();
    }
    /**
     * Kubernetes Services (camel-kubernetes)
     * Perform operations on Kubernetes Services and get notified on Service
     * changes.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static KubernetesServicesComponentBuilderFactory.KubernetesServicesComponentBuilder kubernetesServices() {
        return KubernetesServicesComponentBuilderFactory.kubernetesServices();
    }
    /**
     * Kudu (camel-kudu)
     * Interact with Apache Kudu, a free and open source column-oriented data
     * store of the Apache Hadoop ecosystem.
     * 
     * Category: database,iot,cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-kudu
     * 
     * @return the dsl builder
     */
    static KuduComponentBuilderFactory.KuduComponentBuilder kudu() {
        return KuduComponentBuilderFactory.kudu();
    }
    /**
     * langChain4j Chat (camel-langchain4j-chat)
     * LangChain4j Chat component
     * 
     * Category: ai
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-langchain4j-chat
     * 
     * @return the dsl builder
     */
    static Langchain4jChatComponentBuilderFactory.Langchain4jChatComponentBuilder langchain4jChat() {
        return Langchain4jChatComponentBuilderFactory.langchain4jChat();
    }
    /**
     * LangChain4j Embeddings (camel-langchain4j-embeddings)
     * LangChain4j Embeddings
     * 
     * Category: ai
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-langchain4j-embeddings
     * 
     * @return the dsl builder
     */
    static Langchain4jEmbeddingsComponentBuilderFactory.Langchain4jEmbeddingsComponentBuilder langchain4jEmbeddings() {
        return Langchain4jEmbeddingsComponentBuilderFactory.langchain4jEmbeddings();
    }
    /**
     * Language (camel-language)
     * Execute scripts in any of the languages supported by Camel.
     * 
     * Category: core,script
     * Since: 2.5
     * Maven coordinates: org.apache.camel:camel-language
     * 
     * @return the dsl builder
     */
    static LanguageComponentBuilderFactory.LanguageComponentBuilder language() {
        return LanguageComponentBuilderFactory.language();
    }
    /**
     * LDAP (camel-ldap)
     * Perform searches on LDAP servers.
     * 
     * Category: database,security
     * Since: 1.5
     * Maven coordinates: org.apache.camel:camel-ldap
     * 
     * @return the dsl builder
     */
    static LdapComponentBuilderFactory.LdapComponentBuilder ldap() {
        return LdapComponentBuilderFactory.ldap();
    }
    /**
     * LDIF (camel-ldif)
     * Perform updates on an LDAP server from an LDIF body content.
     * 
     * Category: database,security
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-ldif
     * 
     * @return the dsl builder
     */
    static LdifComponentBuilderFactory.LdifComponentBuilder ldif() {
        return LdifComponentBuilderFactory.ldif();
    }
    /**
     * Log Data (camel-log)
     * Prints data form the routed message (such as body and headers) to the
     * logger.
     * 
     * Category: core,monitoring
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-log
     * 
     * @return the dsl builder
     */
    static LogComponentBuilderFactory.LogComponentBuilder log() {
        return LogComponentBuilderFactory.log();
    }
    /**
     * Printer (camel-printer)
     * Send print jobs to printers.
     * 
     * Category: document
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-printer
     * 
     * @return the dsl builder
     */
    static LprComponentBuilderFactory.LprComponentBuilder lpr() {
        return LprComponentBuilderFactory.lpr();
    }
    /**
     * Lucene (camel-lucene)
     * Perform inserts or queries against Apache Lucene databases.
     * 
     * Category: database,search
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-lucene
     * 
     * @return the dsl builder
     */
    static LuceneComponentBuilderFactory.LuceneComponentBuilder lucene() {
        return LuceneComponentBuilderFactory.lucene();
    }
    /**
     * Lumberjack (camel-lumberjack)
     * Receive logs messages using the Lumberjack protocol.
     * 
     * Category: monitoring
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-lumberjack
     * 
     * @return the dsl builder
     */
    static LumberjackComponentBuilderFactory.LumberjackComponentBuilder lumberjack() {
        return LumberjackComponentBuilderFactory.lumberjack();
    }
    /**
     * MapStruct (camel-mapstruct)
     * Type Conversion using Mapstruct
     * 
     * Category: transformation
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-mapstruct
     * 
     * @return the dsl builder
     */
    static MapstructComponentBuilderFactory.MapstructComponentBuilder mapstruct() {
        return MapstructComponentBuilderFactory.mapstruct();
    }
    /**
     * Master (camel-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-master
     * 
     * @return the dsl builder
     */
    static MasterComponentBuilderFactory.MasterComponentBuilder master() {
        return MasterComponentBuilderFactory.master();
    }
    /**
     * Metrics (camel-metrics)
     * Collect various metrics directly from Camel routes using the DropWizard
     * metrics library.
     * 
     * Category: monitoring
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-metrics
     * 
     * @return the dsl builder
     */
    static MetricsComponentBuilderFactory.MetricsComponentBuilder metrics() {
        return MetricsComponentBuilderFactory.metrics();
    }
    /**
     * Micrometer (camel-micrometer)
     * Collect various metrics directly from Camel routes using the Micrometer
     * library.
     * 
     * Category: monitoring
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-micrometer
     * 
     * @return the dsl builder
     */
    static MicrometerComponentBuilderFactory.MicrometerComponentBuilder micrometer() {
        return MicrometerComponentBuilderFactory.micrometer();
    }
    /**
     * Milvus (camel-milvus)
     * Perform operations on the Milvus Vector Database.
     * 
     * Category: database,ai
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-milvus
     * 
     * @return the dsl builder
     */
    static MilvusComponentBuilderFactory.MilvusComponentBuilder milvus() {
        return MilvusComponentBuilderFactory.milvus();
    }
    /**
     * Mina (camel-mina)
     * Socket level networking using TCP or UDP with Apache Mina 2.x.
     * 
     * Category: networking
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-mina
     * 
     * @return the dsl builder
     */
    static MinaComponentBuilderFactory.MinaComponentBuilder mina() {
        return MinaComponentBuilderFactory.mina();
    }
    /**
     * Minio (camel-minio)
     * Store and retrieve objects from Minio Storage Service using Minio SDK.
     * 
     * Category: cloud,file
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-minio
     * 
     * @return the dsl builder
     */
    static MinioComponentBuilderFactory.MinioComponentBuilder minio() {
        return MinioComponentBuilderFactory.minio();
    }
    /**
     * MLLP (camel-mllp)
     * Communicate with external systems using the MLLP protocol.
     * 
     * Category: HEALTH
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-mllp
     * 
     * @return the dsl builder
     */
    static MllpComponentBuilderFactory.MllpComponentBuilder mllp() {
        return MllpComponentBuilderFactory.mllp();
    }
    /**
     * Mock (camel-mock)
     * Test routes and mediation rules using mocks.
     * 
     * Category: core,testing
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mock
     * 
     * @return the dsl builder
     */
    static MockComponentBuilderFactory.MockComponentBuilder mock() {
        return MockComponentBuilderFactory.mock();
    }
    /**
     * MongoDB (camel-mongodb)
     * Perform operations on MongoDB documents and collections.
     * 
     * Category: database
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-mongodb
     * 
     * @return the dsl builder
     */
    static MongodbComponentBuilderFactory.MongodbComponentBuilder mongodb() {
        return MongodbComponentBuilderFactory.mongodb();
    }
    /**
     * MongoDB GridFS (camel-mongodb-gridfs)
     * Interact with MongoDB GridFS.
     * 
     * Category: database,file
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-mongodb-gridfs
     * 
     * @return the dsl builder
     */
    static MongodbGridfsComponentBuilderFactory.MongodbGridfsComponentBuilder mongodbGridfs() {
        return MongodbGridfsComponentBuilderFactory.mongodbGridfs();
    }
    /**
     * Mustache (camel-mustache)
     * Transform messages using a Mustache template.
     * 
     * Category: transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mustache
     * 
     * @return the dsl builder
     */
    static MustacheComponentBuilderFactory.MustacheComponentBuilder mustache() {
        return MustacheComponentBuilderFactory.mustache();
    }
    /**
     * MVEL (camel-mvel)
     * Transform messages using an MVEL template.
     * 
     * Category: transformation,script
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-mvel
     * 
     * @return the dsl builder
     */
    static MvelComponentBuilderFactory.MvelComponentBuilder mvel() {
        return MvelComponentBuilderFactory.mvel();
    }
    /**
     * MyBatis (camel-mybatis)
     * Performs a query, poll, insert, update or delete in a relational database
     * using MyBatis.
     * 
     * Category: database
     * Since: 2.7
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * @return the dsl builder
     */
    static MybatisComponentBuilderFactory.MybatisComponentBuilder mybatis() {
        return MybatisComponentBuilderFactory.mybatis();
    }
    /**
     * MyBatis Bean (camel-mybatis)
     * Perform queries, inserts, updates or deletes in a relational database
     * using MyBatis.
     * 
     * Category: database
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-mybatis
     * 
     * @return the dsl builder
     */
    static MybatisBeanComponentBuilderFactory.MybatisBeanComponentBuilder mybatisBean() {
        return MybatisBeanComponentBuilderFactory.mybatisBean();
    }
    /**
     * Nats (camel-nats)
     * Send and receive messages from NATS messaging system.
     * 
     * Category: messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-nats
     * 
     * @return the dsl builder
     */
    static NatsComponentBuilderFactory.NatsComponentBuilder nats() {
        return NatsComponentBuilderFactory.nats();
    }
    /**
     * Netty (camel-netty)
     * Socket level networking using TCP or UDP with Netty 4.x.
     * 
     * Category: networking
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty
     * 
     * @return the dsl builder
     */
    static NettyComponentBuilderFactory.NettyComponentBuilder netty() {
        return NettyComponentBuilderFactory.netty();
    }
    /**
     * Netty HTTP (camel-netty-http)
     * Netty HTTP server and client using the Netty 4.x.
     * 
     * Category: networking,http
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty-http
     * 
     * @return the dsl builder
     */
    static NettyHttpComponentBuilderFactory.NettyHttpComponentBuilder nettyHttp() {
        return NettyHttpComponentBuilderFactory.nettyHttp();
    }
    /**
     * Nitrite (camel-nitrite)
     * Access Nitrite databases.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-nitrite
     * 
     * @return the dsl builder
     */
    static NitriteComponentBuilderFactory.NitriteComponentBuilder nitrite() {
        return NitriteComponentBuilderFactory.nitrite();
    }
    /**
     * OAI-PMH (camel-oaipmh)
     * Harvest metadata using OAI-PMH protocol
     * 
     * Category: search
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-oaipmh
     * 
     * @return the dsl builder
     */
    static OaipmhComponentBuilderFactory.OaipmhComponentBuilder oaipmh() {
        return OaipmhComponentBuilderFactory.oaipmh();
    }
    /**
     * Olingo2 (camel-olingo2)
     * Communicate with OData 2.0 services using Apache Olingo.
     * 
     * Category: cloud
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-olingo2
     * 
     * @return the dsl builder
     */
    static Olingo2ComponentBuilderFactory.Olingo2ComponentBuilder olingo2() {
        return Olingo2ComponentBuilderFactory.olingo2();
    }
    /**
     * Olingo4 (camel-olingo4)
     * Communicate with OData 4.0 services using Apache Olingo OData API.
     * 
     * Category: cloud
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-olingo4
     * 
     * @return the dsl builder
     */
    static Olingo4ComponentBuilderFactory.Olingo4ComponentBuilder olingo4() {
        return Olingo4ComponentBuilderFactory.olingo4();
    }
    /**
     * OpenSearch (camel-opensearch)
     * Send requests to OpenSearch via Java Client API.
     * 
     * Category: search,monitoring
     * Since: 4.0
     * Maven coordinates: org.apache.camel:camel-opensearch
     * 
     * @return the dsl builder
     */
    static OpensearchComponentBuilderFactory.OpensearchComponentBuilder opensearch() {
        return OpensearchComponentBuilderFactory.opensearch();
    }
    /**
     * Openshift Build Config (camel-kubernetes)
     * Perform operations on OpenShift Build Configs.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static OpenshiftBuildConfigsComponentBuilderFactory.OpenshiftBuildConfigsComponentBuilder openshiftBuildConfigs() {
        return OpenshiftBuildConfigsComponentBuilderFactory.openshiftBuildConfigs();
    }
    /**
     * Openshift Builds (camel-kubernetes)
     * Perform operations on OpenShift Builds.
     * 
     * Category: container,cloud
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static OpenshiftBuildsComponentBuilderFactory.OpenshiftBuildsComponentBuilder openshiftBuilds() {
        return OpenshiftBuildsComponentBuilderFactory.openshiftBuilds();
    }
    /**
     * Openshift Deployment Configs (camel-kubernetes)
     * Perform operations on Openshift Deployment Configs and get notified on
     * Deployment Config changes.
     * 
     * Category: container,cloud
     * Since: 3.18
     * Maven coordinates: org.apache.camel:camel-kubernetes
     * 
     * @return the dsl builder
     */
    static OpenshiftDeploymentconfigsComponentBuilderFactory.OpenshiftDeploymentconfigsComponentBuilder openshiftDeploymentconfigs() {
        return OpenshiftDeploymentconfigsComponentBuilderFactory.openshiftDeploymentconfigs();
    }
    /**
     * OpenStack Cinder (camel-openstack)
     * Access data in OpenStack Cinder block storage.
     * 
     * Category: container
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static OpenstackCinderComponentBuilderFactory.OpenstackCinderComponentBuilder openstackCinder() {
        return OpenstackCinderComponentBuilderFactory.openstackCinder();
    }
    /**
     * OpenStack Glance (camel-openstack)
     * Manage VM images and metadata definitions in OpenStack Glance.
     * 
     * Category: container
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static OpenstackGlanceComponentBuilderFactory.OpenstackGlanceComponentBuilder openstackGlance() {
        return OpenstackGlanceComponentBuilderFactory.openstackGlance();
    }
    /**
     * OpenStack Keystone (camel-openstack)
     * Access OpenStack Keystone for API client authentication, service
     * discovery and distributed multi-tenant authorization.
     * 
     * Category: container
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static OpenstackKeystoneComponentBuilderFactory.OpenstackKeystoneComponentBuilder openstackKeystone() {
        return OpenstackKeystoneComponentBuilderFactory.openstackKeystone();
    }
    /**
     * OpenStack Neutron (camel-openstack)
     * Access OpenStack Neutron for network services.
     * 
     * Category: container
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static OpenstackNeutronComponentBuilderFactory.OpenstackNeutronComponentBuilder openstackNeutron() {
        return OpenstackNeutronComponentBuilderFactory.openstackNeutron();
    }
    /**
     * OpenStack Nova (camel-openstack)
     * Access OpenStack to manage compute resources.
     * 
     * Category: container
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static OpenstackNovaComponentBuilderFactory.OpenstackNovaComponentBuilder openstackNova() {
        return OpenstackNovaComponentBuilderFactory.openstackNova();
    }
    /**
     * OpenStack Swift (camel-openstack)
     * Access OpenStack Swift object/blob store.
     * 
     * Category: container
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-openstack
     * 
     * @return the dsl builder
     */
    static OpenstackSwiftComponentBuilderFactory.OpenstackSwiftComponentBuilder openstackSwift() {
        return OpenstackSwiftComponentBuilderFactory.openstackSwift();
    }
    /**
     * OptaPlanner (camel-optaplanner)
     * Solve planning problems with OptaPlanner.
     * 
     * Category: workflow
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-optaplanner
     * 
     * @return the dsl builder
     */
    static OptaplannerComponentBuilderFactory.OptaplannerComponentBuilder optaplanner() {
        return OptaplannerComponentBuilderFactory.optaplanner();
    }
    /**
     * Paho (camel-paho)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT Client.
     * 
     * Category: messaging,iot
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-paho
     * 
     * @return the dsl builder
     */
    static PahoComponentBuilderFactory.PahoComponentBuilder paho() {
        return PahoComponentBuilderFactory.paho();
    }
    /**
     * Paho MQTT 5 (camel-paho-mqtt5)
     * Communicate with MQTT message brokers using Eclipse Paho MQTT v5 Client.
     * 
     * Category: messaging,iot
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-paho-mqtt5
     * 
     * @return the dsl builder
     */
    static PahoMqtt5ComponentBuilderFactory.PahoMqtt5ComponentBuilder pahoMqtt5() {
        return PahoMqtt5ComponentBuilderFactory.pahoMqtt5();
    }
    /**
     * PDF (camel-pdf)
     * Create, modify or extract content from PDF documents.
     * 
     * Category: document,transformation
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-pdf
     * 
     * @return the dsl builder
     */
    static PdfComponentBuilderFactory.PdfComponentBuilder pdf() {
        return PdfComponentBuilderFactory.pdf();
    }
    /**
     * PostgresSQL Replication Slot (camel-pg-replication-slot)
     * Poll for PostgreSQL Write-Ahead Log (WAL) records using Streaming
     * Replication Slots.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-pg-replication-slot
     * 
     * @return the dsl builder
     */
    static PgReplicationSlotComponentBuilderFactory.PgReplicationSlotComponentBuilder pgReplicationSlot() {
        return PgReplicationSlotComponentBuilderFactory.pgReplicationSlot();
    }
    /**
     * PostgresSQL Event (camel-pgevent)
     * Send and receive PostgreSQL events via LISTEN and NOTIFY commands.
     * 
     * Category: database
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-pgevent
     * 
     * @return the dsl builder
     */
    static PgeventComponentBuilderFactory.PgeventComponentBuilder pgevent() {
        return PgeventComponentBuilderFactory.pgevent();
    }
    /**
     * Pinecone (camel-pinecone)
     * Perform operations on the Pinecone Vector Database.
     * 
     * Category: database,ai
     * Since: 4.6
     * Maven coordinates: org.apache.camel:camel-pinecone
     * 
     * @return the dsl builder
     */
    static PineconeComponentBuilderFactory.PineconeComponentBuilder pinecone() {
        return PineconeComponentBuilderFactory.pinecone();
    }
    /**
     * Platform HTTP (camel-platform-http)
     * Expose HTTP endpoints using the HTTP server available in the current
     * platform.
     * 
     * Category: http
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-platform-http
     * 
     * @return the dsl builder
     */
    static PlatformHttpComponentBuilderFactory.PlatformHttpComponentBuilder platformHttp() {
        return PlatformHttpComponentBuilderFactory.platformHttp();
    }
    /**
     * PLC4X (camel-plc4x)
     * Read and write to PLC devices
     * 
     * Category: iot
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-plc4x
     * 
     * @return the dsl builder
     */
    static Plc4xComponentBuilderFactory.Plc4xComponentBuilder plc4x() {
        return Plc4xComponentBuilderFactory.plc4x();
    }
    /**
     * POP3 (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static Pop3ComponentBuilderFactory.Pop3ComponentBuilder pop3() {
        return Pop3ComponentBuilderFactory.pop3();
    }
    /**
     * POP3S (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static Pop3sComponentBuilderFactory.Pop3sComponentBuilder pop3s() {
        return Pop3sComponentBuilderFactory.pop3s();
    }
    /**
     * PubNub (camel-pubnub)
     * Send and receive messages to/from PubNub data stream network for
     * connected devices.
     * 
     * Category: cloud,iot,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-pubnub
     * 
     * @return the dsl builder
     */
    static PubnubComponentBuilderFactory.PubnubComponentBuilder pubnub() {
        return PubnubComponentBuilderFactory.pubnub();
    }
    /**
     * Pulsar (camel-pulsar)
     * Send and receive messages from/to Apache Pulsar messaging system.
     * 
     * Category: messaging
     * Since: 2.24
     * Maven coordinates: org.apache.camel:camel-pulsar
     * 
     * @return the dsl builder
     */
    static PulsarComponentBuilderFactory.PulsarComponentBuilder pulsar() {
        return PulsarComponentBuilderFactory.pulsar();
    }
    /**
     * Qdrant (camel-qdrant)
     * Perform operations on the Qdrant Vector Database.
     * 
     * Category: database,ai
     * Since: 4.5
     * Maven coordinates: org.apache.camel:camel-qdrant
     * 
     * @return the dsl builder
     */
    static QdrantComponentBuilderFactory.QdrantComponentBuilder qdrant() {
        return QdrantComponentBuilderFactory.qdrant();
    }
    /**
     * Quartz (camel-quartz)
     * Schedule sending of messages using the Quartz 2.x scheduler.
     * 
     * Category: scheduling
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-quartz
     * 
     * @return the dsl builder
     */
    static QuartzComponentBuilderFactory.QuartzComponentBuilder quartz() {
        return QuartzComponentBuilderFactory.quartz();
    }
    /**
     * QuickFix (camel-quickfix)
     * Open a Financial Interchange (FIX) session using an embedded QuickFix/J
     * engine.
     * 
     * Category: messaging
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-quickfix
     * 
     * @return the dsl builder
     */
    static QuickfixComponentBuilderFactory.QuickfixComponentBuilder quickfix() {
        return QuickfixComponentBuilderFactory.quickfix();
    }
    /**
     * Reactive Streams (camel-reactive-streams)
     * Exchange messages with reactive stream processing libraries compatible
     * with the reactive streams standard.
     * 
     * Category: messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-reactive-streams
     * 
     * @return the dsl builder
     */
    static ReactiveStreamsComponentBuilderFactory.ReactiveStreamsComponentBuilder reactiveStreams() {
        return ReactiveStreamsComponentBuilderFactory.reactiveStreams();
    }
    /**
     * Ref (camel-ref)
     * Route messages to an endpoint looked up dynamically by name in the Camel
     * Registry.
     * 
     * Category: core
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-ref
     * 
     * @return the dsl builder
     */
    static RefComponentBuilderFactory.RefComponentBuilder ref() {
        return RefComponentBuilderFactory.ref();
    }
    /**
     * REST (camel-rest)
     * Expose REST services or call external REST services.
     * 
     * Category: core,rest
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * @return the dsl builder
     */
    static RestEndpointComponentBuilderFactory.RestEndpointComponentBuilder restEndpoint() {
        return RestEndpointComponentBuilderFactory.restEndpoint();
    }
    /**
     * REST API (camel-rest)
     * Expose OpenAPI Specification of the REST services defined using Camel
     * REST DSL.
     * 
     * Category: core,rest
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-rest
     * 
     * @return the dsl builder
     */
    static RestApiComponentBuilderFactory.RestApiComponentBuilder restApi() {
        return RestApiComponentBuilderFactory.restApi();
    }
    /**
     * REST OpenApi (camel-rest-openapi)
     * To call REST services using OpenAPI specification as contract.
     * 
     * Category: rest,api
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-rest-openapi
     * 
     * @return the dsl builder
     */
    static RestOpenapiComponentBuilderFactory.RestOpenapiComponentBuilder restOpenapi() {
        return RestOpenapiComponentBuilderFactory.restOpenapi();
    }
    /**
     * Robot Framework (camel-robotframework)
     * Pass camel exchanges to acceptance test written in Robot DSL.
     * 
     * Category: testing
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-robotframework
     * 
     * @return the dsl builder
     */
    static RobotframeworkComponentBuilderFactory.RobotframeworkComponentBuilder robotframework() {
        return RobotframeworkComponentBuilderFactory.robotframework();
    }
    /**
     * RocketMQ (camel-rocketmq)
     * Send and receive messages from RocketMQ cluster.
     * 
     * Category: messaging
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-rocketmq
     * 
     * @return the dsl builder
     */
    static RocketmqComponentBuilderFactory.RocketmqComponentBuilder rocketmq() {
        return RocketmqComponentBuilderFactory.rocketmq();
    }
    /**
     * RSS (camel-rss)
     * Poll RSS feeds.
     * 
     * Category: document
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-rss
     * 
     * @return the dsl builder
     */
    static RssComponentBuilderFactory.RssComponentBuilder rss() {
        return RssComponentBuilderFactory.rss();
    }
    /**
     * Saga (camel-saga)
     * Execute custom actions within a route using the Saga EIP.
     * 
     * Category: clustering
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-saga
     * 
     * @return the dsl builder
     */
    static SagaComponentBuilderFactory.SagaComponentBuilder saga() {
        return SagaComponentBuilderFactory.saga();
    }
    /**
     * Salesforce (camel-salesforce)
     * Communicate with Salesforce using Java DTOs.
     * 
     * Category: cloud,saas
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-salesforce
     * 
     * @return the dsl builder
     */
    static SalesforceComponentBuilderFactory.SalesforceComponentBuilder salesforce() {
        return SalesforceComponentBuilderFactory.salesforce();
    }
    /**
     * SAP NetWeaver (camel-sap-netweaver)
     * Send requests to SAP NetWeaver Gateway using HTTP.
     * 
     * Category: saas
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-sap-netweaver
     * 
     * @return the dsl builder
     */
    static SapNetweaverComponentBuilderFactory.SapNetweaverComponentBuilder sapNetweaver() {
        return SapNetweaverComponentBuilderFactory.sapNetweaver();
    }
    /**
     * Scheduler (camel-scheduler)
     * Generate messages in specified intervals using
     * java.util.concurrent.ScheduledExecutorService.
     * 
     * Category: core,scheduling
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-scheduler
     * 
     * @return the dsl builder
     */
    static SchedulerComponentBuilderFactory.SchedulerComponentBuilder scheduler() {
        return SchedulerComponentBuilderFactory.scheduler();
    }
    /**
     * Schematron (camel-schematron)
     * Validate XML payload using the Schematron Library.
     * 
     * Category: validation
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-schematron
     * 
     * @return the dsl builder
     */
    static SchematronComponentBuilderFactory.SchematronComponentBuilder schematron() {
        return SchematronComponentBuilderFactory.schematron();
    }
    /**
     * SCP (camel-jsch)
     * Copy files to/from remote hosts using the secure copy protocol (SCP).
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-jsch
     * 
     * @return the dsl builder
     */
    static ScpComponentBuilderFactory.ScpComponentBuilder scp() {
        return ScpComponentBuilderFactory.scp();
    }
    /**
     * SEDA (camel-seda)
     * Asynchronously call another endpoint from any Camel Context in the same
     * JVM.
     * 
     * Category: core,messaging
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-seda
     * 
     * @return the dsl builder
     */
    static SedaComponentBuilderFactory.SedaComponentBuilder seda() {
        return SedaComponentBuilderFactory.seda();
    }
    /**
     * Service (camel-service)
     * Register a Camel endpoint to a Service Registry (such as Consul, Etcd)
     * and delegate to it.
     * 
     * Category: cloud
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-service
     * 
     * @return the dsl builder
     */
    static ServiceComponentBuilderFactory.ServiceComponentBuilder service() {
        return ServiceComponentBuilderFactory.service();
    }
    /**
     * ServiceNow (camel-servicenow)
     * Interact with ServiceNow via its REST API.
     * 
     * Category: api,cloud,management
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-servicenow
     * 
     * @return the dsl builder
     */
    static ServicenowComponentBuilderFactory.ServicenowComponentBuilder servicenow() {
        return ServicenowComponentBuilderFactory.servicenow();
    }
    /**
     * Servlet (camel-servlet)
     * Serve HTTP requests by a Servlet.
     * 
     * Category: http
     * Since: 2.0
     * Maven coordinates: org.apache.camel:camel-servlet
     * 
     * @return the dsl builder
     */
    static ServletComponentBuilderFactory.ServletComponentBuilder servlet() {
        return ServletComponentBuilderFactory.servlet();
    }
    /**
     * SFTP (camel-ftp)
     * Upload and download files to/from SFTP servers.
     * 
     * Category: file
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-ftp
     * 
     * @return the dsl builder
     */
    static SftpComponentBuilderFactory.SftpComponentBuilder sftp() {
        return SftpComponentBuilderFactory.sftp();
    }
    /**
     * Simple JMS (camel-sjms)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 1.x API.
     * 
     * Category: messaging
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-sjms
     * 
     * @return the dsl builder
     */
    static SjmsComponentBuilderFactory.SjmsComponentBuilder sjms() {
        return SjmsComponentBuilderFactory.sjms();
    }
    /**
     * Simple JMS2 (camel-sjms2)
     * Send and receive messages to/from a JMS Queue or Topic using plain JMS
     * 2.x API.
     * 
     * Category: messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-sjms2
     * 
     * @return the dsl builder
     */
    static Sjms2ComponentBuilderFactory.Sjms2ComponentBuilder sjms2() {
        return Sjms2ComponentBuilderFactory.sjms2();
    }
    /**
     * Slack (camel-slack)
     * Send and receive messages to/from Slack.
     * 
     * Category: social
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-slack
     * 
     * @return the dsl builder
     */
    static SlackComponentBuilderFactory.SlackComponentBuilder slack() {
        return SlackComponentBuilderFactory.slack();
    }
    /**
     * SMB (camel-smb)
     * Receive files from SMB (Server Message Block) shares.
     * 
     * Category: file
     * Since: 4.3
     * Maven coordinates: org.apache.camel:camel-smb
     * 
     * @return the dsl builder
     */
    static SmbComponentBuilderFactory.SmbComponentBuilder smb() {
        return SmbComponentBuilderFactory.smb();
    }
    /**
     * SMPP (camel-smpp)
     * Send and receive SMS messages using a SMSC (Short Message Service
     * Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     * 
     * @return the dsl builder
     */
    static SmppComponentBuilderFactory.SmppComponentBuilder smpp() {
        return SmppComponentBuilderFactory.smpp();
    }
    /**
     * SMPP (Secure) (camel-smpp)
     * Send and receive SMS messages using a SMSC (Short Message Service
     * Center).
     * 
     * Category: mobile
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-smpp
     * 
     * @return the dsl builder
     */
    static SmppsComponentBuilderFactory.SmppsComponentBuilder smpps() {
        return SmppsComponentBuilderFactory.smpps();
    }
    /**
     * SMTP (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static SmtpComponentBuilderFactory.SmtpComponentBuilder smtp() {
        return SmtpComponentBuilderFactory.smtp();
    }
    /**
     * SMTPS (camel-mail)
     * Send and receive emails using imap, pop3 and smtp protocols.
     * 
     * Category: mail
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-mail
     * 
     * @return the dsl builder
     */
    static SmtpsComponentBuilderFactory.SmtpsComponentBuilder smtps() {
        return SmtpsComponentBuilderFactory.smtps();
    }
    /**
     * SNMP (camel-snmp)
     * Receive traps and poll SNMP (Simple Network Management Protocol) capable
     * devices.
     * 
     * Category: monitoring
     * Since: 2.1
     * Maven coordinates: org.apache.camel:camel-snmp
     * 
     * @return the dsl builder
     */
    static SnmpComponentBuilderFactory.SnmpComponentBuilder snmp() {
        return SnmpComponentBuilderFactory.snmp();
    }
    /**
     * Splunk (camel-splunk)
     * Publish or search for events in Splunk.
     * 
     * Category: iot,monitoring
     * Since: 2.13
     * Maven coordinates: org.apache.camel:camel-splunk
     * 
     * @return the dsl builder
     */
    static SplunkComponentBuilderFactory.SplunkComponentBuilder splunk() {
        return SplunkComponentBuilderFactory.splunk();
    }
    /**
     * Splunk HEC (camel-splunk-hec)
     * The splunk component allows publishing events in Splunk using the HTTP
     * Event Collector.
     * 
     * Category: monitoring
     * Since: 3.3
     * Maven coordinates: org.apache.camel:camel-splunk-hec
     * 
     * @return the dsl builder
     */
    static SplunkHecComponentBuilderFactory.SplunkHecComponentBuilder splunkHec() {
        return SplunkHecComponentBuilderFactory.splunkHec();
    }
    /**
     * Spring Batch (camel-spring-batch)
     * Send messages to Spring Batch for further processing.
     * 
     * Category: workflow
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-spring-batch
     * 
     * @return the dsl builder
     */
    static SpringBatchComponentBuilderFactory.SpringBatchComponentBuilder springBatch() {
        return SpringBatchComponentBuilderFactory.springBatch();
    }
    /**
     * Spring Event (camel-spring)
     * Listen for Spring Application Events.
     * 
     * Category: messaging
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-spring
     * 
     * @return the dsl builder
     */
    static SpringEventComponentBuilderFactory.SpringEventComponentBuilder springEvent() {
        return SpringEventComponentBuilderFactory.springEvent();
    }
    /**
     * Spring JDBC (camel-spring-jdbc)
     * Access databases through SQL and JDBC with Spring Transaction support.
     * 
     * Category: database
     * Since: 3.10
     * Maven coordinates: org.apache.camel:camel-spring-jdbc
     * 
     * @return the dsl builder
     */
    static SpringJdbcComponentBuilderFactory.SpringJdbcComponentBuilder springJdbc() {
        return SpringJdbcComponentBuilderFactory.springJdbc();
    }
    /**
     * Spring LDAP (camel-spring-ldap)
     * Perform searches in LDAP servers using filters as the message payload.
     * 
     * Category: security
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-ldap
     * 
     * @return the dsl builder
     */
    static SpringLdapComponentBuilderFactory.SpringLdapComponentBuilder springLdap() {
        return SpringLdapComponentBuilderFactory.springLdap();
    }
    /**
     * Spring RabbitMQ (camel-spring-rabbitmq)
     * Send and receive messages from RabbitMQ using the Spring RabbitMQ client.
     * 
     * Category: messaging
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-spring-rabbitmq
     * 
     * @return the dsl builder
     */
    static SpringRabbitmqComponentBuilderFactory.SpringRabbitmqComponentBuilder springRabbitmq() {
        return SpringRabbitmqComponentBuilderFactory.springRabbitmq();
    }
    /**
     * Spring Redis (camel-spring-redis)
     * Send and receive messages from Redis.
     * 
     * Category: cache
     * Since: 2.11
     * Maven coordinates: org.apache.camel:camel-spring-redis
     * 
     * @return the dsl builder
     */
    static SpringRedisComponentBuilderFactory.SpringRedisComponentBuilder springRedis() {
        return SpringRedisComponentBuilderFactory.springRedis();
    }
    /**
     * Spring WebService (camel-spring-ws)
     * Access external web services as a client or expose your own web services.
     * 
     * Category: webservice
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-spring-ws
     * 
     * @return the dsl builder
     */
    static SpringWsComponentBuilderFactory.SpringWsComponentBuilder springWs() {
        return SpringWsComponentBuilderFactory.springWs();
    }
    /**
     * SQL (camel-sql)
     * Perform SQL queries using Spring JDBC.
     * 
     * Category: database
     * Since: 1.4
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * @return the dsl builder
     */
    static SqlComponentBuilderFactory.SqlComponentBuilder sql() {
        return SqlComponentBuilderFactory.sql();
    }
    /**
     * SQL Stored Procedure (camel-sql)
     * Perform SQL queries as a JDBC Stored Procedures using Spring JDBC.
     * 
     * Category: database
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-sql
     * 
     * @return the dsl builder
     */
    static SqlStoredComponentBuilderFactory.SqlStoredComponentBuilder sqlStored() {
        return SqlStoredComponentBuilderFactory.sqlStored();
    }
    /**
     * SSH (camel-ssh)
     * Execute commands on remote hosts using SSH.
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-ssh
     * 
     * @return the dsl builder
     */
    static SshComponentBuilderFactory.SshComponentBuilder ssh() {
        return SshComponentBuilderFactory.ssh();
    }
    /**
     * StAX (camel-stax)
     * Process XML payloads by a SAX ContentHandler.
     * 
     * Category: transformation
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-stax
     * 
     * @return the dsl builder
     */
    static StaxComponentBuilderFactory.StaxComponentBuilder stax() {
        return StaxComponentBuilderFactory.stax();
    }
    /**
     * Stitch (camel-stitch)
     * Stitch is a cloud ETL service that integrates various data sources into a
     * central data warehouse through various integrations.
     * 
     * Category: cloud,api,saas,bigdata
     * Since: 3.8
     * Maven coordinates: org.apache.camel:camel-stitch
     * 
     * @return the dsl builder
     */
    static StitchComponentBuilderFactory.StitchComponentBuilder stitch() {
        return StitchComponentBuilderFactory.stitch();
    }
    /**
     * Stomp (camel-stomp)
     * Send and receive messages to/from STOMP (Simple Text Oriented Messaging
     * Protocol) compliant message brokers.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-stomp
     * 
     * @return the dsl builder
     */
    static StompComponentBuilderFactory.StompComponentBuilder stomp() {
        return StompComponentBuilderFactory.stomp();
    }
    /**
     * Stream (camel-stream)
     * Read from system-in and write to system-out and system-err streams.
     * 
     * Category: file,core
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-stream
     * 
     * @return the dsl builder
     */
    static StreamComponentBuilderFactory.StreamComponentBuilder stream() {
        return StreamComponentBuilderFactory.stream();
    }
    /**
     * String Template (camel-stringtemplate)
     * Transform messages using StringTemplate engine.
     * 
     * Category: transformation,script
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-stringtemplate
     * 
     * @return the dsl builder
     */
    static StringTemplateComponentBuilderFactory.StringTemplateComponentBuilder stringTemplate() {
        return StringTemplateComponentBuilderFactory.stringTemplate();
    }
    /**
     * Stub (camel-stub)
     * Stub out any physical endpoints while in development or testing.
     * 
     * Category: core,testing
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-stub
     * 
     * @return the dsl builder
     */
    static StubComponentBuilderFactory.StubComponentBuilder stub() {
        return StubComponentBuilderFactory.stub();
    }
    /**
     * Telegram (camel-telegram)
     * Send and receive messages using the Telegram Bot API.
     * 
     * Category: cloud,api,chat
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-telegram
     * 
     * @return the dsl builder
     */
    static TelegramComponentBuilderFactory.TelegramComponentBuilder telegram() {
        return TelegramComponentBuilderFactory.telegram();
    }
    /**
     * Thrift (camel-thrift)
     * Call and expose remote procedures (RPC) with Apache Thrift data format
     * and serialization mechanism.
     * 
     * Category: rpc,transformation
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-thrift
     * 
     * @return the dsl builder
     */
    static ThriftComponentBuilderFactory.ThriftComponentBuilder thrift() {
        return ThriftComponentBuilderFactory.thrift();
    }
    /**
     * Thymeleaf (camel-thymeleaf)
     * Transform messages using a Thymeleaf template.
     * 
     * Category: transformation
     * Since: 4.1
     * Maven coordinates: org.apache.camel:camel-thymeleaf
     * 
     * @return the dsl builder
     */
    static ThymeleafComponentBuilderFactory.ThymeleafComponentBuilder thymeleaf() {
        return ThymeleafComponentBuilderFactory.thymeleaf();
    }
    /**
     * Tika (camel-tika)
     * Parse documents and extract metadata and text using Apache Tika.
     * 
     * Category: document,transformation
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-tika
     * 
     * @return the dsl builder
     */
    static TikaComponentBuilderFactory.TikaComponentBuilder tika() {
        return TikaComponentBuilderFactory.tika();
    }
    /**
     * Timer (camel-timer)
     * Generate messages in specified intervals using java.util.Timer.
     * 
     * Category: core,scheduling
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-timer
     * 
     * @return the dsl builder
     */
    static TimerComponentBuilderFactory.TimerComponentBuilder timer() {
        return TimerComponentBuilderFactory.timer();
    }
    /**
     * Twilio (camel-twilio)
     * Interact with Twilio REST APIs using Twilio Java SDK.
     * 
     * Category: api,messaging,cloud
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-twilio
     * 
     * @return the dsl builder
     */
    static TwilioComponentBuilderFactory.TwilioComponentBuilder twilio() {
        return TwilioComponentBuilderFactory.twilio();
    }
    /**
     * Twitter Direct Message (camel-twitter)
     * Send and receive Twitter direct messages.
     * 
     * Category: saas,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * @return the dsl builder
     */
    static TwitterDirectmessageComponentBuilderFactory.TwitterDirectmessageComponentBuilder twitterDirectmessage() {
        return TwitterDirectmessageComponentBuilderFactory.twitterDirectmessage();
    }
    /**
     * Twitter Search (camel-twitter)
     * Access Twitter Search.
     * 
     * Category: saas,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * @return the dsl builder
     */
    static TwitterSearchComponentBuilderFactory.TwitterSearchComponentBuilder twitterSearch() {
        return TwitterSearchComponentBuilderFactory.twitterSearch();
    }
    /**
     * Twitter Timeline (camel-twitter)
     * Send tweets and receive tweets from user's timeline.
     * 
     * Category: saas,social
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * @return the dsl builder
     */
    static TwitterTimelineComponentBuilderFactory.TwitterTimelineComponentBuilder twitterTimeline() {
        return TwitterTimelineComponentBuilderFactory.twitterTimeline();
    }
    /**
     * Undertow (camel-undertow)
     * Expose HTTP and WebSocket endpoints and access external HTTP/WebSocket
     * servers.
     * 
     * Category: http,networking
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-undertow
     * 
     * @return the dsl builder
     */
    static UndertowComponentBuilderFactory.UndertowComponentBuilder undertow() {
        return UndertowComponentBuilderFactory.undertow();
    }
    /**
     * Validator (camel-validator)
     * Validate the payload using XML Schema and JAXP Validation.
     * 
     * Category: core,validation
     * Since: 1.1
     * Maven coordinates: org.apache.camel:camel-validator
     * 
     * @return the dsl builder
     */
    static ValidatorComponentBuilderFactory.ValidatorComponentBuilder validator() {
        return ValidatorComponentBuilderFactory.validator();
    }
    /**
     * Velocity (camel-velocity)
     * Transform messages using a Velocity template.
     * 
     * Category: transformation
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-velocity
     * 
     * @return the dsl builder
     */
    static VelocityComponentBuilderFactory.VelocityComponentBuilder velocity() {
        return VelocityComponentBuilderFactory.velocity();
    }
    /**
     * Vert.x (camel-vertx)
     * Send and receive messages to/from Vert.x Event Bus.
     * 
     * Category: messaging
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-vertx
     * 
     * @return the dsl builder
     */
    static VertxComponentBuilderFactory.VertxComponentBuilder vertx() {
        return VertxComponentBuilderFactory.vertx();
    }
    /**
     * Vert.x HTTP Client (camel-vertx-http)
     * Send requests to external HTTP servers using Vert.x
     * 
     * Category: http
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-http
     * 
     * @return the dsl builder
     */
    static VertxHttpComponentBuilderFactory.VertxHttpComponentBuilder vertxHttp() {
        return VertxHttpComponentBuilderFactory.vertxHttp();
    }
    /**
     * Vert.x WebSocket (camel-vertx-websocket)
     * Expose WebSocket endpoints and connect to remote WebSocket servers using
     * Vert.x
     * 
     * Category: http,networking
     * Since: 3.5
     * Maven coordinates: org.apache.camel:camel-vertx-websocket
     * 
     * @return the dsl builder
     */
    static VertxWebsocketComponentBuilderFactory.VertxWebsocketComponentBuilder vertxWebsocket() {
        return VertxWebsocketComponentBuilderFactory.vertxWebsocket();
    }
    /**
     * Wasm (camel-wasm)
     * Invoke Wasm functions.
     * 
     * Category: core,script
     * Since: 4.4
     * Maven coordinates: org.apache.camel:camel-wasm
     * 
     * @return the dsl builder
     */
    static WasmComponentBuilderFactory.WasmComponentBuilder wasm() {
        return WasmComponentBuilderFactory.wasm();
    }
    /**
     * Weather (camel-weather)
     * Poll the weather information from Open Weather Map.
     * 
     * Category: api
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-weather
     * 
     * @return the dsl builder
     */
    static WeatherComponentBuilderFactory.WeatherComponentBuilder weather() {
        return WeatherComponentBuilderFactory.weather();
    }
    /**
     * Web3j Ethereum Blockchain (camel-web3j)
     * Interact with Ethereum nodes using web3j client API.
     * 
     * Category: blockchain
     * Since: 2.22
     * Maven coordinates: org.apache.camel:camel-web3j
     * 
     * @return the dsl builder
     */
    static Web3jComponentBuilderFactory.Web3jComponentBuilder web3j() {
        return Web3jComponentBuilderFactory.web3j();
    }
    /**
     * Webhook (camel-webhook)
     * Expose webhook endpoints to receive push notifications for other Camel
     * components.
     * 
     * Category: cloud
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-webhook
     * 
     * @return the dsl builder
     */
    static WebhookComponentBuilderFactory.WebhookComponentBuilder webhook() {
        return WebhookComponentBuilderFactory.webhook();
    }
    /**
     * WhatsApp (camel-whatsapp)
     * Send messages to WhatsApp.
     * 
     * Category: cloud,api,chat
     * Since: 3.19
     * Maven coordinates: org.apache.camel:camel-whatsapp
     * 
     * @return the dsl builder
     */
    static WhatsappComponentBuilderFactory.WhatsappComponentBuilder whatsapp() {
        return WhatsappComponentBuilderFactory.whatsapp();
    }
    /**
     * WordPress (camel-wordpress)
     * Manage posts and users using the WordPress API.
     * 
     * Category: cloud,api,cms
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-wordpress
     * 
     * @return the dsl builder
     */
    static WordpressComponentBuilderFactory.WordpressComponentBuilder wordpress() {
        return WordpressComponentBuilderFactory.wordpress();
    }
    /**
     * Workday (camel-workday)
     * Detect and parse documents using Workday.
     * 
     * Category: cloud,api,saas
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-workday
     * 
     * @return the dsl builder
     */
    static WorkdayComponentBuilderFactory.WorkdayComponentBuilder workday() {
        return WorkdayComponentBuilderFactory.workday();
    }
    /**
     * XChange (camel-xchange)
     * Access market data and trade on Bitcoin and Altcoin exchanges.
     * 
     * Category: blockchain
     * Since: 2.21
     * Maven coordinates: org.apache.camel:camel-xchange
     * 
     * @return the dsl builder
     */
    static XchangeComponentBuilderFactory.XchangeComponentBuilder xchange() {
        return XchangeComponentBuilderFactory.xchange();
    }
    /**
     * XJ (camel-xj)
     * Transform JSON and XML message using a XSLT.
     * 
     * Category: transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xj
     * 
     * @return the dsl builder
     */
    static XjComponentBuilderFactory.XjComponentBuilder xj() {
        return XjComponentBuilderFactory.xj();
    }
    /**
     * XML Security Sign (camel-xmlsecurity)
     * Sign XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * @return the dsl builder
     */
    static XmlsecuritySignComponentBuilderFactory.XmlsecuritySignComponentBuilder xmlsecuritySign() {
        return XmlsecuritySignComponentBuilderFactory.xmlsecuritySign();
    }
    /**
     * XML Security Verify (camel-xmlsecurity)
     * Verify XML payloads using the XML signature specification.
     * 
     * Category: security,transformation
     * Since: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * @return the dsl builder
     */
    static XmlsecurityVerifyComponentBuilderFactory.XmlsecurityVerifyComponentBuilder xmlsecurityVerify() {
        return XmlsecurityVerifyComponentBuilderFactory.xmlsecurityVerify();
    }
    /**
     * XMPP (camel-xmpp)
     * Send and receive messages to/from an XMPP chat server.
     * 
     * Category: chat,messaging
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-xmpp
     * 
     * @return the dsl builder
     */
    static XmppComponentBuilderFactory.XmppComponentBuilder xmpp() {
        return XmppComponentBuilderFactory.xmpp();
    }
    /**
     * XQuery (camel-saxon)
     * Query and/or transform XML payloads using XQuery and Saxon.
     * 
     * Category: transformation
     * Since: 1.0
     * Maven coordinates: org.apache.camel:camel-saxon
     * 
     * @return the dsl builder
     */
    static XqueryComponentBuilderFactory.XqueryComponentBuilder xquery() {
        return XqueryComponentBuilderFactory.xquery();
    }
    /**
     * XSLT (camel-xslt)
     * Transforms XML payload using an XSLT template.
     * 
     * Category: core,transformation
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-xslt
     * 
     * @return the dsl builder
     */
    static XsltComponentBuilderFactory.XsltComponentBuilder xslt() {
        return XsltComponentBuilderFactory.xslt();
    }
    /**
     * XSLT Saxon (camel-xslt-saxon)
     * Transform XML payloads using an XSLT template using Saxon.
     * 
     * Category: core,transformation
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-xslt-saxon
     * 
     * @return the dsl builder
     */
    static XsltSaxonComponentBuilderFactory.XsltSaxonComponentBuilder xsltSaxon() {
        return XsltSaxonComponentBuilderFactory.xsltSaxon();
    }
    /**
     * Zeebe (camel-zeebe)
     * Zeebe component which integrates with Camunda Zeebe to interact with the
     * API.
     * 
     * Category: workflow,saas
     * Since: 3.21
     * Maven coordinates: org.apache.camel:camel-zeebe
     * 
     * @return the dsl builder
     */
    static ZeebeComponentBuilderFactory.ZeebeComponentBuilder zeebe() {
        return ZeebeComponentBuilderFactory.zeebe();
    }
    /**
     * Zendesk (camel-zendesk)
     * Manage Zendesk tickets, users, organizations, etc.
     * 
     * Category: cloud,api,saas
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zendesk
     * 
     * @return the dsl builder
     */
    static ZendeskComponentBuilderFactory.ZendeskComponentBuilder zendesk() {
        return ZendeskComponentBuilderFactory.zendesk();
    }
    /**
     * ZooKeeper (camel-zookeeper)
     * Manage ZooKeeper clusters.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-zookeeper
     * 
     * @return the dsl builder
     */
    static ZookeeperComponentBuilderFactory.ZookeeperComponentBuilder zookeeper() {
        return ZookeeperComponentBuilderFactory.zookeeper();
    }
    /**
     * ZooKeeper Master (camel-zookeeper-master)
     * Have only a single consumer in a cluster consuming from a given endpoint;
     * with automatic failover if the JVM dies.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-zookeeper-master
     * 
     * @return the dsl builder
     */
    static ZookeeperMasterComponentBuilderFactory.ZookeeperMasterComponentBuilder zookeeperMaster() {
        return ZookeeperMasterComponentBuilderFactory.zookeeperMaster();
    }
}