/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;

public class EnumFormatFactory
extends AbstractFormatFactory {
    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return formattingOptions.getClazz().isEnum();
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        EnumFormat enumFormat = new EnumFormat(formattingOptions.getClazz());
        return enumFormat;
    }

    private static class EnumFormat<T extends Enum<T>>
    implements Format<T> {
        private final Class<T> clazz;

        EnumFormat(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public String format(T object) throws Exception {
            return ((Enum)object).name();
        }

        @Override
        public T parse(String string) throws Exception {
            return Enum.valueOf(this.clazz, string);
        }
    }
}

