/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.Header;
import org.apache.camel.Headers;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Variable;
import org.apache.camel.Variables;
import org.apache.camel.component.bean.CamelInvocationHandler;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelInvocationHandler.class);
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private static final Lock LOCK = new ReentrantLock();
    public static final String CAMEL_INVOCATION_HANDLER = "CamelInvocationHandler";
    private static ExecutorService executorService;
    protected final Endpoint endpoint;
    protected final Producer producer;

    protected AbstractCamelInvocationHandler(Endpoint endpoint, Producer producer) {
        this.endpoint = endpoint;
        this.producer = producer;
    }

    private static Object getBody(Exchange exchange, Class<?> type) throws InvalidPayloadException {
        if (exchange.getMessage().getBody() != null) {
            return exchange.getMessage().getMandatoryBody(type);
        }
        return null;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isValidMethod(method)) {
            return this.doInvokeProxy(proxy, method, args);
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("equals".equals(method.getName())) {
            return Boolean.FALSE;
        }
        return null;
    }

    public abstract Object doInvokeProxy(Object var1, Method var2, Object[] var3) throws Throwable;

    protected Object invokeProxy(Method method, ExchangePattern pattern, Object[] args, boolean binding) throws Throwable {
        boolean canUseBinding;
        DefaultExchange exchange = DefaultExchange.newFromEndpoint((Endpoint)this.endpoint, (ExchangePattern)pattern);
        boolean bl = canUseBinding = method.getParameterCount() == 1;
        if (!canUseBinding) {
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.isAnnotationPresent(Header.class) && !parameter.isAnnotationPresent(Headers.class) && !parameter.isAnnotationPresent(Variable.class) && !parameter.isAnnotationPresent(Variables.class) && !parameter.isAnnotationPresent(ExchangeProperty.class) && !parameter.isAnnotationPresent(Body.class)) continue;
                canUseBinding = true;
                break;
            }
        }
        if (binding && canUseBinding) {
            int index = 0;
            for (Annotation[] row : method.getParameterAnnotations()) {
                Object value = args[index];
                if (row == null || row.length == 0) {
                    exchange.getIn().setBody(value);
                } else {
                    for (Annotation ann : row) {
                        Map map;
                        String name;
                        if (ann.annotationType().isAssignableFrom(Header.class)) {
                            Header header = (Header)ann;
                            name = header.value();
                            exchange.getIn().setHeader(name, value);
                            continue;
                        }
                        if (ann.annotationType().isAssignableFrom(Headers.class)) {
                            map = (Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, (Exchange)exchange, value);
                            if (map == null) continue;
                            exchange.getIn().getHeaders().putAll(map);
                            continue;
                        }
                        if (ann.annotationType().isAssignableFrom(Variable.class)) {
                            Variable variable = (Variable)ann;
                            name = variable.value();
                            exchange.setVariable(name, value);
                            continue;
                        }
                        if (ann.annotationType().isAssignableFrom(Variables.class)) {
                            map = (Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, (Exchange)exchange, value);
                            if (map == null) continue;
                            exchange.getVariables().putAll(map);
                            continue;
                        }
                        if (ann.annotationType().isAssignableFrom(ExchangeProperty.class)) {
                            ExchangeProperty ep = (ExchangeProperty)ann;
                            name = ep.value();
                            exchange.setProperty(name, value);
                            continue;
                        }
                        exchange.getIn().setBody(value);
                    }
                }
                ++index;
            }
        } else if (args != null) {
            if (args.length == 1) {
                exchange.getIn().setBody(args[0]);
            } else {
                exchange.getIn().setBody((Object)args);
            }
        }
        if (binding) {
            LOG.trace("Binding to service interface as @Body,@Header,@ExchangeProperty detected when calling proxy method: {}", (Object)method);
        } else {
            LOG.trace("No binding to service interface as @Body,@Header,@ExchangeProperty not detected when calling proxy method: {}", (Object)method);
        }
        return this.doInvoke(method, (Exchange)exchange);
    }

    protected Object invokeWithBody(Method method, Object body, ExchangePattern pattern) throws Throwable {
        DefaultExchange exchange = DefaultExchange.newFromEndpoint((Endpoint)this.endpoint, (ExchangePattern)pattern);
        exchange.getIn().setBody(body);
        return this.doInvoke(method, (Exchange)exchange);
    }

    protected Object doInvoke(final Method method, final Exchange exchange) throws Throwable {
        final boolean isFuture = method.getReturnType() == Future.class;
        FutureTask<Object> task = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LOG.trace("Proxied method call {} invoking producer: {}", (Object)method.getName(), (Object)AbstractCamelInvocationHandler.this.producer);
                AbstractCamelInvocationHandler.this.producer.process(exchange);
                Object answer = AbstractCamelInvocationHandler.this.afterInvoke(method, exchange, isFuture);
                LOG.trace("Proxied method call {} returning: {}", (Object)method.getName(), answer);
                return answer;
            }
        });
        if (isFuture) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting task for exchange id {}", (Object)exchange.getExchangeId());
            }
            AbstractCamelInvocationHandler.getExecutorService(exchange.getContext()).submit(task);
            return task;
        }
        try {
            task.run();
            return task.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    protected Object afterInvoke(Method method, Exchange exchange, boolean isFuture) throws Exception {
        Class<?> to;
        Exception cause = exchange.getException();
        if (cause != null) {
            Throwable found = this.findSuitableException(cause, method);
            if (found != null) {
                if (found instanceof Exception) {
                    throw (Exception)found;
                }
                throw new CamelExchangeException("Error processing exchange", exchange, (Throwable)cause);
            }
            if (cause instanceof RuntimeCamelException) {
                if (cause.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)cause.getCause();
                }
                throw cause;
            }
            throw cause;
        }
        Class<?> clazz = to = isFuture ? AbstractCamelInvocationHandler.getGenericType(exchange.getContext(), method.getGenericReturnType()) : method.getReturnType();
        if (to == Void.TYPE) {
            return null;
        }
        return AbstractCamelInvocationHandler.getBody(exchange, to);
    }

    protected static Class<?> getGenericType(CamelContext context, Type type) throws ClassNotFoundException {
        if (type == null) {
            return Object.class;
        }
        String name = StringHelper.between((String)type.toString(), (String)"<", (String)">");
        if (name != null) {
            if (name.contains("<")) {
                name = StringHelper.before((String)name, (String)"<");
            }
            return context.getClassResolver().resolveMandatoryClass(name);
        }
        return Object.class;
    }

    protected static ExecutorService getExecutorService(CamelContext context) {
        LOCK.lock();
        try {
            if (executorService == null || executorService.isTerminated() || executorService.isShutdown()) {
                executorService = (ExecutorService)context.getRegistry().lookupByNameAndType(CAMEL_INVOCATION_HANDLER, ExecutorService.class);
                if (executorService == null) {
                    executorService = context.getExecutorServiceManager().newThreadPool(CamelInvocationHandler.class, CAMEL_INVOCATION_HANDLER, CAMEL_INVOCATION_HANDLER);
                }
                if (executorService == null) {
                    executorService = context.getExecutorServiceManager().newDefaultThreadPool(CamelInvocationHandler.class, CAMEL_INVOCATION_HANDLER);
                }
            }
            ExecutorService executorService = AbstractCamelInvocationHandler.executorService;
            return executorService;
        }
        finally {
            LOCK.unlock();
        }
    }

    protected Throwable findSuitableException(Throwable cause, Method method) {
        if (method.getExceptionTypes() == null || method.getExceptionTypes().length == 0) {
            return null;
        }
        for (Class<?> type : method.getExceptionTypes()) {
            Object fault = ObjectHelper.getException(type, (Throwable)cause);
            if (fault == null) continue;
            return (Throwable)Throwable.class.cast(fault);
        }
        return null;
    }

    protected boolean isValidMethod(Method method) {
        for (Method excluded : EXCLUDED_METHODS) {
            if (!ObjectHelper.isOverridingMethod((Method)excluded, (Method)method)) continue;
            return false;
        }
        return true;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
    }
}

