/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanTypeHolder;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

public class ConstantTypeBeanHolder
implements BeanTypeHolder {
    private final Class<?> type;
    private final BeanInfo beanInfo;
    private Map<String, Object> options;

    public ConstantTypeBeanHolder(Class<?> type, CamelContext context) {
        this(type, new BeanInfo(context, type));
    }

    public ConstantTypeBeanHolder(Class<?> type, BeanInfo beanInfo) {
        ObjectHelper.notNull(type, (String)"type");
        ObjectHelper.notNull((Object)beanInfo, (String)"beanInfo");
        this.type = type;
        this.beanInfo = beanInfo;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public ConstantBeanHolder createCacheHolder() throws Exception {
        Object bean = this.getBean(null);
        return new ConstantBeanHolder(bean, this.beanInfo);
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public Object getBean(Exchange exchange) {
        if (this.beanInfo.hasPublicNoArgConstructors()) {
            Object bean = this.getBeanInfo().getCamelContext().getInjector().newInstance(this.type, false);
            if (this.options != null && !this.options.isEmpty()) {
                PropertyBindingSupport.build().withRemoveParameters(false).withCamelContext(this.getBeanInfo().getCamelContext()).withProperties(this.options).withTarget(bean).bind();
            }
            return bean;
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return null;
    }

    @Override
    public boolean supportProcessor() {
        return false;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return null;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

