/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.ClasspathPropertiesSource;
import org.apache.camel.component.properties.FilePropertiesSource;
import org.apache.camel.component.properties.LocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.component.properties.RefPropertiesSource;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.util.OrderedLocationProperties;

public class DefaultPropertiesLookup
implements PropertiesLookup {
    private final PropertiesComponent component;

    public DefaultPropertiesLookup(PropertiesComponent component) {
        this.component = component;
    }

    @Override
    public String lookup(String name, String defaultValue) {
        try {
            return this.doLookup(name, defaultValue);
        }
        catch (NoTypeConversionAvailableException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    private String doLookup(String name, String defaultValue) throws NoTypeConversionAvailableException {
        String loc;
        Object value;
        String answer = null;
        Properties local = this.component.getLocalProperties();
        if (local != null && (value = local.get(name)) != null) {
            OrderedLocationProperties locationProperties;
            Object val;
            answer = (String)this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
            loc = DefaultPropertiesLookup.location(local, name, "LocalProperties");
            String localDefaultValue = null;
            if (local instanceof OrderedLocationProperties && (val = (locationProperties = (OrderedLocationProperties)local).getDefaultValue((Object)name)) != null) {
                localDefaultValue = (String)this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, val);
            }
            this.onLookup(name, answer, localDefaultValue, loc);
        }
        if (answer == null && this.component.getOverrideProperties() != null && (value = this.component.getOverrideProperties().get(name)) != null) {
            answer = (String)this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
            loc = DefaultPropertiesLookup.location(local, name, "OverrideProperties");
            this.onLookup(name, answer, defaultValue, loc);
        }
        if (answer == null) {
            value = this.component.getPropertiesSources().iterator();
            while (value.hasNext()) {
                LoadablePropertiesSource propSource;
                Properties prop;
                PropertiesSource ps = (PropertiesSource)value.next();
                answer = ps.getProperty(name, defaultValue);
                if (answer == null) continue;
                Object source = ps.getName();
                if (ps instanceof ClasspathPropertiesSource) {
                    ClasspathPropertiesSource propSource2 = (ClasspathPropertiesSource)ps;
                    source = "classpath:" + propSource2.getLocation().getPath();
                } else if (ps instanceof FilePropertiesSource) {
                    FilePropertiesSource propSource3 = (FilePropertiesSource)ps;
                    source = "file:" + propSource3.getLocation().getPath();
                } else if (ps instanceof RefPropertiesSource) {
                    RefPropertiesSource propSource4 = (RefPropertiesSource)ps;
                    source = "ref:" + propSource4.getLocation().getPath();
                } else if (ps instanceof LocationPropertiesSource) {
                    LocationPropertiesSource propSource5 = (LocationPropertiesSource)ps;
                    source = propSource5.getLocation().getPath();
                } else if (ps instanceof LoadablePropertiesSource && (prop = (propSource = (LoadablePropertiesSource)ps).loadProperties()) instanceof OrderedLocationProperties) {
                    OrderedLocationProperties olp = (OrderedLocationProperties)prop;
                    source = olp.getLocation((Object)name);
                }
                this.onLookup(name, answer, defaultValue, (String)source);
                break;
            }
        }
        if (answer == null && this.component.getInitialProperties() != null && (value = this.component.getInitialProperties().get(name)) != null) {
            answer = (String)this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
            loc = DefaultPropertiesLookup.location(local, name, "InitialProperties");
            this.onLookup(name, answer, defaultValue, loc);
        }
        return answer;
    }

    private void onLookup(String name, String value, String defaultValue, String source) {
        for (PropertiesLookupListener listener : this.component.getPropertiesLookupListeners()) {
            try {
                listener.onLookup(name, value, defaultValue, source);
            }
            catch (Exception exception) {}
        }
    }

    private static String location(Properties prop, String name, String defaultLocation) {
        String loc = null;
        if (prop instanceof OrderedLocationProperties) {
            OrderedLocationProperties value = (OrderedLocationProperties)prop;
            loc = value.getLocation((Object)name);
        }
        if (loc == null) {
            loc = defaultLocation;
        }
        return loc;
    }
}

