/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.RegistryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHealthCheckRegistry
implements HealthCheckRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHealthCheckRegistry.class);
    private final Set<HealthCheck> checks = new CopyOnWriteArraySet<HealthCheck>();
    private final Set<HealthCheckRepository> repositories = new CopyOnWriteArraySet<HealthCheckRepository>();
    private CamelContext camelContext;

    public DefaultHealthCheckRegistry() {
        this(null);
    }

    public DefaultHealthCheckRegistry(CamelContext camelContext) {
        this.repositories.add(new RegistryRepository());
        this.setCamelContext(camelContext);
    }

    public final void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        for (HealthCheck check : this.checks) {
            if (!(check instanceof CamelContextAware)) continue;
            ((CamelContextAware)check).setCamelContext(camelContext);
        }
        for (HealthCheckRepository repository : this.repositories) {
            if (!(repository instanceof CamelContextAware)) continue;
            ((CamelContextAware)repository).setCamelContext(camelContext);
        }
    }

    public final CamelContext getCamelContext() {
        return this.camelContext;
    }

    public boolean register(HealthCheck check) {
        boolean result = this.checks.add(check);
        if (result) {
            if (check instanceof CamelContextAware) {
                ((CamelContextAware)check).setCamelContext(this.camelContext);
            }
            LOGGER.debug("HealthCheck with id {} successfully registered", (Object)check.getId());
        }
        return result;
    }

    public boolean unregister(HealthCheck check) {
        boolean result = this.checks.remove(check);
        if (result) {
            LOGGER.debug("HealthCheck with id {} successfully un-registered", (Object)check.getId());
        }
        return result;
    }

    public void setRepositories(Collection<HealthCheckRepository> repositories) {
        repositories.clear();
        repositories.addAll(repositories);
    }

    public Collection<HealthCheckRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    public boolean addRepository(HealthCheckRepository repository) {
        boolean result = this.repositories.add(repository);
        if (result && repository instanceof CamelContextAware) {
            ((CamelContextAware)repository).setCamelContext(this.getCamelContext());
            LOGGER.debug("HealthCheckRepository {} successfully registered", (Object)repository);
        }
        return result;
    }

    public boolean removeRepository(HealthCheckRepository repository) {
        boolean result = this.repositories.remove(repository);
        if (result) {
            LOGGER.debug("HealthCheckRepository with {} successfully un-registered", (Object)repository);
        }
        return result;
    }

    public Stream<HealthCheck> stream() {
        return Stream.concat(this.checks.stream(), this.repositories.stream().flatMap(HealthCheckRepository::stream)).distinct();
    }
}

