/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class IOConverter {
    private static final Logger LOG = LoggerFactory.getLogger(IOConverter.class);

    private IOConverter() {
    }

    @Converter
    public static InputStream toInputStream(URL url) throws IOException {
        return IOHelper.buffered((InputStream)url.openStream());
    }

    @Converter
    public static InputStream toInputStream(File file) throws IOException {
        return IOHelper.buffered((InputStream)new FileInputStream(file));
    }

    public static InputStream toInputStream(File file, String charset) throws IOException {
        if (charset != null) {
            return new IOHelper.EncodingInputStream(file, charset);
        }
        return IOConverter.toInputStream(file);
    }

    @Converter
    public static BufferedReader toReader(File file, Exchange exchange) throws IOException {
        return IOHelper.toReader((File)file, (String)ExchangeHelper.getCharsetName((Exchange)exchange));
    }

    @Converter
    public static File toFile(String name) {
        return new File(name);
    }

    @Converter
    public static OutputStream toOutputStream(File file) throws FileNotFoundException {
        return IOHelper.buffered((OutputStream)new FileOutputStream(file));
    }

    @Converter
    public static BufferedWriter toWriter(File file, Exchange exchange) throws IOException {
        FileOutputStream os = new FileOutputStream(file, false);
        return IOConverter.toWriter(os, ExchangeHelper.getCharsetName((Exchange)exchange));
    }

    public static BufferedWriter toWriter(File file, boolean append, String charset) throws IOException {
        return IOConverter.toWriter(new FileOutputStream(file, append), charset);
    }

    public static BufferedWriter toWriter(FileOutputStream os, String charset) throws IOException {
        return IOHelper.buffered((Writer)new IOHelper.EncodingFileWriter(os, charset));
    }

    @Converter
    public static Reader toReader(InputStream in, Exchange exchange) throws IOException {
        return IOHelper.buffered((Reader)new InputStreamReader(in, ExchangeHelper.getCharsetName((Exchange)exchange)));
    }

    @Converter
    public static Reader toReader(byte[] data, Exchange exchange) throws IOException {
        return IOConverter.toReader(new ByteArrayInputStream(data), exchange);
    }

    @Converter
    public static Writer toWriter(OutputStream out, Exchange exchange) throws IOException {
        return IOHelper.buffered((Writer)new OutputStreamWriter(out, ExchangeHelper.getCharsetName((Exchange)exchange)));
    }

    @Converter
    public static StringReader toReader(String text) {
        return new StringReader(text);
    }

    @Converter
    public static InputStream toInputStream(String text, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(text.getBytes(ExchangeHelper.getCharsetName((Exchange)exchange)));
    }

    @Converter
    public static InputStream toInputStream(StringBuffer buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(buffer.toString(), exchange);
    }

    @Converter
    public static InputStream toInputStream(StringBuilder builder, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(builder.toString(), exchange);
    }

    @Converter
    public static InputStream toInputStream(BufferedReader buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(IOConverter.toString(buffer), exchange);
    }

    @Converter
    public static String toString(byte[] data, Exchange exchange) throws IOException {
        return new String(data, ExchangeHelper.getCharsetName((Exchange)exchange));
    }

    @Converter
    public static String toString(File file, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(file, exchange));
    }

    @Converter
    public static byte[] toByteArray(File file) throws IOException {
        InputStream is = IOConverter.toInputStream(file);
        try {
            byte[] byArray = IOConverter.toBytes(is);
            return byArray;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"file", (Logger)LOG);
        }
    }

    @Converter
    public static byte[] toByteArray(Reader reader, Exchange exchange) throws IOException {
        return IOConverter.toByteArray(IOHelper.buffered((Reader)reader), exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static String toString(URL url, Exchange exchange) throws IOException {
        InputStream is = IOConverter.toInputStream(url);
        try {
            String string = IOConverter.toString(is, exchange);
            return string;
        }
        finally {
            IOHelper.close((Closeable)is, (String)"url", (Logger)LOG);
        }
    }

    @Converter
    public static String toString(Reader reader) throws IOException {
        return IOHelper.toString((Reader)reader);
    }

    @Converter
    public static String toString(BufferedReader reader) throws IOException {
        return IOHelper.toString((BufferedReader)reader);
    }

    @Converter
    public static byte[] toByteArray(BufferedReader reader, Exchange exchange) throws IOException {
        String s = IOConverter.toString(reader);
        return IOConverter.toByteArray(s, exchange);
    }

    @Converter
    public static byte[] toByteArray(String value, Exchange exchange) throws IOException {
        return value.getBytes(ExchangeHelper.getCharsetName((Exchange)exchange));
    }

    @Converter
    public static String toString(InputStream in, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(in, exchange));
    }

    @Converter
    public static InputStream toInputStream(byte[] data) {
        return new ByteArrayInputStream(data);
    }

    @Converter
    public static ObjectOutput toObjectOutput(OutputStream stream) throws IOException {
        if (stream instanceof ObjectOutput) {
            return (ObjectOutput)((Object)stream);
        }
        return new ObjectOutputStream(IOHelper.buffered((OutputStream)stream));
    }

    @Converter
    public static ObjectInput toObjectInput(InputStream stream, final Exchange exchange) throws IOException {
        if (stream instanceof ObjectInput) {
            return (ObjectInput)((Object)stream);
        }
        return new ObjectInputStream(IOHelper.buffered((InputStream)stream)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class answer = null;
                String name = objectStreamClass.getName();
                if (exchange != null) {
                    LOG.trace("Loading class {} using Camel ClassResolver", (Object)name);
                    answer = exchange.getContext().getClassResolver().resolveClass(name);
                }
                if (answer == null) {
                    LOG.trace("Loading class {} using JDK default implementation", (Object)name);
                    answer = super.resolveClass(objectStreamClass);
                }
                return answer;
            }
        };
    }

    @Converter
    public static byte[] toBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copy((InputStream)IOHelper.buffered((InputStream)stream), (OutputStream)bos);
        return bos.toByteArray();
    }

    @Converter
    public static byte[] toByteArray(ByteArrayOutputStream os) {
        return os.toByteArray();
    }

    @Converter
    public static ByteBuffer covertToByteBuffer(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os);
        return ByteBuffer.wrap(os.toByteArray());
    }

    @Converter
    public static String toString(ByteArrayOutputStream os, Exchange exchange) throws IOException {
        return os.toString(ExchangeHelper.getCharsetName((Exchange)exchange));
    }

    @Converter
    public static InputStream toInputStream(ByteArrayOutputStream os) {
        return new ByteArrayInputStream(os.toByteArray());
    }

    @Converter
    public static Properties toProperties(File file) throws IOException {
        return IOConverter.toProperties(new FileInputStream(file));
    }

    @Converter
    public static Properties toProperties(InputStream is) throws IOException {
        Properties prop = new Properties();
        try {
            prop.load(is);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        return prop;
    }

    @Converter
    public static Properties toProperties(Reader reader) throws IOException {
        Properties prop = new Properties();
        try {
            prop.load(reader);
        }
        finally {
            IOHelper.close((Closeable)reader);
        }
        return prop;
    }
}

