/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsonable;
import org.apache.camel.util.json.Jsoner;

public final class DefaultBacklogTracerEventMessage
implements BacklogTracerEventMessage {
    private final CamelContext camelContext;
    private final StopWatch watch;
    private final boolean first;
    private final boolean last;
    private final long uid;
    private final long timestamp;
    private final String location;
    private final String routeId;
    private final String toNode;
    private final String toNodeParentId;
    private final String toNodeParentWhenId;
    private final String toNodeParentWhenLabel;
    private final String toNodeShortName;
    private final String toNodeLabel;
    private final int toNodeLevel;
    private final String exchangeId;
    private final String correlationExchangeId;
    private final String threadName;
    private String endpointUri;
    private boolean remoteEndpoint;
    private String endpointServiceUrl;
    private String endpointServiceProtocol;
    private Map<String, String> endpointServiceMetadata;
    private final boolean rest;
    private final boolean template;
    private final JsonObject data;
    private volatile String dataAsJson;
    private volatile String dataAsXml;
    private Throwable exception;
    private volatile JsonObject exceptionAsJsonObject;
    private volatile String exceptionAsXml;
    private volatile String exceptionAsJSon;
    private long duration;
    private boolean done;

    public DefaultBacklogTracerEventMessage(CamelContext camelContext, boolean first, boolean last, long uid, long timestamp, String location, String routeId, String toNode, String toNodeParentId, String toNodeParentWhenId, String toNodeParentWhenLabel, String toNodeShortName, String toNodeLabel, int toNodeLevel, String exchangeId, String correlationExchangeId, boolean rest, boolean template, JsonObject data) {
        this.camelContext = camelContext;
        this.watch = new StopWatch();
        this.first = first;
        this.last = last;
        this.uid = uid;
        this.timestamp = timestamp;
        this.location = location;
        this.routeId = routeId;
        this.toNode = toNode;
        this.toNodeParentId = toNodeParentId;
        this.toNodeParentWhenId = toNodeParentWhenId;
        this.toNodeParentWhenLabel = toNodeParentWhenLabel;
        this.toNodeShortName = toNodeShortName;
        this.toNodeLabel = toNodeLabel;
        this.toNodeLevel = toNodeLevel;
        this.exchangeId = exchangeId;
        this.correlationExchangeId = correlationExchangeId;
        this.rest = rest;
        this.template = template;
        this.threadName = Thread.currentThread().getName();
        this.data = data;
    }

    public void doneProcessing() {
        this.done = true;
        this.duration = this.watch.taken();
    }

    public long getUid() {
        return this.uid;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public boolean isRest() {
        return this.rest;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public String getToNode() {
        return this.toNode;
    }

    public String getToNodeParentId() {
        return this.toNodeParentId;
    }

    public String getToNodeParentWhenId() {
        return this.toNodeParentWhenId;
    }

    public String getToNodeParentWhenLabel() {
        return this.toNodeParentWhenLabel;
    }

    public String getToNodeShortName() {
        return this.toNodeShortName;
    }

    public String getToNodeLabel() {
        return this.toNodeLabel;
    }

    public int getToNodeLevel() {
        return this.toNodeLevel;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getCorrelationExchangeId() {
        return this.correlationExchangeId;
    }

    public String getProcessingThreadName() {
        return this.threadName;
    }

    public String getMessageAsXml() {
        return this.getMessageAsXml(4);
    }

    public String getMessageAsXml(int indent) {
        if (this.dataAsXml == null) {
            this.dataAsXml = this.toXML(this.data, indent);
        }
        return this.dataAsXml;
    }

    public String getMessageAsJSon() {
        if (this.dataAsJson == null) {
            this.dataAsJson = this.data.toJson();
        }
        return this.dataAsJson;
    }

    public long getElapsed() {
        return this.done ? this.duration : this.watch.taken();
    }

    public void setElapsed(long elapsed) {
        this.duration = elapsed;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isFailed() {
        return this.hasException();
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getExceptionAsXml() {
        return this.getExceptionAsXml(4);
    }

    public String getExceptionAsXml(int indent) {
        if (this.exceptionAsXml == null && this.exception != null) {
            this.exceptionAsXml = MessageHelper.dumpExceptionAsXML((Throwable)this.exception, (int)indent);
        }
        return this.exceptionAsXml;
    }

    public String getExceptionAsJSon() {
        if (this.exceptionAsJSon == null && this.exception != null) {
            this.exceptionAsJSon = MessageHelper.dumpExceptionAsJSon((Throwable)this.exception, (int)4, (boolean)true);
        }
        return this.exceptionAsJSon;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public boolean isRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public void setRemoteEndpoint(boolean remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        this.dataAsJson = null;
        this.dataAsXml = null;
    }

    public String getEndpointServiceUrl() {
        return this.endpointServiceUrl;
    }

    public void setEndpointServiceUrl(String endpointServiceUrl) {
        this.endpointServiceUrl = endpointServiceUrl;
        this.dataAsJson = null;
        this.dataAsXml = null;
    }

    public String getEndpointServiceProtocol() {
        return this.endpointServiceProtocol;
    }

    public void setEndpointServiceProtocol(String endpointServiceProtocol) {
        this.endpointServiceProtocol = endpointServiceProtocol;
        this.dataAsJson = null;
        this.dataAsXml = null;
    }

    public Map<String, String> getEndpointServiceMetadata() {
        return this.endpointServiceMetadata;
    }

    public void setEndpointServiceMetadata(Map<String, String> endpointServiceMetadata) {
        this.endpointServiceMetadata = endpointServiceMetadata;
        this.dataAsJson = null;
        this.dataAsXml = null;
    }

    public String toString() {
        return "DefaultBacklogTracerEventMessage[" + this.exchangeId + " at " + this.toNode + "]";
    }

    public String toXml(int indent) {
        String prefix = " ".repeat(indent);
        StringBuilder sb = new StringBuilder(512);
        sb.append(prefix).append("<").append("backlogTracerEventMessage").append(">\n");
        sb.append(prefix).append("  <uid>").append(this.uid).append("</uid>\n");
        sb.append(prefix).append("  <first>").append(this.first).append("</first>\n");
        sb.append(prefix).append("  <last>").append(this.last).append("</last>\n");
        sb.append(prefix).append("  <rest>").append(this.rest).append("</rest>\n");
        sb.append(prefix).append("  <template>").append(this.template).append("</template>\n");
        String ts = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.timestamp);
        sb.append(prefix).append("  <timestamp>").append(ts).append("</timestamp>\n");
        sb.append(prefix).append("  <elapsed>").append(this.getElapsed()).append("</elapsed>\n");
        sb.append(prefix).append("  <threadName>").append(this.getProcessingThreadName()).append("</threadName>\n");
        sb.append(prefix).append("  <done>").append(this.isDone()).append("</done>\n");
        sb.append(prefix).append("  <failed>").append(this.isFailed()).append("</failed>\n");
        if (this.getLocation() != null) {
            sb.append(prefix).append("  <location>").append(this.getLocation()).append("</location>\n");
        }
        sb.append(prefix).append("  <routeId>").append(this.routeId != null ? this.routeId : "").append("</routeId>\n");
        if (this.endpointUri != null) {
            sb.append(prefix).append("  <endpointUri>").append(this.endpointUri).append("</endpointUri>\n");
            sb.append(prefix).append("  <remoteEndpoint>").append(this.remoteEndpoint).append("</remoteEndpoint>\n");
        }
        if (this.toNode != null) {
            sb.append(prefix).append("  <toNode>").append(this.toNode).append("</toNode>\n");
        } else {
            sb.append(prefix).append("  <toNode>").append(this.routeId).append("</toNode>\n");
        }
        sb.append(prefix).append("  <exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        if (this.endpointServiceUrl != null) {
            sb.append(prefix).append("  <endpointService>\n");
            sb.append(prefix).append("    <serviceUrl>").append(this.endpointServiceUrl).append("</serviceUrl>\n");
            if (this.endpointServiceProtocol != null) {
                sb.append(prefix).append("    <serviceProtocol>").append(this.endpointServiceProtocol).append("</serviceProtocol>\n");
            }
            if (this.endpointServiceMetadata != null) {
                sb.append(prefix).append("    <serviceMetadata>\n");
                this.endpointServiceMetadata.forEach((k, v) -> sb.append(prefix).append("      <").append((String)k).append(">").append((String)v).append("</").append((String)k).append(">\n"));
                sb.append(prefix).append("    </serviceMetadata>\n");
            }
            sb.append(prefix).append("  </endpointService>\n");
        }
        sb.append(this.getMessageAsXml(indent + 2)).append("\n");
        if (this.getExceptionAsXml() != null) {
            sb.append(prefix).append(this.getExceptionAsXml(indent + 2)).append("\n");
        }
        sb.append(prefix).append("</").append("backlogTracerEventMessage").append(">");
        return sb.toString();
    }

    private String toXML(JsonObject data, int indent) {
        JsonObject jo;
        String text2;
        Object value;
        String type;
        JsonObject jo2;
        StringBuilder sb = new StringBuilder(1024);
        String prefix = " ".repeat(indent);
        JsonObject root = (JsonObject)data.getMap("message");
        sb.append(prefix);
        sb.append("<message exchangeId=\"").append(root.getString("exchangeId")).append("\" exchangePattern=\"").append(root.getString("exchangePattern")).append("\" exchangeType=\"").append(root.getString("exchangeType")).append("\" messageType=\"").append(root.getString("messageType")).append("\">\n");
        JsonArray arr = (JsonArray)root.getCollection("exchangeVariables");
        if (arr != null && !arr.isEmpty()) {
            sb.append(prefix);
            sb.append("  <exchangeVariables>\n");
            for (Object entry : arr) {
                jo2 = (JsonObject)entry;
                sb.append(prefix);
                sb.append("    <exchangeVariable key=\"").append(jo2.getString("key")).append("\"");
                type = jo2.getString("type");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                value = jo2.get((Object)"value");
                if (value != null) {
                    try {
                        text2 = (String)this.camelContext.getTypeConverter().tryConvertTo(String.class, value);
                        sb.append(StringHelper.xmlEncode((String)text2));
                    }
                    catch (Exception text2) {
                        // empty catch block
                    }
                }
                sb.append("</exchangeVariable>\n");
            }
            sb.append(prefix);
            sb.append("  </exchangeVariables>\n");
        }
        if ((arr = (JsonArray)root.getCollection("exchangeProperties")) != null && !arr.isEmpty()) {
            sb.append(prefix);
            sb.append("  <exchangeProperties>\n");
            for (Object entry : arr) {
                jo2 = (JsonObject)entry;
                sb.append(prefix);
                sb.append("    <exchangeProperty key=\"").append(jo2.getString("key")).append("\"");
                type = jo2.getString("type");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                value = jo2.get((Object)"value");
                if (value != null) {
                    try {
                        text2 = (String)this.camelContext.getTypeConverter().tryConvertTo(String.class, value);
                        sb.append(StringHelper.xmlEncode((String)text2));
                    }
                    catch (Exception text3) {
                        // empty catch block
                    }
                }
                sb.append("</exchangeProperty>\n");
            }
            sb.append(prefix);
            sb.append("  </exchangeProperties>\n");
        }
        if ((arr = (JsonArray)root.getCollection("headers")) != null && !arr.isEmpty()) {
            sb.append(prefix);
            sb.append("  <headers>\n");
            for (Object entry : arr) {
                jo2 = (JsonObject)entry;
                sb.append(prefix);
                sb.append("    <header key=\"").append(jo2.getString("key")).append("\"");
                type = jo2.getString("type");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                value = jo2.get((Object)"value");
                if (value != null) {
                    try {
                        text2 = (String)this.camelContext.getTypeConverter().tryConvertTo(String.class, value);
                        sb.append(StringHelper.xmlEncode((String)text2));
                    }
                    catch (Exception text4) {
                        // empty catch block
                    }
                }
                sb.append("</header>\n");
            }
            sb.append(prefix);
            sb.append("  </headers>\n");
        }
        if ((jo = (JsonObject)root.getMap("body")) != null) {
            Long position;
            Long size;
            sb.append(prefix);
            sb.append("  <body");
            String type2 = jo.getString("type");
            if (type2 != null) {
                sb.append(" type=\"").append(type2).append("\"");
            }
            if ((size = jo.getLong("size")) != null) {
                sb.append(" size=\"").append(size).append("\"");
            }
            if ((position = jo.getLong("position")) != null) {
                sb.append(" position=\"").append(position).append("\"");
            }
            sb.append(">");
            value = jo.get((Object)"value");
            if (value != null) {
                try {
                    text2 = (String)this.camelContext.getTypeConverter().tryConvertTo(String.class, value);
                    sb.append(StringHelper.xmlEncode((String)text2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append("</body>\n");
        }
        sb.append(prefix);
        sb.append("</message>");
        return sb.toString();
    }

    public String toJSon(int indent) {
        Jsonable jo = (Jsonable)this.asJSon();
        if (indent > 0) {
            return Jsoner.prettyPrint((String)jo.toJson(), (int)indent);
        }
        return Jsoner.prettyPrint((String)jo.toJson());
    }

    public Map<String, Object> asJSon() {
        JsonObject jo = new JsonObject();
        jo.put((Object)"uid", (Object)this.uid);
        jo.put((Object)"first", (Object)this.first);
        jo.put((Object)"last", (Object)this.last);
        jo.put((Object)"rest", (Object)this.rest);
        jo.put((Object)"template", (Object)this.template);
        if (this.location != null) {
            jo.put((Object)"location", (Object)this.location);
        }
        if (this.endpointUri != null) {
            jo.put((Object)"endpointUri", (Object)this.endpointUri);
            jo.put((Object)"remoteEndpoint", (Object)this.remoteEndpoint);
        }
        if (this.routeId != null) {
            jo.put((Object)"routeId", (Object)this.routeId);
        }
        if (this.toNode != null) {
            jo.put((Object)"nodeId", (Object)this.toNode);
        }
        if (this.toNodeParentId != null) {
            jo.put((Object)"nodeParentId", (Object)this.toNodeParentId);
        }
        if (this.toNodeParentWhenId != null) {
            jo.put((Object)"nodeParentWhenId", (Object)this.toNodeParentWhenId);
        }
        if (this.toNodeParentWhenLabel != null) {
            jo.put((Object)"nodeParentWhenLabel", (Object)this.toNodeParentWhenLabel);
        }
        if (this.toNodeShortName != null) {
            jo.put((Object)"nodeShortName", (Object)this.toNodeShortName);
        }
        if (this.toNodeLabel != null) {
            jo.put((Object)"nodeLabel", (Object)Jsoner.escape((String)this.toNodeLabel));
        }
        jo.put((Object)"nodeLevel", (Object)this.toNodeLevel);
        if (this.exchangeId != null) {
            jo.put((Object)"exchangeId", (Object)this.exchangeId);
        }
        if (this.correlationExchangeId != null) {
            jo.put((Object)"correlationExchangeId", (Object)this.correlationExchangeId);
        }
        if (this.timestamp > 0L) {
            jo.put((Object)"timestamp", (Object)this.timestamp);
        }
        jo.put((Object)"elapsed", (Object)this.getElapsed());
        jo.put((Object)"threadName", (Object)this.getProcessingThreadName());
        jo.put((Object)"done", (Object)this.isDone());
        jo.put((Object)"failed", (Object)this.isFailed());
        if (this.endpointServiceUrl != null) {
            JsonObject es = new JsonObject();
            es.put((Object)"serviceUrl", (Object)this.endpointServiceUrl);
            if (this.endpointServiceProtocol != null) {
                es.put((Object)"serviceProtocol", (Object)this.endpointServiceProtocol);
            }
            if (this.endpointServiceMetadata != null) {
                es.put((Object)"serviceMetadata", this.endpointServiceMetadata);
            }
            jo.put((Object)"endpointService", (Object)es);
        }
        jo.put((Object)"message", (Object)this.data.getMap("message"));
        if (this.exception != null) {
            if (this.exceptionAsJsonObject == null) {
                try {
                    this.exceptionAsJsonObject = MessageHelper.dumpExceptionAsJSonObject((Throwable)this.exception);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.exceptionAsJsonObject != null) {
                jo.put((Object)"exception", this.exceptionAsJsonObject.get((Object)"exception"));
            }
        }
        return jo;
    }
}

