/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsonable;
import org.apache.camel.util.json.Jsoner;

public final class DefaultBacklogTracerEventMessage
implements BacklogTracerEventMessage {
    private final long uid;
    private final long timestamp;
    private final String routeId;
    private final String toNode;
    private final String exchangeId;
    private final boolean rest;
    private final boolean template;
    private final String messageAsXml;
    private final String messageAsJSon;

    public DefaultBacklogTracerEventMessage(long uid, long timestamp, String routeId, String toNode, String exchangeId, boolean rest, boolean template, String messageAsXml, String messageAsJSon) {
        this.uid = uid;
        this.timestamp = timestamp;
        this.routeId = routeId;
        this.toNode = toNode;
        this.exchangeId = exchangeId;
        this.rest = rest;
        this.template = template;
        this.messageAsXml = messageAsXml;
        this.messageAsJSon = messageAsJSon;
    }

    public long getUid() {
        return this.uid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public boolean isRest() {
        return this.rest;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public String getToNode() {
        return this.toNode;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getMessageAsXml() {
        return this.messageAsXml;
    }

    public String getMessageAsJSon() {
        return this.messageAsJSon;
    }

    public String toString() {
        return "DefaultBacklogTracerEventMessage[" + this.exchangeId + " at " + this.toNode + "]";
    }

    public String toXml(int indent) {
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            prefix.append(" ");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)prefix).append("<").append("backlogTracerEventMessage").append(">\n");
        sb.append((CharSequence)prefix).append("  <uid>").append(this.uid).append("</uid>\n");
        sb.append((CharSequence)prefix).append("  <rest>").append(this.rest).append("</rest>\n");
        sb.append((CharSequence)prefix).append("  <template>").append(this.template).append("</template>\n");
        String ts = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.timestamp);
        sb.append((CharSequence)prefix).append("  <timestamp>").append(ts).append("</timestamp>\n");
        sb.append((CharSequence)prefix).append("  <routeId>").append(this.routeId != null ? this.routeId : "").append("</routeId>\n");
        if (this.toNode != null) {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.toNode).append("</toNode>\n");
        } else {
            sb.append((CharSequence)prefix).append("  <toNode>").append(this.routeId).append("</toNode>\n");
        }
        sb.append((CharSequence)prefix).append("  <exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        sb.append((CharSequence)prefix).append(this.messageAsXml).append("\n");
        sb.append((CharSequence)prefix).append("</").append("backlogTracerEventMessage").append(">");
        return sb.toString();
    }

    public String toJSon(int indent) {
        Jsonable jo = (Jsonable)this.asJSon();
        if (indent > 0) {
            return Jsoner.prettyPrint((String)jo.toJson(), (int)indent);
        }
        return Jsoner.prettyPrint((String)jo.toJson());
    }

    public Map<String, Object> asJSon() {
        JsonObject jo = new JsonObject();
        jo.put((Object)"uid", (Object)this.uid);
        jo.put((Object)"rest", (Object)this.rest);
        jo.put((Object)"template", (Object)this.template);
        if (this.routeId != null) {
            jo.put((Object)"routeId", (Object)this.routeId);
        }
        if (this.toNode != null) {
            jo.put((Object)"nodeId", (Object)this.toNode);
        }
        if (this.timestamp > 0L) {
            jo.put((Object)"timestamp", (Object)this.timestamp);
        }
        try {
            JsonObject msg = (JsonObject)Jsoner.deserialize((String)this.messageAsJSon);
            jo.put((Object)"message", msg.get((Object)"message"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jo;
    }
}

