/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.iam;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.CreateUserResult;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserResult;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysResult;
import com.amazonaws.services.identitymanagement.model.ListUsersResult;
import com.amazonaws.services.identitymanagement.model.StatusType;
import com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.UpdateAccessKeyResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.common.AwsExchangeUtil;
import org.apache.camel.component.aws.iam.IAMConfiguration;
import org.apache.camel.component.aws.iam.IAMEndpoint;
import org.apache.camel.component.aws.iam.IAMOperations;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IAMProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(IAMProducer.class);
    private transient String iamProducerToString;

    public IAMProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listAccessKeys: {
                this.listAccessKeys(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createAccessKey: {
                this.createAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteAccessKey: {
                this.deleteAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case updateAccessKey: {
                this.updateAccessKey(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case createUser: {
                this.createUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case deleteUser: {
                this.deleteUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case getUser: {
                this.getUser(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            case listUsers: {
                this.listUsers(this.getEndpoint().getIamClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private IAMOperations determineOperation(Exchange exchange) {
        IAMOperations operation = (IAMOperations)((Object)exchange.getIn().getHeader("CamelAwsIAMOperation", IAMOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected IAMConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.iamProducerToString == null) {
            this.iamProducerToString = "IAMProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.iamProducerToString;
    }

    public IAMEndpoint getEndpoint() {
        return (IAMEndpoint)super.getEndpoint();
    }

    private void listAccessKeys(AmazonIdentityManagement iamClient, Exchange exchange) {
        ListAccessKeysResult result;
        try {
            result = iamClient.listAccessKeys();
        }
        catch (AmazonServiceException ase) {
            LOG.trace("List Access Keys command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createUser(AmazonIdentityManagement iamClient, Exchange exchange) {
        CreateUserResult result;
        CreateUserRequest request = new CreateUserRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.createUser(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Create user command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteUser(AmazonIdentityManagement iamClient, Exchange exchange) {
        DeleteUserResult result;
        DeleteUserRequest request = new DeleteUserRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.deleteUser(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Delete user command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void getUser(AmazonIdentityManagement iamClient, Exchange exchange) {
        GetUserResult result;
        GetUserRequest request = new GetUserRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.getUser(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("get user command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void listUsers(AmazonIdentityManagement iamClient, Exchange exchange) {
        ListUsersResult result;
        try {
            result = iamClient.listUsers();
        }
        catch (AmazonServiceException ase) {
            LOG.trace("List users command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createAccessKey(AmazonIdentityManagement iamClient, Exchange exchange) {
        CreateAccessKeyResult result;
        CreateAccessKeyRequest request = new CreateAccessKeyRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.createAccessKey(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Create Access Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteAccessKey(AmazonIdentityManagement iamClient, Exchange exchange) {
        DeleteAccessKeyResult result;
        DeleteAccessKeyRequest request = new DeleteAccessKeyRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String accessKeyId = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID", String.class);
        request.withAccessKeyId(accessKeyId);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.deleteAccessKey(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Delete Access Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateAccessKey(AmazonIdentityManagement iamClient, Exchange exchange) {
        UpdateAccessKeyResult result;
        UpdateAccessKeyRequest request = new UpdateAccessKeyRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID"))) {
            throw new IllegalArgumentException("Key Id must be specified");
        }
        String accessKeyId = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyID", String.class);
        request.withAccessKeyId(accessKeyId);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMAccessKeyStatus"))) {
            throw new IllegalArgumentException("Access Key status must be specified");
        }
        String status = (String)exchange.getIn().getHeader("CamelAwsIAMAccessKeyStatus", String.class);
        request.withStatus(StatusType.fromValue((String)status));
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsIAMUsername"))) {
            String userName = (String)exchange.getIn().getHeader("CamelAwsIAMUsername", String.class);
            request.withUserName(userName);
        }
        try {
            result = iamClient.updateAccessKey(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Update Access Key command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = AwsExchangeUtil.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }
}

