/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.Arrays;
import java.util.Collection;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.Resource;

public interface RoutesLoader
extends CamelContextAware {
    public static final String FACTORY = "routes-loader";

    default public void loadRoutes(Collection<Resource> resources) throws Exception {
        Collection<RoutesBuilder> builders = this.findRoutesBuilders(resources);
        for (RoutesBuilder builder : builders) {
            if (!(builder instanceof RouteConfigurationsBuilder)) continue;
            this.getCamelContext().addRoutesConfigurations((RouteConfigurationsBuilder)((Object)builder));
        }
        for (RoutesBuilder builder : builders) {
            this.getCamelContext().addRoutes(builder);
        }
    }

    default public void loadRoutes(Resource ... resources) throws Exception {
        Collection<RoutesBuilder> builders = this.findRoutesBuilders(resources);
        for (RoutesBuilder builder : builders) {
            if (!(builder instanceof RouteConfigurationsBuilder)) continue;
            this.getCamelContext().addRoutesConfigurations((RouteConfigurationsBuilder)((Object)builder));
        }
        for (RoutesBuilder builder : builders) {
            this.getCamelContext().addRoutes(builder);
        }
    }

    default public Collection<RoutesBuilder> findRoutesBuilders(Resource ... resources) throws Exception {
        return this.findRoutesBuilders(Arrays.asList(resources));
    }

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> var1) throws Exception;
}

