/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.camel.spi.annotations.ConstantProvider;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;
import org.apache.camel.tools.apt.AnnotationProcessorHelper;
import org.apache.camel.tools.apt.helper.IOHelper;
import org.apache.camel.tools.apt.helper.Strings;

@SupportedAnnotationTypes(value={"org.apache.camel.spi.annotations.ConstantProvider"})
public class ConstantProviderProcessor
extends AbstractCamelAnnotationProcessor {
    boolean acceptClass(Element element) {
        return true;
    }

    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        TypeElement constantAnnotationType = this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.spi.annotations.ConstantProvider");
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(constantAnnotationType);
        TreeMap<String, Element> constantClasses = new TreeMap<String, Element>();
        for (Element element : elements) {
            TypeElement te;
            if (!(element instanceof TypeElement) || (te = (TypeElement)element).getNestingKind().isNested() || !this.acceptClass(te)) continue;
            String javaTypeName = Strings.canonicalClassName(te.getQualifiedName().toString());
            constantClasses.put(javaTypeName, element);
        }
        constantClasses.forEach((k, v) -> {
            String fqn = v.getAnnotation(ConstantProvider.class).value();
            TreeMap<String, String> fields = new TreeMap<String, String>(String::compareToIgnoreCase);
            HashSet<? extends Element> set = new HashSet<Element>(v.getEnclosedElements());
            for (VariableElement field : ElementFilter.fieldsIn(set)) {
                TypeMirror fieldType = field.asType();
                String fullTypeClassName = fieldType.toString();
                if (!String.class.getName().equals(fullTypeClassName)) continue;
                String name = field.getSimpleName().toString();
                String text = (String)field.getConstantValue();
                fields.put(name, text);
                AnnotationProcessorHelper.dumpExceptionToErrorFile("camel-apt-error.log", "Name: " + field.getSimpleName().toString() + "=" + text, null);
            }
            if (!fields.isEmpty()) {
                this.generateConstantProviderClass(fqn, fields);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConstantProviderClass(String fqn, Map<String, String> fields) {
        String pn = fqn.substring(0, fqn.lastIndexOf(46));
        String cn = fqn.substring(fqn.lastIndexOf(46) + 1);
        Writer w = null;
        try {
            JavaFileObject src = this.processingEnv.getFiler().createSourceFile(fqn, new Element[0]);
            w = src.openWriter();
            w.write("/* Generated by org.apache.camel:apt */\n");
            w.write("package " + pn + ";\n");
            w.write("\n");
            w.write("import java.util.HashMap;\n");
            w.write("import java.util.Map;\n");
            w.write("\n");
            w.write("/**\n");
            w.write(" * Source code generated by org.apache.camel:apt\n");
            w.write(" */\n");
            w.write("public class " + cn + " {\n");
            w.write("\n");
            w.write("    private static final Map<String, String> MAP;\n");
            w.write("    static {\n");
            w.write("        Map<String, String> map = new HashMap<>(" + fields.size() + ");\n");
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                w.write("        map.put(\"" + entry.getKey() + "\", \"" + entry.getValue() + "\");\n");
            }
            w.write("        MAP = map;\n");
            w.write("    }\n");
            w.write("\n");
            w.write("    public static String lookup(String key) {\n");
            w.write("        return MAP.get(key);\n");
            w.write("    }\n");
            w.write("}\n");
            w.write("\n");
        }
        catch (Exception e) {
            try {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to generate source code file: " + fqn + ": " + e.getMessage());
                AnnotationProcessorHelper.dumpExceptionToErrorFile("camel-apt-error.log", "Unable to generate source code file: " + fqn, e);
            }
            catch (Throwable throwable) {
                IOHelper.close(w);
                throw throwable;
            }
            IOHelper.close(w);
        }
        IOHelper.close(w);
    }
}

