/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.tools.apt.AnnotationProcessorHelper;
import org.apache.camel.tools.apt.CoreEipAnnotationProcessor;
import org.apache.camel.tools.apt.SpringAnnotationProcessor;
import org.apache.camel.tools.apt.helper.Strings;

@SupportedAnnotationTypes(value={"javax.xml.bind.annotation.*", "org.apache.camel.spi.Label"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ModelAnnotationProcessor
extends AbstractProcessor {
    private CoreEipAnnotationProcessor coreProcessor = new CoreEipAnnotationProcessor();
    private SpringAnnotationProcessor springProcessor = new SpringAnnotationProcessor();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                return true;
            }
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(XmlRootElement.class);
            for (Element element : elements) {
                boolean spring;
                if (!(element instanceof TypeElement)) continue;
                TypeElement classElement = (TypeElement)element;
                String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
                boolean core = javaTypeName.startsWith("org.apache.camel.model");
                boolean bl = spring = javaTypeName.startsWith("org.apache.camel.spring") || javaTypeName.startsWith("org.apache.camel.core.xml");
                if (core) {
                    this.coreProcessor.processModelClass(this.processingEnv, roundEnv, classElement);
                    continue;
                }
                if (!spring) continue;
                this.springProcessor.processModelClass(this.processingEnv, roundEnv, classElement);
            }
        }
        catch (Throwable e) {
            AnnotationProcessorHelper.dumpExceptionToErrorFile("camel-apt-error.log", "Error processing", e);
        }
        return true;
    }
}

