/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.util.List;
import java.util.function.Function;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.RelMetadataFixture;
import org.apache.calcite.test.RelOptFixture;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;

interface RelSupplier {
    public static final RelSupplier NONE = new RelSupplier(){

        @Override
        public RelNode apply(RelOptFixture fixture) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelNode apply2(RelMetadataFixture metadataFixture) {
            throw new UnsupportedOperationException();
        }
    };
    public static final FrameworkConfig FRAMEWORK_CONFIG = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(CalciteAssert.addSchema(Frameworks.createRootSchema((boolean)true), CalciteAssert.SchemaSpec.SCOTT_WITH_TEMPORAL)).traitDefs((List)null).programs(new Program[]{Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)true, (int)2)}).build();

    public RelNode apply(RelOptFixture var1);

    public RelNode apply2(RelMetadataFixture var1);

    public static RelSupplier of(String sql) {
        if (sql.contains(" \n")) {
            throw new AssertionError((Object)"trailing whitespace");
        }
        return new SqlRelSupplier(sql);
    }

    public static RelSupplier of(Function<RelBuilder, RelNode> relFn) {
        return new FnRelSupplier(relFn);
    }

    public static class FnRelSupplier
    implements RelSupplier {
        private final Function<RelBuilder, RelNode> relFn;

        private FnRelSupplier(Function<RelBuilder, RelNode> relFn) {
            this.relFn = relFn;
        }

        public String toString() {
            return "<relFn>";
        }

        public int hashCode() {
            return this.relFn.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FnRelSupplier && ((FnRelSupplier)o).relFn == this.relFn;
        }

        @Override
        public RelNode apply(RelOptFixture fixture) {
            return this.relFn.apply(RelBuilder.create((FrameworkConfig)FRAMEWORK_CONFIG));
        }

        @Override
        public RelNode apply2(RelMetadataFixture metadataFixture) {
            return this.relFn.apply(RelBuilder.create((FrameworkConfig)FRAMEWORK_CONFIG));
        }
    }

    public static class SqlRelSupplier
    implements RelSupplier {
        private final String sql;

        private SqlRelSupplier(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof SqlRelSupplier && ((SqlRelSupplier)o).sql.equals(this.sql);
        }

        public int hashCode() {
            return 3709 + this.sql.hashCode();
        }

        @Override
        public RelNode apply(RelOptFixture fixture) {
            String sql2 = fixture.diffRepos().expand("sql", this.sql);
            return fixture.tester.convertSqlToRel((SqlTestFactory)fixture.factory, (String)sql2, (boolean)fixture.decorrelate, (boolean)fixture.factory.sqlToRelConfig.isTrimUnusedFields()).rel;
        }

        @Override
        public RelNode apply2(RelMetadataFixture metadataFixture) {
            return metadataFixture.sqlToRel(this.sql);
        }
    }
}

