/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserListFixture;
import org.apache.calcite.sql.parser.SqlParserTest;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;

public class SqlParserFixture {
    public static final SqlTestFactory FACTORY = SqlTestFactory.INSTANCE.withParserConfig(c -> c.withQuoting(Quoting.DOUBLE_QUOTE).withUnquotedCasing(Casing.TO_UPPER).withQuotedCasing(Casing.UNCHANGED).withConformance((SqlConformance)SqlConformanceEnum.DEFAULT));
    public static final SqlParserFixture DEFAULT = new SqlParserFixture(FACTORY, StringAndPos.of((String)"?"), false, SqlParserTest.TesterImpl.DEFAULT, null, true, parser -> {});
    public final SqlTestFactory factory;
    public final StringAndPos sap;
    public final boolean expression;
    public final SqlParserTest.Tester tester;
    public final boolean convertToLinux;
    public final @Nullable SqlDialect dialect;
    public final Consumer<SqlParser> parserChecker;

    SqlParserFixture(SqlTestFactory factory, StringAndPos sap, boolean expression, SqlParserTest.Tester tester, @Nullable SqlDialect dialect, boolean convertToLinux, Consumer<SqlParser> parserChecker) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.sap = Objects.requireNonNull(sap, "sap");
        this.expression = expression;
        this.tester = Objects.requireNonNull(tester, "tester");
        this.dialect = dialect;
        this.convertToLinux = convertToLinux;
        this.parserChecker = Objects.requireNonNull(parserChecker, "parserChecker");
    }

    public SqlParserFixture same() {
        return this.ok(this.sap.sql);
    }

    public SqlParserFixture ok(String expected) {
        UnaryOperator<String> converter = SqlParserTest.linux(this.convertToLinux);
        if (this.expression) {
            this.tester.checkExp(this.factory, this.sap, converter, expected, this.parserChecker);
        } else {
            this.tester.check(this.factory, this.sap, this.dialect, converter, expected, this.parserChecker);
        }
        return this;
    }

    public SqlParserFixture fails(String expectedMsgPattern) {
        if (this.expression) {
            this.tester.checkExpFails(this.factory, this.sap, expectedMsgPattern);
        } else {
            this.tester.checkFails(this.factory, this.sap, false, expectedMsgPattern);
        }
        return this;
    }

    public SqlParserFixture hasWarning(Consumer<List<? extends Throwable>> messageMatcher) {
        Consumer<SqlParser> parserConsumer = parser -> messageMatcher.accept(parser.getWarnings());
        return new SqlParserFixture(this.factory, this.sap, this.expression, this.tester, this.dialect, this.convertToLinux, parserConsumer);
    }

    public SqlParserFixture node(Matcher<SqlNode> matcher) {
        this.tester.checkNode(this.factory, this.sap, matcher);
        return this;
    }

    public SqlParserFixture sql(String sql) {
        if (sql.equals(this.sap.addCarets())) {
            return this;
        }
        StringAndPos sap = StringAndPos.of((String)sql);
        return new SqlParserFixture(this.factory, sap, this.expression, this.tester, this.dialect, this.convertToLinux, this.parserChecker);
    }

    public SqlParserFixture expression() {
        return this.expression(true);
    }

    public SqlParserFixture expression(boolean expression) {
        if (this.expression == expression) {
            return this;
        }
        return new SqlParserFixture(this.factory, this.sap, expression, this.tester, this.dialect, this.convertToLinux, this.parserChecker);
    }

    protected SqlParserListFixture list() {
        return new SqlParserListFixture(this.factory, this.tester, this.dialect, this.convertToLinux, this.sap);
    }

    public SqlParserFixture withDialect(SqlDialect dialect) {
        if (dialect == this.dialect) {
            return this;
        }
        SqlTestFactory factory = this.factory.withParserConfig(arg_0 -> ((SqlDialect)dialect).configureParser(arg_0));
        return new SqlParserFixture(factory, this.sap, this.expression, this.tester, dialect, this.convertToLinux, this.parserChecker);
    }

    public SqlParserFixture withFactory(UnaryOperator<SqlTestFactory> transform) {
        SqlTestFactory factory = (SqlTestFactory)transform.apply(this.factory);
        if (factory == this.factory) {
            return this;
        }
        return new SqlParserFixture(factory, this.sap, this.expression, this.tester, this.dialect, this.convertToLinux, this.parserChecker);
    }

    public SqlParserFixture withConfig(UnaryOperator<SqlParser.Config> transform) {
        return this.withFactory(f -> f.withParserConfig(transform));
    }

    public SqlParserFixture withConformance(SqlConformance conformance) {
        return this.withConfig(c -> c.withConformance(conformance));
    }

    public SqlParserFixture withTester(SqlParserTest.Tester tester) {
        if (tester == this.tester) {
            return this;
        }
        return new SqlParserFixture(this.factory, this.sap, this.expression, tester, this.dialect, this.convertToLinux, this.parserChecker);
    }

    public SqlParserFixture withConvertToLinux(boolean convertToLinux) {
        if (convertToLinux == this.convertToLinux) {
            return this;
        }
        return new SqlParserFixture(this.factory, this.sap, this.expression, this.tester, this.dialect, convertToLinux, this.parserChecker);
    }

    public SqlParser parser() {
        return this.factory.createParser(this.sap.addCarets());
    }

    public SqlNode node() {
        return ((SqlParserTest.TesterImpl)this.tester).parseStmtAndHandleEx(this.factory, this.sap.addCarets(), parser -> {});
    }

    public SqlNodeList nodeList() {
        return ((SqlParserTest.TesterImpl)this.tester).parseStmtsAndHandleEx(this.factory, this.sap.addCarets());
    }
}

