/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.chain;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.locator.BeanLocator;

public abstract class Chain<T> {
    @Inject
    @BatchProperty
    @Documentation(value="The locator to use to create chain components")
    protected String locator;
    @Inject
    @BatchProperty
    @Documentation(value="The list of components of the chain")
    protected String chain;
    @Inject
    @BatchProperty
    @Documentation(value="The separator to use in chain string (default to ',')")
    protected String separator;
    @Inject
    @BatchProperty
    @Documentation(value="Should release phase of the lifecycle be called (default to false), use true for @Dependent beans.")
    protected String forceRelease;
    private Collection<BeanLocator.LocatorInstance<T>> runtimeChain = new ArrayList<BeanLocator.LocatorInstance<T>>();

    public Object runChain(Object item) throws Exception {
        if (this.chain == null) {
            return item;
        }
        if (this.separator == null) {
            this.separator = ",";
        }
        if (this.runtimeChain.isEmpty()) {
            BeanLocator beanLocator = this.getBeanLocator();
            Class<T> type = this.findType();
            for (String next : this.chain.split(this.separator)) {
                this.runtimeChain.add(beanLocator.newInstance(type, next));
            }
        }
        Object current = item;
        for (BeanLocator.LocatorInstance<T> next : this.runtimeChain) {
            current = this.invoke(next, current);
        }
        if (Boolean.parseBoolean(this.forceRelease)) {
            for (BeanLocator.LocatorInstance<T> next : this.runtimeChain) {
                next.release();
            }
            this.runtimeChain.clear();
        }
        return current;
    }

    protected BeanLocator getBeanLocator() {
        return BeanLocator.Finder.get(this.locator);
    }

    protected Class<T> findType() {
        return (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(this.getClass().getGenericSuperclass())).getActualTypeArguments()[0]);
    }

    protected abstract Object invoke(BeanLocator.LocatorInstance<T> var1, Object var2) throws Exception;
}

