/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.WSDL20Util;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.neethi.Policy;

public class AxisBindingMessage
extends AxisDescription {
    private String name;
    private String direction;
    private Map options = new HashMap();
    private AxisMessage axisMessage;
    private boolean fault = false;
    private Policy effectivePolicy = null;
    private Date lastPolicyCalcuatedTime = null;

    public boolean isFault() {
        return this.fault;
    }

    public void setFault(boolean fault) {
        this.fault = fault;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AxisMessage getAxisMessage() {
        return this.axisMessage;
    }

    public void setAxisMessage(AxisMessage axisMessage) {
        this.axisMessage = axisMessage;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void setProperty(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getProperty(String name) {
        Object obj = this.options.get(name);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public Object getKey() {
        return null;
    }

    public void engageModule(AxisModule axisModule) throws AxisFault {
        throw new UnsupportedOperationException("Sorry we do not support this");
    }

    public boolean isEngaged(String moduleName) {
        throw new UnsupportedOperationException("axisMessage.isEngaged() is not supported");
    }

    public OMElement toWSDL20(OMNamespace wsdl, OMNamespace tns, OMNamespace wsoap, OMNamespace whttp, Map nameSpaceMap) {
        ArrayList list;
        OMElement bindingMessageElement;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        if (this.isFault()) {
            bindingMessageElement = this.getParent() instanceof AxisBinding ? omFactory.createOMElement("fault", wsdl) : ("in".equals(this.getDirection()) ? omFactory.createOMElement("infault", wsdl) : omFactory.createOMElement("outfault", wsdl));
            bindingMessageElement.addAttribute(omFactory.createOMAttribute("ref", null, tns.getPrefix() + ":" + this.name));
            WSDL20Util.extractWSDL20SoapFaultInfo(this.options, bindingMessageElement, omFactory, wsoap);
            Integer code = (Integer)this.options.get("whttp:code");
            if (code != null) {
                bindingMessageElement.addAttribute(omFactory.createOMAttribute("code", whttp, code.toString()));
            }
        } else {
            bindingMessageElement = "in".equals(this.getDirection()) ? omFactory.createOMElement("input", wsdl) : omFactory.createOMElement("output", wsdl);
        }
        String property = (String)this.options.get("whttp:contentEncoding");
        if (property != null) {
            bindingMessageElement.addAttribute(omFactory.createOMAttribute("contentEncoding", whttp, property));
        }
        if ((list = (ArrayList)this.options.get("whttp:header")) != null && list.size() > 0) {
            WSDLSerializationUtil.addHTTPHeaderElements(omFactory, list, whttp, bindingMessageElement, nameSpaceMap);
        }
        if ((list = (ArrayList)this.options.get("wsoap:header")) != null && list.size() > 0) {
            WSDLSerializationUtil.addSOAPHeaderElements(omFactory, list, wsoap, bindingMessageElement, nameSpaceMap);
        }
        if ((list = (ArrayList)this.options.get("wsoap:module")) != null && list.size() > 0) {
            WSDLSerializationUtil.addSOAPModuleElements(omFactory, list, wsoap, bindingMessageElement);
        }
        WSDLSerializationUtil.addWSDLDocumentationElement(this, bindingMessageElement, omFactory, wsdl);
        WSDLSerializationUtil.addPoliciesAsExtensibleElement(this, bindingMessageElement);
        return bindingMessageElement;
    }

    public AxisBindingOperation getAxisBindingOperation() {
        return (AxisBindingOperation)this.parent;
    }

    public Policy getEffectivePolicy() {
        if (this.lastPolicyCalcuatedTime == null || this.isPolicyUpdated()) {
            this.effectivePolicy = this.calculateEffectivePolicy();
        }
        return this.effectivePolicy;
    }

    public Policy calculateEffectivePolicy() {
        AxisConfiguration axisConfiguration;
        AxisService axisService;
        AxisOperation axisOperation;
        AxisEndpoint axisEndpoint;
        AxisBinding axisBinding;
        PolicySubject policySubject = null;
        ArrayList policyList = new ArrayList();
        policySubject = this.getPolicySubject();
        policyList.addAll(policySubject.getAttachedPolicyComponents());
        AxisBindingOperation axisBindingOperation = this.getAxisBindingOperation();
        if (axisBindingOperation != null) {
            policyList.addAll(axisBindingOperation.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisBinding axisBinding2 = axisBinding = axisBindingOperation == null ? null : axisBindingOperation.getAxisBinding();
        if (axisBinding != null) {
            policyList.addAll(axisBinding.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisEndpoint axisEndpoint2 = axisEndpoint = axisBinding == null ? null : axisBinding.getAxisEndpoint();
        if (axisEndpoint != null) {
            policyList.addAll(axisEndpoint.getPolicySubject().getAttachedPolicyComponents());
        }
        if (this.axisMessage != null) {
            policyList.addAll(this.axisMessage.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisOperation axisOperation2 = axisOperation = this.axisMessage == null ? null : this.axisMessage.getAxisOperation();
        if (axisOperation != null) {
            policyList.addAll(axisOperation.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisService axisService2 = axisService = axisOperation == null ? null : axisOperation.getAxisService();
        if (axisService != null) {
            policyList.addAll(axisService.getPolicySubject().getAttachedPolicyComponents());
        }
        AxisConfiguration axisConfiguration2 = axisConfiguration = axisService == null ? null : axisService.getAxisConfiguration();
        if (axisConfiguration != null) {
            policyList.addAll(axisConfiguration.getPolicySubject().getAttachedPolicyComponents());
        }
        return PolicyUtil.getMergedPolicy(policyList, axisService);
    }

    private boolean isPolicyUpdated() {
        AxisConfiguration axisConfiguration;
        AxisService axisService;
        AxisOperation axisOperation;
        AxisEndpoint axisEndpoint;
        AxisBinding axisBinding;
        if (this.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime)) {
            return true;
        }
        AxisBindingOperation axisBindingOperation = this.getAxisBindingOperation();
        if (axisBindingOperation != null && axisBindingOperation.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime)) {
            return true;
        }
        AxisBinding axisBinding2 = axisBinding = axisBindingOperation == null ? null : axisBindingOperation.getAxisBinding();
        if (axisBinding != null && axisBinding.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime)) {
            return true;
        }
        AxisEndpoint axisEndpoint2 = axisEndpoint = axisBinding == null ? null : axisBinding.getAxisEndpoint();
        if (axisEndpoint != null && axisEndpoint.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime)) {
            return true;
        }
        if (this.axisMessage != null && this.axisMessage.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime)) {
            return true;
        }
        AxisOperation axisOperation2 = axisOperation = this.axisMessage == null ? null : this.axisMessage.getAxisOperation();
        if (axisOperation != null && axisOperation.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime)) {
            return true;
        }
        AxisService axisService2 = axisService = axisOperation == null ? null : axisOperation.getAxisService();
        if (axisService != null && axisService.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime)) {
            return true;
        }
        AxisConfiguration axisConfiguration2 = axisConfiguration = axisService == null ? null : axisService.getAxisConfiguration();
        return axisConfiguration != null && axisConfiguration.getPolicySubject().getLastUpdatedTime().after(this.lastPolicyCalcuatedTime);
    }
}

