/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.schema.typemap.JavaTypeMap;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.CTypeMapper;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUtility {
    public static void invoke(CodeGenConfiguration configuration) throws Exception {
        ArrayList<XmlSchema> schemaList = new ArrayList<XmlSchema>();
        for (AxisService service : configuration.getAxisServices()) {
            schemaList.addAll(service.getSchema());
        }
        HashMap<String, XmlSchema> schemaMap = new HashMap<String, XmlSchema>();
        ExtensionUtility.populateSchemaMap(schemaMap, schemaList);
        if (schemaList == null || schemaList.isEmpty()) {
            configuration.setTypeMapper((TypeMapper)new DefaultTypeMapper());
            return;
        }
        CompilerOptions options = new CompilerOptions();
        ExtensionUtility.populateDefaultOptions(options, configuration);
        ExtensionUtility.populateUserparameters(options, configuration);
        SchemaCompiler schemaCompiler = new SchemaCompiler(options);
        schemaCompiler.compile(schemaList);
        Object mapper = configuration.getTypeMapper();
        if (mapper == null) {
            mapper = configuration.getOutputLanguage() != null && !configuration.getOutputLanguage().trim().equals("") && configuration.getOutputLanguage().toLowerCase().equals("c") ? new CTypeMapper() : new JavaTypeMapper();
        }
        if (options.isWriteOutput()) {
            for (Map.Entry<QName, String> entry : schemaCompiler.getProcessedElementMap().entrySet()) {
                mapper.addTypeMappingName(entry.getKey(), entry.getValue());
            }
        } else {
            Map processedModelMap = schemaCompiler.getProcessedModelMap();
            for (QName qNameKey : processedModelMap.keySet()) {
                mapper.addTypeMappingObject(qNameKey, processedModelMap.get(qNameKey));
            }
            for (Map.Entry<QName, String> entry : schemaCompiler.getProcessedElementMap().entrySet()) {
                mapper.addTypeMappingName(entry.getKey(), entry.getValue());
            }
            configuration.putProperty((Object)"externalTemplate", (Object)schemaCompiler.getCompilerProperties().getProperty("schema.bean.writer.template"));
        }
        Map<String, XmlSchema> loadedSchemaMap = schemaCompiler.getLoadedSchemaMap();
        for (AxisService service : configuration.getAxisServices()) {
            ArrayList serviceSchemaList = service.getSchema();
            ArrayList<XmlSchema> schemaListToAdd = new ArrayList<XmlSchema>();
            for (XmlSchema xmlSchema : serviceSchemaList) {
                if (loadedSchemaMap.containsKey(xmlSchema.getTargetNamespace())) {
                    schemaListToAdd.add(loadedSchemaMap.get(xmlSchema.getTargetNamespace()));
                    continue;
                }
                schemaListToAdd.add(xmlSchema);
            }
            service.releaseSchemaList();
            service.addSchema(schemaListToAdd);
        }
        if (!configuration.isParametersWrapped()) {
            for (AxisService axisService : configuration.getAxisServices()) {
                Iterator operations = axisService.getOperations();
                while (operations.hasNext()) {
                    AxisOperation op = (AxisOperation)operations.next();
                    if (WSDLUtil.isInputPresentForMEP((String)op.getMessageExchangePattern())) {
                        ExtensionUtility.walkSchema(op.getMessage("In"), mapper, schemaMap, op.getName().getLocalPart(), "_input");
                    }
                    if (!configuration.getDatabindingType().equals("adb") || !WSDLUtil.isOutputPresentForMEP((String)op.getMessageExchangePattern())) continue;
                    ExtensionUtility.walkSchema(op.getMessage("Out"), mapper, schemaMap, op.getName().getLocalPart(), "_output");
                }
            }
        }
        if (!configuration.isParametersWrapped() || configuration.isBackwordCompatibilityMode()) {
            for (AxisService axisService : configuration.getAxisServices()) {
                Iterator operators = axisService.getOperations();
                while (operators.hasNext()) {
                    AxisMessage axisMessage;
                    AxisOperation axisOperation = (AxisOperation)operators.next();
                    if (WSDLUtil.isInputPresentForMEP((String)axisOperation.getMessageExchangePattern())) {
                        axisMessage = axisOperation.getMessage("In");
                        ExtensionUtility.setComplexTypeName(axisMessage);
                    }
                    if (!WSDLUtil.isOutputPresentForMEP((String)axisOperation.getMessageExchangePattern())) continue;
                    axisMessage = axisOperation.getMessage("Out");
                    ExtensionUtility.setComplexTypeName(axisMessage);
                }
            }
        }
        configuration.setTypeMapper(mapper);
    }

    private static void setComplexTypeName(AxisMessage axisMessage) throws AxisFault {
        if (axisMessage.getSchemaElement() != null) {
            XmlSchemaComplexType complexType;
            XmlSchemaElement schemaElement = axisMessage.getSchemaElement();
            XmlSchemaType schemaType = schemaElement.getSchemaType();
            QName schemaTypeQname = schemaElement.getSchemaTypeName();
            if (schemaType == null && schemaTypeQname != null) {
                XmlSchema schema;
                AxisService axisService = axisMessage.getAxisOperation().getAxisService();
                Iterator iterator = axisService.getSchema().iterator();
                while (iterator.hasNext() && (schemaType = ExtensionUtility.getSchemaType(schema = (XmlSchema)iterator.next(), schemaTypeQname)) == null) {
                }
            }
            if (schemaType instanceof XmlSchemaComplexType && (complexType = (XmlSchemaComplexType)schemaType).getName() != null && complexType.getQName() != null) {
                Map metaInfo = complexType.getMetaInfoMap();
                String complexTypeName = (String)metaInfo.get("CLASS_NAME");
                if (complexTypeName.endsWith("[]")) {
                    complexTypeName = complexTypeName.substring(0, complexTypeName.length() - 2);
                }
                axisMessage.addParameter(new Parameter("complexType", (Object)complexTypeName));
            }
        }
    }

    private static void populateSchemaMap(Map<String, XmlSchema> schemaMap, List<XmlSchema> schemaList) {
        for (XmlSchema xmlSchema : schemaList) {
            schemaMap.put(xmlSchema.getTargetNamespace(), xmlSchema);
        }
    }

    private static void walkSchema(AxisMessage message, TypeMapper mapper, Map<String, XmlSchema> schemaMap, String opName, String qnameSuffix) {
        if (message.getParameter("UnWrapped") != null) {
            XmlSchemaElement schemaElement = message.getSchemaElement();
            XmlSchemaType schemaType = schemaElement.getSchemaType();
            QName schemaTypeQname = schemaElement.getSchemaTypeName();
            if (schemaType == null && schemaTypeQname != null) {
                XmlSchema schema;
                AxisService axisService = message.getAxisOperation().getAxisService();
                Iterator iterator = axisService.getSchema().iterator();
                while (iterator.hasNext() && (schemaType = ExtensionUtility.getSchemaType(schema = (XmlSchema)iterator.next(), schemaTypeQname)) == null) {
                }
            }
            JavaTypeMap basicTypeMap = new JavaTypeMap();
            if (schemaType instanceof XmlSchemaComplexType) {
                ExtensionUtility.processXMLSchemaComplexType(schemaType, mapper, opName, schemaMap, qnameSuffix);
            } else if (schemaTypeQname != null && basicTypeMap.getTypeMap().containsKey(schemaTypeQname)) {
                QName partQName = WSDLUtil.getPartQName((String)opName, (String)qnameSuffix, (String)message.getElementQName().getLocalPart());
                mapper.addTypeMappingName(partQName, (String)basicTypeMap.getTypeMap().get(schemaTypeQname));
            } else if (schemaType instanceof XmlSchemaSimpleType) {
                XmlSchemaSimpleType xmlSchemaSimpleType = (XmlSchemaSimpleType)schemaType;
                ExtensionUtility.populateClassName(xmlSchemaSimpleType.getMetaInfoMap(), mapper, opName, false, message.getElementQName().getLocalPart(), qnameSuffix);
            }
        }
    }

    private static void processXMLSchemaComplexType(XmlSchemaType schemaType, TypeMapper mapper, String opName, Map schemaMap, String qnameSuffix) {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType cmplxType = (XmlSchemaComplexType)schemaType;
            if (cmplxType.getContentModel() == null) {
                ExtensionUtility.processSchemaSequence(cmplxType.getParticle(), mapper, opName, schemaMap, qnameSuffix);
            } else {
                ExtensionUtility.processComplexContentModel(cmplxType, mapper, opName, schemaMap, qnameSuffix);
            }
            ExtensionUtility.processAttributes(cmplxType, opName, qnameSuffix, mapper);
        }
    }

    private static void processAttributes(XmlSchemaComplexType complexType, String opName, String qnameSuffix, TypeMapper typeMap) {
        for (XmlSchemaObject item : complexType.getAttributes()) {
            if (!(item instanceof XmlSchemaAttribute)) continue;
            XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)item;
            ExtensionUtility.populateClassName(xmlSchemaAttribute.getMetaInfoMap(), typeMap, opName, false, xmlSchemaAttribute.getName(), qnameSuffix);
        }
    }

    private static XmlSchemaType getSchemaType(XmlSchema schema, QName typeName) {
        XmlSchemaType xmlSchemaType = null;
        if (schema != null && (xmlSchemaType = schema.getTypeByName(typeName)) == null) {
            for (XmlSchemaObject object : schema.getExternals()) {
                XmlSchema schema1;
                if (object instanceof XmlSchemaImport) {
                    schema1 = ((XmlSchemaImport)object).getSchema();
                    xmlSchemaType = ExtensionUtility.getSchemaType(schema1, typeName);
                }
                if (object instanceof XmlSchemaInclude) {
                    schema1 = ((XmlSchemaInclude)object).getSchema();
                    xmlSchemaType = ExtensionUtility.getSchemaType(schema1, typeName);
                }
                if (xmlSchemaType == null) continue;
                break;
            }
        }
        return xmlSchemaType;
    }

    private static void processComplexContentModel(XmlSchemaComplexType cmplxType, TypeMapper mapper, String opName, Map<String, XmlSchema> schemaMap, String qnameSuffix) {
        XmlSchemaComplexContent xmlSchemaComplexContent;
        XmlSchemaContent content;
        XmlSchemaContentModel contentModel = cmplxType.getContentModel();
        if (contentModel instanceof XmlSchemaComplexContent && (content = (xmlSchemaComplexContent = (XmlSchemaComplexContent)contentModel).getContent()) instanceof XmlSchemaComplexContentExtension) {
            XmlSchema xmlSchema;
            XmlSchemaComplexContentExtension schemaExtension = (XmlSchemaComplexContentExtension)content;
            ExtensionUtility.processSchemaSequence(schemaExtension.getParticle(), mapper, opName, schemaMap, qnameSuffix);
            XmlSchemaType extensionSchemaType = null;
            Iterator<XmlSchema> iterator = schemaMap.values().iterator();
            while (iterator.hasNext() && (extensionSchemaType = ExtensionUtility.getSchemaType(xmlSchema = iterator.next(), schemaExtension.getBaseTypeName())) == null) {
            }
            ExtensionUtility.processXMLSchemaComplexType(extensionSchemaType, mapper, opName, schemaMap, qnameSuffix);
        }
    }

    private static void processSchemaSequence(XmlSchemaParticle particle, TypeMapper mapper, String opName, Map<String, XmlSchema> schemaMap, String qnameSuffix) {
        if (particle instanceof XmlSchemaSequence) {
            List items = ((XmlSchemaSequence)particle).getItems();
            for (XmlSchemaSequenceMember item : items) {
                boolean isArray;
                if (item instanceof XmlSchemaElement) {
                    XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)item;
                    isArray = xmlSchemaElement.getMaxOccurs() > 1L;
                    XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                    String partName = null;
                    partName = xmlSchemaElement.getRef().getTargetQName() != null ? xmlSchemaElement.getRef().getTargetQName().getLocalPart() : xmlSchemaElement.getName();
                    ExtensionUtility.populateClassName(xmlSchemaElement.getMetaInfoMap(), mapper, opName, isArray, partName, qnameSuffix);
                    continue;
                }
                if (!(item instanceof XmlSchemaAny)) continue;
                XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)item;
                isArray = xmlSchemaAny.getMaxOccurs() > 1L;
                QName partQName = WSDLUtil.getPartQName((String)opName, (String)qnameSuffix, (String)"extraElement");
                if (isArray) {
                    mapper.addTypeMappingName(partQName, "org.apache.axiom.om.OMElement[]");
                    continue;
                }
                mapper.addTypeMappingName(partQName, "org.apache.axiom.om.OMElement");
            }
        }
    }

    private static void populateClassName(Map metaInfoMap, TypeMapper typeMap, String opName, boolean isArray, String partName, String qnameSuffix) {
        if (metaInfoMap != null) {
            String className = (String)metaInfoMap.get("CLASS_NAME");
            if (isArray && !className.endsWith("[]")) {
                className = className + "[]";
            } else if (!isArray && className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
            }
            QName partQName = WSDLUtil.getPartQName((String)opName, (String)qnameSuffix, (String)partName);
            typeMap.addTypeMappingName(partQName, className);
            if (Boolean.TRUE.equals(metaInfoMap.get("CLASS_NAME_PRIMITIVE"))) {
                typeMap.addTypeMappingStatus(partQName, (Object)Boolean.TRUE);
            }
        }
    }

    private static XmlSchemaType findSchemaType(Map<String, XmlSchema> schemaMap, QName schemaTypeName) {
        XmlSchema schema = schemaMap.get(schemaTypeName.getNamespaceURI());
        if (schema != null) {
            return schema.getTypeByName(schemaTypeName);
        }
        return null;
    }

    private static void populateUserparameters(CompilerOptions options, CodeGenConfiguration configuration) {
        String packageName;
        Map propertyMap = configuration.getProperties();
        if (propertyMap.containsKey("w")) {
            if (Boolean.valueOf(propertyMap.get("w").toString()).booleanValue()) {
                options.setWrapClasses(true);
            } else {
                options.setWrapClasses(false);
            }
        }
        if (propertyMap.containsKey("r")) {
            if (Boolean.valueOf(propertyMap.get("r").toString()).booleanValue()) {
                options.setWriteOutput(true);
            } else {
                options.setWriteOutput(false);
            }
        }
        if (propertyMap.containsKey("p") && ((packageName = (String)propertyMap.get("p")) != null || !"".equals(packageName))) {
            options.setPackageName(packageName);
        }
        options.setNs2PackageMap(configuration.getUri2PackageNameMap());
        if (propertyMap.containsKey("mp") && ((packageName = (String)propertyMap.get("mp")) != null || !"".equals(packageName))) {
            options.setMapperClassPackage(packageName);
        }
        if (propertyMap.containsKey("osv")) {
            options.setOffStrictValidation(true);
        }
        if (propertyMap.containsKey("uwc")) {
            options.setUseWrapperClasses(true);
        }
        if (propertyMap.containsKey("iu")) {
            options.setIgnoreUnexpected(true);
        }
        if (!options.isWrapClasses() && propertyMap.containsKey("h")) {
            options.setHelperMode(true);
        }
    }

    private static void populateDefaultOptions(CompilerOptions options, CodeGenConfiguration configuration) {
        File outputDir;
        File file = outputDir = configuration.isFlattenFiles() ? configuration.getOutputLocation() : new File(configuration.getOutputLocation(), configuration.getSourceLocation());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        options.setOutputLocation(outputDir);
        options.setNs2PackageMap(configuration.getUri2PackageNameMap() == null ? new HashMap() : configuration.getUri2PackageNameMap());
        if (configuration.isServerSide()) {
            options.setWrapClasses(false);
            options.setWriteOutput(true);
        } else {
            options.setWrapClasses(configuration.isPackClasses());
            options.setWriteOutput(!configuration.isPackClasses());
        }
        if (configuration.isGenerateAll()) {
            options.setGenerateAll(true);
        }
        if (configuration.isBackwordCompatibilityMode()) {
            options.setBackwordCompatibilityMode(true);
        }
        if (configuration.isSuppressPrefixesMode()) {
            options.setSuppressPrefixesMode(true);
        }
    }
}

