/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.TrevniRuntimeException;
import org.apache.trevni.avro.AvroColumnator;

public class AvroColumnWriter<D> {
    private Schema schema;
    private GenericData model;
    private ColumnFileWriter writer;
    private int[] arrayWidths;
    public static final String SCHEMA_KEY = "avro.schema";

    public AvroColumnWriter(Schema s2, ColumnFileMetaData meta) throws IOException {
        this(s2, meta, GenericData.get());
    }

    public AvroColumnWriter(Schema s2, ColumnFileMetaData meta, GenericData model) throws IOException {
        this.schema = s2;
        AvroColumnator columnator = new AvroColumnator(s2);
        meta.set(SCHEMA_KEY, s2.toString());
        this.writer = new ColumnFileWriter(meta, columnator.getColumns());
        this.arrayWidths = columnator.getArrayWidths();
        this.model = model;
    }

    public long sizeEstimate() {
        return this.writer.sizeEstimate();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writer.writeTo(out);
    }

    public void writeTo(File file) throws IOException {
        this.writer.writeTo(file);
    }

    public void write(D value) throws IOException {
        this.writer.startRow();
        int count = this.write(value, this.schema, 0);
        assert (count == this.writer.getColumnCount());
        this.writer.endRow();
    }

    private int write(Object o, Schema s2, int column) throws IOException {
        if (AvroColumnator.isSimple(s2)) {
            this.writeValue(o, s2, column);
            return column + 1;
        }
        switch (s2.getType()) {
            case MAP: {
                Map map = (Map)o;
                this.writer.writeLength(map.size(), column);
                for (Map.Entry e : map.entrySet()) {
                    this.writer.writeValue(null, column);
                    this.writer.writeValue(e.getKey(), column + 1);
                    int c = this.write(e.getValue(), s2.getValueType(), column + 2);
                    assert (c == column + this.arrayWidths[column]);
                }
                return column + this.arrayWidths[column];
            }
            case RECORD: {
                for (Schema.Field f : s2.getFields()) {
                    column = this.write(this.model.getField(o, f.name(), f.pos()), f.schema(), column);
                }
                return column;
            }
            case ARRAY: {
                Collection elements = (Collection)o;
                this.writer.writeLength(elements.size(), column);
                if (AvroColumnator.isSimple(s2.getElementType())) {
                    for (Object element : elements) {
                        this.writeValue(element, s2.getElementType(), column);
                    }
                    return column + 1;
                }
                for (Object element : elements) {
                    this.writer.writeValue(null, column);
                    int c = this.write(element, s2.getElementType(), column + 1);
                    assert (c == column + this.arrayWidths[column]);
                }
                return column + this.arrayWidths[column];
            }
            case UNION: {
                int b = this.model.resolveUnion(s2, o);
                int i = 0;
                for (Schema branch : s2.getTypes()) {
                    boolean selected;
                    boolean bl = selected = i++ == b;
                    if (branch.getType() == Schema.Type.NULL) continue;
                    if (!selected) {
                        this.writer.writeLength(0, column);
                        column += this.arrayWidths[column];
                        continue;
                    }
                    this.writer.writeLength(1, column);
                    if (AvroColumnator.isSimple(branch)) {
                        this.writeValue(o, branch, column++);
                        continue;
                    }
                    this.writer.writeValue(null, column);
                    column = this.write(o, branch, column + 1);
                }
                return column;
            }
        }
        throw new TrevniRuntimeException("Unknown schema: " + s2);
    }

    private void writeValue(Object value, Schema s2, int column) throws IOException {
        switch (s2.getType()) {
            case STRING: {
                if (!(value instanceof Utf8)) break;
                value = value.toString();
                break;
            }
            case ENUM: {
                if (value instanceof Enum) {
                    value = ((Enum)value).ordinal();
                    break;
                }
                value = s2.getEnumOrdinal(value.toString());
                break;
            }
            case FIXED: {
                value = ((GenericFixed)value).bytes();
            }
        }
        this.writer.writeValue(value, column);
    }
}

