/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerUpdateResponsePBImpl
extends ContainerUpdateResponse {
    private YarnServiceProtos.ContainerUpdateResponseProto proto = YarnServiceProtos.ContainerUpdateResponseProto.getDefaultInstance();
    private YarnServiceProtos.ContainerUpdateResponseProto.Builder builder = null;
    private boolean viaProto = false;
    private List<ContainerId> succeededRequests = null;
    private Map<ContainerId, SerializedException> failedRequests = null;

    public ContainerUpdateResponsePBImpl() {
        this.builder = YarnServiceProtos.ContainerUpdateResponseProto.newBuilder();
    }

    public ContainerUpdateResponsePBImpl(YarnServiceProtos.ContainerUpdateResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public List<ContainerId> getSuccessfullyUpdatedContainers() {
        this.initSucceededRequests();
        return this.succeededRequests;
    }

    @Override
    public void setSuccessfullyUpdatedContainers(List<ContainerId> succeeded) {
        this.maybeInitBuilder();
        if (succeeded == null) {
            this.builder.clearSucceededRequests();
        }
        this.succeededRequests = succeeded;
    }

    @Override
    public Map<ContainerId, SerializedException> getFailedRequests() {
        this.initFailedRequests();
        return this.failedRequests;
    }

    @Override
    public void setFailedRequests(Map<ContainerId, SerializedException> failedRequests) {
        this.maybeInitBuilder();
        if (failedRequests == null) {
            this.builder.clearFailedRequests();
        }
        this.failedRequests = failedRequests;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerUpdateResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    public YarnServiceProtos.ContainerUpdateResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void initSucceededRequests() {
        if (this.succeededRequests != null) {
            return;
        }
        YarnServiceProtos.ContainerUpdateResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerIdProto> list = p.getSucceededRequestsList();
        this.succeededRequests = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.succeededRequests.add(this.convertFromProtoFormat(c));
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.ContainerUpdateResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void initFailedRequests() {
        if (this.failedRequests != null) {
            return;
        }
        YarnServiceProtos.ContainerUpdateResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.ContainerExceptionMapProto> protoList = p.getFailedRequestsList();
        this.failedRequests = new HashMap<ContainerId, SerializedException>();
        for (YarnServiceProtos.ContainerExceptionMapProto ce : protoList) {
            this.failedRequests.put(this.convertFromProtoFormat(ce.getContainerId()), this.convertFromProtoFormat(ce.getException()));
        }
    }

    private void mergeLocalToBuilder() {
        if (this.succeededRequests != null) {
            this.addSucceededRequestsToProto();
        }
        if (this.failedRequests != null) {
            this.addFailedRequestsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void addSucceededRequestsToProto() {
        this.maybeInitBuilder();
        this.builder.clearSucceededRequests();
        if (this.succeededRequests == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    private Iterator<ContainerId> iter;
                    {
                        this.iter = ContainerUpdateResponsePBImpl.this.succeededRequests.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return ContainerUpdateResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllSucceededRequests((Iterable<? extends YarnProtos.ContainerIdProto>)iterable);
    }

    private void addFailedRequestsToProto() {
        this.maybeInitBuilder();
        this.builder.clearFailedRequests();
        if (this.failedRequests == null) {
            return;
        }
        ArrayList<YarnServiceProtos.ContainerExceptionMapProto> protoList = new ArrayList<YarnServiceProtos.ContainerExceptionMapProto>();
        for (Map.Entry<ContainerId, SerializedException> entry : this.failedRequests.entrySet()) {
            protoList.add(YarnServiceProtos.ContainerExceptionMapProto.newBuilder().setContainerId(this.convertToProtoFormat(entry.getKey())).setException(this.convertToProtoFormat(entry.getValue())).build());
        }
        this.builder.addAllFailedRequests(protoList);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private SerializedExceptionPBImpl convertFromProtoFormat(YarnProtos.SerializedExceptionProto p) {
        return new SerializedExceptionPBImpl(p);
    }

    private YarnProtos.SerializedExceptionProto convertToProtoFormat(SerializedException t) {
        return ((SerializedExceptionPBImpl)t).getProto();
    }
}

