/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class FsUrlConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(FsUrlConnection.class);
    private Configuration conf;
    private InputStream is;

    FsUrlConnection(Configuration conf, URL url) {
        super(url);
        Preconditions.checkArgument(conf != null, "null conf argument");
        Preconditions.checkArgument(url != null, "null url argument");
        this.conf = conf;
    }

    @Override
    public void connect() throws IOException {
        Preconditions.checkState(this.is == null, "Already connected");
        try {
            LOG.debug("Connecting to {}", (Object)this.url);
            URI uri = this.url.toURI();
            FileSystem fs = FileSystem.get(uri, this.conf);
            this.is = uri.isOpaque() && uri.getScheme().equals("file") ? fs.open(new Path(uri.getSchemeSpecificPart())) : fs.open(new Path(uri));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.connect();
        }
        return this.is;
    }
}

