/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class KeyProvider {
    public static final String DEFAULT_CIPHER_NAME = "hadoop.security.key.default.cipher";
    public static final String DEFAULT_CIPHER = "AES/CTR/NoPadding";
    public static final String DEFAULT_BITLENGTH_NAME = "hadoop.security.key.default.bitlength";
    public static final int DEFAULT_BITLENGTH = 128;
    public static final String JCEKS_KEY_SERIALFILTER_DEFAULT = "java.lang.Enum;java.security.KeyRep;java.security.KeyRep$Type;javax.crypto.spec.SecretKeySpec;org.apache.hadoop.crypto.key.JavaKeyStoreProvider$KeyMetadata;!*";
    public static final String JCEKS_KEY_SERIAL_FILTER = "jceks.key.serialFilter";
    private final Configuration conf;

    public KeyProvider(Configuration conf) {
        this.conf = new Configuration(conf);
        if (System.getProperty(JCEKS_KEY_SERIAL_FILTER) == null) {
            String serialFilter = conf.get("hadoop.security.crypto.jceks.key.serialfilter", JCEKS_KEY_SERIALFILTER_DEFAULT);
            System.setProperty(JCEKS_KEY_SERIAL_FILTER, serialFilter);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static Options options(Configuration conf) {
        return new Options(conf);
    }

    public boolean isTransient() {
        return false;
    }

    public abstract KeyVersion getKeyVersion(String var1) throws IOException;

    public abstract List<String> getKeys() throws IOException;

    public Metadata[] getKeysMetadata(String ... names) throws IOException {
        Metadata[] result = new Metadata[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.getMetadata(names[i]);
        }
        return result;
    }

    public abstract List<KeyVersion> getKeyVersions(String var1) throws IOException;

    public KeyVersion getCurrentKey(String name) throws IOException {
        Metadata meta = this.getMetadata(name);
        if (meta == null) {
            return null;
        }
        return this.getKeyVersion(KeyProvider.buildVersionName(name, meta.getVersions() - 1));
    }

    public abstract Metadata getMetadata(String var1) throws IOException;

    public abstract KeyVersion createKey(String var1, byte[] var2, Options var3) throws IOException;

    private String getAlgorithm(String cipher) {
        int slash = cipher.indexOf(47);
        if (slash == -1) {
            return cipher;
        }
        return cipher.substring(0, slash);
    }

    protected byte[] generateKey(int size, String algorithm) throws NoSuchAlgorithmException {
        algorithm = this.getAlgorithm(algorithm);
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
        keyGenerator.init(size);
        byte[] key = keyGenerator.generateKey().getEncoded();
        return key;
    }

    public KeyVersion createKey(String name, Options options) throws NoSuchAlgorithmException, IOException {
        byte[] material = this.generateKey(options.getBitLength(), options.getCipher());
        return this.createKey(name, material, options);
    }

    public abstract void deleteKey(String var1) throws IOException;

    public abstract KeyVersion rollNewVersion(String var1, byte[] var2) throws IOException;

    public void close() throws IOException {
    }

    public KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        Metadata meta = this.getMetadata(name);
        if (meta == null) {
            throw new IOException("Can't find Metadata for key " + name);
        }
        byte[] material = this.generateKey(meta.getBitLength(), meta.getCipher());
        return this.rollNewVersion(name, material);
    }

    public void invalidateCache(String name) throws IOException {
    }

    public abstract void flush() throws IOException;

    public static String getBaseName(String versionName) throws IOException {
        int div = versionName.lastIndexOf(64);
        if (div == -1) {
            throw new IOException("No version in key path " + versionName);
        }
        return versionName.substring(0, div);
    }

    protected static String buildVersionName(String name, int version) {
        return name + "@" + version;
    }

    public static KeyProvider findProvider(List<KeyProvider> providerList, String keyName) throws IOException {
        for (KeyProvider provider : providerList) {
            if (provider.getMetadata(keyName) == null) continue;
            return provider;
        }
        throw new IOException("Can't find KeyProvider for key " + keyName);
    }

    public boolean needsPassword() throws IOException {
        return false;
    }

    public String noPasswordWarning() {
        return null;
    }

    public String noPasswordError() {
        return null;
    }

    public static class Options {
        private String cipher;
        private int bitLength;
        private String description;
        private Map<String, String> attributes;

        public Options(Configuration conf) {
            this.cipher = conf.get(KeyProvider.DEFAULT_CIPHER_NAME, KeyProvider.DEFAULT_CIPHER);
            this.bitLength = conf.getInt(KeyProvider.DEFAULT_BITLENGTH_NAME, 128);
        }

        public Options setCipher(String cipher) {
            this.cipher = cipher;
            return this;
        }

        public Options setBitLength(int bitLength) {
            this.bitLength = bitLength;
            return this;
        }

        public Options setDescription(String description) {
            this.description = description;
            return this;
        }

        public Options setAttributes(Map<String, String> attributes) {
            if (attributes != null) {
                if (attributes.containsKey(null)) {
                    throw new IllegalArgumentException("attributes cannot have a NULL key");
                }
                this.attributes = new HashMap<String, String>(attributes);
            }
            return this;
        }

        public String getCipher() {
            return this.cipher;
        }

        public int getBitLength() {
            return this.bitLength;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, String> getAttributes() {
            return this.attributes == null ? Collections.emptyMap() : this.attributes;
        }

        public String toString() {
            return "Options{cipher='" + this.cipher + '\'' + ", bitLength=" + this.bitLength + ", description='" + this.description + '\'' + ", attributes=" + this.attributes + '}';
        }
    }

    public static class Metadata {
        private static final String CIPHER_FIELD = "cipher";
        private static final String BIT_LENGTH_FIELD = "bitLength";
        private static final String CREATED_FIELD = "created";
        private static final String DESCRIPTION_FIELD = "description";
        private static final String VERSIONS_FIELD = "versions";
        private static final String ATTRIBUTES_FIELD = "attributes";
        private final String cipher;
        private final int bitLength;
        private final String description;
        private final Date created;
        private int versions;
        private Map<String, String> attributes;

        protected Metadata(String cipher, int bitLength, String description, Map<String, String> attributes, Date created, int versions) {
            this.cipher = cipher;
            this.bitLength = bitLength;
            this.description = description;
            this.attributes = attributes == null || attributes.isEmpty() ? null : attributes;
            this.created = created;
            this.versions = versions;
        }

        public String toString() {
            StringBuilder metaSB = new StringBuilder();
            metaSB.append("cipher: ").append(this.cipher).append(", ");
            metaSB.append("length: ").append(this.bitLength).append(", ");
            metaSB.append("description: ").append(this.description).append(", ");
            metaSB.append("created: ").append(this.created).append(", ");
            metaSB.append("version: ").append(this.versions).append(", ");
            metaSB.append("attributes: ");
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                    metaSB.append("[");
                    metaSB.append(attribute.getKey());
                    metaSB.append("=");
                    metaSB.append(attribute.getValue());
                    metaSB.append("], ");
                }
                metaSB.deleteCharAt(metaSB.length() - 2);
            } else {
                metaSB.append("null");
            }
            return metaSB.toString();
        }

        public String getDescription() {
            return this.description;
        }

        public Date getCreated() {
            return this.created;
        }

        public String getCipher() {
            return this.cipher;
        }

        public Map<String, String> getAttributes() {
            return this.attributes == null ? Collections.emptyMap() : this.attributes;
        }

        public String getAlgorithm() {
            int slash = this.cipher.indexOf(47);
            if (slash == -1) {
                return this.cipher;
            }
            return this.cipher.substring(0, slash);
        }

        public int getBitLength() {
            return this.bitLength;
        }

        public int getVersions() {
            return this.versions;
        }

        protected int addVersion() {
            return this.versions++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] serialize() throws IOException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (JsonWriter writer = new JsonWriter(new OutputStreamWriter((OutputStream)buffer, StandardCharsets.UTF_8));){
                writer.beginObject();
                if (this.cipher != null) {
                    writer.name(CIPHER_FIELD).value(this.cipher);
                }
                if (this.bitLength != 0) {
                    writer.name(BIT_LENGTH_FIELD).value(this.bitLength);
                }
                if (this.created != null) {
                    writer.name(CREATED_FIELD).value(this.created.getTime());
                }
                if (this.description != null) {
                    writer.name(DESCRIPTION_FIELD).value(this.description);
                }
                if (this.attributes != null && this.attributes.size() > 0) {
                    writer.name(ATTRIBUTES_FIELD).beginObject();
                    for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                        writer.name(attribute.getKey()).value(attribute.getValue());
                    }
                    writer.endObject();
                }
                writer.name(VERSIONS_FIELD).value(this.versions);
                writer.endObject();
                writer.flush();
            }
            return buffer.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Metadata(byte[] bytes) throws IOException {
            String cipher = null;
            int bitLength = 0;
            Date created = null;
            int versions = 0;
            String description = null;
            HashMap<String, String> attributes = null;
            try (JsonReader reader = new JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));){
                reader.beginObject();
                while (reader.hasNext()) {
                    String field = reader.nextName();
                    if (CIPHER_FIELD.equals(field)) {
                        cipher = reader.nextString();
                        continue;
                    }
                    if (BIT_LENGTH_FIELD.equals(field)) {
                        bitLength = reader.nextInt();
                        continue;
                    }
                    if (CREATED_FIELD.equals(field)) {
                        created = new Date(reader.nextLong());
                        continue;
                    }
                    if (VERSIONS_FIELD.equals(field)) {
                        versions = reader.nextInt();
                        continue;
                    }
                    if (DESCRIPTION_FIELD.equals(field)) {
                        description = reader.nextString();
                        continue;
                    }
                    if (!ATTRIBUTES_FIELD.equalsIgnoreCase(field)) continue;
                    reader.beginObject();
                    attributes = new HashMap<String, String>();
                    while (reader.hasNext()) {
                        attributes.put(reader.nextName(), reader.nextString());
                    }
                    reader.endObject();
                }
                reader.endObject();
            }
            this.cipher = cipher;
            this.bitLength = bitLength;
            this.created = created;
            this.description = description;
            this.attributes = attributes;
            this.versions = versions;
        }
    }

    public static class KeyVersion {
        private final String name;
        private final String versionName;
        private final byte[] material;

        protected KeyVersion(String name, String versionName, byte[] material) {
            this.name = name == null ? null : name.intern();
            this.versionName = versionName == null ? null : versionName.intern();
            this.material = material;
        }

        public String getName() {
            return this.name;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public byte[] getMaterial() {
            return this.material;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("key(");
            buf.append(this.versionName);
            buf.append(")=");
            if (this.material == null) {
                buf.append("null");
            } else {
                for (byte b : this.material) {
                    buf.append(' ');
                    int right = b & 0xFF;
                    if (right < 16) {
                        buf.append('0');
                    }
                    buf.append(Integer.toHexString(right));
                }
            }
            return buf.toString();
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs == null || this.getClass() != rhs.getClass()) {
                return false;
            }
            KeyVersion kv = (KeyVersion)rhs;
            return new EqualsBuilder().append(this.name, kv.name).append(this.versionName, kv.versionName).append(this.material, kv.material).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.name).append(this.versionName).append(this.material).toHashCode();
        }
    }
}

