/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.validate;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.ValueVectorUtility;
import org.apache.arrow.vector.validate.ValidateUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestValidateVectorFull {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testBaseVariableWidthVector() {
        try (VarCharVector vector = new VarCharVector("v", this.allocator);){
            ValueVectorUtility.validateFull((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, "aaa", "bbb", "ccc");
            ValueVectorUtility.validateFull((ValueVector)vector);
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            offsetBuf.setInt(0L, 100);
            offsetBuf.setInt(4L, 50);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the offset buffer are decreasing"));
        }
    }

    @Test
    public void testBaseLargeVariableWidthVector() {
        try (LargeVarCharVector vector = new LargeVarCharVector("v", this.allocator);){
            ValueVectorUtility.validateFull((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, "aaa", "bbb", null, "ccc");
            ValueVectorUtility.validateFull((ValueVector)vector);
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            offsetBuf.setLong(0L, 100L);
            offsetBuf.setLong(8L, 50L);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the large offset buffer are decreasing"));
        }
    }

    @Test
    public void testListVector() {
        try (ListVector vector = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validateFull((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, Arrays.asList(1, 2, 3), Arrays.asList(4, 5), Arrays.asList(6, 7, 8, 9));
            ValueVectorUtility.validateFull((ValueVector)vector);
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            offsetBuf.setInt(0L, 100);
            offsetBuf.setInt(8L, 50);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the offset buffer are decreasing"));
        }
    }

    @Test
    public void testLargeListVector() {
        try (LargeListVector vector = LargeListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validateFull((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, Arrays.asList(1, 2, 3), Arrays.asList(4, 5), Arrays.asList(6, 7, 8, 9));
            ValueVectorUtility.validateFull((ValueVector)vector);
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            offsetBuf.setLong(0L, 100L);
            offsetBuf.setLong(16L, 50L);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the large offset buffer are decreasing"));
        }
    }

    @Test
    public void testStructVectorRangeEquals() {
        try (StructVector vector = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            IntVector intVector = (IntVector)vector.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            VarCharVector strVector = (VarCharVector)vector.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            ValueVectorUtility.validateFull((ValueVector)vector);
            ValueVectorUtility.validateFull((ValueVector)intVector);
            ValueVectorUtility.validateFull((ValueVector)strVector);
            ValueVectorDataPopulator.setVector(intVector, 1, 2, 3, 4, 5);
            ValueVectorDataPopulator.setVector(strVector, "a", "b", "c", "d", "e");
            vector.setValueCount(5);
            ValueVectorUtility.validateFull((ValueVector)vector);
            ValueVectorUtility.validateFull((ValueVector)intVector);
            ValueVectorUtility.validateFull((ValueVector)strVector);
            ArrowBuf offsetBuf = strVector.getOffsetBuffer();
            offsetBuf.setInt(0L, 100);
            offsetBuf.setInt(8L, 50);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)strVector));
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the offset buffer are decreasing"));
            e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the offset buffer are decreasing"));
        }
    }

    @Test
    public void testUnionVector() {
        try (UnionVector vector = UnionVector.empty((String)"union", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validateFull((ValueVector)vector);
            NullableFloat4Holder float4Holder = new NullableFloat4Holder();
            float4Holder.value = 1.01f;
            float4Holder.isSet = 1;
            NullableFloat8Holder float8Holder = new NullableFloat8Holder();
            float8Holder.value = 2.02f;
            float8Holder.isSet = 1;
            vector.setType(0, Types.MinorType.FLOAT4);
            vector.setSafe(0, float4Holder);
            vector.setType(1, Types.MinorType.FLOAT8);
            vector.setSafe(1, float8Holder);
            vector.setValueCount(2);
            ValueVectorUtility.validateFull((ValueVector)vector);
            vector.getTypeBuffer().setByte(0L, -1);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("The type id at position 0 is negative"));
        }
    }

    @Test
    public void testDenseUnionVector() {
        try (DenseUnionVector vector = DenseUnionVector.empty((String)"union", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validateFull((ValueVector)vector);
            NullableFloat4Holder float4Holder = new NullableFloat4Holder();
            float4Holder.value = 1.01f;
            float4Holder.isSet = 1;
            NullableFloat8Holder float8Holder = new NullableFloat8Holder();
            float8Holder.value = 2.02f;
            float8Holder.isSet = 1;
            byte float4TypeId = vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT4.getType()));
            byte float8TypeId = vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT8.getType()));
            vector.setTypeId(0, float4TypeId);
            vector.setSafe(0, float4Holder);
            vector.setTypeId(1, float8TypeId);
            vector.setSafe(1, float8Holder);
            vector.setValueCount(2);
            ValueVectorUtility.validateFull((ValueVector)vector);
            ValueVector subVector = vector.getVectorByType(float4TypeId);
            Assert.assertTrue((boolean)(subVector instanceof Float4Vector));
            Assertions.assertEquals((int)1, (int)subVector.getValueCount());
            subVector.setValueCount(0);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Dense union vector offset exceeds sub-vector boundary"));
        }
    }

    @Test
    public void testBaseVariableWidthVectorInstanceMethod() {
        try (VarCharVector vector = new VarCharVector("v", this.allocator);){
            vector.validateFull();
            ValueVectorDataPopulator.setVector(vector, "aaa", "bbb", "ccc");
            vector.validateFull();
            ArrowBuf offsetBuf = vector.getOffsetBuffer();
            offsetBuf.setInt(0L, 100);
            offsetBuf.setInt(4L, 50);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ((VarCharVector)vector).validateFull());
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the offset buffer are decreasing"));
        }
    }

    @Test
    public void testValidateVarCharUTF8() {
        try (VarCharVector vector = new VarCharVector("v", this.allocator);){
            vector.validateFull();
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{"aaa".getBytes(StandardCharsets.UTF_8), "bbb".getBytes(StandardCharsets.UTF_8), {-1, -2}});
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ((VarCharVector)vector).validateFull());
            Assert.assertTrue((boolean)e.getMessage().contains("UTF"));
        }
    }

    @Test
    public void testValidateLargeVarCharUTF8() {
        try (LargeVarCharVector vector = new LargeVarCharVector("v", this.allocator);){
            vector.validateFull();
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{"aaa".getBytes(StandardCharsets.UTF_8), "bbb".getBytes(StandardCharsets.UTF_8), {-1, -2}});
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ((LargeVarCharVector)vector).validateFull());
            Assert.assertTrue((boolean)e.getMessage().contains("UTF"));
        }
    }

    @Test
    public void testValidateDecimal() {
        try (DecimalVector vector = new DecimalVector(Field.nullable((String)"v", (ArrowType)new ArrowType.Decimal(2, 0, 128)), this.allocator);){
            vector.validateFull();
            ValueVectorDataPopulator.setVector(vector, 1L);
            vector.validateFull();
            vector.clear();
            ValueVectorDataPopulator.setVector(vector, Long.MAX_VALUE);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ((DecimalVector)vector).validateFull());
            Assert.assertTrue((boolean)e.getMessage().contains("Decimal"));
        }
    }

    @Test
    public void testValidateDecimal256() {
        try (Decimal256Vector vector = new Decimal256Vector(Field.nullable((String)"v", (ArrowType)new ArrowType.Decimal(2, 0, 128)), this.allocator);){
            vector.validateFull();
            ValueVectorDataPopulator.setVector(vector, 1L);
            vector.validateFull();
            vector.clear();
            ValueVectorDataPopulator.setVector(vector, Long.MAX_VALUE);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ((Decimal256Vector)vector).validateFull());
            Assert.assertTrue((boolean)e.getMessage().contains("Decimal"));
        }
    }
}

