/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.util;

import junit.framework.TestCase;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.vector.ElementAddressableVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.ElementAddressableVectorIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestElementAddressableVectorIterator {
    private final int VECTOR_LENGTH = 100;
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testIterateIntVector() {
        try (IntVector intVector = new IntVector("", this.allocator);){
            intVector.allocateNew(100);
            intVector.setValueCount(100);
            for (int i = 0; i < 100; ++i) {
                if (i == 0) {
                    intVector.setNull(i);
                    continue;
                }
                intVector.set(i, i);
            }
            ElementAddressableVectorIterator it = new ElementAddressableVectorIterator((ElementAddressableVector)intVector);
            int index = 0;
            while (it.hasNext()) {
                ArrowBufPointer pt;
                if (index % 2 == 0) {
                    pt = new ArrowBufPointer();
                    it.next(pt);
                } else {
                    pt = it.next();
                }
                if (index == 0) {
                    TestCase.assertNull((Object)pt.getBuf());
                } else {
                    Assert.assertEquals((long)index, (long)pt.getBuf().getInt(pt.getOffset()));
                }
                ++index;
            }
        }
    }

    @Test
    public void testIterateVarCharVector() {
        try (VarCharVector strVector = new VarCharVector("", this.allocator);){
            strVector.allocateNew(1000L, 100);
            strVector.setValueCount(100);
            for (int i = 0; i < 100; ++i) {
                if (i == 0) {
                    strVector.setNull(i);
                    continue;
                }
                strVector.set(i, String.valueOf(i).getBytes());
            }
            ElementAddressableVectorIterator it = new ElementAddressableVectorIterator((ElementAddressableVector)strVector);
            int index = 0;
            while (it.hasNext()) {
                ArrowBufPointer pt;
                if (index % 2 == 0) {
                    pt = new ArrowBufPointer();
                    it.next(pt);
                } else {
                    pt = it.next();
                }
                if (index == 0) {
                    TestCase.assertNull((Object)pt.getBuf());
                } else {
                    String expected = String.valueOf(index);
                    byte[] actual = new byte[expected.length()];
                    Assert.assertEquals((long)expected.length(), (long)pt.getLength());
                    pt.getBuf().getBytes(pt.getOffset(), actual);
                    Assert.assertEquals((Object)expected, (Object)new String(actual));
                }
                ++index;
            }
        }
    }
}

