/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.types.pojo;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;

public class TestField {
    private static Field field(String name, boolean nullable, ArrowType type, Map<String, String> metadata) {
        return new Field(name, new FieldType(nullable, type, null, metadata), Collections.emptyList());
    }

    @Test
    public void testMetadata() throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>(1);
        metadata.put("testKey", "testValue");
        Schema schema = new Schema(Collections.singletonList(TestField.field("a", false, (ArrowType)new ArrowType.Int(8, true), metadata)));
        String json = schema.toJson();
        Schema actual = Schema.fromJSON((String)json);
        this.jsonContains(json, "\"key\" : \"testKey\"", "\"value\" : \"testValue\"");
        Map actualMetadata = ((Field)actual.getFields().get(0)).getMetadata();
        Assert.assertEquals((long)1L, (long)actualMetadata.size());
        Assert.assertEquals((Object)"testValue", actualMetadata.get("testKey"));
    }

    private void jsonContains(String json, String ... strings) {
        for (String string : strings) {
            Assert.assertTrue((String)(json + " contains " + string), (boolean)json.contains(string));
        }
    }
}

