/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.testing;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.holders.IntervalDayHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.Assert;

public class ValueVectorDataPopulator {
    private ValueVectorDataPopulator() {
    }

    public static void setVector(BigIntVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(BitVector vector, Integer ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].intValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(DateDayVector vector, Integer ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].intValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(DateMilliVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(DecimalVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(Decimal256Vector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(Decimal256Vector vector, BigDecimal ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i]);
        }
        vector.setValueCount(length);
    }

    public static void setVector(DurationVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(FixedSizeBinaryVector vector, byte[] ... values) {
        int length = values.length;
        vector.allocateNewSafe();
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i]);
        }
        vector.setValueCount(length);
    }

    public static void setVector(Float4Vector vector, Float ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].floatValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(Float8Vector vector, Double ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].doubleValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(IntVector vector, Integer ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].intValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(IntervalDayVector vector, IntervalDayHolder ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].days, values[i].milliseconds);
        }
        vector.setValueCount(length);
    }

    public static void setVector(IntervalYearVector vector, Integer ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].intValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(SmallIntVector vector, Short ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].shortValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeMicroVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeMilliVector vector, Integer ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].intValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeNanoVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeSecVector vector, Integer ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].intValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampMicroTZVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampMicroVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampMilliTZVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampMilliVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampNanoTZVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampNanoVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampSecTZVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TimeStampSecVector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(TinyIntVector vector, Byte ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].byteValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(UInt1Vector vector, Byte ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].byteValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(UInt2Vector vector, Character ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].charValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(UInt4Vector vector, Integer ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].intValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(UInt8Vector vector, Long ... values) {
        int length = values.length;
        vector.allocateNew(length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i].longValue());
        }
        vector.setValueCount(length);
    }

    public static void setVector(VarBinaryVector vector, byte[] ... values) {
        int length = values.length;
        vector.allocateNewSafe();
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i]);
        }
        vector.setValueCount(length);
    }

    public static void setVector(VarCharVector vector, byte[] ... values) {
        int length = values.length;
        vector.allocateNewSafe();
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i]);
        }
        vector.setValueCount(length);
    }

    public static void setVector(LargeVarCharVector vector, byte[] ... values) {
        int length = values.length;
        vector.allocateNewSafe();
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.set(i, values[i]);
        }
        vector.setValueCount(length);
    }

    public static void setVector(VarCharVector vector, String ... values) {
        int length = values.length;
        vector.allocateNewSafe();
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.setSafe(i, values[i].getBytes(StandardCharsets.UTF_8));
        }
        vector.setValueCount(length);
    }

    public static void setVector(LargeVarCharVector vector, String ... values) {
        int length = values.length;
        vector.allocateNewSafe();
        for (int i = 0; i < length; ++i) {
            if (values[i] == null) continue;
            vector.setSafe(i, values[i].getBytes(StandardCharsets.UTF_8));
        }
        vector.setValueCount(length);
    }

    public static void setVector(ListVector vector, List<Integer> ... values) {
        vector.allocateNewSafe();
        Types.MinorType type = Types.MinorType.INT;
        vector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        IntVector dataVector = (IntVector)vector.getDataVector();
        dataVector.allocateNew();
        int curPos = 0;
        vector.getOffsetBuffer().setInt(0L, curPos);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                BitVectorHelper.unsetBit((ArrowBuf)vector.getValidityBuffer(), (int)i);
            } else {
                BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)i);
                for (int value : values[i]) {
                    dataVector.setSafe(curPos, value);
                    ++curPos;
                }
            }
            vector.getOffsetBuffer().setInt((long)((i + 1) * 4), curPos);
        }
        dataVector.setValueCount(curPos);
        vector.setLastSet(values.length - 1);
        vector.setValueCount(values.length);
    }

    public static void setVector(LargeListVector vector, List<Integer> ... values) {
        vector.allocateNewSafe();
        Types.MinorType type = Types.MinorType.INT;
        vector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        IntVector dataVector = (IntVector)vector.getDataVector();
        dataVector.allocateNew();
        int curPos = 0;
        vector.getOffsetBuffer().setLong(0L, (long)curPos);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                BitVectorHelper.unsetBit((ArrowBuf)vector.getValidityBuffer(), (int)i);
            } else {
                BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)i);
                for (int value : values[i]) {
                    dataVector.setSafe(curPos, value);
                    ++curPos;
                }
            }
            vector.getOffsetBuffer().setLong((long)(i + 1) * 8L, (long)curPos);
        }
        dataVector.setValueCount(curPos);
        vector.setLastSet(values.length - 1);
        vector.setValueCount(values.length);
    }

    public static void setVector(FixedSizeListVector vector, List<Integer> ... values) {
        vector.allocateNewSafe();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            Assert.assertEquals((long)vector.getListSize(), (long)values[i].size());
        }
        Types.MinorType type = Types.MinorType.INT;
        vector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        IntVector dataVector = (IntVector)vector.getDataVector();
        dataVector.allocateNew();
        int curPos = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                BitVectorHelper.unsetBit((ArrowBuf)vector.getValidityBuffer(), (int)i);
                continue;
            }
            BitVectorHelper.setBit((ArrowBuf)vector.getValidityBuffer(), (long)i);
            for (int value : values[i]) {
                dataVector.setSafe(curPos, value);
                ++curPos;
            }
        }
        dataVector.setValueCount(curPos);
        vector.setValueCount(values.length);
    }

    public static void setVector(StructVector vector, Map<String, List<Integer>> values) {
        vector.allocateNewSafe();
        int valueCount = 0;
        for (Map.Entry<String, List<Integer>> entry : values.entrySet()) {
            IntVector child = (IntVector)vector.addOrGet(entry.getKey(), FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
            child.allocateNew();
            List<Integer> v = entry.getValue();
            for (int i = 0; i < v.size(); ++i) {
                if (v.get(i) != null) {
                    child.set(i, v.get(i).intValue());
                    vector.setIndexDefined(i);
                    continue;
                }
                child.setNull(i);
            }
            valueCount = Math.max(valueCount, v.size());
        }
        vector.setValueCount(valueCount);
    }
}

