/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.table;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.PeriodDuration;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableDecimalHolder;
import org.apache.arrow.vector.holders.NullableDurationHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import org.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import org.apache.arrow.vector.holders.NullableSmallIntHolder;
import org.apache.arrow.vector.holders.NullableTimeMicroHolder;
import org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import org.apache.arrow.vector.holders.NullableTimeNanoHolder;
import org.apache.arrow.vector.holders.NullableTimeSecHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import org.apache.arrow.vector.holders.NullableTimeStampSecTZHolder;
import org.apache.arrow.vector.holders.NullableTinyIntHolder;
import org.apache.arrow.vector.holders.NullableUInt1Holder;
import org.apache.arrow.vector.holders.NullableUInt2Holder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.holders.NullableUInt8Holder;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.table.TestUtils;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.TestExtensionType;
import org.apache.arrow.vector.util.JsonStringHashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RowTest {
    private BufferAllocator allocator;

    RowTest() {
    }

    @BeforeEach
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterEach
    public void terminate() {
        this.allocator.close();
    }

    @Test
    void constructor() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)c.getDefaultCharacterSet());
        }
    }

    @Test
    void at() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            Assertions.assertEquals((int)c.getRowNumber(), (int)-1);
            c.setPosition(1);
            Assertions.assertEquals((int)c.getRowNumber(), (int)1);
        }
    }

    @Test
    void getIntByVectorIndex() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((int)2, (int)c.getInt(0));
        }
    }

    @Test
    void getIntByVectorName() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((int)2, (int)c.getInt("intCol1"));
        }
    }

    @Test
    void testNameNotFound() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.getVarCharObj("wrong name"));
        }
    }

    @Test
    void testWrongType() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertThrows(ClassCastException.class, () -> c.getVarCharObj("intCol1"));
        }
    }

    @Test
    void getDecimal() {
        ArrayList<DecimalVector> vectors = new ArrayList<DecimalVector>();
        DecimalVector decimalVector = new DecimalVector("decimal_vector", this.allocator, 55, 10);
        vectors.add(decimalVector);
        decimalVector.setSafe(0, new BigDecimal("0.0543278923"));
        decimalVector.setSafe(1, new BigDecimal("2.0543278923"));
        decimalVector.setValueCount(2);
        BigDecimal one = decimalVector.getObject(1);
        NullableDecimalHolder holder1 = new NullableDecimalHolder();
        NullableDecimalHolder holder2 = new NullableDecimalHolder();
        try (Table t = new Table(vectors);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((Object)one, (Object)c.getDecimalObj("decimal_vector"));
            Assertions.assertEquals((Object)one, (Object)c.getDecimalObj(0));
            c.getDecimal(0, holder1);
            c.getDecimal("decimal_vector", holder2);
            Assertions.assertEquals((Object)holder1.buffer, (Object)holder2.buffer);
            Assertions.assertEquals((long)c.getDecimal(0).memoryAddress(), (long)c.getDecimal("decimal_vector").memoryAddress());
        }
    }

    @Test
    void getDuration() {
        ArrayList<DurationVector> vectors = new ArrayList<DurationVector>();
        TimeUnit unit = TimeUnit.SECOND;
        FieldType fieldType = FieldType.nullable((ArrowType)new ArrowType.Duration(unit));
        DurationVector durationVector = new DurationVector("duration_vector", fieldType, this.allocator);
        NullableDurationHolder holder1 = new NullableDurationHolder();
        NullableDurationHolder holder2 = new NullableDurationHolder();
        holder1.value = 100L;
        holder1.unit = TimeUnit.SECOND;
        holder1.isSet = 1;
        holder2.value = 200L;
        holder2.unit = TimeUnit.SECOND;
        holder2.isSet = 1;
        vectors.add(durationVector);
        durationVector.setSafe(0, holder1);
        durationVector.setSafe(1, holder2);
        durationVector.setValueCount(2);
        Duration one = durationVector.getObject(1);
        try (Table t = new Table(vectors);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((Object)one, (Object)c.getDurationObj("duration_vector"));
            Assertions.assertEquals((Object)one, (Object)c.getDurationObj(0));
            c.getDuration(0, holder1);
            c.getDuration("duration_vector", holder2);
            Assertions.assertEquals((long)holder1.value, (long)holder2.value);
            ArrowBuf durationBuf1 = c.getDuration(0);
            ArrowBuf durationBuf2 = c.getDuration("duration_vector");
            Assertions.assertEquals((long)durationBuf1.memoryAddress(), (long)durationBuf2.memoryAddress());
        }
    }

    @Test
    void getIntervalDay() {
        ArrayList<IntervalDayVector> vectors = new ArrayList<IntervalDayVector>();
        IntervalUnit unit = IntervalUnit.DAY_TIME;
        FieldType fieldType = FieldType.nullable((ArrowType)new ArrowType.Interval(unit));
        IntervalDayVector intervalDayVector = new IntervalDayVector("intervalDay_vector", fieldType, this.allocator);
        NullableIntervalDayHolder holder1 = new NullableIntervalDayHolder();
        NullableIntervalDayHolder holder2 = new NullableIntervalDayHolder();
        holder1.days = 100;
        holder1.milliseconds = 1000;
        holder1.isSet = 1;
        holder2.days = 200;
        holder2.milliseconds = 2000;
        holder2.isSet = 1;
        vectors.add(intervalDayVector);
        intervalDayVector.setSafe(0, holder1);
        intervalDayVector.setSafe(1, holder2);
        intervalDayVector.setValueCount(2);
        Duration one = intervalDayVector.getObject(1);
        try (Table t = new Table(vectors);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((Object)one, (Object)c.getIntervalDayObj("intervalDay_vector"));
            Assertions.assertEquals((Object)one, (Object)c.getIntervalDayObj(0));
            c.getIntervalDay(0, holder1);
            c.getIntervalDay("intervalDay_vector", holder2);
            Assertions.assertEquals((int)holder1.days, (int)holder2.days);
            Assertions.assertEquals((int)holder1.milliseconds, (int)holder2.milliseconds);
            ArrowBuf intDayBuf1 = c.getIntervalDay(0);
            ArrowBuf intDayBuf2 = c.getIntervalDay("intervalDay_vector");
            Assertions.assertEquals((long)intDayBuf1.memoryAddress(), (long)intDayBuf2.memoryAddress());
        }
    }

    @Test
    void getIntervalMonth() {
        ArrayList<IntervalMonthDayNanoVector> vectors = new ArrayList<IntervalMonthDayNanoVector>();
        IntervalUnit unit = IntervalUnit.MONTH_DAY_NANO;
        FieldType fieldType = FieldType.nullable((ArrowType)new ArrowType.Interval(unit));
        IntervalMonthDayNanoVector intervalMonthVector = new IntervalMonthDayNanoVector("intervalMonth_vector", fieldType, this.allocator);
        NullableIntervalMonthDayNanoHolder holder1 = new NullableIntervalMonthDayNanoHolder();
        NullableIntervalMonthDayNanoHolder holder2 = new NullableIntervalMonthDayNanoHolder();
        holder1.days = 1;
        holder1.months = 10;
        holder1.isSet = 1;
        holder2.days = 2;
        holder2.months = 20;
        holder2.isSet = 1;
        vectors.add(intervalMonthVector);
        intervalMonthVector.setSafe(0, holder1);
        intervalMonthVector.setSafe(1, holder2);
        intervalMonthVector.setValueCount(2);
        PeriodDuration one = intervalMonthVector.getObject(1);
        try (Table t = new Table(vectors);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((Object)one, (Object)c.getIntervalMonthDayNanoObj("intervalMonth_vector"));
            Assertions.assertEquals((Object)one, (Object)c.getIntervalMonthDayNanoObj(0));
            c.getIntervalMonthDayNano(0, holder1);
            c.getIntervalMonthDayNano("intervalMonth_vector", holder2);
            Assertions.assertEquals((int)holder1.days, (int)holder2.days);
            Assertions.assertEquals((int)holder1.months, (int)holder2.months);
            ArrowBuf intMonthBuf1 = c.getIntervalMonthDayNano(0);
            ArrowBuf intMonthBuf2 = c.getIntervalMonthDayNano("intervalMonth_vector");
            Assertions.assertEquals((long)intMonthBuf1.memoryAddress(), (long)intMonthBuf2.memoryAddress());
        }
    }

    @Test
    void getIntervalYear() {
        ArrayList<IntervalYearVector> vectors = new ArrayList<IntervalYearVector>();
        IntervalUnit unit = IntervalUnit.YEAR_MONTH;
        FieldType fieldType = FieldType.nullable((ArrowType)new ArrowType.Interval(unit));
        IntervalYearVector intervalYearVector = new IntervalYearVector("intervalYear_vector", fieldType, this.allocator);
        NullableIntervalYearHolder holder1 = new NullableIntervalYearHolder();
        NullableIntervalYearHolder holder2 = new NullableIntervalYearHolder();
        holder1.value = 1;
        holder1.isSet = 1;
        holder2.value = 2;
        holder2.isSet = 1;
        vectors.add(intervalYearVector);
        intervalYearVector.setSafe(0, holder1);
        intervalYearVector.setSafe(1, holder2);
        intervalYearVector.setValueCount(2);
        Period one = intervalYearVector.getObject(1);
        try (Table t = new Table(vectors);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((Object)one, (Object)c.getIntervalYearObj("intervalYear_vector"));
            Assertions.assertEquals((Object)one, (Object)c.getIntervalYearObj(0));
            c.getIntervalYear(0, holder1);
            c.getIntervalYear("intervalYear_vector", holder2);
            Assertions.assertEquals((int)holder1.value, (int)holder2.value);
            int intYear1 = c.getIntervalYear(0);
            int intYear2 = c.getIntervalYear("intervalYear_vector");
            Assertions.assertEquals((int)2, (int)intYear1);
            Assertions.assertEquals((int)intYear1, (int)intYear2);
        }
    }

    @Test
    void getBit() {
        ArrayList<BitVector> vectors = new ArrayList<BitVector>();
        BitVector bitVector = new BitVector("bit_vector", this.allocator);
        NullableBitHolder holder1 = new NullableBitHolder();
        NullableBitHolder holder2 = new NullableBitHolder();
        vectors.add(bitVector);
        bitVector.setSafe(0, 0);
        bitVector.setSafe(1, 1);
        bitVector.setValueCount(2);
        int one = bitVector.get(1);
        try (Table t = new Table(vectors);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((int)one, (int)c.getBit("bit_vector"));
            Assertions.assertEquals((int)one, (int)c.getBit(0));
            c.getBit(0, holder1);
            c.getBit("bit_vector", holder2);
            Assertions.assertEquals((int)holder1.value, (int)holder2.value);
        }
    }

    @Test
    void hasNext() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            Assertions.assertTrue((boolean)c.hasNext());
            c.setPosition(1);
            Assertions.assertFalse((boolean)c.hasNext());
        }
    }

    @Test
    void next() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(0);
            c.next();
            Assertions.assertEquals((int)1, (int)c.getRowNumber());
        }
    }

    @Test
    void isNull() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertFalse((boolean)c.isNull(0));
        }
    }

    @Test
    void isNullByFieldName() {
        List<FieldVector> vectorList = TestUtils.twoIntColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertFalse((boolean)c.isNull("intCol1"));
        }
    }

    @Test
    void fixedWidthVectorTest() {
        List<FieldVector> vectorList = TestUtils.fixedWidthVectors(this.allocator, 2);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertFalse((boolean)c.isNull("bigInt_vector"));
            Assertions.assertEquals((int)c.getInt("int_vector"), (int)c.getInt(0));
            Assertions.assertEquals((long)c.getBigInt("bigInt_vector"), (long)c.getBigInt(1));
            Assertions.assertEquals((short)c.getSmallInt("smallInt_vector"), (short)c.getSmallInt(2));
            Assertions.assertEquals((byte)c.getTinyInt("tinyInt_vector"), (byte)c.getTinyInt(3));
            NullableIntHolder int4Holder = new NullableIntHolder();
            NullableTinyIntHolder int1Holder = new NullableTinyIntHolder();
            NullableSmallIntHolder int2Holder = new NullableSmallIntHolder();
            NullableBigIntHolder int8Holder = new NullableBigIntHolder();
            c.getInt(0, int4Holder);
            c.getBigInt(1, int8Holder);
            c.getSmallInt(2, int2Holder);
            c.getTinyInt(3, int1Holder);
            Assertions.assertEquals((int)c.getInt("int_vector"), (int)int4Holder.value);
            Assertions.assertEquals((long)c.getBigInt("bigInt_vector"), (long)int8Holder.value);
            Assertions.assertEquals((short)c.getSmallInt("smallInt_vector"), (short)int2Holder.value);
            Assertions.assertEquals((byte)c.getTinyInt("tinyInt_vector"), (byte)int1Holder.value);
            c.getInt("int_vector", int4Holder);
            c.getBigInt("bigInt_vector", int8Holder);
            c.getSmallInt("smallInt_vector", int2Holder);
            c.getTinyInt("tinyInt_vector", int1Holder);
            Assertions.assertEquals((int)c.getInt("int_vector"), (int)int4Holder.value);
            Assertions.assertEquals((long)c.getBigInt("bigInt_vector"), (long)int8Holder.value);
            Assertions.assertEquals((short)c.getSmallInt("smallInt_vector"), (short)int2Holder.value);
            Assertions.assertEquals((byte)c.getTinyInt("tinyInt_vector"), (byte)int1Holder.value);
            Assertions.assertEquals((byte)c.getUInt1("uInt1_vector"), (byte)c.getUInt1(4));
            Assertions.assertEquals((char)c.getUInt2("uInt2_vector"), (char)c.getUInt2(5));
            Assertions.assertEquals((int)c.getUInt4("uInt4_vector"), (int)c.getUInt4(6));
            Assertions.assertEquals((long)c.getUInt8("uInt8_vector"), (long)c.getUInt8(7));
            NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
            NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
            NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
            NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
            c.getUInt1(4, uInt1Holder);
            c.getUInt2(5, uInt2Holder);
            c.getUInt4(6, uInt4Holder);
            c.getUInt8(7, uInt8Holder);
            Assertions.assertEquals((byte)c.getUInt1("uInt1_vector"), (byte)uInt1Holder.value);
            Assertions.assertEquals((char)c.getUInt2("uInt2_vector"), (char)uInt2Holder.value);
            Assertions.assertEquals((int)c.getUInt4("uInt4_vector"), (int)uInt4Holder.value);
            Assertions.assertEquals((long)c.getUInt8("uInt8_vector"), (long)uInt8Holder.value);
            c.getUInt1("uInt1_vector", uInt1Holder);
            c.getUInt2("uInt2_vector", uInt2Holder);
            c.getUInt4("uInt4_vector", uInt4Holder);
            c.getUInt8("uInt8_vector", uInt8Holder);
            Assertions.assertEquals((byte)c.getUInt1("uInt1_vector"), (byte)uInt1Holder.value);
            Assertions.assertEquals((char)c.getUInt2("uInt2_vector"), (char)uInt2Holder.value);
            Assertions.assertEquals((int)c.getUInt4("uInt4_vector"), (int)uInt4Holder.value);
            Assertions.assertEquals((long)c.getUInt8("uInt8_vector"), (long)uInt8Holder.value);
            Assertions.assertEquals((float)c.getFloat4("float4_vector"), (float)c.getFloat4(8));
            Assertions.assertEquals((double)c.getFloat8("float8_vector"), (double)c.getFloat8(9));
            NullableFloat4Holder float4Holder = new NullableFloat4Holder();
            NullableFloat8Holder float8Holder = new NullableFloat8Holder();
            c.getFloat4(8, float4Holder);
            c.getFloat8(9, float8Holder);
            Assertions.assertEquals((float)c.getFloat4("float4_vector"), (float)float4Holder.value);
            Assertions.assertEquals((double)c.getFloat8("float8_vector"), (double)float8Holder.value);
            c.getFloat4("float4_vector", float4Holder);
            c.getFloat8("float8_vector", float8Holder);
            Assertions.assertEquals((float)c.getFloat4("float4_vector"), (float)float4Holder.value);
            Assertions.assertEquals((double)c.getFloat8("float8_vector"), (double)float8Holder.value);
            Assertions.assertEquals((int)c.getTimeSec("timeSec_vector"), (int)c.getTimeSec(10));
            Assertions.assertEquals((int)c.getTimeMilli("timeMilli_vector"), (int)c.getTimeMilli(11));
            Assertions.assertEquals((long)c.getTimeMicro("timeMicro_vector"), (long)c.getTimeMicro(12));
            Assertions.assertEquals((long)c.getTimeNano("timeNano_vector"), (long)c.getTimeNano(13));
            NullableTimeSecHolder timeSecHolder = new NullableTimeSecHolder();
            NullableTimeMilliHolder timeMilliHolder = new NullableTimeMilliHolder();
            NullableTimeMicroHolder timeMicroHolder = new NullableTimeMicroHolder();
            NullableTimeNanoHolder timeNanoHolder = new NullableTimeNanoHolder();
            c.getTimeSec(10, timeSecHolder);
            c.getTimeMilli(11, timeMilliHolder);
            c.getTimeMicro(12, timeMicroHolder);
            c.getTimeNano(13, timeNanoHolder);
            Assertions.assertEquals((int)c.getTimeSec("timeSec_vector"), (int)timeSecHolder.value);
            Assertions.assertEquals((int)c.getTimeMilli("timeMilli_vector"), (int)timeMilliHolder.value);
            Assertions.assertEquals((long)c.getTimeMicro("timeMicro_vector"), (long)timeMicroHolder.value);
            Assertions.assertEquals((long)c.getTimeNano("timeNano_vector"), (long)timeNanoHolder.value);
            LocalDateTime milliDT = c.getTimeMilliObj(11);
            Assertions.assertNotNull((Object)milliDT);
            Assertions.assertEquals((Object)milliDT, (Object)c.getTimeMilliObj("timeMilli_vector"));
            c.getTimeSec("timeSec_vector", timeSecHolder);
            c.getTimeMilli("timeMilli_vector", timeMilliHolder);
            c.getTimeMicro("timeMicro_vector", timeMicroHolder);
            c.getTimeNano("timeNano_vector", timeNanoHolder);
            Assertions.assertEquals((int)c.getTimeSec("timeSec_vector"), (int)timeSecHolder.value);
            Assertions.assertEquals((int)c.getTimeMilli("timeMilli_vector"), (int)timeMilliHolder.value);
            Assertions.assertEquals((long)c.getTimeMicro("timeMicro_vector"), (long)timeMicroHolder.value);
            Assertions.assertEquals((long)c.getTimeNano("timeNano_vector"), (long)timeNanoHolder.value);
            Assertions.assertEquals((long)c.getTimeStampSec("timeStampSec_vector"), (long)c.getTimeStampSec(14));
            Assertions.assertEquals((long)c.getTimeStampMilli("timeStampMilli_vector"), (long)c.getTimeStampMilli(15));
            Assertions.assertEquals((long)c.getTimeStampMicro("timeStampMicro_vector"), (long)c.getTimeStampMicro(16));
            Assertions.assertEquals((long)c.getTimeStampNano("timeStampNano_vector"), (long)c.getTimeStampNano(17));
            NullableTimeStampSecHolder timeStampSecHolder = new NullableTimeStampSecHolder();
            NullableTimeStampMilliHolder timeStampMilliHolder = new NullableTimeStampMilliHolder();
            NullableTimeStampMicroHolder timeStampMicroHolder = new NullableTimeStampMicroHolder();
            NullableTimeStampNanoHolder timeStampNanoHolder = new NullableTimeStampNanoHolder();
            c.getTimeStampSec(14, timeStampSecHolder);
            c.getTimeStampMilli(15, timeStampMilliHolder);
            c.getTimeStampMicro(16, timeStampMicroHolder);
            c.getTimeStampNano(17, timeStampNanoHolder);
            Assertions.assertEquals((long)c.getTimeStampSec("timeStampSec_vector"), (long)timeStampSecHolder.value);
            Assertions.assertEquals((long)c.getTimeStampMilli("timeStampMilli_vector"), (long)timeStampMilliHolder.value);
            Assertions.assertEquals((long)c.getTimeStampMicro("timeStampMicro_vector"), (long)timeStampMicroHolder.value);
            Assertions.assertEquals((long)c.getTimeStampNano("timeStampNano_vector"), (long)timeStampNanoHolder.value);
            LocalDateTime secDT = c.getTimeStampSecObj(14);
            Assertions.assertNotNull((Object)secDT);
            Assertions.assertEquals((Object)secDT, (Object)c.getTimeStampSecObj("timeStampSec_vector"));
            LocalDateTime milliDT1 = c.getTimeStampMilliObj(15);
            Assertions.assertNotNull((Object)milliDT1);
            Assertions.assertEquals((Object)milliDT1, (Object)c.getTimeStampMilliObj("timeStampMilli_vector"));
            LocalDateTime microDT = c.getTimeStampMicroObj(16);
            Assertions.assertNotNull((Object)microDT);
            Assertions.assertEquals((Object)microDT, (Object)c.getTimeStampMicroObj("timeStampMicro_vector"));
            LocalDateTime nanoDT = c.getTimeStampNanoObj(17);
            Assertions.assertNotNull((Object)nanoDT);
            Assertions.assertEquals((Object)nanoDT, (Object)c.getTimeStampNanoObj("timeStampNano_vector"));
            c.getTimeStampSec("timeStampSec_vector", timeStampSecHolder);
            c.getTimeStampMilli("timeStampMilli_vector", timeStampMilliHolder);
            c.getTimeStampMicro("timeStampMicro_vector", timeStampMicroHolder);
            c.getTimeStampNano("timeStampNano_vector", timeStampNanoHolder);
            Assertions.assertEquals((long)c.getTimeStampSec("timeStampSec_vector"), (long)timeStampSecHolder.value);
            Assertions.assertEquals((long)c.getTimeStampMilli("timeStampMilli_vector"), (long)timeStampMilliHolder.value);
            Assertions.assertEquals((long)c.getTimeStampMicro("timeStampMicro_vector"), (long)timeStampMicroHolder.value);
            Assertions.assertEquals((long)c.getTimeStampNano("timeStampNano_vector"), (long)timeStampNanoHolder.value);
        }
    }

    @Test
    void timestampsWithTimezones() {
        List<FieldVector> vectorList = TestUtils.timezoneTemporalVectors(this.allocator, 2);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((long)c.getTimeStampSecTZ("timeStampSecTZ_vector"), (long)c.getTimeStampSecTZ(0));
            Assertions.assertEquals((long)c.getTimeStampMilliTZ("timeStampMilliTZ_vector"), (long)c.getTimeStampMilliTZ(1));
            Assertions.assertEquals((long)c.getTimeStampMicroTZ("timeStampMicroTZ_vector"), (long)c.getTimeStampMicroTZ(2));
            Assertions.assertEquals((long)c.getTimeStampNanoTZ("timeStampNanoTZ_vector"), (long)c.getTimeStampNanoTZ(3));
            NullableTimeStampSecTZHolder timeStampSecHolder = new NullableTimeStampSecTZHolder();
            NullableTimeStampMilliTZHolder timeStampMilliHolder = new NullableTimeStampMilliTZHolder();
            NullableTimeStampMicroTZHolder timeStampMicroHolder = new NullableTimeStampMicroTZHolder();
            NullableTimeStampNanoTZHolder timeStampNanoHolder = new NullableTimeStampNanoTZHolder();
            c.getTimeStampSecTZ(0, timeStampSecHolder);
            c.getTimeStampMilliTZ(1, timeStampMilliHolder);
            c.getTimeStampMicroTZ(2, timeStampMicroHolder);
            c.getTimeStampNanoTZ(3, timeStampNanoHolder);
            long tsSec = timeStampSecHolder.value;
            long tsMil = timeStampMilliHolder.value;
            long tsMic = timeStampMicroHolder.value;
            long tsNan = timeStampNanoHolder.value;
            Assertions.assertEquals((long)c.getTimeStampSecTZ("timeStampSecTZ_vector"), (long)timeStampSecHolder.value);
            Assertions.assertEquals((long)c.getTimeStampMilliTZ("timeStampMilliTZ_vector"), (long)timeStampMilliHolder.value);
            Assertions.assertEquals((long)c.getTimeStampMicroTZ("timeStampMicroTZ_vector"), (long)timeStampMicroHolder.value);
            Assertions.assertEquals((long)c.getTimeStampNanoTZ("timeStampNanoTZ_vector"), (long)timeStampNanoHolder.value);
            c.getTimeStampSecTZ("timeStampSecTZ_vector", timeStampSecHolder);
            c.getTimeStampMilliTZ("timeStampMilliTZ_vector", timeStampMilliHolder);
            c.getTimeStampMicroTZ("timeStampMicroTZ_vector", timeStampMicroHolder);
            c.getTimeStampNanoTZ("timeStampNanoTZ_vector", timeStampNanoHolder);
            Assertions.assertEquals((long)tsSec, (long)timeStampSecHolder.value);
            Assertions.assertEquals((long)tsMil, (long)timeStampMilliHolder.value);
            Assertions.assertEquals((long)tsMic, (long)timeStampMicroHolder.value);
            Assertions.assertEquals((long)tsNan, (long)timeStampNanoHolder.value);
        }
    }

    @Test
    void getVarChar() {
        List<FieldVector> vectorList = TestUtils.intPlusVarcharColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((Object)c.getVarCharObj(1), (Object)"two");
            Assertions.assertEquals((Object)c.getVarCharObj(1), (Object)c.getVarCharObj("varcharCol1"));
            Assertions.assertArrayEquals((byte[])"two".getBytes(), (byte[])c.getVarChar("varcharCol1"));
            Assertions.assertArrayEquals((byte[])"two".getBytes(), (byte[])c.getVarChar(1));
        }
    }

    @Test
    void getVarBinary() {
        List<FieldVector> vectorList = TestUtils.intPlusVarBinaryColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertArrayEquals((byte[])c.getVarBinary(1), (byte[])"two".getBytes());
            Assertions.assertArrayEquals((byte[])c.getVarBinary(1), (byte[])c.getVarBinary("varbinaryCol1"));
        }
    }

    @Test
    void getLargeVarBinary() {
        List<FieldVector> vectorList = TestUtils.intPlusLargeVarBinaryColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertArrayEquals((byte[])c.getLargeVarBinary(1), (byte[])"two".getBytes());
            Assertions.assertArrayEquals((byte[])c.getLargeVarBinary(1), (byte[])c.getLargeVarBinary("varbinaryCol1"));
        }
    }

    @Test
    void getLargeVarChar() {
        List<FieldVector> vectorList = TestUtils.intPlusLargeVarcharColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertEquals((Object)c.getLargeVarCharObj(1), (Object)"two");
            Assertions.assertEquals((Object)c.getLargeVarCharObj(1), (Object)c.getLargeVarCharObj("varcharCol1"));
            Assertions.assertArrayEquals((byte[])"two".getBytes(), (byte[])c.getLargeVarChar("varcharCol1"));
            Assertions.assertArrayEquals((byte[])"two".getBytes(), (byte[])c.getLargeVarChar(1));
        }
    }

    @Test
    void getFixedBinary() {
        List<FieldVector> vectorList = TestUtils.intPlusFixedBinaryColumns(this.allocator);
        try (Table t = new Table(vectorList);){
            Row c = t.immutableRow();
            c.setPosition(1);
            Assertions.assertArrayEquals((byte[])c.getFixedSizeBinary(1), (byte[])"two".getBytes());
            Assertions.assertArrayEquals((byte[])c.getFixedSizeBinary(1), (byte[])c.getFixedSizeBinary("varbinaryCol1"));
        }
    }

    @Test
    void testSimpleListVector1() {
        try (ListVector listVector = TestUtils.simpleListVector(this.allocator);
             VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{listVector});
             Table table = new Table(vectorSchemaRoot);){
            for (Row c : table) {
                List list = c.getList("int list vector");
                Assertions.assertEquals((int)10, (int)list.size());
            }
        }
    }

    @Test
    void testSimpleListVector2() {
        try (ListVector listVector = TestUtils.simpleListVector(this.allocator);
             VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{listVector});
             Table table = new Table(vectorSchemaRoot);){
            for (Row c : table) {
                List list = c.getList(0);
                Assertions.assertEquals((int)10, (int)list.size());
            }
        }
    }

    @Test
    void testSimpleStructVector1() {
        try (StructVector structVector = TestUtils.simpleStructVector(this.allocator);
             VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{structVector});
             Table table = new Table(vectorSchemaRoot);){
            for (Row c : table) {
                JsonStringHashMap struct = (JsonStringHashMap)c.getStruct("struct_vector");
                JsonStringHashMap struct1 = (JsonStringHashMap)c.getStruct(0);
                int a = (Integer)struct.get((Object)"struct_int_child");
                double b = (Double)struct.get((Object)"struct_flt_child");
                int a1 = (Integer)struct1.get((Object)"struct_int_child");
                double b1 = (Double)struct1.get((Object)"struct_flt_child");
                Assertions.assertNotNull((Object)struct);
                Assertions.assertEquals((int)a, (int)a1);
                Assertions.assertEquals((double)b, (double)b1);
                Assertions.assertTrue((a >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((b <= (double)a ? 1 : 0) != 0, (String)String.format("a = %s and b = %s", a, b));
            }
        }
    }

    @Test
    void testSimpleUnionVector() {
        try (UnionVector unionVector = TestUtils.simpleUnionVector(this.allocator);
             VectorSchemaRoot vsr = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{unionVector});
             Table table = new Table(vsr);){
            Row c = table.immutableRow();
            c.setPosition(0);
            Object object0 = c.getUnion("union_vector");
            Object object1 = c.getUnion(0);
            Assertions.assertEquals((Object)object0, (Object)object1);
            c.setPosition(1);
            Assertions.assertNull((Object)c.getUnion("union_vector"));
            c.setPosition(2);
            Object object2 = c.getUnion("union_vector");
            Assertions.assertEquals((Object)100, (Object)object0);
            Assertions.assertEquals((Object)100, (Object)object2);
        }
    }

    @Test
    void testSimpleDenseUnionVector() {
        try (DenseUnionVector unionVector = TestUtils.simpleDenseUnionVector(this.allocator);
             VectorSchemaRoot vsr = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{unionVector});
             Table table = new Table(vsr);){
            Row c = table.immutableRow();
            c.setPosition(0);
            Object object0 = c.getDenseUnion("union_vector");
            Object object1 = c.getDenseUnion(0);
            Assertions.assertEquals((Object)object0, (Object)object1);
            c.setPosition(1);
            Assertions.assertNull((Object)c.getDenseUnion("union_vector"));
            c.setPosition(2);
            Object object2 = c.getDenseUnion("union_vector");
            Assertions.assertEquals((Object)100, (Object)object0);
            Assertions.assertEquals((Object)100, (Object)object2);
        }
    }

    @Test
    void testExtensionTypeVector() {
        TestExtensionType.LocationVector vector = new TestExtensionType.LocationVector("location", this.allocator);
        vector.allocateNew();
        vector.set(0, 34.073814f, -118.24078f);
        vector.setValueCount(1);
        try (VectorSchemaRoot vsr = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{vector});
             Table table = new Table(vsr);){
            Row c = table.immutableRow();
            c.setPosition(0);
            Object object0 = c.getExtensionType("location");
            Object object1 = c.getExtensionType(0);
            Assertions.assertEquals((Object)object0, (Object)object1);
            JsonStringHashMap struct0 = (JsonStringHashMap)object0;
            Assertions.assertEquals((Object)Float.valueOf(34.073814f), (Object)struct0.get((Object)"Latitude"));
        }
    }

    @Test
    void testSimpleMapVector1() {
        try (MapVector mapVector = TestUtils.simpleMapVector(this.allocator);
             Table table = Table.of((FieldVector[])new FieldVector[]{mapVector});){
            int i = 1;
            for (Row c : table) {
                List list = c.getMap("bigint-int map vector");
                List list1 = c.getMap(0);
                for (int j = 0; j < list1.size(); ++j) {
                    Assertions.assertEquals(list.get(j), list1.get(j));
                }
                if (list != null && !list.isEmpty()) {
                    Assertions.assertEquals((int)i, (int)list.size());
                    for (JsonStringHashMap sv : list) {
                        Assertions.assertEquals((int)2, (int)sv.size());
                        Long o1 = (Long)sv.get((Object)"key");
                        Integer o2 = (Integer)sv.get((Object)"value");
                        Assertions.assertEquals((Long)o1, (long)o2.longValue());
                    }
                }
                ++i;
            }
        }
    }

    @Test
    void resetPosition() {
        try (ListVector listVector = TestUtils.simpleListVector(this.allocator);
             VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{listVector});
             Table table = new Table(vectorSchemaRoot);){
            Row row = table.immutableRow();
            row.next();
            Assertions.assertEquals((int)0, (int)row.rowNumber);
            row.resetPosition();
            Assertions.assertEquals((int)-1, (int)row.rowNumber);
        }
    }
}

