/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITTestIPCWithLargeArrowBuffers {
    private static final Logger logger = LoggerFactory.getLogger(ITTestIPCWithLargeArrowBuffers.class);
    static final long BUFFER_SIZE = 0x100000000L;
    static final int DICTIONARY_VECTOR_SIZE = 0x20000000;
    static final int ENCODED_VECTOR_SIZE = 0x40000000;
    static final String FILE_NAME = "largeArrowData.data";
    static final long DICTIONARY_ID = 123L;
    static final ArrowType.Int ENCODED_VECTOR_TYPE = new ArrowType.Int(32, true);
    static final DictionaryEncoding DICTIONARY_ENCODING = new DictionaryEncoding(123L, false, ENCODED_VECTOR_TYPE);
    static final FieldType ENCODED_FIELD_TYPE = new FieldType(true, (ArrowType)ENCODED_VECTOR_TYPE, DICTIONARY_ENCODING, null);
    static final Field ENCODED_VECTOR_FIELD = new Field("encoded vector", ENCODED_FIELD_TYPE, null);

    private void testWriteLargeArrowData(boolean streamMode) throws IOException {
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             BigIntVector dictVector = new BigIntVector("dic vector", (BufferAllocator)allocator);
             FileOutputStream out = new FileOutputStream(FILE_NAME);
             IntVector encodedVector = (IntVector)ENCODED_VECTOR_FIELD.createVector((BufferAllocator)allocator);){
            int i;
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            Dictionary dictionary = new Dictionary((FieldVector)dictVector, DICTIONARY_ENCODING);
            provider.put(dictionary);
            dictVector.allocateNew(0x20000000);
            for (i = 0; i < 0x20000000; ++i) {
                dictVector.set(i, (long)i);
            }
            dictVector.setValueCount(0x20000000);
            Assert.assertTrue((dictVector.getDataBuffer().capacity() > Integer.MAX_VALUE ? 1 : 0) != 0);
            logger.trace("Populating dictionary vector finished");
            encodedVector.allocateNew(0x40000000);
            for (i = 0; i < 0x40000000; ++i) {
                encodedVector.set(i, i % 0x20000000);
            }
            encodedVector.setValueCount(0x40000000);
            Assert.assertTrue((encodedVector.getDataBuffer().capacity() > Integer.MAX_VALUE ? 1 : 0) != 0);
            logger.trace("Populating encoded vector finished");
            try (VectorSchemaRoot root = new VectorSchemaRoot(Arrays.asList(ENCODED_VECTOR_FIELD), Arrays.asList(encodedVector), 0x40000000);
                 ArrowStreamWriter writer = streamMode ? new ArrowStreamWriter(root, (DictionaryProvider)provider, (OutputStream)out) : new ArrowFileWriter(root, (DictionaryProvider)provider, (WritableByteChannel)out.getChannel());){
                writer.start();
                writer.writeBatch();
                writer.end();
                logger.trace("Writing data finished");
            }
        }
        Assert.assertTrue((boolean)new File(FILE_NAME).exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadLargeArrowData(boolean streamMode) throws IOException {
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             FileInputStream in = new FileInputStream(FILE_NAME);
             ArrowStreamReader reader = streamMode ? new ArrowStreamReader((InputStream)in, (BufferAllocator)allocator) : new ArrowFileReader((SeekableByteChannel)in.getChannel(), (BufferAllocator)allocator);){
            Schema readSchema = reader.getVectorSchemaRoot().getSchema();
            Assert.assertEquals((long)1L, (long)readSchema.getFields().size());
            Assert.assertEquals((Object)ENCODED_VECTOR_FIELD, readSchema.getFields().get(0));
            logger.trace("Verifying schema finished");
            Assert.assertTrue((boolean)reader.loadNextBatch());
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            Assert.assertEquals((long)0x40000000L, (long)root.getRowCount());
            Assert.assertEquals((long)1L, (long)root.getFieldVectors().size());
            Assert.assertTrue((boolean)(root.getFieldVectors().get(0) instanceof IntVector));
            IntVector encodedVector = (IntVector)root.getVector(0);
            for (int i = 0; i < 0x40000000; ++i) {
                Assert.assertEquals((long)(i % 0x20000000), (long)encodedVector.get(i));
            }
            logger.trace("Verifying encoded vector finished");
            Map dictVectors = reader.getDictionaryVectors();
            Assert.assertEquals((long)1L, (long)dictVectors.size());
            Dictionary dictionary = (Dictionary)dictVectors.get(123L);
            Assert.assertNotNull((Object)dictionary);
            Assert.assertTrue((boolean)(dictionary.getVector() instanceof BigIntVector));
            BigIntVector dictVector = (BigIntVector)dictionary.getVector();
            Assert.assertEquals((long)0x20000000L, (long)dictVector.getValueCount());
            for (int i = 0; i < 0x20000000; ++i) {
                Assert.assertEquals((long)i, (long)dictVector.get(i));
            }
            logger.trace("Verifying dictionary vector finished");
            Assert.assertFalse((boolean)reader.loadNextBatch());
        }
        finally {
            File dataFile = new File(FILE_NAME);
            dataFile.delete();
            Assert.assertFalse((boolean)dataFile.exists());
        }
    }

    @Test
    public void testIPC() throws IOException {
        logger.trace("Start testing reading/writing large arrow stream data");
        this.testWriteLargeArrowData(true);
        this.testReadLargeArrowData(true);
        logger.trace("Finish testing reading/writing large arrow stream data");
        logger.trace("Start testing reading/writing large arrow file data");
        this.testWriteLargeArrowData(false);
        this.testReadLargeArrowData(false);
        logger.trace("Finish testing reading/writing large arrow file data");
    }
}

