/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.writer;

import java.nio.ByteBuffer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.impl.LargeVarBinaryWriterImpl;
import org.apache.arrow.vector.complex.impl.LargeVarCharWriterImpl;
import org.apache.arrow.vector.complex.impl.VarBinaryWriterImpl;
import org.apache.arrow.vector.complex.impl.VarCharWriterImpl;
import org.apache.arrow.vector.util.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSimpleWriter {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testWriteByteArrayToVarBinary() throws Exception {
        try (VarBinaryVector vector = new VarBinaryVector("test", this.allocator);
             VarBinaryWriterImpl writer = new VarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            writer.writeToVarBinary(input);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])input, (byte[])result);
        }
    }

    @Test
    public void testWriteByteArrayWithOffsetToVarBinary() throws Exception {
        try (VarBinaryVector vector = new VarBinaryVector("test", this.allocator);
             VarBinaryWriterImpl writer = new VarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            writer.writeToVarBinary(input, 1, 1);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])result);
        }
    }

    @Test
    public void testWriteByteBufferToVarBinary() throws Exception {
        try (VarBinaryVector vector = new VarBinaryVector("test", this.allocator);
             VarBinaryWriterImpl writer = new VarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            ByteBuffer buffer = ByteBuffer.wrap(input);
            writer.writeToVarBinary(buffer);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])input, (byte[])result);
        }
    }

    @Test
    public void testWriteByteBufferWithOffsetToVarBinary() throws Exception {
        try (VarBinaryVector vector = new VarBinaryVector("test", this.allocator);
             VarBinaryWriterImpl writer = new VarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            ByteBuffer buffer = ByteBuffer.wrap(input);
            writer.writeToVarBinary(buffer, 1, 1);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])result);
        }
    }

    @Test
    public void testWriteByteArrayToLargeVarBinary() throws Exception {
        try (LargeVarBinaryVector vector = new LargeVarBinaryVector("test", this.allocator);
             LargeVarBinaryWriterImpl writer = new LargeVarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            writer.writeToLargeVarBinary(input);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])input, (byte[])result);
        }
    }

    @Test
    public void testWriteByteArrayWithOffsetToLargeVarBinary() throws Exception {
        try (LargeVarBinaryVector vector = new LargeVarBinaryVector("test", this.allocator);
             LargeVarBinaryWriterImpl writer = new LargeVarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            writer.writeToLargeVarBinary(input, 1, 1);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])result);
        }
    }

    @Test
    public void testWriteByteBufferToLargeVarBinary() throws Exception {
        try (LargeVarBinaryVector vector = new LargeVarBinaryVector("test", this.allocator);
             LargeVarBinaryWriterImpl writer = new LargeVarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            ByteBuffer buffer = ByteBuffer.wrap(input);
            writer.writeToLargeVarBinary(buffer);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])input, (byte[])result);
        }
    }

    @Test
    public void testWriteByteBufferWithOffsetToLargeVarBinary() throws Exception {
        try (LargeVarBinaryVector vector = new LargeVarBinaryVector("test", this.allocator);
             LargeVarBinaryWriterImpl writer = new LargeVarBinaryWriterImpl(vector);){
            byte[] input = new byte[]{1, 2};
            ByteBuffer buffer = ByteBuffer.wrap(input);
            writer.writeToLargeVarBinary(buffer, 1, 1);
            byte[] result = vector.get(0);
            Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])result);
        }
    }

    @Test
    public void testWriteStringToVarChar() throws Exception {
        try (VarCharVector vector = new VarCharVector("test", this.allocator);
             VarCharWriterImpl writer = new VarCharWriterImpl(vector);){
            String input = "testInput";
            writer.writeVarChar(input);
            String result = vector.getObject(0).toString();
            Assert.assertEquals((Object)input, (Object)result);
        }
    }

    @Test
    public void testWriteTextToVarChar() throws Exception {
        try (VarCharVector vector = new VarCharVector("test", this.allocator);
             VarCharWriterImpl writer = new VarCharWriterImpl(vector);){
            String input = "testInput";
            writer.writeVarChar(new Text(input));
            String result = vector.getObject(0).toString();
            Assert.assertEquals((Object)input, (Object)result);
        }
    }

    @Test
    public void testWriteStringToLargeVarChar() throws Exception {
        try (LargeVarCharVector vector = new LargeVarCharVector("test", this.allocator);
             LargeVarCharWriterImpl writer = new LargeVarCharWriterImpl(vector);){
            String input = "testInput";
            writer.writeLargeVarChar(input);
            String result = vector.getObject(0).toString();
            Assert.assertEquals((Object)input, (Object)result);
        }
    }

    @Test
    public void testWriteTextToLargeVarChar() throws Exception {
        try (LargeVarCharVector vector = new LargeVarCharVector("test", this.allocator);
             LargeVarCharWriterImpl writer = new LargeVarCharWriterImpl(vector);){
            String input = "testInput";
            writer.writeLargeVarChar(new Text(input));
            String result = vector.getObject(0).toString();
            Assert.assertEquals((Object)input, (Object)result);
        }
    }
}

