/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDecimalVector {
    private static long[] intValues = new long[60];
    private int scale = 3;
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testValuesWriteRead() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(10, this.scale, 128), this.allocator);){
            int i;
            try (DecimalVector oldConstructor = new DecimalVector("decimal", this.allocator, 10, this.scale);){
                Assert.assertEquals((Object)decimalVector.getField().getType(), (Object)oldConstructor.getField().getType());
            }
            decimalVector.allocateNew();
            BigDecimal[] values = new BigDecimal[intValues.length];
            for (i = 0; i < intValues.length; ++i) {
                BigDecimal decimal;
                values[i] = decimal = new BigDecimal(BigInteger.valueOf(intValues[i]), this.scale);
                decimalVector.setSafe(i, decimal);
            }
            decimalVector.setValueCount(intValues.length);
            for (i = 0; i < intValues.length; ++i) {
                BigDecimal value = decimalVector.getObject(i);
                Assert.assertEquals((String)("unexpected data at index: " + i), (Object)values[i], (Object)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigDecimalDifferentScaleAndPrecision() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(4, 2, 128), this.allocator);){
            BigDecimal decimal;
            decimalVector.allocateNew();
            boolean hasError = false;
            try {
                decimal = new BigDecimal(BigInteger.valueOf(0L), 3);
                decimalVector.setSafe(0, decimal);
            }
            catch (UnsupportedOperationException ue) {
                hasError = true;
            }
            finally {
                Assert.assertTrue((boolean)hasError);
            }
            hasError = false;
            try {
                decimal = new BigDecimal(BigInteger.valueOf(12345L), 2);
                decimalVector.setSafe(0, decimal);
            }
            catch (UnsupportedOperationException ue) {
                hasError = true;
            }
            finally {
                Assert.assertTrue((boolean)hasError);
            }
        }
    }

    @Test
    public void testWriteBigEndian() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(38, 9, 128), this.allocator);){
            decimalVector.allocateNew();
            BigDecimal decimal1 = new BigDecimal("123456789.000000000");
            BigDecimal decimal2 = new BigDecimal("11.123456789");
            BigDecimal decimal3 = new BigDecimal("1.000000000");
            BigDecimal decimal4 = new BigDecimal("0.111111111");
            BigDecimal decimal5 = new BigDecimal("987654321.123456789");
            BigDecimal decimal6 = new BigDecimal("222222222222.222222222");
            BigDecimal decimal7 = new BigDecimal("7777777777777.666666667");
            BigDecimal decimal8 = new BigDecimal("1212121212.343434343");
            byte[] decimalValue1 = decimal1.unscaledValue().toByteArray();
            byte[] decimalValue2 = decimal2.unscaledValue().toByteArray();
            byte[] decimalValue3 = decimal3.unscaledValue().toByteArray();
            byte[] decimalValue4 = decimal4.unscaledValue().toByteArray();
            byte[] decimalValue5 = decimal5.unscaledValue().toByteArray();
            byte[] decimalValue6 = decimal6.unscaledValue().toByteArray();
            byte[] decimalValue7 = decimal7.unscaledValue().toByteArray();
            byte[] decimalValue8 = decimal8.unscaledValue().toByteArray();
            decimalVector.setBigEndian(0, decimalValue1);
            decimalVector.setBigEndian(1, decimalValue2);
            decimalVector.setBigEndian(2, decimalValue3);
            decimalVector.setBigEndian(3, decimalValue4);
            decimalVector.setBigEndian(4, decimalValue5);
            decimalVector.setBigEndian(5, decimalValue6);
            decimalVector.setBigEndian(6, decimalValue7);
            decimalVector.setBigEndian(7, decimalValue8);
            decimalVector.setValueCount(8);
            Assert.assertEquals((long)8L, (long)decimalVector.getValueCount());
            Assert.assertEquals((Object)decimal1, (Object)decimalVector.getObject(0));
            Assert.assertEquals((Object)decimal2, (Object)decimalVector.getObject(1));
            Assert.assertEquals((Object)decimal3, (Object)decimalVector.getObject(2));
            Assert.assertEquals((Object)decimal4, (Object)decimalVector.getObject(3));
            Assert.assertEquals((Object)decimal5, (Object)decimalVector.getObject(4));
            Assert.assertEquals((Object)decimal6, (Object)decimalVector.getObject(5));
            Assert.assertEquals((Object)decimal7, (Object)decimalVector.getObject(6));
            Assert.assertEquals((Object)decimal8, (Object)decimalVector.getObject(7));
        }
    }

    @Test
    public void testLongReadWrite() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(38, 0, 128), this.allocator);){
            int i;
            decimalVector.allocateNew();
            long[] longValues = new long[]{0L, -2L, Long.MAX_VALUE, Long.MIN_VALUE, 187L};
            for (i = 0; i < longValues.length; ++i) {
                decimalVector.set(i, longValues[i]);
            }
            decimalVector.setValueCount(longValues.length);
            for (i = 0; i < longValues.length; ++i) {
                Assert.assertEquals((Object)new BigDecimal(longValues[i]), (Object)decimalVector.getObject(i));
            }
        }
    }

    @Test
    public void testBigDecimalReadWrite() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(38, 9, 128), this.allocator);){
            decimalVector.allocateNew();
            BigDecimal decimal1 = new BigDecimal("123456789.000000000");
            BigDecimal decimal2 = new BigDecimal("11.123456789");
            BigDecimal decimal3 = new BigDecimal("1.000000000");
            BigDecimal decimal4 = new BigDecimal("-0.111111111");
            BigDecimal decimal5 = new BigDecimal("-987654321.123456789");
            BigDecimal decimal6 = new BigDecimal("-222222222222.222222222");
            BigDecimal decimal7 = new BigDecimal("7777777777777.666666667");
            BigDecimal decimal8 = new BigDecimal("1212121212.343434343");
            decimalVector.set(0, decimal1);
            decimalVector.set(1, decimal2);
            decimalVector.set(2, decimal3);
            decimalVector.set(3, decimal4);
            decimalVector.set(4, decimal5);
            decimalVector.set(5, decimal6);
            decimalVector.set(6, decimal7);
            decimalVector.set(7, decimal8);
            decimalVector.setValueCount(8);
            Assert.assertEquals((long)8L, (long)decimalVector.getValueCount());
            Assert.assertEquals((Object)decimal1, (Object)decimalVector.getObject(0));
            Assert.assertEquals((Object)decimal2, (Object)decimalVector.getObject(1));
            Assert.assertEquals((Object)decimal3, (Object)decimalVector.getObject(2));
            Assert.assertEquals((Object)decimal4, (Object)decimalVector.getObject(3));
            Assert.assertEquals((Object)decimal5, (Object)decimalVector.getObject(4));
            Assert.assertEquals((Object)decimal6, (Object)decimalVector.getObject(5));
            Assert.assertEquals((Object)decimal7, (Object)decimalVector.getObject(6));
            Assert.assertEquals((Object)decimal8, (Object)decimalVector.getObject(7));
        }
    }

    @Test
    public void decimalBE2NE() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(21, 2, 128), this.allocator);){
            decimalVector.allocateNew();
            BigInteger[] testBigInts = new BigInteger[]{new BigInteger("0"), new BigInteger("-1"), new BigInteger("23"), new BigInteger("234234"), new BigInteger("-234234234"), new BigInteger("234234234234"), new BigInteger("-56345345345345"), new BigInteger("29823462983462893462934679234653456345"), new BigInteger("-3894572983475982374598324598234346536"), new BigInteger("-345345"), new BigInteger("754533")};
            int insertionIdx = 0;
            ++insertionIdx;
            for (BigInteger val : testBigInts) {
                decimalVector.setBigEndian(insertionIdx++, val.toByteArray());
            }
            int n = ++insertionIdx;
            ++insertionIdx;
            decimalVector.setBigEndian(n, new byte[0]);
            try {
                decimalVector.setBigEndian(insertionIdx, new byte[17]);
                Assert.fail((String)"above statement should have failed");
            }
            catch (IllegalArgumentException ex) {
                Assert.assertTrue((boolean)ex.getMessage().equals("Invalid decimal value length. Valid length in [1 - 16], got 17"));
            }
            decimalVector.setValueCount(insertionIdx);
            int outputIdx = 0;
            Assert.assertTrue((boolean)decimalVector.isNull(outputIdx++));
            for (BigInteger expected : testBigInts) {
                BigDecimal actual = decimalVector.getObject(outputIdx++);
                Assert.assertEquals((Object)expected, (Object)actual.unscaledValue());
            }
            Assert.assertTrue((boolean)decimalVector.isNull(outputIdx++));
            Assert.assertEquals((Object)BigInteger.valueOf(0L), (Object)decimalVector.getObject(outputIdx).unscaledValue());
        }
    }

    @Test
    public void setUsingArrowBufOfInts() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(5, 2, 128), this.allocator);
             ArrowBuf buf = this.allocator.buffer(8L);){
            decimalVector.allocateNew();
            int val = 70532;
            buf.setInt(0L, val);
            decimalVector.setSafe(0, 0L, buf, 4);
            val = -70532;
            buf.setInt(4L, val);
            decimalVector.setSafe(1, 4L, buf, 4);
            decimalVector.setValueCount(2);
            BigDecimal[] expectedValues = new BigDecimal[]{BigDecimal.valueOf(705.32), BigDecimal.valueOf(-705.32)};
            for (int i = 0; i < 2; ++i) {
                BigDecimal value = decimalVector.getObject(i);
                Assert.assertEquals((Object)expectedValues[i], (Object)value);
            }
        }
    }

    @Test
    public void setUsingArrowLongBytes() {
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(18, 0, 128), this.allocator);
             ArrowBuf buf = this.allocator.buffer(16L);){
            decimalVector.allocateNew();
            long val = Long.MAX_VALUE;
            buf.setLong(0L, val);
            decimalVector.setSafe(0, 0L, buf, 8);
            val = Long.MIN_VALUE;
            buf.setLong(8L, val);
            decimalVector.setSafe(1, 8L, buf, 8);
            decimalVector.setValueCount(2);
            BigDecimal[] expectedValues = new BigDecimal[]{BigDecimal.valueOf(Long.MAX_VALUE), BigDecimal.valueOf(Long.MIN_VALUE)};
            for (int i = 0; i < 2; ++i) {
                BigDecimal value = decimalVector.getObject(i);
                Assert.assertEquals((Object)expectedValues[i], (Object)value);
            }
        }
    }

    @Test
    public void setUsingArrowBufOfBEBytes() {
        BigDecimal[] expectedValues2;
        Throwable throwable;
        ArrowBuf buf;
        try (DecimalVector decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(5, 2, 128), this.allocator);){
            buf = this.allocator.buffer(9L);
            throwable = null;
            try {
                expectedValues2 = new BigDecimal[]{BigDecimal.valueOf(705.32), BigDecimal.valueOf(-705.32), BigDecimal.valueOf(705.32)};
                this.verifyWritingArrowBufWithBigEndianBytes(decimalVector, buf, expectedValues2, 3);
            }
            catch (Throwable expectedValues2) {
                throwable = expectedValues2;
                throw expectedValues2;
            }
            finally {
                if (buf != null) {
                    TestDecimalVector.$closeResource(throwable, (AutoCloseable)buf);
                }
            }
        }
        decimalVector = TestUtils.newVector(DecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(36, 2, 128), this.allocator);
        var2_2 = null;
        try {
            buf = this.allocator.buffer(45L);
            throwable = null;
            try {
                expectedValues2 = new BigDecimal[]{new BigDecimal("2982346298346289346293467923465345.63"), new BigDecimal("-2982346298346289346293467923465345.63"), new BigDecimal("2982346298346289346293467923465345.63")};
                this.verifyWritingArrowBufWithBigEndianBytes(decimalVector, buf, expectedValues2, 15);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (buf != null) {
                    TestDecimalVector.$closeResource(throwable, (AutoCloseable)buf);
                }
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        finally {
            if (decimalVector != null) {
                TestDecimalVector.$closeResource(var2_2, (AutoCloseable)decimalVector);
            }
        }
    }

    @Test
    public void testGetTransferPairWithField() {
        DecimalVector fromVector = new DecimalVector("decimal", this.allocator, 10, this.scale);
        TransferPair transferPair = fromVector.getTransferPair(fromVector.getField(), this.allocator);
        DecimalVector toVector = (DecimalVector)transferPair.getTo();
        Assert.assertSame((Object)fromVector.getField(), (Object)toVector.getField());
    }

    private void verifyWritingArrowBufWithBigEndianBytes(DecimalVector decimalVector, ArrowBuf buf, BigDecimal[] expectedValues, int length) {
        int i;
        decimalVector.allocateNew();
        for (i = 0; i < expectedValues.length; ++i) {
            byte[] bigEndianBytes = expectedValues[i].unscaledValue().toByteArray();
            buf.setBytes((long)(length * i), bigEndianBytes, 0, (long)bigEndianBytes.length);
            decimalVector.setBigEndianSafe(i, (long)(length * i), buf, bigEndianBytes.length);
        }
        decimalVector.setValueCount(3);
        for (i = 0; i < expectedValues.length; ++i) {
            BigDecimal value = decimalVector.getObject(i);
            Assert.assertEquals((Object)expectedValues[i], (Object)value);
        }
    }

    static {
        for (int i = 0; i < intValues.length / 2; ++i) {
            TestDecimalVector.intValues[i] = 1 << i + 1;
            TestDecimalVector.intValues[2 * i] = -1 * (1 << i + 1);
        }
    }
}

