/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;

public class ActiveMQTopic
extends ActiveMQDestination
implements Topic {
    private static final long serialVersionUID = 7873614001276404156L;

    public static SimpleString createAddressFromName(String name) {
        return new SimpleString(name);
    }

    public ActiveMQTopic(String name) {
        this(name, false);
    }

    public ActiveMQTopic(String name, boolean temporary) {
        super(name, name, ActiveMQDestination.TYPE.TOPIC, null);
    }

    protected ActiveMQTopic(String address, String name, boolean temporary, ActiveMQSession session) {
        super(address, name, temporary ? ActiveMQDestination.TYPE.TEMP_TOPIC : ActiveMQDestination.TYPE.TOPIC, session);
    }

    public String getTopicName() {
        return this.name;
    }

    public String toString() {
        return "ActiveMQTopic[" + this.name + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQTopic)) {
            return false;
        }
        ActiveMQTopic that = (ActiveMQTopic)o;
        return super.getAddress().equals(that.getAddress());
    }

    @Override
    public int hashCode() {
        return super.getAddress().hashCode();
    }
}

