/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientLogger;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;

public class JMSMessageListenerWrapper
implements MessageHandler {
    private final ConnectionFactoryOptions options;
    private final ActiveMQConnection connection;
    private final ActiveMQSession session;
    private final MessageListener listener;
    private final ClientConsumer consumer;
    private final boolean transactedOrClientAck;
    private final boolean individualACK;
    private final boolean clientACK;

    protected JMSMessageListenerWrapper(ConnectionFactoryOptions options, ActiveMQConnection connection, ActiveMQSession session, ClientConsumer consumer, MessageListener listener, int ackMode) {
        this.options = options;
        this.connection = connection;
        this.session = session;
        this.consumer = consumer;
        this.listener = listener;
        this.transactedOrClientAck = ackMode == 0 || ackMode == 2 || session.isXA();
        this.individualACK = ackMode == 101;
        this.clientACK = ackMode == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        ActiveMQMessage msg = ActiveMQMessage.createMessage(message, this.session.getCoreSession(), this.options);
        if (this.individualACK) {
            msg.setIndividualAcknowledge();
        }
        if (this.clientACK) {
            msg.setClientAcknowledge();
        }
        try {
            msg.doBeforeReceive();
        }
        catch (Exception e) {
            ActiveMQJMSClientLogger.LOGGER.errorPreparingMessageForReceipt(msg.getCoreMessage().toString(), e);
            return;
        }
        if (this.transactedOrClientAck) {
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                ((ClientSessionInternal)this.session.getCoreSession()).markRollbackOnly();
                ActiveMQJMSClientLogger.LOGGER.errorProcessingMessage(e);
            }
        }
        try {
            this.connection.getThreadAwareContext().setCurrentThread(false);
            this.listener.onMessage((Message)msg);
        }
        catch (RuntimeException e) {
            ActiveMQJMSClientLogger.LOGGER.onMessageError(e);
            if (!this.transactedOrClientAck) {
                try {
                    if (this.individualACK) {
                        message.individualAcknowledge();
                    }
                    this.session.getCoreSession().rollback(true);
                    this.session.setRecoverCalled(true);
                }
                catch (Exception e2) {
                    ActiveMQJMSClientLogger.LOGGER.errorRecoveringSession(e2);
                }
            }
        }
        finally {
            this.connection.getThreadAwareContext().clearCurrentThread(false);
        }
        if (!this.session.isRecoverCalled() && !this.individualACK) {
            try {
                if (!this.consumer.isClosed() && !this.transactedOrClientAck) {
                    message.acknowledge();
                }
            }
            catch (ActiveMQException e) {
                ((ClientSessionInternal)this.session.getCoreSession()).markRollbackOnly();
                ActiveMQJMSClientLogger.LOGGER.errorProcessingMessage(e);
            }
        }
        this.session.setRecoverCalled(false);
    }
}

