/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Command;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.Create;
import org.apache.activemq.artemis.cli.commands.InstallAbstract;
import org.apache.activemq.artemis.util.JVMArgumentParser;

@Command(name="upgrade", description="Update an artemis instance to the current artemis.home, keeping all the data and broker.xml. Warning: backup your instance before using this command and compare the files.")
public class Upgrade
extends InstallAbstract {
    private static final String[] KEEPING_JVM_ARGUMENTS = new String[]{"-Xmx", "-Djava.security.auth.login.config", "-Dhawtio.role="};
    private static final String JDK_PREFIX_WINDOWS = "IF \"%JAVA_ARGS%\"==\"\" (set JAVA_ARGS=";
    private static final String JDK_PREFIX_LINUX = "JAVA_ARGS=";
    protected static final String OLD_LOGGING_PROPERTIES = "logging.properties";

    protected void checkDirectory() {
        if (!this.directory.exists()) {
            throw new RuntimeException(String.format("Could not find path '%s' to upgrade.", this.directory));
        }
        if (!this.directory.canWrite()) {
            throw new RuntimeException(String.format("The path '%s' is not writable.", this.directory));
        }
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.checkDirectory();
        super.execute(context);
        return this.run(context);
    }

    @Override
    public Object run(ActionContext context) throws Exception {
        super.run(context);
        context.out.println("*******************************************************************************************************************************");
        context.out.println("Upgrading broker instance " + this.directory + " to use artemis.home=" + this.getBrokerHome());
        File bkpFolder = this.findBackup(context);
        File binBkp = new File(bkpFolder, "bin");
        File etcBkp = new File(bkpFolder, "etc");
        File tmp = new File(bkpFolder, "tmp");
        binBkp.mkdirs();
        etcBkp.mkdirs();
        tmp.mkdirs();
        File bin = new File(this.directory, "bin");
        File etcFolder = new File(this.directory, this.etc);
        if (this.etc == null || this.etc.equals("etc")) {
            File cmd;
            if (this.IS_WINDOWS && !this.IS_CYGWIN) {
                cmd = new File(bin, "artemis.cmd");
                String pattern = "set ARTEMIS_INSTANCE_ETC=";
                etcFolder = this.getETC(context, etcFolder, cmd, pattern);
            } else {
                cmd = new File(bin, "artemis");
                String pattern = "ARTEMIS_INSTANCE_ETC=";
                etcFolder = this.getETC(context, etcFolder, cmd, pattern);
            }
        }
        if (bin == null || !bin.exists()) {
            throw new IOException(bin + " does not exist for binary");
        }
        if (etcFolder == null || !etcFolder.exists()) {
            throw new IOException(etcFolder + " does not exist for etc");
        }
        HashMap<String, String> filters = new HashMap<String, String>();
        Create.addScriptFilters(filters, this.getHome(), this.getInstance(), etcFolder, new File(this.getInstance(), "notUsed"), new File(this.getInstance(), "om-not-used.dmp"), this.javaMemory, this.javaOptions, "NA");
        if (this.IS_WINDOWS) {
            this.write("bin/artemis-service.exe", true);
            this.write("bin/artemis-service.exe.config", true);
            this.write("bin/artemis.cmd", new File(tmp, "artemis.cmd"), filters, false, false);
            this.upgrade(new File(tmp, "artemis.cmd"), new File(bin, "artemis.cmd"), binBkp, "set ARTEMIS_INSTANCE_ETC=");
            this.write("bin/artemis-service.xml", new File(tmp, "artemis-service.xml"), filters, false, false);
            this.upgrade(new File(tmp, "artemis-service.xml"), new File(bin, "artemis-service.xml"), binBkp, "<env name=\"ARTEMIS_INSTANCE\"", "<env name=\"ARTEMIS_INSTANCE_ETC\"", "<env name=\"ARTEMIS_INSTANCE_URI\"", "<env name=\"ARTEMIS_INSTANCE_ETC_URI\"", "<env name=\"ARTEMIS_DATA_DIR\"", "<logpath>", "<startargument>-Xmx", "<stopargument>-Xmx", "<name>", "<id>", "<startargument>-Dhawtio.role=");
            this.write("etc/artemis.profile.cmd", new File(tmp, "artemis.profile.cmd"), filters, false, false);
            this.upgradeJDK(JDK_PREFIX_WINDOWS, "", KEEPING_JVM_ARGUMENTS, new File(tmp, "artemis.profile.cmd"), new File(etcFolder, "artemis.profile.cmd"), binBkp, "set ARTEMIS_INSTANCE=\"", "set ARTEMIS_DATA_DIR=", "set ARTEMIS_ETC_DIR=", "set ARTEMIS_OOME_DUMP=", "set ARTEMIS_INSTANCE_URI=", "set ARTEMIS_INSTANCE_ETC_URI=");
        }
        if (!this.IS_WINDOWS || this.IS_CYGWIN) {
            this.write("bin/artemis", new File(tmp, "artemis"), filters, false, false);
            this.upgrade(new File(tmp, "artemis"), new File(bin, "artemis"), binBkp, "ARTEMIS_INSTANCE_ETC=");
            this.write("bin/artemis-service", new File(tmp, "artemis-service"), filters, false, false);
            this.upgrade(new File(tmp, "artemis-service"), new File(bin, "artemis-service"), binBkp, new String[0]);
            this.write("etc/artemis.profile", new File(tmp, "artemis.profile"), filters, false, false);
            this.upgradeJDK(JDK_PREFIX_LINUX, "\"", KEEPING_JVM_ARGUMENTS, new File(tmp, "artemis.profile"), new File(etcFolder, "artemis.profile"), etcBkp, "ARTEMIS_INSTANCE=", "ARTEMIS_DATA_DIR=", "ARTEMIS_ETC_DIR=", "ARTEMIS_OOME_DUMP=", "ARTEMIS_INSTANCE_URI=", "ARTEMIS_INSTANCE_ETC_URI=", "HAWTIO_ROLE=");
        }
        Files.copy(new File(etcFolder, "bootstrap.xml").toPath(), new File(tmp, "bootstrap.xml").toPath(), new CopyOption[0]);
        this.replaceLines(new File(tmp, "bootstrap.xml"), new File(etcFolder, "bootstrap.xml"), binBkp, "<web path", "   <web path=\"web\" rootRedirectLocation=\"console\">");
        this.upgradeLogging(context, etcBkp, etcFolder);
        context.out.println();
        context.out.println("*******************************************************************************************************************************");
        return null;
    }

    private File getETC(ActionContext context, File etcFolder, File cmd, String pattern) throws IOException {
        String etcLine = this.getLine(cmd, pattern);
        if (etcLine != null) {
            etcLine = etcLine.trim();
            etcLine = etcLine.substring(pattern.length() + 1, etcLine.length() - 1);
            etcFolder = new File(etcLine);
            context.out.println("ETC found at " + etcFolder);
        }
        return etcFolder;
    }

    private String getLine(File cmd, String pattern) throws IOException {
        try (Stream<String> lines = Files.lines(cmd.toPath());){
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if (!line.trim().startsWith(pattern)) continue;
                String string = line;
                return string;
            }
        }
        return null;
    }

    private void upgradeJDK(String jdkPrefix, String endOfLine, String[] keepArguments, File tmpFile, File targetFile, File bkp, String ... keepingPrefixes) throws Exception {
        HashMap replaceMatrix = new HashMap();
        HashMap currentArguments = new HashMap();
        this.doUpgrade(tmpFile, targetFile, bkp, oldLine -> {
            if (oldLine.trim().startsWith(jdkPrefix)) {
                JVMArgumentParser.parseOriginalArgs(jdkPrefix, endOfLine, oldLine, keepArguments, currentArguments);
                return;
            }
            for (String prefix : keepingPrefixes) {
                if (!oldLine.trim().startsWith(prefix)) continue;
                replaceMatrix.put(prefix, oldLine);
            }
        }, newLine -> {
            if (newLine.trim().startsWith(jdkPrefix)) {
                String result = JVMArgumentParser.parseNewLine(jdkPrefix, endOfLine, newLine, keepArguments, currentArguments);
                return result;
            }
            for (String prefix : keepingPrefixes) {
                if (!newLine.trim().startsWith(prefix)) continue;
                String originalLine = (String)replaceMatrix.get(prefix);
                return originalLine;
            }
            return newLine;
        });
    }

    private void replaceLines(File tmpFile, File targetFile, File bkp, String ... replacePairs) throws Exception {
        this.doUpgrade(tmpFile, targetFile, bkp, null, newLine -> {
            for (int i = 0; i < replacePairs.length; i += 2) {
                if (!newLine.trim().startsWith(replacePairs[i])) continue;
                return replacePairs[i + 1];
            }
            return newLine;
        });
    }

    private void upgrade(File tmpFile, File targetFile, File bkp, String ... keepingPrefixes) throws Exception {
        HashMap replaceMatrix = new HashMap();
        this.doUpgrade(tmpFile, targetFile, bkp, oldLine -> {
            for (String prefix : keepingPrefixes) {
                if (!oldLine.trim().startsWith(prefix)) continue;
                replaceMatrix.put(prefix, oldLine);
            }
        }, newLine -> {
            for (String prefix : keepingPrefixes) {
                if (!newLine.trim().startsWith(prefix)) continue;
                String originalLine = (String)replaceMatrix.get(prefix);
                return originalLine;
            }
            return newLine;
        });
    }

    private void doUpgrade(File tmpFile, File targetFile, File bkp, Consumer<String> originalConsumer, Function<String, String> targetFunction) throws Exception {
        Files.copy(targetFile.toPath(), bkp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (originalConsumer != null) {
            try (Stream<String> originalLines = Files.lines(targetFile.toPath());){
                originalLines.forEach(line -> originalConsumer.accept((String)line));
            }
        }
        try (Stream<String> lines = Files.lines(tmpFile.toPath());
             PrintStream streamOutput = new PrintStream(new FileOutputStream(targetFile));){
            Iterator linesIterator = lines.iterator();
            while (linesIterator.hasNext()) {
                String line2 = (String)linesIterator.next();
                if ((line2 = targetFunction.apply(line2)) == null) continue;
                streamOutput.println(line2);
            }
        }
    }

    private void upgradeLogging(ActionContext context, File bkpFolder, File etc) throws Exception {
        File oldLogging = new File(etc, OLD_LOGGING_PROPERTIES);
        if (oldLogging.exists()) {
            File newLogging;
            File oldLoggingCopy = new File(bkpFolder, OLD_LOGGING_PROPERTIES);
            context.out.println("Copying " + oldLogging.toPath() + " to " + oldLoggingCopy.toPath());
            Files.copy(oldLogging.toPath(), bkpFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
            context.out.println("Removing " + oldLogging.toPath());
            if (!oldLogging.delete()) {
                context.out.println(oldLogging.toPath() + " could not be removed!");
            }
            if (!(newLogging = new File(etc, "log4j2.properties")).exists()) {
                context.out.println("Creating " + newLogging);
                try (InputStream inputStream = Upgrade.openStream("etc/log4j2.properties");
                     FileOutputStream outputStream = new FileOutputStream(newLogging);){
                    Upgrade.copy(inputStream, outputStream);
                }
            }
        }
    }

    protected File findBackup(ActionContext context) {
        for (int bkp = 0; bkp < 10; ++bkp) {
            File bkpFolder = new File(this.directory, "old-config-bkp." + bkp);
            if (bkpFolder.exists()) continue;
            bkpFolder.mkdirs();
            context.out.println("Using " + bkpFolder.getAbsolutePath() + " as a backup folder for the modified files");
            return bkpFolder;
        }
        throw new RuntimeException("Too many backup folders in place already. Please remove some of the old-config-bkp.* folders");
    }
}

