/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.PasswordAction;

@Command(name="reset", description="Reset user's password or roles")
public class ResetUser
extends PasswordAction {
    @Option(name={"--plaintext"}, description="store the password in plaintext (Default: false)")
    boolean plaintext = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.checkInputUser();
        this.checkInputPassword();
        this.reset();
        return null;
    }

    private void reset() throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"resetUser", (Object[])new Object[]{ResetUser.this.userCommandUser, ResetUser.this.userCommandPassword, ResetUser.this.role, ResetUser.this.plaintext});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                ((ResetUser)ResetUser.this).getActionContext().out.println(ResetUser.this.userCommandUser + " reset successfully.");
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                ((ResetUser)ResetUser.this).getActionContext().err.println("Failed to reset user " + ResetUser.this.userCommandUser + ". Reason: " + errMsg);
            }
        });
    }
}

