/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Artemis {
    public static void main(String[] args) throws Throwable {
        String home = System.getProperty("artemis.home");
        File fileHome = home != null ? new File(home) : null;
        String instance = System.getProperty("artemis.instance");
        File fileInstance = instance != null ? new File(instance) : null;
        Object brokerEtc = System.getProperty("artemis.instance.etc");
        File fileBrokerETC = null;
        if (brokerEtc != null) {
            brokerEtc = ((String)brokerEtc).replace("\\", "/");
            fileBrokerETC = new File((String)brokerEtc);
        } else if (instance != null) {
            brokerEtc = instance + "/etc";
            fileBrokerETC = new File((String)brokerEtc);
        }
        Object result = Artemis.execute(fileHome, fileInstance, fileBrokerETC, true, args);
        if (result instanceof Exception) {
            System.exit(1);
        }
    }

    public static Object execute(File artemisHome, File artemisInstance, File fileBrokerETC, boolean useSystemOut, List<String> args) throws Throwable {
        return Artemis.execute(artemisHome, artemisInstance, fileBrokerETC, useSystemOut, args.toArray(new String[args.size()]));
    }

    public static Object execute(File fileHome, File fileInstance, File fileBrokerETC, boolean useSystemOut, String ... args) throws Throwable {
        ArrayList<File> dirs = new ArrayList<File>();
        if (fileHome != null) {
            dirs.add(new File(fileHome, "lib"));
        }
        if (fileInstance != null) {
            dirs.add(new File(fileInstance, "lib"));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (fileBrokerETC == null && fileInstance != null) {
            fileBrokerETC = new File(fileInstance, "etc");
        }
        if (fileBrokerETC != null) {
            urls.add(fileBrokerETC.toURI().toURL());
        }
        if (fileHome != null) {
            File etcFile = new File(fileHome, "etc");
            urls.add(etcFile.toURI().toURL());
        }
        for (File bootdir : dirs) {
            if (!bootdir.exists() || !bootdir.isDirectory()) continue;
            ArrayList<File> files = new ArrayList<File>();
            for (File f : bootdir.listFiles()) {
                if (!f.getName().endsWith(".jar") && !f.getName().endsWith(".zip")) continue;
                files.add(f);
            }
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file, File file1) {
                    return file.getName().compareTo(file1.getName());
                }
            });
            for (File f : files) {
                Artemis.add(urls, f);
            }
        }
        if (System.getProperty("java.io.tmpdir") == null && fileInstance != null) {
            System.setProperty("java.io.tmpdir", new File(fileInstance, "tmp").getCanonicalPath());
        }
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> clazz = loader.loadClass("org.apache.activemq.artemis.cli.Artemis");
        Method method = clazz.getMethod("execute", Boolean.TYPE, Boolean.TYPE, File.class, File.class, File.class, args.getClass());
        try {
            Object f = method.invoke(null, useSystemOut, useSystemOut, fileHome, fileInstance, fileBrokerETC, args);
            return f;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private static void add(ArrayList<URL> urls, File file) {
        try {
            urls.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

