/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV2;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPConverter;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AMQPMessage
extends RefCountMessage {
    public static final SimpleString ADDRESS_PROPERTY = SimpleString.toSimpleString((String)"_AMQ_AD");
    public static final int DEFAULT_MESSAGE_PRIORITY = 4;
    public static final int MAX_MESSAGE_PRIORITY = 9;
    final long messageFormat;
    ReadableBuffer data;
    boolean bufferValid;
    Boolean durable;
    long messageID;
    SimpleString address;
    MessageImpl protonMessage;
    private volatile int memoryEstimate = -1;
    private long expiration = 0L;
    private int headerEnds = 0;
    private int messagePaylodStart = 0;
    private boolean parsedHeaders = false;
    private Header _header;
    private DeliveryAnnotations _deliveryAnnotations;
    private MessageAnnotations _messageAnnotations;
    private Properties _properties;
    private int deliveryAnnotationsPosition = -1;
    private int appLocation = -1;
    private ApplicationProperties applicationProperties;
    private long scheduledTime = -1L;
    private String connectionID;
    private final CoreMessageObjectPools coreMessageObjectPools;
    Set<Object> rejectedConsumers;
    private volatile TypedProperties extraProperties;

    public AMQPMessage(long messageFormat, byte[] data, TypedProperties extraProperties) {
        this(messageFormat, data, extraProperties, null);
    }

    public AMQPMessage(long messageFormat, byte[] data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this(messageFormat, (ReadableBuffer)ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(data)), extraProperties, coreMessageObjectPools);
    }

    public AMQPMessage(long messageFormat, ReadableBuffer data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this.data = data;
        this.messageFormat = messageFormat;
        this.bufferValid = true;
        this.coreMessageObjectPools = coreMessageObjectPools;
        this.extraProperties = extraProperties == null ? null : new TypedProperties(extraProperties);
        this.parseHeaders();
    }

    public AMQPMessage(long messageFormat) {
        this.messageFormat = messageFormat;
        this.bufferValid = false;
        this.coreMessageObjectPools = null;
    }

    public AMQPMessage(long messageFormat, org.apache.qpid.proton.message.Message message) {
        this.messageFormat = messageFormat;
        this.protonMessage = (MessageImpl)message;
        this.bufferValid = false;
        this.coreMessageObjectPools = null;
    }

    public AMQPMessage(org.apache.qpid.proton.message.Message message) {
        this(0L, message);
    }

    public synchronized MessageImpl getProtonMessage() {
        if (this.protonMessage == null) {
            this.protonMessage = (MessageImpl)Message.Factory.create();
            if (this.data != null) {
                this.data.rewind();
                this.protonMessage.decode(this.data.duplicate());
                this._header = this.protonMessage.getHeader();
                this.protonMessage.setHeader(null);
            }
        }
        return this.protonMessage;
    }

    private void initalizeObjects() {
        if (this.protonMessage == null && this.data == null) {
            this.headerEnds = 0;
            this.messagePaylodStart = 0;
            this._header = new Header();
            this._deliveryAnnotations = new DeliveryAnnotations(new HashMap());
            this._properties = new Properties();
            this.applicationProperties = new ApplicationProperties(new HashMap());
            this.protonMessage = (MessageImpl)Message.Factory.create();
            this.protonMessage.setApplicationProperties(this.applicationProperties);
            this.protonMessage.setDeliveryAnnotations(this._deliveryAnnotations);
        }
    }

    private Map<String, Object> getApplicationPropertiesMap() {
        ApplicationProperties appMap = this.getApplicationProperties();
        HashMap map = null;
        if (appMap != null) {
            map = appMap.getValue();
        }
        if (map == null) {
            map = new HashMap();
            this.applicationProperties = new ApplicationProperties(map);
        }
        return map;
    }

    private ApplicationProperties getApplicationProperties() {
        this.parseHeaders();
        if (this.applicationProperties == null && this.appLocation >= 0) {
            ReadableBuffer buffer = this.data.duplicate();
            buffer.position(this.appLocation);
            TLSEncode.getDecoder().setBuffer(buffer);
            Object section = TLSEncode.getDecoder().readObject();
            this.applicationProperties = (ApplicationProperties)section;
            this.appLocation = -1;
            TLSEncode.getDecoder().setBuffer(null);
        }
        return this.applicationProperties;
    }

    private DeliveryAnnotations getDeliveryAnnotations() {
        this.parseHeaders();
        if (this._deliveryAnnotations == null && this.deliveryAnnotationsPosition >= 0) {
            ReadableBuffer buffer = this.data.duplicate();
            buffer.position(this.deliveryAnnotationsPosition);
            TLSEncode.getDecoder().setBuffer(buffer);
            Object section = TLSEncode.getDecoder().readObject();
            this._deliveryAnnotations = (DeliveryAnnotations)section;
            this.deliveryAnnotationsPosition = -1;
            TLSEncode.getDecoder().setBuffer(null);
        }
        return this._deliveryAnnotations;
    }

    private synchronized void parseHeaders() {
        if (!this.parsedHeaders) {
            if (this.data == null) {
                this.initalizeObjects();
            } else {
                this.partialDecode(this.data);
            }
            this.parsedHeaders = true;
        }
    }

    public Message setConnectionID(String connectionID) {
        this.connectionID = connectionID;
        return this;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public MessageAnnotations getMessageAnnotations() {
        this.parseHeaders();
        return this._messageAnnotations;
    }

    public Header getHeader() {
        this.parseHeaders();
        return this._header;
    }

    public Properties getProperties() {
        this.parseHeaders();
        return this._properties;
    }

    private Object getSymbol(String symbol) {
        return this.getSymbol(Symbol.getSymbol((String)symbol));
    }

    private Object getSymbol(Symbol symbol) {
        Map mapAnnotations;
        MessageAnnotations annotations = this.getMessageAnnotations();
        Map map = mapAnnotations = annotations != null ? annotations.getValue() : null;
        if (mapAnnotations != null) {
            return mapAnnotations.get(symbol);
        }
        return null;
    }

    private Object removeSymbol(Symbol symbol) {
        Map mapAnnotations;
        MessageAnnotations annotations = this.getMessageAnnotations();
        Map map = mapAnnotations = annotations != null ? annotations.getValue() : null;
        if (mapAnnotations != null) {
            return mapAnnotations.remove(symbol);
        }
        return null;
    }

    private void setSymbol(String symbol, Object value) {
        this.setSymbol(Symbol.getSymbol((String)symbol), value);
    }

    private void setSymbol(Symbol symbol, Object value) {
        Map mapAnnotations;
        MessageAnnotations annotations = this.getMessageAnnotations();
        if (annotations == null) {
            annotations = this._messageAnnotations = new MessageAnnotations(new HashMap());
        }
        Map map = mapAnnotations = annotations != null ? annotations.getValue() : null;
        if (mapAnnotations != null) {
            mapAnnotations.put(symbol, value);
        }
    }

    public RoutingType getRoutingType() {
        Object routingType = this.getSymbol(AMQPMessageSupport.ROUTING_TYPE);
        if (routingType != null) {
            return RoutingType.getType((byte)((Byte)routingType));
        }
        routingType = this.getSymbol(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION);
        if (routingType != null) {
            if (0 == (Byte)routingType || 2 == (Byte)routingType) {
                return RoutingType.ANYCAST;
            }
            if (1 == (Byte)routingType || 3 == (Byte)routingType) {
                return RoutingType.MULTICAST;
            }
        } else {
            return null;
        }
        return null;
    }

    public Message setRoutingType(RoutingType routingType) {
        this.parseHeaders();
        if (routingType == null) {
            this.removeSymbol(AMQPMessageSupport.ROUTING_TYPE);
        } else {
            this.setSymbol(AMQPMessageSupport.ROUTING_TYPE, (Object)routingType.getType());
        }
        return this;
    }

    public SimpleString getGroupID() {
        this.parseHeaders();
        if (this._properties != null && this._properties.getGroupId() != null) {
            return SimpleString.toSimpleString((String)this._properties.getGroupId(), this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getGroupIdStringSimpleStringPool());
        }
        return null;
    }

    public Long getScheduledDeliveryTime() {
        if (this.scheduledTime < 0L) {
            Object objscheduledTime = this.getSymbol("x-opt-delivery-time");
            Object objdelay = this.getSymbol("x-opt-delivery-delay");
            this.scheduledTime = objscheduledTime != null && objscheduledTime instanceof Number ? ((Number)objscheduledTime).longValue() : (objdelay != null && objdelay instanceof Number ? System.currentTimeMillis() + ((Number)objdelay).longValue() : 0L);
        }
        return this.scheduledTime;
    }

    public AMQPMessage setScheduledDeliveryTime(Long time) {
        this.parseHeaders();
        this.setSymbol(AMQPMessageSupport.JMS_DELIVERY_TIME, (Object)time);
        return this;
    }

    public Persister<Message> getPersister() {
        return AMQPMessagePersisterV2.getInstance();
    }

    public synchronized boolean acceptsConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            return true;
        }
        return !this.rejectedConsumers.contains(consumer);
    }

    public synchronized void rejectConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            this.rejectedConsumers = new HashSet<Object>();
        }
        this.rejectedConsumers.add(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void partialDecode(ReadableBuffer buffer) {
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setBuffer(buffer.rewind());
        this._header = null;
        this.expiration = 0L;
        this.headerEnds = 0;
        this.messagePaylodStart = 0;
        this._deliveryAnnotations = null;
        this._messageAnnotations = null;
        this._properties = null;
        this.applicationProperties = null;
        this.appLocation = -1;
        this.deliveryAnnotationsPosition = -1;
        try {
            while (buffer.hasRemaining()) {
                int constructorPos = buffer.position();
                TypeConstructor constructor = decoder.readConstructor();
                if (Header.class.equals((Object)constructor.getTypeClass())) {
                    this._header = (Header)constructor.readValue();
                    this.headerEnds = this.messagePaylodStart = buffer.position();
                    this.durable = this._header.getDurable();
                    if (this._header.getTtl() == null) continue;
                    this.expiration = System.currentTimeMillis() + (long)this._header.getTtl().intValue();
                    continue;
                }
                if (DeliveryAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    constructor.skipValue();
                    this.deliveryAnnotationsPosition = constructorPos;
                    this.messagePaylodStart = buffer.position();
                    continue;
                }
                if (MessageAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    this._messageAnnotations = (MessageAnnotations)constructor.readValue();
                    continue;
                }
                if (Properties.class.equals((Object)constructor.getTypeClass())) {
                    this._properties = (Properties)constructor.readValue();
                    if (this._properties.getAbsoluteExpiryTime() != null && this._properties.getAbsoluteExpiryTime().getTime() > 0L) {
                        this.expiration = this._properties.getAbsoluteExpiryTime().getTime();
                    }
                    if (buffer.hasRemaining() && ApplicationProperties.class.equals((Object)(constructor = decoder.peekConstructor()).getTypeClass())) {
                        this.appLocation = buffer.position();
                    }
                } else if (ApplicationProperties.class.equals((Object)constructor.getTypeClass())) {
                    this.appLocation = constructorPos;
                }
                break;
            }
        }
        finally {
            decoder.setByteBuffer(null);
            buffer.position(0);
        }
    }

    public long getMessageFormat() {
        return this.messageFormat;
    }

    public void messageChanged() {
        this.bufferValid = false;
        this.data = null;
    }

    public ByteBuf getBuffer() {
        if (this.data == null) {
            return null;
        }
        return Unpooled.wrappedBuffer((ByteBuffer)this.data.byteBuffer());
    }

    public AMQPMessage setBuffer(ByteBuf buffer) {
        this.data = null;
        return this;
    }

    public Message copy() {
        this.checkBuffer();
        ReadableBuffer view = this.data.duplicate();
        byte[] newData = new byte[view.remaining() - (this.messagePaylodStart - this.headerEnds)];
        view.position(0).limit(this.headerEnds);
        view.get(newData, 0, this.headerEnds);
        view.clear();
        view.position(this.messagePaylodStart);
        view.get(newData, this.headerEnds, view.remaining());
        AMQPMessage newEncode = new AMQPMessage(this.messageFormat, newData, this.extraProperties, this.coreMessageObjectPools);
        newEncode.setDurable(this.isDurable()).setMessageID(this.getMessageID());
        return newEncode;
    }

    public Message copy(long newID) {
        this.checkBuffer();
        return this.copy().setMessageID(newID);
    }

    public long getMessageID() {
        return this.messageID;
    }

    public Message setMessageID(long id) {
        this.messageID = id;
        return this;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public AMQPMessage setExpiration(long expiration) {
        Properties properties = this.getProperties();
        if (properties != null) {
            if (expiration <= 0L) {
                properties.setAbsoluteExpiryTime(null);
            } else {
                properties.setAbsoluteExpiryTime(new Date(expiration));
            }
        }
        this.expiration = expiration;
        return this;
    }

    public Object getUserID() {
        Properties properties = this.getProperties();
        if (properties != null && properties.getMessageId() != null) {
            return properties.getMessageId();
        }
        return null;
    }

    public Object getAMQPUserID() {
        Properties properties = this.getProperties();
        if (properties != null && properties.getUserId() != null) {
            Binary binary = properties.getUserId();
            return new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public Message setUserID(Object userID) {
        return null;
    }

    public boolean isDurable() {
        if (this.durable != null) {
            return this.durable;
        }
        this.parseHeaders();
        if (this.getHeader() != null && this.getHeader().getDurable() != null) {
            this.durable = this.getHeader().getDurable();
            return this.durable;
        }
        return this.durable != null ? this.durable : false;
    }

    public Object getDuplicateProperty() {
        return null;
    }

    public Message setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public String getAddress() {
        SimpleString addressSimpleString = this.getAddressSimpleString();
        return addressSimpleString == null ? null : addressSimpleString.toString();
    }

    public SimpleString cachedAddressSimpleString(String address) {
        return CoreMessageObjectPools.cachedAddressSimpleString((String)address, (CoreMessageObjectPools)this.coreMessageObjectPools);
    }

    public AMQPMessage setAddress(String address) {
        this.setAddress(this.cachedAddressSimpleString(address));
        return this;
    }

    public AMQPMessage setAddress(SimpleString address) {
        this.address = address;
        this.createExtraProperties().putSimpleStringProperty(ADDRESS_PROPERTY, address);
        return this;
    }

    public SimpleString getAddressSimpleString() {
        if (this.address == null) {
            Properties properties;
            TypedProperties extraProperties = this.getExtraProperties();
            if (extraProperties != null) {
                this.address = extraProperties.getSimpleStringProperty(ADDRESS_PROPERTY);
            }
            if (this.address == null && (properties = this.getProperties()) != null && properties.getTo() != null) {
                this.address = this.cachedAddressSimpleString(properties.getTo());
            }
        }
        return this.address;
    }

    public long getTimestamp() {
        if (this.getProperties() != null && this.getProperties().getCreationTime() != null) {
            return this.getProperties().getCreationTime().getTime();
        }
        return 0L;
    }

    public Message setTimestamp(long timestamp) {
        this.getProperties().setCreationTime(new Date(timestamp));
        return this;
    }

    public byte getPriority() {
        if (this.getHeader() != null && this.getHeader().getPriority() != null) {
            return (byte)Math.min(this.getHeader().getPriority().intValue(), 9);
        }
        return 4;
    }

    public Message setPriority(byte priority) {
        this.getHeader().setPriority(UnsignedByte.valueOf((byte)priority));
        return this;
    }

    public void receiveBuffer(ByteBuf buffer) {
    }

    private synchronized void checkBuffer() {
        if (!this.bufferValid) {
            this.encodeProtonMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeProtonMessage() {
        int estimated = Math.max(1500, this.data != null ? this.data.capacity() + 1000 : 0);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(estimated);
        try {
            this.getProtonMessage().encode((WritableBuffer)new NettyWritable(buffer));
            byte[] bytes = new byte[buffer.writerIndex()];
            buffer.readBytes(bytes);
            this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(bytes));
            this.bufferValid = true;
        }
        finally {
            buffer.release();
        }
    }

    public int getEncodeSize() {
        this.checkBuffer();
        return this.data.remaining() - this.messagePaylodStart + 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBuffer(ByteBuf buffer, int deliveryCount) {
        this.checkBuffer();
        int amqpDeliveryCount = deliveryCount - 1;
        if (amqpDeliveryCount > 0) {
            Header header = this.getHeader();
            if (header == null) {
                header = new Header();
                header.setDurable(this.durable);
            }
            Header header2 = header;
            synchronized (header2) {
                header.setDeliveryCount(UnsignedInteger.valueOf((int)amqpDeliveryCount));
                TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(buffer));
                TLSEncode.getEncoder().writeObject((Object)header);
                TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            }
        } else if (this.headerEnds > 0) {
            buffer.writeBytes(this.data.duplicate().limit(this.headerEnds).byteBuffer());
        }
        this.data.position(this.messagePaylodStart);
        buffer.writeBytes(this.data.byteBuffer());
        this.data.position(0);
    }

    public ReadableBuffer getSendBuffer(int deliveryCount) {
        this.checkBuffer();
        if (deliveryCount > 1) {
            return this.createCopyWithNewDeliveryCount(deliveryCount);
        }
        if (this.headerEnds != this.messagePaylodStart) {
            return this.createCopyWithoutDeliveryAnnotations();
        }
        return this.data.duplicate();
    }

    private ReadableBuffer createCopyWithoutDeliveryAnnotations() {
        assert (this.headerEnds != this.messagePaylodStart);
        ReadableBuffer duplicate = this.data.duplicate();
        ByteBuf result = PooledByteBufAllocator.DEFAULT.heapBuffer(this.getEncodeSize());
        result.writeBytes(duplicate.limit(this.headerEnds).byteBuffer());
        duplicate.clear();
        duplicate.position(this.messagePaylodStart);
        result.writeBytes(duplicate.byteBuffer());
        return new NettyReadable(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadableBuffer createCopyWithNewDeliveryCount(int deliveryCount) {
        assert (deliveryCount > 1);
        int amqpDeliveryCount = deliveryCount - 1;
        ByteBuf result = PooledByteBufAllocator.DEFAULT.heapBuffer(this.getEncodeSize());
        Header header = this.getHeader();
        if (header == null) {
            header = new Header();
            header.setDurable(this.durable);
        }
        Header header2 = header;
        synchronized (header2) {
            header.setDeliveryCount(UnsignedInteger.valueOf((int)amqpDeliveryCount));
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(result));
            TLSEncode.getEncoder().writeObject((Object)header);
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        }
        this.data.position(this.messagePaylodStart);
        result.writeBytes(this.data.byteBuffer());
        this.data.position(0);
        return new NettyReadable(result);
    }

    public TypedProperties createExtraProperties() {
        if (this.extraProperties == null) {
            this.extraProperties = new TypedProperties();
        }
        return this.extraProperties;
    }

    public TypedProperties getExtraProperties() {
        return this.extraProperties;
    }

    public AMQPMessage setExtraProperties(TypedProperties extraProperties) {
        this.extraProperties = extraProperties;
        return this;
    }

    public Message putExtraBytesProperty(SimpleString key, byte[] value) {
        this.createExtraProperties().putBytesProperty(key, value);
        return this;
    }

    public byte[] getExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return this.extraProperties.getBytesProperty(key);
    }

    public byte[] removeExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return (byte[])this.extraProperties.removeProperty(key);
    }

    public Message putBooleanProperty(String key, boolean value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putByteProperty(String key, byte value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putBytesProperty(String key, byte[] value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putShortProperty(String key, short value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putCharProperty(String key, char value) {
        this.getApplicationPropertiesMap().put(key, Character.valueOf(value));
        return this;
    }

    public Message putIntProperty(String key, int value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putLongProperty(String key, long value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putFloatProperty(String key, float value) {
        this.getApplicationPropertiesMap().put(key, Float.valueOf(value));
        return this;
    }

    public Message putDoubleProperty(String key, double value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putBooleanProperty(SimpleString key, boolean value) {
        this.getApplicationPropertiesMap().put(key.toString(), value);
        return this;
    }

    public Message putByteProperty(SimpleString key, byte value) {
        return this.putByteProperty(key.toString(), value);
    }

    public Message putBytesProperty(SimpleString key, byte[] value) {
        return this.putBytesProperty(key.toString(), value);
    }

    public Message putShortProperty(SimpleString key, short value) {
        return this.putShortProperty(key.toString(), value);
    }

    public Message putCharProperty(SimpleString key, char value) {
        return this.putCharProperty(key.toString(), value);
    }

    public Message putIntProperty(SimpleString key, int value) {
        return this.putIntProperty(key.toString(), value);
    }

    public Message putLongProperty(SimpleString key, long value) {
        return this.putLongProperty(key.toString(), value);
    }

    public Message putFloatProperty(SimpleString key, float value) {
        return this.putFloatProperty(key.toString(), value);
    }

    public Message putDoubleProperty(SimpleString key, double value) {
        return this.putDoubleProperty(key.toString(), value);
    }

    public Message putStringProperty(String key, String value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        return this.putObjectProperty(key.toString(), value);
    }

    public Object removeProperty(String key) {
        return this.getApplicationPropertiesMap().remove(key);
    }

    public boolean containsProperty(String key) {
        return this.getApplicationPropertiesMap().containsKey(key);
    }

    public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return (Boolean)this.getApplicationPropertiesMap().get(key);
    }

    public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return (Byte)this.getApplicationPropertiesMap().get(key);
    }

    public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return (Double)this.getApplicationPropertiesMap().get(key);
    }

    public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return (Integer)this.getApplicationPropertiesMap().get(key);
    }

    public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return (Long)this.getApplicationPropertiesMap().get(key);
    }

    public Object getObjectProperty(String key) {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            if (this.getProperties() != null) {
                return this.getProperties().getSubject();
            }
        } else {
            if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
                return this.getConnectionID();
            }
            if (key.equals("JMSXGroupID")) {
                return this.getGroupID();
            }
            if (key.equals("JMSXUserID")) {
                return this.getAMQPUserID();
            }
            if (key.equals(MessageUtil.CORRELATIONID_HEADER_NAME.toString())) {
                if (this.getProperties() != null && this.getProperties().getCorrelationId() != null) {
                    return AMQPMessageIdHelper.INSTANCE.toCorrelationIdString(this.getProperties().getCorrelationId());
                }
            } else {
                Object value = this.getApplicationPropertiesMap().get(key);
                if (value instanceof UnsignedInteger || value instanceof UnsignedByte || value instanceof UnsignedLong || value instanceof UnsignedShort) {
                    return ((Number)value).longValue();
                }
                return value;
            }
        }
        return null;
    }

    public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return (Short)this.getApplicationPropertiesMap().get(key);
    }

    public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return (Float)this.getApplicationPropertiesMap().get(key);
    }

    public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            return this.getProperties().getSubject();
        }
        if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
            return this.getConnectionID();
        }
        return (String)this.getApplicationPropertiesMap().get(key);
    }

    public Object removeAnnotation(SimpleString key) {
        return this.removeSymbol(Symbol.getSymbol((String)key.toString()));
    }

    public Object getAnnotation(SimpleString key) {
        return this.getSymbol(key.toString());
    }

    public AMQPMessage setAnnotation(SimpleString key, Object value) {
        this.setSymbol(key.toString(), value);
        return this;
    }

    public void reencode() {
        this.parseHeaders();
        this.getApplicationProperties();
        this.getDeliveryAnnotations();
        if (this._header != null) {
            this.getProtonMessage().setHeader(this._header);
        }
        if (this._deliveryAnnotations != null) {
            this.getProtonMessage().setDeliveryAnnotations(this._deliveryAnnotations);
        }
        if (this._messageAnnotations != null) {
            this.getProtonMessage().setMessageAnnotations(this._messageAnnotations);
        }
        if (this.applicationProperties != null) {
            this.getProtonMessage().setApplicationProperties(this.applicationProperties);
        }
        if (this._properties != null) {
            if (this.address != null) {
                this._properties.setTo(this.address.toString());
            }
            this.getProtonMessage().setProperties(this._properties);
        }
        this.bufferValid = false;
        this.checkBuffer();
    }

    public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return SimpleString.toSimpleString((String)((String)this.getApplicationPropertiesMap().get(key)), (SimpleString.StringSimpleStringPool)this.getPropertyValuesPool());
    }

    public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return (byte[])this.getApplicationPropertiesMap().get(key);
    }

    public Object removeProperty(SimpleString key) {
        return this.removeProperty(key.toString());
    }

    public boolean containsProperty(SimpleString key) {
        return this.containsProperty(key.toString());
    }

    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBooleanProperty(key.toString());
    }

    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(key.toString());
    }

    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getDoubleProperty(key.toString());
    }

    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(key.toString());
    }

    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getLongProperty(key.toString());
    }

    public Object getObjectProperty(SimpleString key) {
        return this.getObjectProperty(key.toString());
    }

    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getShortProperty(key.toString());
    }

    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getFloatProperty(key.toString());
    }

    public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(key.toString());
    }

    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getSimpleStringProperty(key.toString());
    }

    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(key.toString());
    }

    public Message putStringProperty(SimpleString key, SimpleString value) {
        return this.putStringProperty(key.toString(), value.toString());
    }

    public Message putStringProperty(SimpleString key, String value) {
        return this.putStringProperty(key.toString(), value);
    }

    public Set<SimpleString> getPropertyNames() {
        HashSet<SimpleString> values = new HashSet<SimpleString>();
        for (String k : this.getApplicationPropertiesMap().keySet()) {
            values.add(SimpleString.toSimpleString((String)k.toString(), (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
        }
        return values;
    }

    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 352 + (this.data != null ? this.data.capacity() : 0);
        }
        return this.memoryEstimate;
    }

    public ICoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        try {
            return AMQPConverter.getInstance().toCore(this, coreMessageObjectPools);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ICoreMessage toCore() {
        return this.toCore(null);
    }

    public SimpleString getLastValueProperty() {
        return this.getSimpleStringProperty(HDR_LAST_VALUE_NAME);
    }

    public Message setLastValueProperty(SimpleString lastValueName) {
        return this.putStringProperty(HDR_LAST_VALUE_NAME, lastValueName);
    }

    public SimpleString getReplyTo() {
        if (this.getProperties() != null) {
            return SimpleString.toSimpleString((String)this.getProperties().getReplyTo());
        }
        return null;
    }

    public AMQPMessage setReplyTo(SimpleString address) {
        if (this.getProperties() != null) {
            this.getProperties().setReplyTo(address != null ? address.toString() : null);
        }
        return this;
    }

    public int getPersistSize() {
        this.checkBuffer();
        return 4 + this.internalPersistSize();
    }

    private int internalPersistSize() {
        return this.data.remaining();
    }

    public void persist(ActiveMQBuffer targetRecord) {
        this.checkBuffer();
        targetRecord.writeInt(this.internalPersistSize());
        if (this.data.hasArray()) {
            targetRecord.writeBytes(this.data.array(), this.data.arrayOffset(), this.data.remaining());
        } else {
            targetRecord.writeBytes(this.data.byteBuffer());
        }
    }

    public void reloadPersistence(ActiveMQBuffer record) {
        int size = record.readInt();
        byte[] recordArray = new byte[size];
        record.readBytes(recordArray);
        this.messagePaylodStart = 0;
        this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(recordArray));
        this.bufferValid = true;
        this.durable = true;
        this.parseHeaders();
    }

    public String toString() {
        return "AMQPMessage [durable=" + this.isDurable() + ", messageID=" + this.getMessageID() + ", address=" + this.getAddress() + ", size=" + this.getEncodeSize() + ", applicationProperties=" + this.getApplicationProperties() + ", properties=" + this.getProperties() + ", extraProperties = " + this.getExtraProperties() + "]";
    }

    private SimpleString.StringSimpleStringPool getPropertyKeysPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyKeysPool();
    }

    private SimpleString.StringSimpleStringPool getPropertyValuesPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyValuesPool();
    }

    public long getPersistentSize() throws ActiveMQException {
        return this.getEncodeSize();
    }
}

