/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSender;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToAddressSender;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBridgeToAddressPolicyManager
extends AMQPBridgeToPolicyManager
implements ActiveMQServerAddressPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPBridgeAddressPolicy policy;
    private final Map<String, AMQPBridgeAddressSenderManager> addressTracking = new HashMap<String, AMQPBridgeAddressSenderManager>();

    public AMQPBridgeToAddressPolicyManager(AMQPBridgeManager bridge, AMQPBridgeMetrics metrics, AMQPBridgeAddressPolicy policy) {
        super(bridge, metrics, policy.getPolicyName(), AMQPBridgeType.BRIDGE_TO_ADDRESS);
        Objects.requireNonNull(policy, "The Address match policy cannot be null");
        this.policy = policy;
    }

    @Override
    public AMQPBridgeAddressPolicy getPolicy() {
        return this.policy;
    }

    @Override
    protected void scanManagedResources() {
        this.server.getPostOffice().getAddresses().stream().map(address -> this.server.getAddressInfo(address)).forEach(addressInfo -> this.afterAddAddress((AddressInfo)addressInfo, false));
    }

    @Override
    protected void safeCleanupManagerResources() {
        try {
            this.addressTracking.forEach((k, v) -> v.shutdownNow());
        }
        finally {
            this.addressTracking.clear();
        }
    }

    public synchronized void afterAddAddress(AddressInfo addressInfo, boolean reload) {
        if (this.isActive() && this.policy.test(addressInfo)) {
            try {
                AMQPBridgeAddressSenderManager manager = new AMQPBridgeAddressSenderManager(this, this.configuration, addressInfo);
                this.addressTracking.put(manager.getAddress(), manager);
                manager.start();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.bridgeBindingsLookupError(addressInfo.getName(), (Throwable)e);
            }
        }
    }

    public synchronized void afterRemoveAddress(SimpleString address, AddressInfo addressInfo) throws ActiveMQException {
        AMQPBridgeAddressSenderManager manager;
        if (this.isActive() && (manager = this.addressTracking.remove(address.toString())) != null) {
            logger.trace("Clearing sender tracking for removed bridged Address {}", (Object)addressInfo.getName());
            manager.shutdownNow();
        }
    }

    private AMQPBridgeSender createBridgeSender(AMQPBridgeSenderInfo senderInfo) {
        Objects.requireNonNull(senderInfo, "AMQP Bridge Address sender information object was null");
        if (logger.isTraceEnabled()) {
            logger.trace("AMQP Bridge {} creating address sender: {} for policy: {}", new Object[]{this.bridge.getName(), senderInfo, this.policy.getPolicyName()});
        }
        return new AMQPBridgeToAddressSender(this, this.configuration, this.session, senderInfo, this.metrics.newSenderMetrics());
    }

    private String generateTempQueueName(String remoteAddress) {
        return "amqp-bridge-" + this.bridge.getName() + "-policy-" + this.policyName + "-address-sender-to-" + remoteAddress + "-" + UUID.randomUUID().toString();
    }

    private AMQPBridgeSenderInfo createSenderInfo(AddressInfo address) {
        String addressName = address.getName().toString();
        StringBuilder remoteAddressBuilder = new StringBuilder();
        if (this.policy.getRemoteAddressPrefix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressPrefix());
        }
        if (this.policy.getRemoteAddress() != null && !this.policy.getRemoteAddress().isBlank()) {
            remoteAddressBuilder.append(this.policy.getRemoteAddress());
        } else {
            remoteAddressBuilder.append(addressName);
        }
        if (this.policy.getRemoteAddressSuffix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressSuffix());
        }
        String remoteAddress = remoteAddressBuilder.toString();
        return new AMQPBridgeSenderInfo(AMQPBridgeSenderInfo.Role.ADDRESS_SENDER, addressName, this.generateTempQueueName(remoteAddress), address.getRoutingType(), remoteAddress);
    }

    private static class AMQPBridgeAddressSenderManager
    extends AMQPBridgeSenderManager {
        private final AMQPBridgeToAddressPolicyManager manager;
        private final AddressInfo addressInfo;

        AMQPBridgeAddressSenderManager(AMQPBridgeToAddressPolicyManager manager, AMQPBridgeSenderConfiguration configuration, AddressInfo addressInfo) {
            super(manager, configuration);
            this.manager = manager;
            this.addressInfo = addressInfo;
        }

        public String getAddress() {
            return this.addressInfo.getName().toString();
        }

        @Override
        protected AMQPBridgeSender createBridgeSender() {
            return this.manager.createBridgeSender(this.manager.createSenderInfo(this.addressInfo));
        }
    }
}

