/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.openmbean.MessageOpenTypeFactory;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageSymbolSearch;
import org.apache.activemq.artemis.protocol.amqp.broker.KMPNeedle;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.AmqpCoreConverter;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPMessage
extends RefCountMessage
implements Message {
    private static final SimpleString ANNOTATION_AREA_PREFIX = SimpleString.of((String)"m.");
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final SimpleString ADDRESS_PROPERTY = SimpleString.of((String)"_AMQ_AD");
    private static final Symbol[] SCHEDULED_DELIVERY_SYMBOLS = new Symbol[]{AMQPMessageSupport.SCHEDULED_DELIVERY_TIME, AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY};
    private static final KMPNeedle[] SCHEDULED_DELIVERY_NEEDLES = new KMPNeedle[]{AMQPMessageSymbolSearch.kmpNeedleOf(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME), AMQPMessageSymbolSearch.kmpNeedleOf(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY)};
    private static final KMPNeedle[] DUPLICATE_ID_NEEDLES = new KMPNeedle[]{AMQPMessageSymbolSearch.kmpNeedleOf(Message.HDR_DUPLICATE_DETECTION_ID.toString())};
    public static final int DEFAULT_MESSAGE_FORMAT = 0;
    public static final int DEFAULT_MESSAGE_PRIORITY = 4;
    public static final int MAX_MESSAGE_PRIORITY = 9;
    protected static final int VALUE_NOT_PRESENT = -1;
    protected byte messageDataScanned;
    protected boolean modified;
    protected int headerPosition;
    protected int encodedHeaderSize;
    protected int deliveryAnnotationsPosition;
    protected int encodedDeliveryAnnotationsSize;
    protected int messageAnnotationsPosition;
    protected int propertiesPosition;
    protected int applicationPropertiesPosition;
    protected int remainingBodyPosition;
    protected final long messageFormat;
    protected long messageID;
    protected SimpleString address;
    protected volatile int memoryEstimate;
    protected volatile int originalEstimate;
    protected long expiration;
    protected boolean expirationReload;
    protected long scheduledTime;
    protected byte priority;
    protected boolean isPaged;
    protected Header header;
    protected MessageAnnotations messageAnnotations;
    protected Properties properties;
    protected ApplicationProperties applicationProperties;
    protected String connectionID;
    protected final CoreMessageObjectPools coreMessageObjectPools;
    protected Set<Object> rejectedConsumers;
    protected DeliveryAnnotations deliveryAnnotationsForSendBuffer;
    protected DeliveryAnnotations deliveryAnnotations;
    protected volatile TypedProperties extraProperties;
    private volatile Object owner;
    private static MessageOpenTypeFactory AMQP_FACTORY = new AmqpMessageOpenTypeFactory();

    public AMQPMessage(long messageFormat, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this.messageDataScanned = MessageDataScanningStatus.NOT_SCANNED.code;
        this.headerPosition = -1;
        this.deliveryAnnotationsPosition = -1;
        this.messageAnnotationsPosition = -1;
        this.propertiesPosition = -1;
        this.applicationPropertiesPosition = -1;
        this.remainingBodyPosition = -1;
        this.memoryEstimate = -1;
        this.originalEstimate = -1;
        this.expirationReload = false;
        this.scheduledTime = -1L;
        this.priority = (byte)4;
        this.messageFormat = messageFormat;
        this.coreMessageObjectPools = coreMessageObjectPools;
        this.extraProperties = extraProperties == null ? null : new TypedProperties(extraProperties);
    }

    protected AMQPMessage(AMQPMessage copy) {
        this(copy.messageFormat, copy.extraProperties, copy.coreMessageObjectPools);
        this.headerPosition = copy.headerPosition;
        this.encodedHeaderSize = copy.encodedHeaderSize;
        this.header = copy.header == null ? null : new Header(copy.header);
        this.deliveryAnnotationsPosition = copy.deliveryAnnotationsPosition;
        this.encodedDeliveryAnnotationsSize = copy.encodedDeliveryAnnotationsSize;
        this.deliveryAnnotations = copy.deliveryAnnotations == null ? null : new DeliveryAnnotations(copy.deliveryAnnotations.getValue());
        this.messageAnnotationsPosition = copy.messageAnnotationsPosition;
        this.messageAnnotations = AMQPMessage.copyAnnotations(copy.messageAnnotations);
        this.propertiesPosition = copy.propertiesPosition;
        this.properties = copy.properties == null ? null : new Properties(copy.properties);
        this.applicationPropertiesPosition = copy.applicationPropertiesPosition;
        this.applicationProperties = copy.applicationProperties == null ? null : new ApplicationProperties(copy.applicationProperties.getValue());
        this.remainingBodyPosition = copy.remainingBodyPosition;
        this.messageDataScanned = copy.messageDataScanned;
    }

    private static MessageAnnotations copyAnnotations(MessageAnnotations messageAnnotations) {
        if (messageAnnotations == null) {
            return null;
        }
        HashMap newAnnotation = new HashMap();
        messageAnnotations.getValue().forEach((a, b) -> {
            if (!a.toString().startsWith("x-opt-ORIG") && !a.toString().equals("x-opt-routing-type")) {
                newAnnotation.put(a, b);
            }
        });
        return new MessageAnnotations(newAnnotation);
    }

    protected AMQPMessage(long messageFormat) {
        this.messageDataScanned = MessageDataScanningStatus.NOT_SCANNED.code;
        this.headerPosition = -1;
        this.deliveryAnnotationsPosition = -1;
        this.messageAnnotationsPosition = -1;
        this.propertiesPosition = -1;
        this.applicationPropertiesPosition = -1;
        this.remainingBodyPosition = -1;
        this.memoryEstimate = -1;
        this.originalEstimate = -1;
        this.expirationReload = false;
        this.scheduledTime = -1L;
        this.priority = (byte)4;
        this.messageFormat = messageFormat;
        this.coreMessageObjectPools = null;
    }

    public String getProtocolName() {
        return "AMQP";
    }

    public final MessageDataScanningStatus getDataScanningStatus() {
        return MessageDataScanningStatus.valueOf(this.messageDataScanned);
    }

    public boolean isPaged() {
        return this.isPaged;
    }

    public void setPaged() {
        this.isPaged = true;
    }

    protected ApplicationProperties getDecodedApplicationProperties() {
        return this.applicationProperties;
    }

    protected MessageAnnotations getDecodedMessageAnnotations() {
        return this.messageAnnotations;
    }

    protected abstract ReadableBuffer getData();

    public final MessageImpl getProtonMessage() {
        if (this.getData() == null) {
            throw new NullPointerException("Data is not initialized");
        }
        this.ensureScanning();
        MessageImpl protonMessage = null;
        if (this.getData() != null) {
            protonMessage = (MessageImpl)Message.Factory.create();
            this.getData().rewind();
            protonMessage.decode(this.getData().duplicate());
        }
        return protonMessage;
    }

    public Object getObjectPropertyForFilter(SimpleString key) {
        TypedProperties extra;
        if (key.startsWith(ANNOTATION_AREA_PREFIX)) {
            key = key.subSeq(ANNOTATION_AREA_PREFIX.length(), key.length());
            return this.getAnnotation(key);
        }
        Object value = this.getObjectProperty(key);
        if (value == null && (extra = this.getExtraProperties()) != null) {
            value = extra.getProperty(key);
        }
        return value;
    }

    public final Header getHeader() {
        this.ensureScanning();
        return (Header)this.scanForMessageSection(this.headerPosition, Header.class);
    }

    final Header getCurrentHeader() {
        return this.header;
    }

    final Properties getCurrentProperties() {
        return this.properties;
    }

    protected void ensureScanning() {
        this.ensureDataIsValid();
        this.ensureMessageDataScanned();
    }

    Object getDeliveryAnnotationProperty(Symbol symbol) {
        DeliveryAnnotations daToUse = this.deliveryAnnotations;
        if (daToUse == null) {
            daToUse = this.getDeliveryAnnotations();
        }
        if (daToUse == null) {
            return null;
        }
        return daToUse.getValue().get(symbol);
    }

    public final DeliveryAnnotations getDeliveryAnnotations() {
        this.ensureScanning();
        return (DeliveryAnnotations)this.scanForMessageSection(this.deliveryAnnotationsPosition, DeliveryAnnotations.class);
    }

    @Deprecated
    public final void setDeliveryAnnotationsForSendBuffer(DeliveryAnnotations deliveryAnnotations) {
        this.deliveryAnnotationsForSendBuffer = deliveryAnnotations;
    }

    public final MessageAnnotations getMessageAnnotations() {
        this.ensureScanning();
        return (MessageAnnotations)this.scanForMessageSection(this.messageAnnotationsPosition, MessageAnnotations.class);
    }

    public final Properties getProperties() {
        this.ensureScanning();
        return (Properties)this.scanForMessageSection(this.propertiesPosition, Properties.class);
    }

    public final ApplicationProperties getApplicationProperties() {
        this.ensureScanning();
        return (ApplicationProperties)this.scanForMessageSection(this.applicationPropertiesPosition, ApplicationProperties.class);
    }

    public final String toDebugString() {
        return ByteUtil.debugByteArray((byte[])this.getData().array());
    }

    public final Section getBody() {
        this.ensureScanning();
        return (Section)this.scanForMessageSection(Math.max(0, this.remainingBodyPosition), AmqpSequence.class, AmqpValue.class, Data.class);
    }

    public final Footer getFooter() {
        this.ensureScanning();
        return (Footer)this.scanForMessageSection(Math.max(0, this.remainingBodyPosition), Footer.class);
    }

    protected <T> T scanForMessageSection(int scanStartPosition, Class ... targetTypes) {
        return this.scanForMessageSection(this.getData().duplicate().position(0), scanStartPosition, targetTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T scanForMessageSection(ReadableBuffer buffer, int scanStartPosition, Class ... targetTypes) {
        this.ensureMessageDataScanned();
        if (scanStartPosition == -1) {
            return null;
        }
        DecoderImpl decoder = TLSEncode.getDecoder();
        buffer.position(scanStartPosition);
        Object section = null;
        decoder.setBuffer(buffer);
        try {
            while (buffer.hasRemaining()) {
                TypeConstructor constructor = decoder.readConstructor();
                for (Class type : targetTypes) {
                    if (!type.equals(constructor.getTypeClass())) continue;
                    Object object = section = constructor.readValue();
                    return (T)object;
                }
                constructor.skipValue();
            }
        }
        finally {
            decoder.setBuffer(null);
        }
        return (T)section;
    }

    protected ApplicationProperties lazyDecodeApplicationProperties() {
        this.ensureMessageDataScanned();
        if (this.applicationProperties != null || this.applicationPropertiesPosition == -1) {
            return this.applicationProperties;
        }
        return this.lazyDecodeApplicationProperties(this.getData().duplicate().position(0));
    }

    protected ApplicationProperties lazyDecodeApplicationProperties(ReadableBuffer data) {
        if (this.applicationProperties == null && this.applicationPropertiesPosition != -1) {
            this.applicationProperties = (ApplicationProperties)this.scanForMessageSection(data, this.applicationPropertiesPosition, ApplicationProperties.class);
            if (this.owner != null && this.memoryEstimate != -1) {
                int addition = this.unmarshalledApplicationPropertiesMemoryEstimateFromData(data);
                if (!this.isPaged) {
                    int updatedEstimate;
                    ((PagingStore)this.owner).addSize(addition, false);
                    this.memoryEstimate = updatedEstimate = this.memoryEstimate + addition;
                }
            }
        }
        return this.applicationProperties;
    }

    protected int unmarshalledApplicationPropertiesMemoryEstimateFromData(ReadableBuffer data) {
        if (this.applicationProperties != null) {
            if (this.remainingBodyPosition != -1) {
                return this.remainingBodyPosition - this.applicationPropertiesPosition;
            }
            return data.capacity() - this.applicationPropertiesPosition;
        }
        return 0;
    }

    protected Map<String, Object> getApplicationPropertiesMap(boolean createIfAbsent) {
        ApplicationProperties appMap = this.lazyDecodeApplicationProperties();
        Map map = null;
        if (appMap != null) {
            map = appMap.getValue();
        }
        if (map == null) {
            if (createIfAbsent) {
                map = new HashMap();
                this.applicationProperties = new ApplicationProperties(map);
            } else {
                map = Collections.emptyMap();
            }
        }
        return map;
    }

    protected Map<Symbol, Object> getMessageAnnotationsMap(boolean createIfAbsent) {
        Map map = null;
        if (this.messageAnnotations != null) {
            map = this.messageAnnotations.getValue();
        }
        if (map == null) {
            if (createIfAbsent) {
                map = new HashMap();
                this.messageAnnotations = new MessageAnnotations(map);
            } else {
                map = Collections.emptyMap();
            }
        }
        return map;
    }

    protected Object getMessageAnnotation(String annotation) {
        Object messageAnnotation = this.getMessageAnnotation(Symbol.getSymbol((String)AMQPMessageSupport.toAnnotationName(annotation)));
        if (messageAnnotation == null) {
            messageAnnotation = this.getMessageAnnotation(Symbol.getSymbol((String)annotation));
        }
        return messageAnnotation;
    }

    protected Object getMessageAnnotation(Symbol annotation) {
        this.ensureMessageDataScanned();
        return this.getMessageAnnotationsMap(false).get(annotation);
    }

    protected Object removeMessageAnnotation(Symbol annotation) {
        return this.getMessageAnnotationsMap(false).remove(annotation);
    }

    protected void setMessageAnnotation(String annotation, Object value) {
        this.setMessageAnnotation(Symbol.getSymbol((String)annotation), value);
    }

    protected void setMessageAnnotation(Symbol annotation, Object value) {
        if (value instanceof SimpleString) {
            value = value.toString();
        }
        this.getMessageAnnotationsMap(true).put(annotation, value);
    }

    protected void setMessageAnnotations(MessageAnnotations messageAnnotations) {
        this.messageAnnotations = messageAnnotations;
    }

    protected synchronized void ensureMessageDataScanned() {
        MessageDataScanningStatus state = this.getDataScanningStatus();
        switch (state) {
            case NOT_SCANNED: {
                this.scanMessageData();
                break;
            }
            case RELOAD_PERSISTENCE: {
                this.lazyScanAfterReloadPersistence();
                break;
            }
        }
    }

    protected int getEstimateSavedEncode() {
        return this.remainingBodyPosition > 0 ? this.remainingBodyPosition : 1024;
    }

    protected synchronized void resetMessageData() {
        this.header = null;
        this.messageAnnotations = null;
        this.properties = null;
        this.applicationProperties = null;
        if (!this.expirationReload) {
            this.expiration = 0L;
        }
        this.priority = (byte)4;
        this.encodedHeaderSize = 0;
        this.memoryEstimate = -1;
        this.originalEstimate = -1;
        this.scheduledTime = -1L;
        this.encodedDeliveryAnnotationsSize = 0;
        this.headerPosition = -1;
        this.deliveryAnnotationsPosition = -1;
        this.propertiesPosition = -1;
        this.applicationPropertiesPosition = -1;
        this.remainingBodyPosition = -1;
    }

    protected synchronized void scanMessageData() {
        this.scanMessageData(this.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void scanMessageData(ReadableBuffer data) {
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setBuffer(data);
        this.resetMessageData();
        try {
            while (data.hasRemaining()) {
                int constructorPos = data.position();
                TypeConstructor constructor = decoder.readConstructor();
                if (Header.class.equals((Object)constructor.getTypeClass())) {
                    this.header = (Header)constructor.readValue();
                    this.headerPosition = constructorPos;
                    this.encodedHeaderSize = data.position() - constructorPos;
                    if (this.header.getTtl() != null && !this.expirationReload) {
                        this.expiration = System.currentTimeMillis() + this.header.getTtl().longValue();
                    }
                    if (this.header.getPriority() == null) continue;
                    this.priority = (byte)Math.min(this.header.getPriority().intValue(), 9);
                    continue;
                }
                if (DeliveryAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    this.deliveryAnnotationsPosition = constructorPos;
                    this.deliveryAnnotations = (DeliveryAnnotations)constructor.readValue();
                    this.encodedDeliveryAnnotationsSize = data.position() - constructorPos;
                    continue;
                }
                if (MessageAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    this.messageAnnotationsPosition = constructorPos;
                    this.messageAnnotations = (MessageAnnotations)constructor.readValue();
                    continue;
                }
                if (Properties.class.equals((Object)constructor.getTypeClass())) {
                    this.propertiesPosition = constructorPos;
                    this.properties = (Properties)constructor.readValue();
                    if (this.properties.getAbsoluteExpiryTime() == null || this.properties.getAbsoluteExpiryTime().getTime() <= 0L || this.expirationReload) continue;
                    this.expiration = this.properties.getAbsoluteExpiryTime().getTime();
                    continue;
                }
                if (ApplicationProperties.class.equals((Object)constructor.getTypeClass())) {
                    this.applicationPropertiesPosition = constructorPos;
                    constructor.skipValue();
                    this.remainingBodyPosition = data.hasRemaining() ? data.position() : -1;
                } else {
                    this.remainingBodyPosition = constructorPos;
                }
                break;
            }
        }
        finally {
            decoder.setBuffer(null);
            data.rewind();
        }
        this.messageDataScanned = MessageDataScanningStatus.SCANNED.code;
    }

    public abstract Message copy();

    public final void sendBuffer(ByteBuf buffer, int deliveryCount) {
        this.ensureDataIsValid();
        NettyWritable writable = new NettyWritable(buffer);
        writable.put(this.getSendBuffer(deliveryCount, null));
    }

    public ReadableBuffer getSendBuffer(int deliveryCount, MessageReference reference) {
        DeliveryAnnotations daToWrite;
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        DeliveryAnnotations deliveryAnnotations = daToWrite = reference != null ? (DeliveryAnnotations)reference.getProtocolData(DeliveryAnnotations.class) : null;
        if (reference == null) {
            daToWrite = this.deliveryAnnotationsForSendBuffer;
        }
        if (deliveryCount > 1 || daToWrite != null || this.deliveryAnnotationsPosition != -1) {
            return this.createDeliveryCopy(deliveryCount, daToWrite);
        }
        return this.getData().duplicate();
    }

    protected ReadableBuffer createDeliveryCopy(int deliveryCount, DeliveryAnnotations deliveryAnnotations) {
        ReadableBuffer duplicate = this.getData().duplicate();
        int amqpDeliveryCount = deliveryCount - 1;
        ByteBuf result = PooledByteBufAllocator.DEFAULT.heapBuffer(this.getEncodeSize());
        Header localHeader = this.header;
        if (localHeader == null) {
            if (deliveryCount > 1) {
                localHeader = new Header();
            }
        } else {
            localHeader = new Header(this.header);
        }
        if (localHeader != null) {
            localHeader.setDeliveryCount(UnsignedInteger.valueOf((int)amqpDeliveryCount));
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(result));
            TLSEncode.getEncoder().writeObject((Object)localHeader);
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        }
        this.writeDeliveryAnnotationsForSendBuffer(result, deliveryAnnotations);
        duplicate.position(this.encodedHeaderSize + this.encodedDeliveryAnnotationsSize);
        result.writeBytes(duplicate.byteBuffer());
        return new NettyReadable(result);
    }

    protected void writeDeliveryAnnotationsForSendBuffer(ByteBuf result, DeliveryAnnotations deliveryAnnotations) {
        if (deliveryAnnotations != null && !deliveryAnnotations.getValue().isEmpty()) {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(result));
            TLSEncode.getEncoder().writeObject((Object)deliveryAnnotations);
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        }
    }

    protected int getDeliveryAnnotationsForSendBufferSize() {
        if (this.deliveryAnnotationsForSendBuffer == null || this.deliveryAnnotationsForSendBuffer.getValue().isEmpty()) {
            return 0;
        }
        DroppingWritableBuffer droppingWritableBuffer = new DroppingWritableBuffer();
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)droppingWritableBuffer);
        TLSEncode.getEncoder().writeObject((Object)this.deliveryAnnotationsForSendBuffer);
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        return droppingWritableBuffer.position() + 1;
    }

    public void messageChanged() {
        this.modified = true;
    }

    public abstract int getEncodeSize();

    public final void receiveBuffer(ByteBuf buffer) {
    }

    public abstract int getMemoryEstimate();

    public int getOriginalEstimate() {
        if (this.originalEstimate < 0) {
            return this.getMemoryEstimate();
        }
        return this.originalEstimate;
    }

    public Map<String, Object> toPropertyMap(int valueSizeLimit) {
        return this.toPropertyMap(false, valueSizeLimit);
    }

    private Map<String, Object> toPropertyMap(boolean expandPropertyType, int valueSizeLimit) {
        String propertiesPrefix;
        String annotationPrefix;
        String applicationPropertiesPrefix;
        String extraPropertiesPrefix;
        if (expandPropertyType) {
            extraPropertiesPrefix = "extraProperties.";
            applicationPropertiesPrefix = "applicationProperties.";
            annotationPrefix = "messageAnnotations.";
            propertiesPrefix = "properties.";
        } else {
            extraPropertiesPrefix = "";
            applicationPropertiesPrefix = "";
            annotationPrefix = "";
            propertiesPrefix = "";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SimpleString name : this.getPropertyNames()) {
            Object value = this.getObjectProperty(name.toString());
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                value = binary.getArray();
            }
            map.put(applicationPropertiesPrefix + String.valueOf(name), JsonUtil.truncate((Object)value, (int)valueSizeLimit));
        }
        TypedProperties extraProperties = this.getExtraProperties();
        if (extraProperties != null) {
            extraProperties.forEach((s, o) -> {
                if (o instanceof Number) {
                    map.put(extraPropertiesPrefix + s.toString(), o);
                } else {
                    map.put(extraPropertiesPrefix + s.toString(), JsonUtil.truncate((Object)(o != null ? o.toString() : o), (int)valueSizeLimit));
                }
            });
        }
        AMQPMessage.addAnnotationsAsProperties(annotationPrefix, map, this.messageAnnotations);
        if (this.properties != null) {
            if (this.properties.getContentType() != null) {
                map.put(propertiesPrefix + "contentType", this.properties.getContentType().toString());
            }
            if (this.properties.getContentEncoding() != null) {
                map.put(propertiesPrefix + "contentEncoding", this.properties.getContentEncoding().toString());
            }
            if (this.properties.getGroupId() != null) {
                map.put(propertiesPrefix + "groupId", this.properties.getGroupId());
            }
            if (this.properties.getGroupSequence() != null) {
                map.put(propertiesPrefix + "groupSequence", this.properties.getGroupSequence().intValue());
            }
            if (this.properties.getReplyToGroupId() != null) {
                map.put(propertiesPrefix + "replyToGroupId", this.properties.getReplyToGroupId());
            }
            if (this.properties.getCreationTime() != null) {
                map.put(propertiesPrefix + "creationTime", this.properties.getCreationTime().getTime());
            }
            if (this.properties.getAbsoluteExpiryTime() != null) {
                map.put(propertiesPrefix + "absoluteExpiryTime", this.properties.getAbsoluteExpiryTime().getTime());
            }
            if (this.properties.getTo() != null) {
                map.put(propertiesPrefix + "to", this.properties.getTo());
            }
            if (this.properties.getSubject() != null) {
                map.put(propertiesPrefix + "subject", this.properties.getSubject());
            }
            if (this.properties.getReplyTo() != null) {
                map.put(propertiesPrefix + "replyTo", this.properties.getReplyTo());
            }
            if (this.properties.getCorrelationId() != null) {
                map.put(propertiesPrefix + "correlationId", this.properties.getCorrelationId());
            }
        }
        return map;
    }

    protected static void addAnnotationsAsProperties(String prefix, Map map, MessageAnnotations annotations) {
        if (annotations != null && annotations.getValue() != null) {
            for (Map.Entry entry : annotations.getValue().entrySet()) {
                String key = entry.getKey().toString();
                if ("x-opt-delivery-time".equals(key) && entry.getValue() != null) {
                    long deliveryTime = ((Number)entry.getValue()).longValue();
                    map.put(prefix + "x-opt-delivery-time", deliveryTime);
                    continue;
                }
                if ("x-opt-delivery-delay".equals(key) && entry.getValue() != null) {
                    long delay = ((Number)entry.getValue()).longValue();
                    map.put(prefix + "x-opt-delivery-delay", delay);
                    continue;
                }
                if ("x-opt-ingress-time".equals(key) && entry.getValue() != null) {
                    map.put(prefix + "x-opt-ingress-time", ((Number)entry.getValue()).longValue());
                    continue;
                }
                try {
                    map.put(prefix + key, entry.getValue());
                }
                catch (ActiveMQPropertyConversionException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ICoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        try {
            this.ensureScanning();
            return AmqpCoreConverter.toCore(this, coreMessageObjectPools, this.header, this.messageAnnotations, this.properties, this.lazyDecodeApplicationProperties(), this.getBody(), this.getFooter());
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ICoreMessage toCore() {
        return this.toCore(this.coreMessageObjectPools);
    }

    public abstract void persist(ActiveMQBuffer var1);

    public abstract int getPersistSize();

    protected int internalPersistSize() {
        return this.getData().remaining();
    }

    public abstract void reloadPersistence(ActiveMQBuffer var1, CoreMessageObjectPools var2);

    protected synchronized void lazyScanAfterReloadPersistence() {
        assert (this.messageDataScanned == MessageDataScanningStatus.RELOAD_PERSISTENCE.code);
        this.scanMessageData();
        this.messageDataScanned = MessageDataScanningStatus.SCANNED.code;
        this.modified = false;
        this.getMemoryEstimate();
    }

    public abstract long getPersistentSize() throws ActiveMQException;

    public abstract Persister<Message> getPersister();

    public abstract void reencode();

    protected abstract void ensureDataIsValid();

    protected abstract void encodeMessage();

    public final TypedProperties createExtraProperties() {
        if (this.extraProperties == null) {
            this.extraProperties = new TypedProperties(INTERNAL_PROPERTY_NAMES_PREDICATE);
        }
        return this.extraProperties;
    }

    public final TypedProperties getExtraProperties() {
        return this.extraProperties;
    }

    public final AMQPMessage setExtraProperties(TypedProperties extraProperties) {
        this.extraProperties = extraProperties;
        return this;
    }

    public final Message putExtraBytesProperty(SimpleString key, byte[] value) {
        this.createExtraProperties().putBytesProperty(key, value);
        return this;
    }

    public final byte[] getExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return this.extraProperties.getBytesProperty(key);
    }

    public void clearInternalProperties() {
        if (this.extraProperties != null) {
            this.extraProperties.clearInternalProperties();
        }
    }

    public final byte[] removeExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return (byte[])this.extraProperties.removeProperty(key);
    }

    public final Message setConnectionID(String connectionID) {
        this.connectionID = connectionID;
        return this;
    }

    public final String getConnectionID() {
        return this.connectionID;
    }

    public final long getMessageFormat() {
        return this.messageFormat;
    }

    public final long getMessageID() {
        return this.messageID;
    }

    public final Message setMessageID(long id) {
        this.messageID = id;
        return this;
    }

    public final long getExpiration() {
        if (!this.expirationReload) {
            this.ensureMessageDataScanned();
        }
        return this.expiration;
    }

    public void reloadExpiration(long expiration) {
        this.expiration = expiration;
        this.expirationReload = true;
    }

    public final AMQPMessage setExpiration(long expiration) {
        if (this.properties != null) {
            if (expiration <= 0L) {
                this.properties.setAbsoluteExpiryTime(null);
            } else {
                this.properties.setAbsoluteExpiryTime(new Date(expiration));
            }
        } else if (expiration > 0L) {
            this.properties = new Properties();
            this.properties.setAbsoluteExpiryTime(new Date(expiration));
        }
        if (this.header != null) {
            this.header.setTtl(null);
        }
        this.expiration = Math.max(0L, expiration);
        return this;
    }

    public final Object getUserID() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getMessageId() != null) {
            return this.properties.getMessageId();
        }
        return null;
    }

    public final Object getAMQPUserID() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getUserId() != null) {
            Binary binary = this.properties.getUserId();
            return new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public final Message setUserID(Object userID) {
        return this;
    }

    public final Object getDuplicateProperty() {
        if (this.applicationProperties == null && this.messageDataScanned == MessageDataScanningStatus.SCANNED.code && this.applicationPropertiesPosition != -1 && !AMQPMessageSymbolSearch.anyApplicationProperties(this.getData(), DUPLICATE_ID_NEEDLES, this.applicationPropertiesPosition)) {
            return null;
        }
        return this.getApplicationObjectProperty(Message.HDR_DUPLICATE_DETECTION_ID.toString());
    }

    public boolean isDurable() {
        if (this.header != null && this.header.getDurable() != null) {
            return this.header.getDurable();
        }
        return this.getDataScanningStatus() == MessageDataScanningStatus.RELOAD_PERSISTENCE;
    }

    public final Message setDurable(boolean durable) {
        if (this.header == null) {
            this.header = new Header();
        }
        this.header.setDurable(Boolean.valueOf(durable));
        return this;
    }

    public final String getAddress() {
        SimpleString addressSimpleString = this.getAddressSimpleString();
        return addressSimpleString == null ? null : addressSimpleString.toString();
    }

    public final AMQPMessage setAddress(String address) {
        this.setAddress(this.cachedAddressSimpleString(address));
        return this;
    }

    public final AMQPMessage setAddress(SimpleString address) {
        this.address = address;
        this.createExtraProperties().putSimpleStringProperty(ADDRESS_PROPERTY, address);
        return this;
    }

    final void reloadAddress(SimpleString address) {
        this.address = address;
    }

    public final SimpleString getAddressSimpleString() {
        if (this.address == null) {
            TypedProperties extraProperties = this.getExtraProperties();
            if (extraProperties != null) {
                this.address = extraProperties.getSimpleStringProperty(ADDRESS_PROPERTY);
            }
            if (this.address == null && this.properties != null && this.properties.getTo() != null) {
                this.address = this.cachedAddressSimpleString(this.properties.getTo());
            }
        }
        return this.address;
    }

    protected SimpleString cachedAddressSimpleString(String address) {
        return CoreMessageObjectPools.cachedAddressSimpleString((String)address, (CoreMessageObjectPools)this.coreMessageObjectPools);
    }

    public final long getTimestamp() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getCreationTime() != null) {
            return this.properties.getCreationTime().getTime();
        }
        return 0L;
    }

    public final Message setTimestamp(long timestamp) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setCreationTime(new Date(timestamp));
        return this;
    }

    public final byte getPriority() {
        return this.priority;
    }

    public final Message setPriority(byte priority) {
        this.priority = (byte)Math.min(priority & 0xFF, 9);
        if (this.header == null) {
            this.header = new Header();
        }
        this.header.setPriority(UnsignedByte.valueOf((byte)priority));
        return this;
    }

    public final SimpleString getReplyTo() {
        this.ensureMessageDataScanned();
        if (this.properties != null) {
            return SimpleString.of((String)this.properties.getReplyTo());
        }
        return null;
    }

    public final AMQPMessage setReplyTo(SimpleString address) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setReplyTo(address != null ? address.toString() : null);
        return this;
    }

    public final RoutingType getRoutingType() {
        this.ensureMessageDataScanned();
        Object routingType = this.getMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE);
        if (routingType != null) {
            return RoutingType.getType((byte)((Number)routingType).byteValue());
        }
        routingType = this.getMessageAnnotation(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION);
        if (routingType != null) {
            if (0 == ((Number)routingType).byteValue() || 2 == ((Number)routingType).byteValue()) {
                return RoutingType.ANYCAST;
            }
            if (1 == ((Number)routingType).byteValue() || 3 == ((Number)routingType).byteValue()) {
                return RoutingType.MULTICAST;
            }
        } else {
            return null;
        }
        return null;
    }

    public final Message setRoutingType(RoutingType routingType) {
        if (routingType == null) {
            this.removeMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE);
        } else {
            this.setMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE, (Object)routingType.getType());
        }
        return this;
    }

    public final SimpleString getGroupID() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getGroupId() != null) {
            return SimpleString.of((String)this.properties.getGroupId(), this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getGroupIdStringSimpleStringPool());
        }
        return null;
    }

    public final int getGroupSequence() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getGroupSequence() != null) {
            return this.properties.getGroupSequence().intValue();
        }
        return 0;
    }

    public final Object getCorrelationID() {
        this.ensureMessageDataScanned();
        return this.properties != null ? this.properties.getCorrelationId() : null;
    }

    public final Message setCorrelationID(Object correlationID) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setCorrelationId(correlationID);
        return this;
    }

    public final String getSubject() {
        this.ensureMessageDataScanned();
        if (this.properties != null) {
            return this.properties.getSubject();
        }
        return null;
    }

    public boolean hasScheduledDeliveryTime() {
        if (this.scheduledTime >= 0L) {
            return this.scheduledTime > 0L;
        }
        return this.anyMessageAnnotations(SCHEDULED_DELIVERY_SYMBOLS, SCHEDULED_DELIVERY_NEEDLES);
    }

    private boolean anyMessageAnnotations(Symbol[] symbols, KMPNeedle[] symbolNeedles) {
        assert (symbols.length == symbolNeedles.length);
        int count = symbols.length;
        if (this.messageDataScanned == MessageDataScanningStatus.SCANNED.code) {
            MessageAnnotations messageAnnotations = this.messageAnnotations;
            if (messageAnnotations == null) {
                return false;
            }
            Map map = messageAnnotations.getValue();
            if (map == null) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                if (!map.containsKey(symbols[i])) continue;
                return true;
            }
            return false;
        }
        return AMQPMessageSymbolSearch.anyMessageAnnotations(this.getData(), symbolNeedles);
    }

    public final Long getScheduledDeliveryTime() {
        this.ensureMessageDataScanned();
        if (this.scheduledTime < 0L) {
            Object objscheduledTime = this.getMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME);
            Object objdelay = this.getMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            if (objscheduledTime != null && objscheduledTime instanceof Number) {
                Number number = (Number)objscheduledTime;
                this.scheduledTime = number.longValue();
            } else if (objdelay != null && objdelay instanceof Number) {
                Number number = (Number)objdelay;
                this.scheduledTime = System.currentTimeMillis() + number.longValue();
            } else {
                this.scheduledTime = 0L;
            }
        }
        return this.scheduledTime;
    }

    public final AMQPMessage setScheduledDeliveryTime(Long time) {
        if (time != null && time > 0L) {
            this.setMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME, (Object)time);
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = time;
        } else {
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME);
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = 0L;
        }
        return this;
    }

    public final Object removeAnnotation(SimpleString key) {
        return this.removeMessageAnnotation(Symbol.getSymbol((String)key.toString()));
    }

    public final Object getAnnotation(SimpleString key) {
        return this.getMessageAnnotation(key.toString());
    }

    public final AMQPMessage setAnnotation(SimpleString key, Object value) {
        this.setMessageAnnotation(key.toString(), value);
        return this;
    }

    public Message setBrokerProperty(SimpleString key, Object value) {
        this.setMessageAnnotation(AMQPMessageSupport.toAnnotationName(key.toString()), value);
        this.createExtraProperties().putProperty(key, value);
        return this;
    }

    public Object getBrokerProperty(SimpleString key) {
        TypedProperties extra = this.getExtraProperties();
        if (extra == null) {
            return null;
        }
        return extra.getProperty(key);
    }

    public final Message setIngressTimestamp() {
        this.setMessageAnnotation(AMQPMessageSupport.INGRESS_TIME_MSG_ANNOTATION, (Object)System.currentTimeMillis());
        return this;
    }

    public Long getIngressTimestamp() {
        return (Long)this.getMessageAnnotation(AMQPMessageSupport.INGRESS_TIME_MSG_ANNOTATION);
    }

    public final Object removeProperty(SimpleString key) {
        return this.removeProperty(key.toString());
    }

    public final Object removeProperty(String key) {
        return this.getApplicationPropertiesMap(false).remove(key);
    }

    public final boolean containsProperty(SimpleString key) {
        return this.containsProperty(key.toString());
    }

    public final boolean containsProperty(String key) {
        return this.getApplicationPropertiesMap(false).containsKey(key);
    }

    public final Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return (Boolean)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return (Byte)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return (Double)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return (Integer)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return (Long)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Object getObjectProperty(String key) {
        switch (key) {
            case "JMSType": {
                return this.getSubject();
            }
            case "__AMQ_CID": {
                return this.getConnectionID();
            }
            case "JMSXGroupID": {
                return this.getGroupID();
            }
            case "JMSXGroupSeq": {
                return this.getGroupSequence();
            }
            case "JMSXUserID": {
                return this.getAMQPUserID();
            }
            case "JMSCorrelationID": {
                Object correlationID = this.getCorrelationID();
                if (correlationID != null) {
                    return AMQPMessageIdHelper.INSTANCE.toCorrelationIdStringOrBytes(correlationID);
                }
                return null;
            }
        }
        return this.getApplicationObjectProperty(key);
    }

    private Object getApplicationObjectProperty(String key) {
        Object value = this.getApplicationPropertiesMap(false).get(key);
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof UnsignedInteger || value instanceof UnsignedByte || value instanceof UnsignedLong || value instanceof UnsignedShort) {
                return number.longValue();
            }
        } else if (value instanceof Binary) {
            return this.getBytesProperty(key);
        }
        return value;
    }

    public final Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return (Short)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return (Float)this.getApplicationPropertiesMap(false).get(key);
    }

    public final String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        return switch (key) {
            case "JMSType" -> this.properties.getSubject();
            case "__AMQ_CID" -> this.getConnectionID();
            default -> (String)this.getApplicationPropertiesMap(false).get(key);
        };
    }

    public final Set<SimpleString> getPropertyNames() {
        HashSet<SimpleString> values = new HashSet<SimpleString>();
        for (String k : this.getApplicationPropertiesMap(false).keySet()) {
            values.add(SimpleString.of((String)k.toString(), (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
        }
        return values;
    }

    public final Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBooleanProperty(key.toString());
    }

    public final Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(key.toString());
    }

    public final byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        Object value = this.getApplicationPropertiesMap(false).get(key);
        if (value instanceof Binary) {
            Binary binary = (Binary)value;
            if (binary.getArray() == null) {
                return null;
            }
            if (binary.getArrayOffset() == 0 && binary.getLength() == binary.getArray().length) {
                return binary.getArray();
            }
            byte[] payload = new byte[binary.getLength()];
            System.arraycopy(binary.getArray(), binary.getArrayOffset(), payload, 0, binary.getLength());
            return payload;
        }
        return (byte[])value;
    }

    public final Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getDoubleProperty(key.toString());
    }

    public final Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(key.toString());
    }

    public final Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getLongProperty(key.toString());
    }

    public final Object getObjectProperty(SimpleString key) {
        return this.getObjectProperty(key.toString());
    }

    public final Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getShortProperty(key.toString());
    }

    public final Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getFloatProperty(key.toString());
    }

    public final String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(key.toString());
    }

    public final SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getSimpleStringProperty(key.toString());
    }

    public final byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(key.toString());
    }

    public final SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return SimpleString.of((String)((String)this.getApplicationPropertiesMap(false).get(key)), (SimpleString.StringSimpleStringPool)this.getPropertyValuesPool());
    }

    public final Message putBooleanProperty(String key, boolean value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putByteProperty(String key, byte value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putBytesProperty(String key, byte[] value) {
        Binary payload = null;
        if (value != null) {
            payload = new Binary(value);
        }
        this.getApplicationPropertiesMap(true).put(key, payload);
        return this;
    }

    public final Message putShortProperty(String key, short value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putCharProperty(String key, char value) {
        this.getApplicationPropertiesMap(true).put(key, Character.valueOf(value));
        return this;
    }

    public final Message putIntProperty(String key, int value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putLongProperty(String key, long value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putFloatProperty(String key, float value) {
        this.getApplicationPropertiesMap(true).put(key, Float.valueOf(value));
        return this;
    }

    public final Message putDoubleProperty(String key, double value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putBooleanProperty(SimpleString key, boolean value) {
        this.getApplicationPropertiesMap(true).put(key.toString(), value);
        return this;
    }

    public final Message putByteProperty(SimpleString key, byte value) {
        return this.putByteProperty(key.toString(), value);
    }

    public final Message putBytesProperty(SimpleString key, byte[] value) {
        return this.putBytesProperty(key.toString(), value);
    }

    public final Message putShortProperty(SimpleString key, short value) {
        return this.putShortProperty(key.toString(), value);
    }

    public final Message putCharProperty(SimpleString key, char value) {
        return this.putCharProperty(key.toString(), value);
    }

    public final Message putIntProperty(SimpleString key, int value) {
        return this.putIntProperty(key.toString(), value);
    }

    public final Message putLongProperty(SimpleString key, long value) {
        return this.putLongProperty(key.toString(), value);
    }

    public final Message putFloatProperty(SimpleString key, float value) {
        return this.putFloatProperty(key.toString(), value);
    }

    public final Message putDoubleProperty(SimpleString key, double value) {
        return this.putDoubleProperty(key.toString(), value);
    }

    public final Message putStringProperty(String key, String value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.putBytesProperty(key, bytes);
        } else {
            this.getApplicationPropertiesMap(true).put(key, value);
        }
        return this;
    }

    public final Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        return this.putObjectProperty(key.toString(), value);
    }

    public final Message putStringProperty(SimpleString key, SimpleString value) {
        return this.putStringProperty(key.toString(), value.toString());
    }

    public final Message putStringProperty(SimpleString key, String value) {
        return this.putStringProperty(key.toString(), value);
    }

    public final SimpleString getLastValueProperty() {
        return this.getSimpleStringProperty(HDR_LAST_VALUE_NAME);
    }

    public final Message setLastValueProperty(SimpleString lastValueName) {
        return this.putStringProperty(HDR_LAST_VALUE_NAME, lastValueName);
    }

    public String toString() {
        MessageDataScanningStatus scanningStatus = this.getDataScanningStatus();
        Map applicationProperties = scanningStatus == MessageDataScanningStatus.SCANNED ? this.getApplicationPropertiesMap(false) : Collections.emptyMap();
        return ((Object)((Object)this)).getClass().getSimpleName() + "( [durable=" + this.isDurable() + ", messageID=" + this.getMessageID() + ", address=" + this.getAddress() + ", size=" + this.getEncodeSize() + ", scanningStatus=" + String.valueOf((Object)scanningStatus) + ", applicationProperties=" + String.valueOf(applicationProperties) + ", messageAnnotations=" + String.valueOf(this.getMessageAnnotationsMap(false)) + ", properties=" + String.valueOf(this.properties) + ", extraProperties = " + String.valueOf(this.getExtraProperties()) + "]";
    }

    public final synchronized boolean acceptsConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            return true;
        }
        return !this.rejectedConsumers.contains(consumer);
    }

    public final synchronized void rejectConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            this.rejectedConsumers = new HashSet<Object>();
        }
        this.rejectedConsumers.add(consumer);
    }

    protected SimpleString.StringSimpleStringPool getPropertyKeysPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyKeysPool();
    }

    protected SimpleString.StringSimpleStringPool getPropertyValuesPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyValuesPool();
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public CompositeData toCompositeData(int fieldsLimit, int deliveryCount) throws OpenDataException {
        Map fields = AMQP_FACTORY.getFields((Message)this, fieldsLimit, deliveryCount);
        return new CompositeDataSupport(AMQP_FACTORY.getCompositeType(), fields);
    }

    public static final class MessageDataScanningStatus
    extends Enum<MessageDataScanningStatus> {
        public static final /* enum */ MessageDataScanningStatus NOT_SCANNED = new MessageDataScanningStatus(0);
        public static final /* enum */ MessageDataScanningStatus RELOAD_PERSISTENCE = new MessageDataScanningStatus(1);
        public static final /* enum */ MessageDataScanningStatus SCANNED = new MessageDataScanningStatus(2);
        private static final MessageDataScanningStatus[] STATES;
        final byte code;
        private static final /* synthetic */ MessageDataScanningStatus[] $VALUES;

        public static MessageDataScanningStatus[] values() {
            return (MessageDataScanningStatus[])$VALUES.clone();
        }

        public static MessageDataScanningStatus valueOf(String name) {
            return Enum.valueOf(MessageDataScanningStatus.class, name);
        }

        private MessageDataScanningStatus(int code) {
            assert (code >= 0 && code <= 127);
            this.code = (byte)code;
        }

        static MessageDataScanningStatus valueOf(int code) {
            MessageDataScanningStatus.checkCode(code);
            return STATES[code];
        }

        private static void checkCode(int code) {
            if (code < 0 || code > STATES.length - 1) {
                throw new IllegalArgumentException("invalid status code: " + code);
            }
        }

        private static /* synthetic */ MessageDataScanningStatus[] $values() {
            return new MessageDataScanningStatus[]{NOT_SCANNED, RELOAD_PERSISTENCE, SCANNED};
        }

        static {
            $VALUES = MessageDataScanningStatus.$values();
            MessageDataScanningStatus[] states = MessageDataScanningStatus.values();
            STATES = new MessageDataScanningStatus[states.length];
            for (MessageDataScanningStatus state : states) {
                byte code = state.code;
                if (STATES[code] != null) {
                    throw new AssertionError((Object)("code already in use: " + code));
                }
                MessageDataScanningStatus.STATES[code] = state;
            }
        }
    }

    static class AmqpMessageOpenTypeFactory
    extends MessageOpenTypeFactory<AMQPMessage> {
        AmqpMessageOpenTypeFactory() {
        }

        protected void init() throws OpenDataException {
            super.init();
            this.addItem("text", "text", SimpleType.STRING);
        }

        public Map<String, Object> getFields(AMQPMessage m, int valueSizeLimit, int delivery) throws OpenDataException {
            Object amqpValue;
            if (!m.isLargeMessage()) {
                m.ensureScanning();
            }
            Map rc = super.getFields((Message)m, valueSizeLimit, delivery);
            Properties properties = m.getCurrentProperties();
            byte type = this.getType(m, properties);
            rc.put("type", type);
            if (m.isLargeMessage()) {
                rc.put("text", "... Large message ...");
            } else if (m.getBody() instanceof AmqpValue && (amqpValue = ((AmqpValue)m.getBody()).getValue()) != null) {
                rc.put("text", JsonUtil.truncateString((String)String.valueOf(amqpValue), (int)valueSizeLimit));
            } else {
                rc.put("text", JsonUtil.truncateString((String)String.valueOf(m.getBody()), (int)valueSizeLimit));
            }
            return rc;
        }

        protected Map<String, Object> expandProperties(AMQPMessage m, int valueSizeLimit) {
            return m.toPropertyMap(true, valueSizeLimit);
        }

        private byte getType(AMQPMessage m, Properties properties) {
            Symbol contentType;
            if (m.isLargeMessage()) {
                return 0;
            }
            int type = 4;
            if (m.getBody() == null) {
                return 0;
            }
            Symbol symbol = contentType = properties != null ? properties.getContentType() : null;
            if (m.getBody() instanceof Data && contentType != null) {
                if (AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.equals(contentType)) {
                    type = 2;
                } else if (AMQPMessageSupport.OCTET_STREAM_CONTENT_TYPE_SYMBOL.equals(contentType)) {
                    type = 4;
                } else {
                    Charset charset = AMQPMessageSupport.getCharsetForTextualContent(contentType.toString());
                    if (StandardCharsets.UTF_8.equals(charset)) {
                        type = 3;
                    }
                }
            } else if (m.getBody() instanceof AmqpValue) {
                Object value = ((AmqpValue)m.getBody()).getValue();
                if (value instanceof String) {
                    type = 3;
                } else if (value instanceof Binary) {
                    type = AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.equals(contentType) ? 2 : 4;
                } else if (value instanceof List) {
                    type = 6;
                } else if (value instanceof Map) {
                    type = 5;
                }
            } else if (m.getBody() instanceof AmqpSequence) {
                type = 6;
            }
            return (byte)type;
        }
    }
}

