/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json.simplifier;

import org.jolokia.service.serializer.json.simplifier.AttributeExtractor;
import org.jolokia.service.serializer.json.simplifier.SimplifierAccessor;

public class ClassSimplifier
extends SimplifierAccessor<Class> {
    public ClassSimplifier() {
        super(Class.class);
        this.addExtractor("name", new NameAttributeExtractor());
        this.addExtractor("interfaces", new InterfaceAttributeExtractor());
    }

    @Override
    public String extractString(Object pValue) {
        return ((Class)pValue).getName();
    }

    private static class NameAttributeExtractor
    implements AttributeExtractor<Class> {
        private NameAttributeExtractor() {
        }

        @Override
        public Object extract(Class pClass) {
            return pClass.getName();
        }
    }

    private static class InterfaceAttributeExtractor
    implements AttributeExtractor<Class> {
        private InterfaceAttributeExtractor() {
        }

        @Override
        public Object extract(Class value) throws AttributeExtractor.SkipAttributeException {
            if (value.isInterface()) {
                throw new AttributeExtractor.SkipAttributeException();
            }
            return value.getInterfaces();
        }
    }
}

