/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.nio.charset.UnsupportedCharsetException;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ConvertHeaderDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ConvertBodyReifier;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.processor.ConvertHeaderProcessor;

public class ConvertHeaderReifier
extends ProcessorReifier<ConvertHeaderDefinition> {
    public ConvertHeaderReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ConvertHeaderDefinition)ConvertHeaderDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        String key = this.parseString(((ConvertHeaderDefinition)this.definition).getName());
        Expression nameExpr = LanguageSupport.hasSimpleFunction((String)key) ? this.camelContext.resolveLanguage("simple").createExpression(key) : this.camelContext.resolveLanguage("constant").createExpression(key);
        nameExpr.init(this.camelContext);
        String toKey = this.parseString(((ConvertHeaderDefinition)this.definition).getToName());
        Expression toNameExpr = null;
        if (toKey != null) {
            toNameExpr = LanguageSupport.hasSimpleFunction((String)toKey) ? this.camelContext.resolveLanguage("simple").createExpression(toKey) : this.camelContext.resolveLanguage("constant").createExpression(toKey);
            toNameExpr.init(this.camelContext);
        }
        Class typeClass = this.parse(Class.class, this.or(((ConvertHeaderDefinition)this.definition).getTypeClass(), this.parseString(((ConvertHeaderDefinition)this.definition).getType())));
        String charset = ConvertHeaderReifier.validateCharset(this.parseString(((ConvertHeaderDefinition)this.definition).getCharset()));
        boolean mandatory = true;
        if (((ConvertHeaderDefinition)this.definition).getMandatory() != null) {
            mandatory = this.parseBoolean(((ConvertHeaderDefinition)this.definition).getMandatory(), true);
        }
        ConvertHeaderProcessor answer = new ConvertHeaderProcessor(key, nameExpr, toKey, toNameExpr, typeClass, charset, mandatory);
        answer.setDisabled(ConvertHeaderReifier.isDisabled(this.camelContext, (NamedNode)this.definition));
        return answer;
    }

    public static String validateCharset(String charset) throws UnsupportedCharsetException {
        return ConvertBodyReifier.validateCharset(charset);
    }
}

